/*!
 *******************************************************************************
 * \file             spi_tclmySPINSwitch.cpp
 * \brief            mySPIN device switcher
 * \addtogroup       Connectivity
 * \{
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:     mySPIN device switcher
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 16.06.2016 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/
#include "spi_tclmySPINSwitch.h"
#include "Trace.h"
#include "spi_tclExtCmdRoleSwitch.h"
#include "spi_tclExtCompManager.h"
#include "RespRegister.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_CONNECTIVITY
#include "trcGenProj/Header/spi_tclmySPINSwitch.cpp.trc.h"
#endif
#endif

/***************************************************************************
 ** FUNCTION:  spi_tclmySPINSwitch::spi_tclmySPINSwitch
 ***************************************************************************/
spi_tclmySPINSwitch::spi_tclmySPINSwitch() : m_u32RoleSwitchDeviceHandle(0)
{
   ETG_TRACE_USR1(("[DESC] spi_tclmySPINSwitch::spi_tclmySPINSwitch entered\n"));
   RespRegister *poRespRegister = RespRegister::getInstance();
   if(NULL != poRespRegister)
   {
	  poRespRegister->bRegisterObject((spi_tclExtRespRoleSwitch*)this);
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclmySPINSwitch::~spi_tclmySPINSwitch()
 ***************************************************************************/
spi_tclmySPINSwitch::~spi_tclmySPINSwitch()
{
   ETG_TRACE_USR1(("[DESC] spi_tclmySPINSwitch::~spi_tclmySPINSwitch entered\n"));
   m_u32RoleSwitchDeviceHandle = 0;
}

/***************************************************************************
 ** FUNCTION:  spi_tclmySPINSwitch::vRegisterCallbacks
 ***************************************************************************/
t_Void spi_tclmySPINSwitch::vRegisterCallbacks(const trDeviceSwitcherCbs corfrSwitchCbs)
{
   ETG_TRACE_USR1(("[DESC] spi_tclmySPINSwitch::vRegisterCallbacks entered\n"));
   m_rSwitcherCbs =  corfrSwitchCbs;
}

/***************************************************************************
 ** FUNCTION:  spi_tclmySPINSwitch::enSwitchDeviceMode
 ***************************************************************************/
tenDeviceSwitchResult spi_tclmySPINSwitch::enSwitchDeviceMode(const trUSBDeviceInfo &rfrDeviceInfo, trDeviceSwitchInfo &rfrDeviceSwitchInfo,
         tenDeviceType enDeviceType)
{
   SPI_INTENTIONALLY_UNUSED(rfrDeviceSwitchInfo);
   ETG_TRACE_USR1(("[DESC] spi_tclmySPINSwitch::bSwitchDeviceMode entered\n"));
   tenDeviceSwitchResult enRetVal = e8_DEVICESWITCH_RESULT_UNKNOWN;

//   if (e8_PROFILE_AOAP != rfrDeviceInfo.enUSBProfile)
//   {
      if(e8_APPLE_DEVICE == enDeviceType)
      {
    	 spi_tclExtCompManager *poExtCompMgr = spi_tclExtCompManager::getInstance();
    	 spi_tclExtCmdRoleSwitchIntf *poExtCmdRoleSwitchIntf = NULL;
    	 if(NULL != poExtCompMgr)
    	 {
    	    poExtCmdRoleSwitchIntf = poExtCompMgr->poGetCmdRoleSwitchIntfInst();
    	 }
         t_Bool bRetVal = false;
         if(NULL != poExtCmdRoleSwitchIntf)
         {
            trEAPAppInfo rEAPAppInfo;
            m_u32RoleSwitchDeviceHandle = rfrDeviceInfo.u32DeviceHandle; //Store the device handle for the role switch requested device
            bRetVal = poExtCmdRoleSwitchIntf->bRoleSwitchRequest(rfrDeviceInfo.u32DeviceHandle, e8DEVCONNREQ_SELECT,rEAPAppInfo,e8DEV_TYPE_MYSPIN);
         }
         enRetVal = (false == bRetVal)? e8_DEVICESWITCH_RESULT_FAILED : e8_DEVICESWITCH_RESULT_SUCCESS;
      }
      else
      {
    	  if (e8_PROFILE_AOAP != rfrDeviceInfo.enUSBProfile)
    	  {
    		  enRetVal = e8_DEVICESWITCH_RESULT_INPROGRESS;
    	  }
    	  else
    	  {
    		  ETG_TRACE_USR4(("spi_tclBDCLSwitch::enSwitchDeviceMode: Already in AOAP mode  "));
    		  enRetVal = e8_DEVICESWITCH_RESULT_SWITCH_NOTREQUIRED;
    	  }
      }
      //   }
//   else
//   {
//      ETG_TRACE_USR4(("spi_tclmySPINSwitch::enSwitchDeviceMode: Already in AOAP mode \n "));
//           enRetVal = e8_DEVICESWITCH_RESULT_DEVICE_RESET_REQUIRED;
//   }

   ETG_TRACE_USR1(("[DESC] spi_tclmySPINSwitch::bSwitchDeviceMode Device Switch Result = %d\n", ETG_ENUM(DEVICESWITCH_RESULT, enRetVal)));
   return enRetVal;
}

/***************************************************************************
 ** FUNCTION:  spi_tclmySPINSwitch::enSwitchDeviceMode
 ***************************************************************************/
t_Void spi_tclmySPINSwitch::vPostRoleSwitchCompleteMsg(const t_U32 cou32DeviceHandle, t_Bool  bSwitchStatus)
{
   SPI_INTENTIONALLY_UNUSED(cou32DeviceHandle);
   ETG_TRACE_USR1(("[FUNC]spi_tclmySPINSwitch::vPostRoleSwitchCompleteMsg entered\n"));
    if(0 != m_u32RoleSwitchDeviceHandle)
    {
        if(NULL != m_rSwitcherCbs.fvDeviceSwitchCompleteCb)
        {
           m_rSwitcherCbs.fvDeviceSwitchCompleteCb(m_u32RoleSwitchDeviceHandle,bSwitchStatus);
        }
        m_u32RoleSwitchDeviceHandle = 0; //Clear the stored device handle
    }
}
