/*!
 *******************************************************************************
 * \file             spi_tclCarplaySwitch.cpp
 * \brief            Carplay device switcher
 * \addtogroup       Connectivity
 * \{
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:     Carplay device switcher
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 16.06.2016 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/
#include "spi_tclCarplaySwitch.h"
#include "Trace.h"
#include "RespRegister.h"
#include "spi_tclExtCmdRoleSwitch.h"
#include "spi_tclExtCompManager.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_CONNECTIVITY
#include "trcGenProj/Header/spi_tclCarplaySwitch.cpp.trc.h"
#endif
#endif

/***************************************************************************
 ** FUNCTION:  spi_tclCarplaySwitch::spi_tclCarplaySwitch
 ***************************************************************************/
spi_tclCarplaySwitch::spi_tclCarplaySwitch():m_u32RoleSwitchDeviceHandle(0)
{
   ETG_TRACE_USR1(("[DESC] spi_tclCarplaySwitch::spi_tclCarplaySwitch entered\n"));
   RespRegister *poRespRegister = RespRegister::getInstance();
   if(NULL != poRespRegister)
   {
	  poRespRegister->bRegisterObject((spi_tclExtRespRoleSwitch*)this);
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclCarplaySwitch::~spi_tclCarplaySwitch()
 ***************************************************************************/
spi_tclCarplaySwitch::~spi_tclCarplaySwitch()
{
   ETG_TRACE_USR1(("[DESC] spi_tclCarplaySwitch::~spi_tclCarplaySwitch entered\n"));
   m_u32RoleSwitchDeviceHandle = 0;
}
/***************************************************************************
 ** FUNCTION:  spi_tclCarplaySwitch::vRegisterCallbacks
 ***************************************************************************/
t_Void spi_tclCarplaySwitch::vRegisterCallbacks(const trDeviceSwitcherCbs corfrSwitchCbs)
{
   ETG_TRACE_USR1(("[DESC] spi_tclCarplaySwitch::vRegisterCallbacks entered\n"));
   m_rSwitcherCbs =  corfrSwitchCbs;
}

/***************************************************************************
 ** FUNCTION:  spi_tclCarplaySwitch::enSwitchDeviceMode
 ***************************************************************************/
tenDeviceSwitchResult spi_tclCarplaySwitch::enSwitchDeviceMode(const trUSBDeviceInfo &rfrDeviceInfo,trDeviceSwitchInfo &rfrDeviceSwitchInfo,
         tenDeviceType enDeviceType)
{
   SPI_INTENTIONALLY_UNUSED(enDeviceType);
   ETG_TRACE_USR1(("[DESC] spi_tclCarplaySwitch::enSwitchDeviceMode:DevID:0x%x",rfrDeviceInfo.u32DeviceHandle));

   tenDeviceSwitchResult enRetVal = e8_DEVICESWITCH_RESULT_UNKNOWN;
   tenDeviceConnectionReq enDeviceSelRequest =
            (e8DEV_TYPE_DIPO == rfrDeviceSwitchInfo.enDeviceSwitchType) ?
                     e8DEVCONNREQ_SELECT : e8DEVCONNREQ_DESELECT;

   spi_tclExtCompManager *poExtCompMgr=spi_tclExtCompManager::getInstance();
   spi_tclExtCmdRoleSwitchIntf *poExtCmdRoleSwitchIntf = NULL;
   if(NULL != poExtCompMgr)
   {
      poExtCmdRoleSwitchIntf = poExtCompMgr->poGetCmdRoleSwitchIntfInst();
   }

   //! Request mediaplayer for role switch

   if (NULL != poExtCmdRoleSwitchIntf)
   {
      trEAPAppInfo rEAPAppInfo;
	   m_u32RoleSwitchDeviceHandle = rfrDeviceInfo.u32DeviceHandle; //Store the device handle for the role switch requested device
      t_Bool bRetVal = poExtCmdRoleSwitchIntf->bRoleSwitchRequest(rfrDeviceInfo.u32DeviceHandle,
               enDeviceSelRequest,rEAPAppInfo,
               e8DEV_TYPE_DIPO);
      enRetVal = (false == bRetVal) ? e8_DEVICESWITCH_RESULT_FAILED : e8_DEVICESWITCH_RESULT_SUCCESS;
   }

   ETG_TRACE_USR1(("[DESC] spi_tclCarplaySwitch::enSwitchDeviceMode Device Switch Result = %d\n", ETG_ENUM(DEVICESWITCH_RESULT, enRetVal)));
   return enRetVal;
}

/***************************************************************************
 ** FUNCTION:  spi_tclCarplaySwitch::enSwitchDeviceMode
 ***************************************************************************/
t_Void spi_tclCarplaySwitch::vPostRoleSwitchCompleteMsg(const t_U32 cou32DeviceHandle, t_Bool  bSwitchStatus)
{
	ETG_TRACE_USR1(("[FUNC]spi_tclCarplaySwitch::vPostRoleSwitchCompleteMsg:DevID:0x%x,SelectedDevice:0x%x,SwitchStatus:%d",
			cou32DeviceHandle,m_u32RoleSwitchDeviceHandle,ETG_ENUM(BOOL,bSwitchStatus)));
	if(0 != m_u32RoleSwitchDeviceHandle)
	{
	    if(false == bSwitchStatus)
	    {
		    if(NULL != m_rSwitcherCbs.fvDeviceSwitchCompleteCb)
		    {
			    m_rSwitcherCbs.fvDeviceSwitchCompleteCb(m_u32RoleSwitchDeviceHandle,bSwitchStatus);
		    }
	    }
	    m_u32RoleSwitchDeviceHandle = 0;
	}

    //When DIPO_communication_error is reported from Mediaplayer,stop the selection of the device.
    else if (0 != cou32DeviceHandle)
    {
       if(false == bSwitchStatus)
       {
          if(NULL != m_rSwitcherCbs.fvDeviceSwitchCompleteCb)
          {
             m_rSwitcherCbs.fvDeviceSwitchCompleteCb(cou32DeviceHandle,bSwitchStatus);
          }
       }
    }
}
