/*!
 *******************************************************************************
 * \file             spi_tclmySPINSwitch.h
 * \brief            mySPIN device switcher
 * \addtogroup       Device Switcher
 * \{
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:     mySPIN device switcher
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 16.06.2016 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLMYSPINSWITCH_H_
#define SPI_TCLMYSPINSWITCH_H_

#include "Lock.h"
#include "SPITypes.h"
#include "spi_ConnMngrTypeDefines.h"
#include "spi_tclDeviceSwitchBase.h"
#include "spi_tclExtRespRoleSwitch.h"

/**
 * \class spi_tclmySPINSwitch
 * \brief  mySPIN device switcher. For iPhones, responsible for sending role switch request.
 * For android phones, currently no device switch requets is sent. mySPIN library takes care fo the switch
 */

class spi_tclmySPINSwitch: public spi_tclDeviceSwitchBase, public spi_tclExtRespRoleSwitch
{

   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclmySPINSwitch::spi_tclmySPINSwitch
       ***************************************************************************/
      /*!
       * \brief   Default Constructor
       **************************************************************************/
      spi_tclmySPINSwitch();

      /***************************************************************************
       ** FUNCTION:  spi_tclmySPINSwitch::~spi_tclmySPINSwitch()
       ***************************************************************************/
      /*!
       * \brief   Destructor
       **************************************************************************/
      virtual ~spi_tclmySPINSwitch();

      /***************************************************************************
       ** FUNCTION:  spi_tclmySPINSwitch::vRegisterCallbacks
       ***************************************************************************/
      /*!
       * \brief   Register discoverer callbacks
       * \brief   corfrSwitchCbs: Structure containing the function pointers to be invoked
       **************************************************************************/
      virtual t_Void vRegisterCallbacks(const trDeviceSwitcherCbs corfrSwitchCbs);

      /***************************************************************************
       ** FUNCTION:  spi_tclmySPINSwitch::enSwitchDeviceMode
       ***************************************************************************/
      /*!
       * \brief   Switch the connection profile of the device
       * \param   enDeviceCat: SPI technology to which the device has to be switched to
       * \param   enDeviceSwitchType: Device Switch type
       * \param   rfrDeviceSwitchInfo: Device switch Information
       * \retval   tenDeviceSwitchResult: Indicates result of device switch
       **************************************************************************/
      virtual tenDeviceSwitchResult enSwitchDeviceMode(const trUSBDeviceInfo &rfrDeviceInfo,
               trDeviceSwitchInfo &rfrDeviceSwitchInfo, tenDeviceType enDeviceType = e8_UNKNOWN_DEVICE);

   protected:

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclmySPINSwitch::vPostRoleSwitchCompleteMsg()
       ***************************************************************************/
      /*!
       * \fn      t_Void vPostRoleSwitchCompleteMsg()
       * \brief   Called when role switch completes
       * \param   cou32DeviceHandle:Device handle
       * \param   bSwitchStatus: Role Switch status
       * \sa      None
       **************************************************************************/
      t_Void vPostRoleSwitchCompleteMsg(const t_U32 cou32DeviceHandle, t_Bool  bSwitchStatus);

   private:

      trDeviceSwitcherCbs m_rSwitcherCbs;
      t_U32 m_u32RoleSwitchDeviceHandle;
};
/*! } */
#endif /* SPI_TCLMYSPINSWITCH_H_ */
