/*!
 *******************************************************************************
 * \file             spi_tclUSBReset.h
 * \brief            ML device switcher
 * \addtogroup       Device Switcher
 * \{
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:     ML device switcher
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 16.06.2016 |  Pruthvi Thej Nagaraju       | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLUSBRESET_H_
#define SPI_TCLUSBRESET_H_

#include "Lock.h"
#include "SPITypes.h"
#include "spi_ConnMngrTypeDefines.h"
#include "spi_tclUSBResetIntf.h"

/**
 * \class spi_tclUSBReset
 * \brief  ML device switcher. Reponsible for sending mirrorlink command to USB devices
 */

class spi_tclUSBReset: public spi_tclUSBResetIntf
{

   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclUSBReset::spi_tclUSBReset
       ***************************************************************************/
      /*!
       * \brief   Default Constructor
       **************************************************************************/
      spi_tclUSBReset(spi_tclDiscoveryDataIntf *pDiscovereryDataIntf);

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBReset::~spi_tclUSBReset()
       ***************************************************************************/
      /*!
       * \brief   Destructor
       **************************************************************************/
      virtual ~spi_tclUSBReset();

      /***************************************************************************
       ** FUNCTION:  t_U32 spi_tclUSBReset::bResetUSBDevice
       ***************************************************************************/
      /*!
       * \fn      t_U32 bResetUSBDevice()
       * \brief   Trigger a USB profile switch to re-enumerate the device in default USB Mode
       * \param   rfrDeviceInfo : Contains information of the USB device
       **************************************************************************/
      virtual t_Bool bResetUSBDevice(const trUSBDeviceInfo &rfrDeviceInfo);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclUSBReset::vStopUSBResetRetrial
       ***************************************************************************/
      /*!
       * \fn      t_Void vStopUSBResetRetrial()
       * \brief   Stops USB Reset retrial
       * \param   cou32DeviceHandle: Device handle
       * \sa      bSwitchToUSBMode()
       **************************************************************************/
      virtual t_Void vStopUSBResetRetrial(const t_U32 cou32DeviceHandle);


   private:


      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclUSBReset::vRetryUSBReset
       ***************************************************************************/
      /*!
       * \fn      t_Void vRetryUSBReset()
       * \brief   Retries USB Reset
       * \param   cou32DeviceHandle: Device handle
       * \sa      bSwitchToUSBMode()
       **************************************************************************/
      t_Void vRetryUSBReset(const t_U32 cou32DeviceHandle);

      /***************************************************************************
       ** FUNCTION:  spi_tclUSBReset::bUSBResetTimerCb
       ***************************************************************************/
      /*!
       * \fn     bUSBResetTimerCb
       * \brief  called on expiry of USB reset timer
       * \param  rTimerID: ID of the timer which has expired
       * \param  pvObject: pointer to object passed while starting the timer
       * \param  pvUserData: data passed during start of the timer
       **************************************************************************/
      static t_Bool bUSBResetTimerCb(timer_t rTimerID, t_Void *pvObject,
               const t_Void *pvUserData);

      //! Stores USB reset info
      std::map<t_U32, trUSBResetInfo> m_mapUSBDeviceResetInfo;

      //! Lock to protect m_mapUSBDeviceResetInfo
      Lock m_oLockUSBResetInfo;

      spi_tclDiscoveryDataIntf *m_pDiscovereryDataIntf;

};
/*! } */



#endif /* SPI_TCLUSBRESET_H_ */
