/*!
 *******************************************************************************
 * \file             spi_tclOnCarSwitch.h
 * \brief            AAP device switcher
 * \addtogroup       Device Switcher
 * \{
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:     OnCar device switcher
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author              | Modifications
 06.02.2018 |  Unmukt Jain         | Initial Version

 \endverbatim
 ******************************************************************************/

#ifndef SPI_TCLONCARSWITCH_H_
#define SPI_TCLONCARSWITCH_H_

#include "Lock.h"
#include "SPITypes.h"
#include "spi_ConnMngrTypeDefines.h"
#include "spi_tclDeviceSwitchBase.h"

/**
 * \class spi_tclOnCarSwitch
 * \brief  OnCar device switcher. Responsible for switching OnCar devices to AOAP mode.
 */

class spi_tclOnCarSwitch: public spi_tclDeviceSwitchBase
{

   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarSwitch::spi_tclOnCarSwitch
       ***************************************************************************/
      /*!
       * \brief   Default Constructor
       **************************************************************************/
    spi_tclOnCarSwitch();

      /***************************************************************************
       ** FUNCTION:  spi_tclOnCarSwitch::~spi_tclOnCarSwitch()
       ***************************************************************************/
      /*!
       * \brief   Destructor
       **************************************************************************/
      virtual ~spi_tclOnCarSwitch();

      /***************************************************************************
       ** FUNCTION:  spi_tclDeviceSwitchBase::enSwitchDeviceMode
       ***************************************************************************/
      /*!
       * \brief   Switch the connection profile of the device from default mode to AOAP mode
       * \param   enDeviceCat: SPI technology to which the device has to be switched to
       * \param   enDeviceSwitchType: Device Switch type
       * \param   rfrDeviceSwitchInfo:[OUT] Device switch Information is populated on successful switch
       * \retval   tenDeviceSwitchResult: Indicates result of device switch
       **************************************************************************/
      virtual tenDeviceSwitchResult enSwitchDeviceMode(const trUSBDeviceInfo &rfrDeviceInfo,
               trDeviceSwitchInfo &rfrDeviceSwitchInfo, tenDeviceType enDeviceType = e8_UNKNOWN_DEVICE);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDeviceSwitcher::vSetHeadUnitInfo
       ***************************************************************************/
      /*!
       * \brief   Sets the Headunit information such as model name, vehicle ID etc.
       *          This function has to be called on load settings so that the underlying discoverers
       *          are aware of this info before performing the switch operations.
       *          This infomation will be used during AOAP switch
       * \param   corfrHeadUnitInfo: Reference to the structure containing head unit info
       **************************************************************************/
      virtual t_Void vSetHeadUnitInfo(const trHeadUnitInfo &corfrHeadUnitInfo);

   private:

      //! Stores head unit information
      trHeadUnitInfo m_rHeadUnitInfo;
};
/*! } */

#endif /* SPI_TCLONCARSWITCH_H_ */
