/***********************************************************************/
/*!
 * \file  spi_tclBDCLInputHandler.h
 * \brief SPI input handler for BDCL devices
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Input Handler to report input events from Head Unit to
 BDCL supported Mobile device.
 AUTHOR:         rur1kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author              | Modifications
 18.04.2017 |  Ramya Murthy        | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLBDCLINPUTHANDLER_H_
#define _SPI_TCLBDCLINPUTHANDLER_H_

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include <memory>

#include "spi_tclInputDevBase.h"
#include "BDCLTypes.h"
#include "SPITypes.h"

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/
//! Forward declarations
class spi_tclBDCLCmdInput;

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
typedef std::shared_ptr< spi_tclBDCLCmdInput >     t_SptrBDCLCmdInput;

/****************************************************************************/
/*!
 * \class spi_tclBDCLInputHandler
 * \brief
 ****************************************************************************/
class spi_tclBDCLInputHandler : public spi_tclInputDevBase
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLInputHandler::spi_tclBDCLInputHandler()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLInputHandler()
       * \brief   Default Constructor
       * \sa      spi_tclBDCLInputHandler()
       **************************************************************************/
      spi_tclBDCLInputHandler();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLInputHandler::~spi_tclBDCLInputHandler()
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclBDCLInputHandler()
       * \brief   Destructor
       * \sa      ~spi_tclBDCLInputHandler()
       **************************************************************************/
      ~spi_tclBDCLInputHandler();

      /***************************************************************************
      ** FUNCTION:  virtual t_Void spi_tclBDCLInputHandler::vProcessTouchEvent
      ***************************************************************************/
      /*!
      * \fn      vProcessTouchEvent(t_U32 u32DeviceHandle,trTouchData &rfrTouchData)
      * \brief   Receives the Touch events and forwards it to further handlers
      for processing
      * \param   u32DeviceHandle  : [IN] unique identifier to ML Server
      * \param   rfrTouchData     : [IN] reference to touch data structure which contains
      *          touch details received /ref trTouchData
      * \retval  NONE
      **************************************************************************/
      virtual t_Void vProcessTouchEvent(t_U32 u32DeviceHandle,
         trTouchData &rfrTouchData)const {}

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLInputHandler::vProcessKeyEvents
       ***************************************************************************/
      /*!
       * \fn      vProcessKeyEvents(t_U32 u32DeviceHandle, tenKeyMode enKeyMode,
       tenKeyCode enKeyCode)
       * \brief   Receives hard key events and forwards it to BDCL InputSource Endpoint
       * 		  wrapper.
       * \param   u32DeviceHandle : [IN] unique identifier to BDCL device
       * \param   enKeyMode       : [IN] indicates keypress or keyrelease
       * \param   enKeyCode       : [IN] unique key code identifier
       * \retval  NONE
       **************************************************************************/
      virtual t_Void vProcessKeyEvents(t_U32 u32DeviceHandle, tenKeyMode enKeyMode, tenKeyCode enKeyCode) const;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLInputHandler::vProcessKnobKeyEvents
       ***************************************************************************/
      /*!
       * \fn    vProcessKnobKeyEvents(t_U32 u32DeviceHandle,t_S8 s8EncoderDeltaCount)
       * \brief   Receives knob key events and forwards it to
       further handlers for processing
       * \param   u32DeviceHandle : [IN] unique identifier to BDCL Server
       * \param   s8EncoderDeltaCount : [IN] encoder delta count
       * \retval  NONE
       **************************************************************************/
      virtual t_Void vProcessKnobKeyEvents(t_U32 u32DeviceHandle, t_S8 s8EncoderDeltaCnt) const;

      /***************************************************************************
       ** FUNCTION:  t_Void  spi_tclBDCLInputHandler::vRegisterInputCallbacks()
       ***************************************************************************/
      /*!
       * \fn      t_Void vRegisterVideoCallbacks(const trInputCallbacks& corfrInputCallbacks)
       * \brief   To Register for the asynchronous responses that are required from
       *          ML/DiPo/BDCL Video
       * \param   corfrVideoCallbacks : [IN] Input callabcks structure
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vRegisterInputCallbacks(const trInputCallbacks& corfrInputCallbacks);

      /***************************************************************************
       ** FUNCTION: virtual t_Void spi_tclBDCLInputHandler::vOnSelectDevice()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDevice(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenDeviceCategory coenDevCat,
       *                 const trUserContext& corfrcUsrCntxt)
       * \brief   To setup Video related info when a device is selected or
       *          de selected.
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Type.
       * \pram    coenDevCat  : [IN] Identifies the Connection Request.
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vSelectDevice(const t_U32 cou32DevId,
            const tenDeviceConnectionReq coenConnReq);

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLInputHandler::vOnSelectDeviceResult()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
       *                 const tenDeviceConnectionReq coenConnReq,
       *                 const tenResponseCode coenRespCode)
       * \brief   To perform the actions that are required, after the select device is
       *           successful/failed
       * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
       * \pram    coenConnReq : [IN] Identifies the Connection Request.
       * \pram    coenRespCode: [IN] Response code. Success/Failure
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
            const tenDeviceConnectionReq coenConnReq,
            const tenResponseCode coenRespCode);

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLInputHandler (const spi_tclBDCLInputHandler...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLInputHandler( const spi_tclBDCLInputHandler& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLInputHandler()
       ***************************************************************************/
      spi_tclBDCLInputHandler(const spi_tclBDCLInputHandler& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLInputHandler& operator=( const spi_tclBDCLIn...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLInputHandler& operator=(const spi_tclBDCLInputHandler& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLInputHandler(const spi_tclBDCLInputHandler& otrSrc)
       ***************************************************************************/
      spi_tclBDCLInputHandler& operator=(const spi_tclBDCLInputHandler& corfoSrc);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclBDCLInputHandler::vOnSpeechAppUpdateCb(tenSpeechAppState enSpeechAppState)
       ***************************************************************************/
      /*!
       * \fn      vOnSpeechAppUpdateCb()
       * \brief   vOnDeviceAppUpdateCbMethod.
       * \param   enSpeechAppState:  Speech  states
       * \param   enPhoneAppState:   phone states
       * \param   enNavAppState:     Navigation states
       **************************************************************************/
      t_Void vOnSpeechAppUpdateCb(tenSpeechAppState enSpeechAppState,
                                  tenPhoneAppState enPhoneAppState,
                                  tenNavAppState enNavAppState);


      //! Pointer to Cmd Input class
      t_SptrBDCLCmdInput m_spoCmdInput;

      //! Input Callbacks structure
      trInputCallbacks m_rInputCallbacks;

      //! Structure containing Scaling attributes
      trScalingAttributes m_rScalingAttributes;


      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/

};

#endif //_SPI_TCLBDCLINPUTHANDLER_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>

