/***********************************************************************/
/*!
* \file  spi_tclBDCLVideoDispatcher.cpp
* \brief Message Dispatcher for Video Messages
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Video Messages
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
24.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/

#include "RespRegister.h"
#include "spi_tclBDCLRespVideo.h"
#include "spi_tclBDCLVideoDispatcher.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
      #include "trcGenProj/Header/spi_tclBDCLVideoDispatcher.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleVideoMsg(this);                  \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
** FUNCTION:  BDCLVideoMsgBase::BDCLVideoMsgBase
***************************************************************************/
BDCLVideoMsgBase::BDCLVideoMsgBase()
{
   ETG_TRACE_USR1(("BDCLVideoMsgBase() entered "));
   vSetServiceID(e32MODULEID_BDCLVIDEO);
}

/***************************************************************************
 ** FUNCTION:  BDCLVideoPlaybackStartMsg::BDCLVideoPlaybackStartMsg
 ***************************************************************************/
BDCLVideoPlaybackStartMsg::BDCLVideoPlaybackStartMsg()
{
   ETG_TRACE_USR1(("PlaybackStartMsg::PlaybackStartMsg entered "));
}

/***************************************************************************
** FUNCTION:  BDCLVideoPlaybackStartMsg::vDispatchMsg
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLVideoPlaybackStartMsg, spi_tclBDCLVideoDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLVideoEncoderInitDoneMsg::BDCLVideoEncoderInitDoneMsg
 ***************************************************************************/
BDCLVideoEncoderInitDoneMsg::BDCLVideoEncoderInitDoneMsg():
         m_u32Width(0), m_u32Height(0), m_u32Framerate(0)
{
   ETG_TRACE_USR1(("BDCLVideoEncoderInitDoneMsg::BDCLVideoEncoderInitDoneMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
** FUNCTION:  BDCLVideoEncoderInitDoneMsg::vDispatchMsg
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLVideoEncoderInitDoneMsg, spi_tclBDCLVideoDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLVideoHeartBeatMsg::BDCLVideoHeartBeatMsg
 ***************************************************************************/
BDCLVideoHeartBeatMsg::BDCLVideoHeartBeatMsg()
{
   ETG_TRACE_USR1(("HeartBeatMsg::HeartBeatMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
** FUNCTION:  BDCLVideoHeartBeatMsg::vDispatchMsg
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLVideoHeartBeatMsg, spi_tclBDCLVideoDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLVideoForegroundMsg::BDCLVideoForegroundMsg
 ***************************************************************************/
BDCLVideoForegroundMsg::BDCLVideoForegroundMsg():m_bForeground(false)
{
   ETG_TRACE_USR1(("ForegroundMsg::ForegroundMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
** FUNCTION:  BDCLVideoForegroundMsg::vDispatchMsg
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLVideoForegroundMsg, spi_tclBDCLVideoDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLVideoGotoForegroundMsg::BDCLVideoGotoForegroundMsg
 ***************************************************************************/
BDCLVideoGotoForegroundMsg::BDCLVideoGotoForegroundMsg()
{
   ETG_TRACE_USR1(("GotoForegroundMsg::GotoForegroundMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
** FUNCTION:  BDCLVideoGotoForegroundMsg::vDispatchMsg
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLVideoGotoForegroundMsg, spi_tclBDCLVideoDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLVideoScreenOnOffMsg::BDCLVideoScreenOnOffMsg
 ***************************************************************************/
BDCLVideoScreenOnOffMsg::BDCLVideoScreenOnOffMsg():m_bScreenOn(false)
{
   ETG_TRACE_USR1(("ScreenOnOffMsg::ScreenOnOffMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
** FUNCTION:  BDCLVideoScreenOnOffMsg::vDispatchMsg
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLVideoScreenOnOffMsg, spi_tclBDCLVideoDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLVideoScreenUserPresentMsg::BDCLVideoScreenUserPresentMsg
 ***************************************************************************/
BDCLVideoScreenUserPresentMsg::BDCLVideoScreenUserPresentMsg()
{
   ETG_TRACE_USR1(("ScreenUserPresentMsg::ScreenUserPresentMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
** FUNCTION:  BDCLVideoScreenUserPresentMsg::vDispatchMsg
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLVideoScreenUserPresentMsg, spi_tclBDCLVideoDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLVideoGotoDesktopMsg::BDCLVideoGotoDesktopMsg
 ***************************************************************************/
BDCLVideoGotoDesktopMsg::BDCLVideoGotoDesktopMsg()
{
   ETG_TRACE_USR1(("GotoDesktopMsg::GotoDesktopMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
** FUNCTION:  BDCLVideoGotoDesktopMsg::vDispatchMsg
***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLVideoGotoDesktopMsg, spi_tclBDCLVideoDispatcher);


/***************************************************************************
 ** FUNCTION:  spi_tclBDCLVideoDispatcher::spi_tclBDCLVideoDispatcher
 ***************************************************************************/
spi_tclBDCLVideoDispatcher::spi_tclBDCLVideoDispatcher()
{
   ETG_TRACE_USR1((" spi_tclBDCLVideoDispatcher::spi_tclBDCLVideoDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLVideoDispatcher::~spi_tclBDCLVideoDispatcher
 ***************************************************************************/
spi_tclBDCLVideoDispatcher::~spi_tclBDCLVideoDispatcher()
{
   ETG_TRACE_USR1((" spi_tclBDCLVideoDispatcher::~spi_tclBDCLVideoDispatcher "));
}

/***************************************************************************
** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoPlaybackStartMsg..)
***************************************************************************/
t_Void spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoPlaybackStartMsg* poMsg)const
{
   ETG_TRACE_USR1(("spi_tclBDCLVideoDispatcher::vHandleVideoMsg:PlaybackStart entered"));
   if (NULL != poMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespVideo,
         e16BDCL_VIDEO_REGID,
         vOnPlaybackStart());
   } // if (NULL != poMsg)
}

/***************************************************************************
** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoEncoderInitDoneMsg..)
***************************************************************************/
t_Void spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoEncoderInitDoneMsg* poMsg)const
{
   ETG_TRACE_USR1(("spi_tclBDCLVideoDispatcher::vHandleVideoMsg:BDCLVideoEncoderInitDoneMsg entered"));
   if (NULL != poMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespVideo,
         e16BDCL_VIDEO_REGID,
         vOnVideoEncoderInitDone(poMsg->m_u32Width, poMsg->m_u32Height, poMsg->m_u32Framerate));
   } // if (NULL != poMsg)
}

/***************************************************************************
** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoHeartBeatMsg..)
***************************************************************************/
t_Void spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoHeartBeatMsg* poMsg)const
{
   ETG_TRACE_USR1(("spi_tclBDCLVideoDispatcher::vHandleVideoMsg:HeartBeat entered"));
   if (NULL != poMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespVideo,
         e16BDCL_VIDEO_REGID,
         vOnHeartBeat());
   } // if (NULL != poMsg)
}

/***************************************************************************
** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoForegroundMsg..)
***************************************************************************/
t_Void spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoForegroundMsg* poMsg)const
{
   ETG_TRACE_USR1(("spi_tclBDCLVideoDispatcher::vHandleVideoMsg:Foreground entered"));
   if (NULL != poMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespVideo,
         e16BDCL_VIDEO_REGID,
         vOnForeground(poMsg->m_bForeground));
   } // if (NULL != poMsg)
}

/***************************************************************************
** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoGotoForegroundMsg..)
***************************************************************************/
t_Void spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoGotoForegroundMsg* poMsg)const
{
   ETG_TRACE_USR1(("spi_tclBDCLVideoDispatcher::vHandleVideoMsg:GotoForeground entered"));
   if (NULL != poMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespVideo,
         e16BDCL_VIDEO_REGID,
         vOnGotoForeground());
   } // if (NULL != poMsg)
}

/***************************************************************************
** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoScreenOnOffMsg..)
***************************************************************************/
t_Void spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoScreenOnOffMsg* poMsg)const
{
   ETG_TRACE_USR1(("spi_tclBDCLVideoDispatcher::vHandleVideoMsg:ScreenOnOff entered"));
   if (NULL != poMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespVideo,
         e16BDCL_VIDEO_REGID,
         vOnScreenOnOff(poMsg->m_bScreenOn));
   } // if (NULL != poMsg)
}

/***************************************************************************
** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoScreenUserPresentMsg..)
***************************************************************************/
t_Void spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoScreenUserPresentMsg* poMsg)const
{
   ETG_TRACE_USR1(("spi_tclBDCLVideoDispatcher::vHandleVideoMsg:ScreenUserPresent entered"));
   if (NULL != poMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespVideo,
         e16BDCL_VIDEO_REGID,
         vOnScreenUserPresent());
   } // if (NULL != poMsg)
}

/***************************************************************************
** FUNCTION:  spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoGotoDesktopMsg..)
***************************************************************************/
t_Void spi_tclBDCLVideoDispatcher::vHandleVideoMsg(BDCLVideoGotoDesktopMsg* poMsg)const
{
   ETG_TRACE_USR1(("spi_tclBDCLVideoDispatcher::vHandleVideoMsg:GotoDesktop entered"));
   if (NULL != poMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespVideo,
         e16BDCL_VIDEO_REGID,
         vOnGotoDeskTop());
   } // if (NULL != poMsg)
}

///////////////////////////////////////////////////////////////////////////////
// <EOF>
