/***********************************************************************/
/*!
* \file  spi_tclBDCLCmdVideo.h
* \brief  Implementation of the Class spi_tclBDCLCmdVideo
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         tch5kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLCMDVIDEO_
#define SPI_TCLBDCLCMDVIDEO_

#include <memory>
#include <bdcl/AditVideoSink.h>

#include "BaseTypes.h"
#include "BDCLTypes.h"
#include "BDCL_WrapperTypes.h"
#include "spi_tclBDCLProxyManager.h"
#include "spi_tclVideoSettingsIntf.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
typedef std::unique_ptr< adit::bdcl::AditVideoSink >     t_SptrBDCLVideoSink;

/*!
 * \class spi_tclBDCLCmdVideo
 * \brief
 */
class spi_tclBDCLCmdVideo : public adit::bdcl::IAditVideoSinkCallbacks
{

public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLCmdVideo
       ***************************************************************************/
      /*!
       * \fn       spi_tclBDCLCmdVideo()
       * \brief    Constructor
       * \sa       ~spi_tclBDCLCmdVideo()
       **************************************************************************/
      spi_tclBDCLCmdVideo();

      /***************************************************************************
       ** FUNCTION:   ~spi_tclBDCLCmdVideo()
       ***************************************************************************/
      /*!
       * \fn       ~spi_tclBDCLCmdVideo()
       * \brief    Destructor
       * \sa       spi_tclBDCLCmdVideo()
       **************************************************************************/
      virtual ~spi_tclBDCLCmdVideo();

      /***************************************************************************
       ** FUNCTION:  t_Bool bInitialize()
       ***************************************************************************/
      /*!
       * \fn      bInitialize()
       * \brief   Performs initialization of Video endpoint
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize(const trBdclVideoConfig& corfrVideoConfig);

      /***************************************************************************
       ** FUNCTION:  t_Bool vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      vUninitialize()
       * \brief   Performs uninitialization of Video endpoint
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUninitialize();

      /***************************************************************************
       ** FUNCTION:  t_Void vPrepareVideo()
       ***************************************************************************/
      /*!
       * \fn      vPrepareVideo()
       * \brief   Interface to perform video handshake with MD
       * \param   None
       **************************************************************************/
      t_Void vPrepareVideo();

      /***************************************************************************
       ** FUNCTION:  t_Void vStartVideo()
       ***************************************************************************/
      /*!
       * \fn      vStartVideo()
       * \brief   Interface to notify MD to start video frames
       * \param   None
       **************************************************************************/
      t_Void vStartVideo();

      /***************************************************************************
       ** FUNCTION:  t_Void vPauseVideo()
       ***************************************************************************/
      /*!
       * \fn      vPauseVideo()
       * \brief   Interface to notify MD to pause video frames
       * \param   None
       **************************************************************************/
      t_Void vPauseVideo();

      /***************************************************************************
      ** FUNCTION:  t_Void vSetVideoSettingsInstance(spi_tclVideoSettingsIntf* poVideoSettingsIntf)
      ***************************************************************************/
      /*!
      * \fn      t_Void vSetVideoSettingsInstance()
      * \brief   Method to set video settings instance.
      * \param   poVideoSettingsIntf  : pointer to VideoSettingsIntf.
      * \retval  t_Void
      **************************************************************************/
     t_Void vSetVideoSettingsInstance(spi_tclVideoSettingsIntf* poVideoSettingsIntf);

   private:

      /***************************************************************************
       ** FUNCTION: spi_tclBDCLCmdVideo(const spi_tclBDCLCmdVideo&)
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLCmdVideo(const spi_tclBDCLCmdVideo&)
       * \brief   Copy constructor not implemented
       **************************************************************************/
      spi_tclBDCLCmdVideo(const spi_tclBDCLCmdVideo&);

      /***************************************************************************
       ** FUNCTION: const spi_tclBDCLCmdVideo & operator=(const spi_tclBDCLCmdVideo&);
       ***************************************************************************/
      /*!
       * \fn      const spi_tclBDCLCmdVideo & operator=(const spi_tclBDCLCmdVideo&);
       * \brief   assignment operator not implemented
       **************************************************************************/
      const spi_tclBDCLCmdVideo & operator=(const spi_tclBDCLCmdVideo&);

      /***************************************************************************
       ** FUNCTION:  t_Bool vRegisterCallbacks()
       ***************************************************************************/
      /*!
       * \fn      vRegisterCallbacks()
       * \brief   Registers for interested callbacks with Video Proxy lib
       * \retval  None
       **************************************************************************/
      t_Void vRegisterCallbacks();

      /***************************************************************************
       ** FUNCTION:  t_Bool szPrepareVideoPipeline()
       ***************************************************************************/
      /*!
       * \fn      szPrepareVideoPipeline()
       * \brief   Creates video pipeline configuration string
       * \param   corfrVideoConfig [IN]: Video configuration data
       * \retval  t_String
       **************************************************************************/
      t_String szPrepareVideoPipeline(const trBdclVideoConfig& corfrVideoConfig);

      /***************************************************************************
       ** FUNCTION:  t_Void vSetVideoSinkConfig( )
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetVideoSinkConfig()
       * \brief   Function to set the Video configuration to Video sink
       * \param   corfrVideoConfig: [IN] Video device configuration
       **************************************************************************/
      t_Void vSetVideoSinkConfig(const trBdclVideoConfig& corfrVideoConfig);

      /***************************************************************************
       ** FUNCTION:  void onFirstFrameRendered()
       ***************************************************************************/
      /*!
       * \fn      onFirstFrameRendered()
       * \brief   Triggered when MD sends first video frame
       * \param   None
       **************************************************************************/
      virtual void onFirstFrameRendered();

      /***************************************************************************
       ** FUNCTION:  void onVideoEncoderInitDone()
       ***************************************************************************/
      /*!
       * \fn      onVideoEncoderInitDone()
       * \brief   Callback to receive VideoEncoderInitDone response from MD
       *             containing video resolution selected by MD
       * \param   inWidth [IN]: Video width selected by MD
       * \param   inHeight [IN]: Video height selected by MD
       * \param   inFramerate [IN]: Video frame rate selected by MD
       **************************************************************************/
      virtual void onVideoEncoderInitDone(unsigned int inWidth,
               unsigned int inHeight, unsigned int inFramerate);

      /***************************************************************************
       ** FUNCTION:  void onConnectException()
       ***************************************************************************/
      /*!
       * \fn      onConnectException()
       * \brief   Callback to receive connection exception info
       * \param   inConnectException [IN]: Exception type enumeration
       **************************************************************************/
      virtual void onConnectException(tBdclConnectException inConnectException);

      /***************************************************************************
       ** FUNCTION:  void onError()
       ***************************************************************************/
      /*!
       * \fn      onError()
       * \brief   Callback to receive video error info
       * \param   inErrorCode [IN]: Error type enumeration
       **************************************************************************/
      virtual void onError(tBdclErrorCodes inErrorCode);

      /***************************************************************************
       ** FUNCTION:  t_Void vOnHeartBeatCb()
       ***************************************************************************/
      /*!
       * \fn      vOnHeartBeatCb()
       * \brief   Callback handler for Hearbeat message from MD
       * \param   None
       **************************************************************************/
      static t_Void vOnHeartBeatCb();

      /***************************************************************************
       ** FUNCTION:   t_Void vOnForegroundCb()
       ***************************************************************************/
      /*!
       * \fn      vOnForegroundCb()
       * \brief   Callback handler for Foreground message from MD
       * \param   None
       **************************************************************************/
      static t_Void vOnForegroundCb();

      /***************************************************************************
       ** FUNCTION:   t_Void vOnBackgroundCb()
       ***************************************************************************/
      /*!
       * \fn      vOnBackgroundCb()
       * \brief   Callback handler for Background message from MD
       * \param   None
       **************************************************************************/
      static t_Void vOnBackgroundCb();

      /***************************************************************************
       ** FUNCTION:   t_Void vOnGotoForegroundCb()
       ***************************************************************************/
      /*!
       * \fn      vOnGotoForegroundCb()
       * \brief   Callback handler for GotoForeground message from MD
       * \param   None
       **************************************************************************/
      static t_Void vOnGotoForegroundCb();

      /***************************************************************************
       ** FUNCTION:   t_Void vOnScreenOnCb()
       ***************************************************************************/
      /*!
       * \fn      vOnScreenOnCb()
       * \brief   Callback handler for ScreenOn message from MD
       * \param   None
       **************************************************************************/
      static t_Void vOnScreenOnCb();

      /***************************************************************************
       ** FUNCTION:   t_Void vOnScreenOffCb()
       ***************************************************************************/
      /*!
       * \fn      vOnScreenOffCb()
       * \brief   Callback handler for ScreenOff message from MD
       * \param   None
       **************************************************************************/
      static t_Void vOnScreenOffCb();

      /***************************************************************************
       ** FUNCTION:   t_Void vOnScreenUserPresentCb()
       ***************************************************************************/
      /*!
       * \fn      vOnScreenUserPresentCb()
       * \brief   Callback handler for ScreenUserPresent message from MD
       * \param   None
       **************************************************************************/
      static t_Void vOnScreenUserPresentCb();

      /***************************************************************************
       ** FUNCTION:   t_Void vOnGotoDeskTopCb()
       ***************************************************************************/
      /*!
       * \fn      vOnGotoDeskTopCb()
       * \brief   Callback handler for GotoDesktop message from MD
       * \param   None
       **************************************************************************/
      static t_Void vOnGotoDeskTopCb();

      //! Pointer to Video proxy
      t_SptrBDCLVideoProxy m_spoVideoProxy;

      //! Pointer to Video sink
      t_SptrBDCLVideoSink m_spoVideoSink;

      //! Lock object for Video sink endpoint
      Lock  m_oEndpointLock;

      //! Indicates if video playback is started
      t_Bool m_bIsVideoPauseEnabled;

      tenBdclVideoState m_enVidState;

      spi_tclVideoSettingsIntf* m_poVideoSettings;

};
#endif //SPI_TCLBDCLCMDVIDEO_
