/***********************************************************************/
/*!
* \file  spi_tclBDCLSessionDispatcher.cpp
* \brief Message Dispatcher for Session Messages
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Session Messages
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
24.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/

#include "RespRegister.h"
#include "spi_tclBDCLRespSession.h"
#include "spi_tclBDCLSessionDispatcher.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclBDCLSessionDispatcher.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleSessionMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  BDCLSessionMsgBase::BDCLSessionMsgBase
 ***************************************************************************/
BDCLSessionMsgBase::BDCLSessionMsgBase()
{
   ETG_TRACE_USR1(("BDCLSessionMsgBase::BDCLSessionMsgBase entered "));
   vSetServiceID (e32MODULEID_BDCLSESSION);
}

/***************************************************************************
 ** FUNCTION:  BDCLMDInfoMsg::BDCLMDInfoMsg
 ***************************************************************************/
BDCLMDInfoMsg::BDCLMDInfoMsg()
{
   ETG_TRACE_USR1(("BDCLMDInfoMsg::BDCLMDInfoMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLMDInfoMsg::BDCLMDInfoMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLMDInfoMsg, spi_tclBDCLSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLMDInfoMsg::vAllocateMsg
 ***************************************************************************/
t_Void BDCLMDInfoMsg::vAllocateMsg()
{
   m_prMDInfo = new trBdclMDInfo;
   SPI_NORMAL_ASSERT(NULL == m_prMDInfo);
}

/***************************************************************************
 ** FUNCTION:  BDCLMDInfoMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BDCLMDInfoMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_prMDInfo);
}

/***************************************************************************
 ** FUNCTION:  BDCLProtocolVersionMatchStatusMsg::BDCLProtocolVersionMatchStatusMsg
 ***************************************************************************/
BDCLProtocolVersionMatchStatusMsg::BDCLProtocolVersionMatchStatusMsg() : bProtocolMatchStatus(false)
{
   ETG_TRACE_USR1(("BDCLProtocolVersionMatchStatusMsg::BDCLProtocolVersionMatchStatusMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLProtocolVersionMatchStatusMsg::BDCLProtocolVersionMatchStatusMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLProtocolVersionMatchStatusMsg, spi_tclBDCLSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLModuleStatusMsg::BDCLModuleStatusMsg
 ***************************************************************************/
BDCLModuleStatusMsg::BDCLModuleStatusMsg()
{
   ETG_TRACE_USR1(("BDCLModuleStatusMsg::BDCLModuleStatusMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLModuleStatusMsg::BDCLModuleStatusMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLModuleStatusMsg, spi_tclBDCLSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLModuleStatusMsg::vAllocateMsg
 ***************************************************************************/
t_Void BDCLModuleStatusMsg::vAllocateMsg()
{
   m_pStatusList = new tBdclModuleStatusList;
   SPI_NORMAL_ASSERT(NULL == m_pStatusList);
}

/***************************************************************************
 ** FUNCTION:  BDCLModuleStatusMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void BDCLModuleStatusMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_pStatusList);
}

/***************************************************************************
 ** FUNCTION:  BDCLExitMsg::BDCLExitMsg
 ***************************************************************************/
BDCLExitMsg::BDCLExitMsg()
{
   ETG_TRACE_USR1(("BDCLExitMsg::BDCLExitMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLExitMsg::BDCLExitMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLExitMsg, spi_tclBDCLSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLFeatureConfigRequestMsg::BDCLFeatureConfigRequestMsg
 ***************************************************************************/
BDCLFeatureConfigRequestMsg::BDCLFeatureConfigRequestMsg()
{
   ETG_TRACE_USR1(("BDCLFeatureConfigRequestMsg::BDCLFeatureConfigRequestMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLFeatureConfigRequestMsg::BDCLFeatureConfigRequestMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLFeatureConfigRequestMsg, spi_tclBDCLSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLCoreErrorMsg::BDCLCoreErrorMsg
 ***************************************************************************/
BDCLCoreErrorMsg::BDCLCoreErrorMsg(): m_enCarlifeError(e8CL_AOAP_ERROR_UNKNOWN)
{
   ETG_TRACE_USR1(("BDCLCoreErrorMsg::BDCLCoreErrorMsg entered "));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLCoreErrorMsg::BDCLCoreErrorMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLCoreErrorMsg, spi_tclBDCLSessionDispatcher);

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLSessionDispatcher::spi_tclBDCLSessionDispatcher
 ***************************************************************************/
spi_tclBDCLSessionDispatcher::spi_tclBDCLSessionDispatcher()
{
   ETG_TRACE_USR1((" spi_tclBDCLSessionDispatcher::spi_tclBDCLSessionDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLSessionDispatcher::~spi_tclBDCLSessionDispatcher
 ***************************************************************************/
spi_tclBDCLSessionDispatcher::~spi_tclBDCLSessionDispatcher()
{
   ETG_TRACE_USR1((" spi_tclBDCLSessionDispatcher::~spi_tclBDCLSessionDispatcher "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLMDInfoMsg* poDeviceInfoMsg)
 ***************************************************************************/
t_Void spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLMDInfoMsg* poBDCLMDInfoMsg) const
{
   ETG_TRACE_USR1((" spi_tclBDCLSessionDispatcher::vHandleSessionMsg:MDInfo entered "));
   if (NULL != poBDCLMDInfoMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespSession,
               e16BDCL_SESSION_REGID,
               vOnMDInfo(*poBDCLMDInfoMsg->m_prMDInfo));
   } // if (NULL != poDeviceInfoMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLModuleStatusMsg* poDeviceInfoMsg)
 ***************************************************************************/
t_Void spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLModuleStatusMsg* poBDCLModuleStatusMsg) const
{
   ETG_TRACE_USR1((" spi_tclBDCLSessionDispatcher::vHandleSessionMsg:ModuleStatus entered "));
   if (NULL != poBDCLModuleStatusMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespSession,
               e16BDCL_SESSION_REGID,
               vOnModuleStatusInfo(*poBDCLModuleStatusMsg->m_pStatusList));
   } // if (NULL != poDeviceInfoMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLExitMsg* poBDCLExitMsg)
 ***************************************************************************/
t_Void spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLExitMsg* poBDCLExitMsg) const
{
   ETG_TRACE_USR1((" spi_tclBDCLSessionDispatcher::vHandleSessionMsg:Exit Msg entered "));
   if (NULL != poBDCLExitMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespSession,
               e16BDCL_SESSION_REGID,
               vOnExitInfo());
   } // if (NULL != poDeviceInfoMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLProtocolVersionMatchStatusMsg* poBDCLProtocolVersionMatchStatusMsg)
 ***************************************************************************/
t_Void spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLProtocolVersionMatchStatusMsg* poBDCLProtocolVersionMatchStatusMsg) const
{
   ETG_TRACE_USR1(("spi_tclBDCLSessionDispatcher::vHandleSessionMsg:Protocol Version Match Status entered "));
   if (NULL != poBDCLProtocolVersionMatchStatusMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespSession,
               e16BDCL_SESSION_REGID,
               vOnProtocolVersionMatchStatus(poBDCLProtocolVersionMatchStatusMsg->bProtocolMatchStatus));
   } // if (NULL != poDeviceInfoMsg)
}


/***************************************************************************
 ** FUNCTION:  spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLCoreErrorMsg* poBDCLErrorMsg)
 ***************************************************************************/
t_Void spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLCoreErrorMsg* poBDCLErrorMsg) const
{
   ETG_TRACE_USR1((" spi_tclBDCLSessionDispatcher::vHandleSessionMsg:CoreError Msg entered "));
   if (NULL != poBDCLErrorMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespSession,
               e16BDCL_SESSION_REGID,
               vOnCoreError(poBDCLErrorMsg->m_enCarlifeError));
   } // if (NULL != poDeviceInfoMsg)
}


/***************************************************************************
 ** FUNCTION:  spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLFeatureConfigRequestMsg* poBDCLFeatureConfigRequestMsg)
 ***************************************************************************/
t_Void spi_tclBDCLSessionDispatcher::vHandleSessionMsg(BDCLFeatureConfigRequestMsg* poBDCLFeatureConfigRequestMsg) const
{
   ETG_TRACE_USR1((" spi_tclBDCLSessionDispatcher::vHandleSessionMsg:FeatureConfigRequestt Msg entered "));
   if (NULL != poBDCLFeatureConfigRequestMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespSession,
               e16BDCL_SESSION_REGID,
               vOnFeatureConfigRequest());
   } // if (NULL != poBDCLFeatureConfigRequestMsg)
}
///////////////////////////////////////////////////////////////////////////////
// <EOF>
