/***********************************************************************/
/*!
* \file  spi_tclBDCLRespSession.h
* \brief BDCL Session Output Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    BDCL Session Output Interface
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
24.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLRESPSESSION_H_
#define SPI_TCLBDCLRESPSESSION_H_

#include <vector>

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "BDCLTypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclBDCLRespSession
* \brief BDCL Session Output Interface
*
* updates all the registered clients, whenever there is
* an update on BDCL session
*
****************************************************************************/
class spi_tclBDCLRespSession:public RespBase
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespSession::spi_tclBDCLRespSession()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespSession()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLRespSession()
       **************************************************************************/
      spi_tclBDCLRespSession() :
         RespBase(e16BDCL_SESSION_REGID)
      {
      }

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespSession::~spi_tclBDCLRespSession()
       ***************************************************************************/
      /*!
       * \fn      virtual ~spi_tclBDCLRespSession()
       * \brief   Destructor
       * \sa      spi_tclBDCLRespSession(RegID enRegId)
       **************************************************************************/
      virtual ~spi_tclBDCLRespSession()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespSession::vOnMDInfo()
       ***************************************************************************/
      /*!
       * \fn      vOnMDInfo
       * \brief   Triggered when BDCL device sends device info
       * \param   crfrInfo [IN]: Structure containing BDCL device info
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnMDInfo(const trBdclMDInfo& crfrInfo)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespSession::vOnModuleStatusInfo()
       ***************************************************************************/
      /*!
       * \fn      vOnModuleStatusInfo
       * \brief   Triggered when BDCL device updates status of one or modules on the device
       * \param   corfStatusList [IN]: Structure containing status information of
       *             various logical modules in BDCL device
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnModuleStatusInfo(const tBdclModuleStatusList& corfStatusList)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespSession::vOnExitInfo()
       ***************************************************************************/
      /*!
       * \fn      vOnExitInfo
       * \brief   Triggered when BDCL device sends an exit
       * \param   none
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnExitInfo()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespSession::vOnFeatureConfigRequest()
       ***************************************************************************/
      /*!
       * \fn      vOnFeatureConfigRequest
       * \brief   Triggered when BDCL device sends feature config request
       * \param   none
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnFeatureConfigRequest()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespSession::vOnProtocolVersionMatchStatus()
       ***************************************************************************/
      /*!
       * \fn      vOnProtocolVersionMatchStatus
       * \brief   Triggered when BDCL device updates protocol version match status
       * \param   bProtocolMatchStatus [IN]: TRUE - if protocol version match is successful, else FALSE
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnProtocolVersionMatchStatus(t_Bool bProtocolMatchStatus)
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespSession::vOnCoreError()
       ***************************************************************************/
      /*!
       * \fn      vOnCoreError
       * \brief   Triggered when there is an error notified by AditCoreSurrogate endpoint
       * \param   enCarlifeError [IN]: Error type enumeration
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnCoreError(tenBdclCarLifeError enCarlifeError)
      {
      }

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespSession::spi_tclBDCLRespSession()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespSession(
       *                          const spi_tclBDCLRespSession& corfoSrc))
       * \brief   Parameterized Constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \sa      spi_tclBDCLRespSession(RegID enRegId)
       **************************************************************************/
      spi_tclBDCLRespSession(const spi_tclBDCLRespSession& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespSession& operator=( const spi_tclMLV...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespSession& operator=(
       *                          const spi_tclBDCLRespSession& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLRespSession(const spi_tclBDCLRespSession& otrSrc)
       ***************************************************************************/
      spi_tclBDCLRespSession& operator=(const spi_tclBDCLRespSession& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/


}; //class spi_tclBDCLRespVideo

#endif // SPI_TCLBDCLRESPSESSION_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
