/***********************************************************************/
/*!
* \file  spi_tclBDCLNavigationDispatcher.cpp
* \brief Message Dispatcher for Navigation Messages
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Navigation Messages
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
24.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/

#include "RespRegister.h"
#include "spi_tclBDCLRespNavigation.h"
#include "spi_tclBDCLNavigationDispatcher.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclBDCLNavigationDispatcher.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleNavigationMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  BDCLNavigationMsgBase::BDCLNavigationMsgBase
 ***************************************************************************/
BDCLNavigationMsgBase::BDCLNavigationMsgBase()
{
   ETG_TRACE_USR1(("BDCLNavigationMsgBase::BDCLNavigationMsgBase entered "));
   vSetServiceID (e32MODULEID_BDCLNAVIGATIONTBT);
}

//!class CarLifeDataSubscriptionDoneMsg
/***************************************************************************
 ** FUNCTION:  CarLifeDataSubscriptionDoneMsg::CarLifeDataSubscriptionDoneMsg
 ***************************************************************************/
CarLifeDataSubscriptionDoneMsg::CarLifeDataSubscriptionDoneMsg():
         m_pCarLifeInfoList(NULL)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  CarLifeDataSubscriptionDoneMsg::CarLifeDataSubscriptionDoneMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(CarLifeDataSubscriptionDoneMsg, spi_tclBDCLNavigationDispatcher);

/***************************************************************************
 ** FUNCTION:  CarLifeDataSubscriptionDoneMsg::vAllocateMsg
 ***************************************************************************/
t_Void CarLifeDataSubscriptionDoneMsg::vAllocateMsg()
{
   m_pCarLifeInfoList = new(std::nothrow) tBdclCarLifeInfoList;
   SPI_NORMAL_ASSERT(NULL == m_pCarLifeInfoList);
}

/***************************************************************************
 ** FUNCTION:  CarLifeDataSubscriptionDoneMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void CarLifeDataSubscriptionDoneMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_pCarLifeInfoList);
}

//!class NaviNextTurnInfoMsg
/***************************************************************************
 ** FUNCTION:  NaviNextTurnInfoMsg::NaviNextTurnInfoMsg
 ***************************************************************************/
NaviNextTurnInfoMsg::NaviNextTurnInfoMsg(): m_prNaviNextTurnInfo(NULL)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  NaviNextTurnInfoMsg::NaviNextTurnInfoMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(NaviNextTurnInfoMsg, spi_tclBDCLNavigationDispatcher);

/***************************************************************************
 ** FUNCTION:  NaviNextTurnInfoMsg::vAllocateMsg
 ***************************************************************************/
t_Void NaviNextTurnInfoMsg::vAllocateMsg()
{
   m_prNaviNextTurnInfo = new trBdclNaviNextTurnInfo;
   SPI_NORMAL_ASSERT(NULL == m_prNaviNextTurnInfo);
}

/***************************************************************************
 ** FUNCTION:  NaviNextTurnInfoMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void NaviNextTurnInfoMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_prNaviNextTurnInfo);
}

//Class NaviAssitantGuideInfoMsg
/***************************************************************************
 ** FUNCTION:  NaviAssitantGuideInfoMsg::NaviAssitantGuideInfoMsg
 ***************************************************************************/
NaviAssitantGuideInfoMsg::NaviAssitantGuideInfoMsg(): m_prNaviAssitantGuideInfo(NULL)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  NaviAssitantGuideInfoMsg::NaviAssitantGuideInfoMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(NaviAssitantGuideInfoMsg, spi_tclBDCLNavigationDispatcher);

/***************************************************************************
 ** FUNCTION:  NaviAssitantGuideInfoMsg::vAllocateMsg
 ***************************************************************************/
t_Void NaviAssitantGuideInfoMsg::vAllocateMsg()
{
   m_prNaviAssitantGuideInfo = new trBdclNaviAssitantGuideInfo;
   SPI_NORMAL_ASSERT(NULL == m_prNaviAssitantGuideInfo);
}

/***************************************************************************
 ** FUNCTION:  NaviAssitantGuideInfoMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void NaviAssitantGuideInfoMsg::vDeAllocateMsg()
{
   RELEASE_MEM(m_prNaviAssitantGuideInfo);
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLNavigationDispatcher::spi_tclBDCLNavigationDispatcher
 ***************************************************************************/
spi_tclBDCLNavigationDispatcher::spi_tclBDCLNavigationDispatcher()
{
   ETG_TRACE_USR1((" spi_tclBDCLNavigationDispatcher::spi_tclBDCLNavigationDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLNavigationDispatcher::~spi_tclBDCLNavigationDispatcher
 ***************************************************************************/
spi_tclBDCLNavigationDispatcher::~spi_tclBDCLNavigationDispatcher()
{
   ETG_TRACE_USR1((" spi_tclBDCLNavigationDispatcher::~spi_tclBDCLNavigationDispatcher "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLNavigationDispatcher::vHandleNavigationMsg()
 ***************************************************************************/
t_Void spi_tclBDCLNavigationDispatcher::vHandleNavigationMsg(CarLifeDataSubscriptionDoneMsg* poCarLifeDataSubscriptionDoneMsg) const
{
   ETG_TRACE_USR1(("spi_tclBDCLNavigationDispatcher::vHandleNavigationMsg:CarLifeDataSubscriptionDoneMsg entered"));
   if ((NULL != poCarLifeDataSubscriptionDoneMsg) &&
       (NULL != poCarLifeDataSubscriptionDoneMsg->m_pCarLifeInfoList))
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespNavigation,
               e16BDCL_NAVIGATION_REGID,
               vOnCarLifeDataSubscriptionDoneUpdate(*(poCarLifeDataSubscriptionDoneMsg->m_pCarLifeInfoList)));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLNavigationDispatcher::vHandleNavigationMsg()
 ***************************************************************************/
t_Void spi_tclBDCLNavigationDispatcher::vHandleNavigationMsg(NaviNextTurnInfoMsg* poNaviNextTurnInfoMsg) const
{
   ETG_TRACE_USR1(("spi_tclBDCLNavigationDispatcher::vHandleNavigationMsg:NaviNextTurnInfoMsg entered"));
   if ((NULL != poNaviNextTurnInfoMsg) &&
       (NULL != poNaviNextTurnInfoMsg->m_prNaviNextTurnInfo))
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespNavigation,
               e16BDCL_NAVIGATION_REGID,
               vOnNaviNextTurnInfoUpdate(*(poNaviNextTurnInfoMsg->m_prNaviNextTurnInfo)));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLNavigationDispatcher::vHandleNavigationMsg()
 ***************************************************************************/
t_Void spi_tclBDCLNavigationDispatcher::vHandleNavigationMsg(NaviAssitantGuideInfoMsg* poNaviAssitantGuideInfoMsg) const
{
   ETG_TRACE_USR1(("spi_tclBDCLNavigationDispatcher::vHandleNavigationMsg:NaviAssitantGuideInfoMsg entered"));
   if ((NULL != poNaviAssitantGuideInfoMsg) &&
       (NULL != poNaviAssitantGuideInfoMsg->m_prNaviAssitantGuideInfo))
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespNavigation,
               e16BDCL_NAVIGATION_REGID,
               vOnNaviAssitantGuideInfoUpdate(*(poNaviAssitantGuideInfoMsg->m_prNaviAssitantGuideInfo)));
   }
}

///////////////////////////////////////////////////////////////////////////////
// <EOF>
