/***********************************************************************/
/*!
* \file  spi_tclBDCLNavigationDispatcher.h
* \brief Message Dispatcher for Navigation Messages. implemented using
*        double dispatch mechanism
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Navigation Messages
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
04.05.2017  | pok6kor               | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLNAVIGATIONDISPATCHER_H_
#define SPI_TCLBDCLNAVIGATIONDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "BDCLTypes.h"
#include "SPITypes.h"

//!Forward declarations
class spi_tclBDCLNavigationDispatcher;

/****************************************************************************/
/*!
 * \class BDCLNavigationMsgBase
 * \brief Base Message type for all Navigation messages
 ****************************************************************************/
class BDCLNavigationMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  BDCLNavigationMsgBase::BDCLNavigationMsgBase
       ***************************************************************************/
      /*!
       * \fn      BDCLNavigationMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      BDCLNavigationMsgBase();

      /***************************************************************************
       ** FUNCTION:  BDCLNavigationMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLNavigationDispatcher* poNavigationDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param poNavigationDispatcher : pointer to Message dispatcher for Navigation
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclBDCLNavigationDispatcher* poNavigationDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  BDCLNavigationMsgBase::~BDCLNavigationMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~BDCLNavigationMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLNavigationMsgBase()
      {
      }
};

/****************************************************************************/
/*!
 * \class CarLifeDataSubscriptionDoneMsg
 * \brief Navigation subscription response message
 ****************************************************************************/
class CarLifeDataSubscriptionDoneMsg: public BDCLNavigationMsgBase
{
   public:

      tBdclCarLifeInfoList* m_pCarLifeInfoList;

      /***************************************************************************
       ** FUNCTION:  CarLifeDataSubscriptionDoneMsg::CarLifeDataSubscriptionDoneMsg
       ***************************************************************************/
      /*!
       * \fn      CarLifeDataSubscriptionDoneMsg()
       * \brief   Constructor
       **************************************************************************/
      CarLifeDataSubscriptionDoneMsg();

      /***************************************************************************
       ** FUNCTION:  CarLifeDataSubscriptionDoneMsg::~CarLifeDataSubscriptionDoneMsg
       ***************************************************************************/
      /*!
       * \fn      ~CarLifeDataSubscriptionDoneMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~CarLifeDataSubscriptionDoneMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  CarLifeDataSubscriptionDoneMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLNavigationDispatcher* poNavigationDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poNavigationDispatcher : pointer to Message dispatcher for Navigation
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLNavigationDispatcher* poNavigationDispatcher);

      /***************************************************************************
       ** FUNCTION:  CarLifeDataSubscriptionDoneMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  CarLifeDataSubscriptionDoneMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class NaviNextTurnInfoMsg
 * \brief Navigation Next turn data message
 ****************************************************************************/
class NaviNextTurnInfoMsg: public BDCLNavigationMsgBase
{
   public:

      trBdclNaviNextTurnInfo* m_prNaviNextTurnInfo;

      /***************************************************************************
       ** FUNCTION:  NaviNextTurnInfoMsg::NaviNextTurnInfoMsg
       ***************************************************************************/
      /*!
       * \fn      NaviNextTurnInfoMsg()
       * \brief   Constructor
       **************************************************************************/
      NaviNextTurnInfoMsg();

      /***************************************************************************
       ** FUNCTION:  NaviNextTurnInfoMsg::~NaviNextTurnInfoMsg
       ***************************************************************************/
      /*!
       * \fn      ~NaviNextTurnInfoMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~NaviNextTurnInfoMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  NaviNextTurnInfoMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLNavigationDispatcher* poNavigationDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poNavigationDispatcher : pointer to Message dispatcher for Navigation
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLNavigationDispatcher* poNavigationDispatcher);

      /***************************************************************************
       ** FUNCTION:  NaviNextTurnInfoMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  NaviNextTurnInfoMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class NaviAssitantGuideInfoMsg
 * \brief Navigation assistant guide data message
 ****************************************************************************/
class NaviAssitantGuideInfoMsg: public BDCLNavigationMsgBase
{
   public:

      trBdclNaviAssitantGuideInfo* m_prNaviAssitantGuideInfo;

      /***************************************************************************
       ** FUNCTION:  NaviAssitantGuideInfoMsg::NaviAssitantGuideInfoMsg
       ***************************************************************************/
      /*!
       * \fn      NaviAssitantGuideInfoMsg()
       * \brief   Constructor
       **************************************************************************/
      NaviAssitantGuideInfoMsg();

      /***************************************************************************
       ** FUNCTION:  NaviAssitantGuideInfoMsg::~NaviAssitantGuideInfoMsg
       ***************************************************************************/
      /*!
       * \fn      ~NaviAssitantGuideInfoMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~NaviAssitantGuideInfoMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  NaviAssitantGuideInfoMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLNavigationDispatcher* poNavigationDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poNavigationDispatcher : pointer to Message dispatcher for Navigation
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLNavigationDispatcher* poNavigationDispatcher);

      /***************************************************************************
       ** FUNCTION:  NaviAssitantGuideInfoMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  NaviAssitantGuideInfoMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();

};

/****************************************************************************/
/*!
 * \class spi_tclBDCLNavigationDispatcher
 * \brief Message Dispatcher for Navigation Messages
 ****************************************************************************/
class spi_tclBDCLNavigationDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLNavigationDispatcher::spi_tclBDCLNavigationDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLNavigationDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclBDCLNavigationDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLNavigationDispatcher::~spi_tclBDCLNavigationDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLNavigationDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclBDCLNavigationDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLNavigationDispatcher::vHandleNavigationMsg(CarLifeDataSubscriptionDoneMsg* poBDCLMDInfoMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleNavigationMsg(CarLifeDataSubscriptionDoneMsg* poBDCLMDInfoMsg)
       * \brief   Handles Messages of CarLifeDataSubscriptionDoneMsg type
       * \param   poBDCLMDInfoMsg : pointer to CarLifeDataSubscriptionDoneMsg.
       **************************************************************************/
      t_Void vHandleNavigationMsg(CarLifeDataSubscriptionDoneMsg* poCarLifeDataSubscriptionDoneMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLNavigationDispatcher::vHandleNavigationMsg(NaviNextTurnInfoMsg* poMDInfoMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleNavigationMsg(NaviNextTurnInfoMsg* poMDInfoMsg)
       * \brief   Handles Messages of NaviNextTurnInfoMsg type
       * \param   poNaviNextTurnInfoMsg : pointer to NaviNextTurnInfoMsg.
       **************************************************************************/
      t_Void vHandleNavigationMsg(NaviNextTurnInfoMsg* poNaviNextTurnInfoMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLNavigationDispatcher::vHandleNavigationMsg(NaviAssitantGuideInfoMsg* poConnExceptionMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleNavigationMsg(NaviAssitantGuideInfoMsg* poNaviAssitantGuideInfoMsg)
       * \brief   Handles Messages of NaviAssitantGuideInfoMsg type
       * \param   poNaviAssitantGuideInfoMsg : pointer to NaviAssitantGuideInfoMsg.
       **************************************************************************/
      t_Void vHandleNavigationMsg(NaviAssitantGuideInfoMsg* poNaviAssitantGuideInfoMsg) const;

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLNavigationDispatcher(const spi_tclBDCLNavigationDispatcher...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLNavigationDispatcher(
       *                             const spi_tclBDCLNavigationDispatcher& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLNavigationDispatcher()
       ***************************************************************************/
      spi_tclBDCLNavigationDispatcher(const spi_tclBDCLNavigationDispatcher& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLNavigationDispatcher& operator=( const spi_tclBDCL...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLNavigationDispatcher& operator=(
       *                          const spi_tclBDCLNavigationDispatcher& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLNavigationDispatcher(const spi_tclBDCLNavigationDispatcher& corfoSrc)
       ***************************************************************************/
      spi_tclBDCLNavigationDispatcher& operator=(const spi_tclBDCLNavigationDispatcher& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/
};


#endif /* SPI_TCLBDCLNAVIGATIONDISPATCHER_H_ */

///////////////////////////////////////////////////////////////////////////////
// <EOF>
