/***********************************************************************/
/*!
* \file  spi_tclBDCLCmdNavigation.h
* \brief  Implementation of the Class spi_tclBDCLCmdNavigation
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
04.05.2017  | pok6kor               | Initial Version


\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLCMDNAVIGATION_
#define SPI_TCLBDCLCMDNAVIGATION_

#include <memory>
#include "BDCLTypes.h"
#include "BDCL_WrapperTypes.h"
#include "spi_tclBDCLMsgQInterface.h"
#include "spi_tclBDCLNavigationDispatcher.h"


/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
class spi_tclBDCLNavigationProxyIntf;


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
typedef std::shared_ptr< spi_tclBDCLNavigationProxyIntf >   t_SptrBDCLNavigationProxy;

/*!
 * \class spi_tclBDCLCmdNavigation
 * \brief
 */
class spi_tclBDCLCmdNavigation
{

public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLCmdNavigation
       ***************************************************************************/
      /*!
       * \fn       spi_tclBDCLCmdNavigation()
       * \brief    Constructor
       * \sa       ~spi_tclBDCLCmdNavigation()
       **************************************************************************/
      spi_tclBDCLCmdNavigation();

      /***************************************************************************
       ** FUNCTION:   ~spi_tclBDCLCmdNavigation()
       ***************************************************************************/
      /*!
       * \fn       ~spi_tclBDCLCmdNavigation()
       * \brief    Destructor
       * \sa       spi_tclBDCLCmdNavigation()
       **************************************************************************/
      virtual ~spi_tclBDCLCmdNavigation();

      /***************************************************************************
       ** FUNCTION:  t_Bool bInitialize()
       ***************************************************************************/
      /*!
       * \fn      bInitialize()
       * \brief   Performs initialization for navigation with BDCL device
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Bool vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      vUninitialize()
       * \brief   Performs cleanup of navigation with BDCL device
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUninitialize();

      /***************************************************************************
       ** FUNCTION:  static t_Void vOnCarlifeDataSubscribtionDoneCb(...)
       ***************************************************************************/
      /*!
       * \fn      vOnCarlifeDataSubscribtionDoneCb()
       * \brief   Called on receiving Carlife Data Subscription Done.
       * \param   prInfo [IN]: Structure containing BDCL Carlife Info
       **************************************************************************/
      static t_Void vOnCarlifeDataSubscribtionDoneCb(S_SUBSCRIBE_MOBILE_CARLIFE_INFO_LIST* prSubscribeInfoList);

      /***************************************************************************
       ** FUNCTION:  static t_Void vOnNaviNextTurnInfoCb(...)
       ***************************************************************************/
      /*!
       * \fn      vOnNaviNextTurnInfoCb()
       * \brief   Called on receiving MSG_CMD_NAVI_NEXT_TURN_INFO
       * \param   prInfo [IN]: Structure containing BDCL NaviNextTurnInfo
       **************************************************************************/
      static t_Void vOnNaviNextTurnInfoCb(S_NAVI_NEXT_TURN_INFO* prNextTurnInfo);

      /***************************************************************************
       ** FUNCTION:  static t_Void vOnNaviAssitantGuideInfoCb(...)
       ***************************************************************************/
      /*!
       * \fn      vOnNaviAssitantGuideInfoCb()
       * \brief   Called on receiving MSG_CMD_NAVI_ASSITANTGUIDE_INFO
       * \param   prInfo [IN]: Structure containing NaviAssitantGuideInfo
       **************************************************************************/
      static t_Void vOnNaviAssitantGuideInfoCb(S_NAVI_ASSITANT_GUIDE_INFO* prAssistantGuideInfo);

      /***************************************************************************
       ** FUNCTION:t_Bool vSendCarLifeDataSubscribe(...)
       ***************************************************************************/
      /*!
       * \fn      vSendCarLifeDataSubscribe()
       * \brief   To send Carlife Subscription message to BDCL on MD.
       * \param   rCarLifeInfoList [IN]: Contains list of Car Life Module info
       **************************************************************************/
      t_Bool bSendCarLifeDataSubscribe(const tBdclCarLifeInfoList& corfrCarLifeInfoList);

      /***************************************************************************
       ** FUNCTION:t_Bool vSendCarLifeDataSubscribeStart(...)
       ***************************************************************************/
      /*!
       * \fn      vSendCarLifeDataSubscribeStart()
       * \brief   To send Carlife SubscriptionStart message to BDCL on MD.
       * \param   rCarLifeInfoStartList [IN]: Contains list of Car Life Module info
       **************************************************************************/
      t_Bool bSendCarLifeDataSubscribeStart(const tBdclCarLifeInfoList& corfrCarLifeInfoStartList);

      /***************************************************************************
       ** FUNCTION:t_Bool vSendCarLifeDataSubscribeStop(...)
       ***************************************************************************/
      /*!
       * \fn      vSendCarLifeDataSubscribeStop()
       * \brief   To send Carlife SubscriptionStop message to BDCL on MD.
       * \param   rCarLifeInfoStartList [IN]: Contains list of Car Life Module info
       **************************************************************************/
      t_Bool bSendCarLifeDataSubscribeStop(const tBdclCarLifeInfoList& corfrCarLifeInfoStopList);
	  
   private:

      /***************************************************************************
       ** FUNCTION: spi_tclBDCLCmdNavigation(const spi_tclBDCLCmdNavigation&)
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLCmdNavigation(const spi_tclBDCLCmdNavigation&)
       * \brief   Copy constructor not implemented
       **************************************************************************/
      spi_tclBDCLCmdNavigation(const spi_tclBDCLCmdNavigation&);

      /***************************************************************************
       ** FUNCTION: const spi_tclBDCLCmdNavigation & operator=(const spi_tclBDCLCmdNavigation&);
       ***************************************************************************/
      /*!
       * \fn      const spi_tclBDCLCmdNavigation & operator=(const spi_tclBDCLCmdNavigation&);
       * \brief   assignment operator not implemented
       **************************************************************************/
      const spi_tclBDCLCmdNavigation & operator=(const spi_tclBDCLCmdNavigation&);

      //! Pointer to Navigation proxy
      t_SptrBDCLNavigationProxy m_spoNavigationProxy;

};
#endif //SPI_TCLBDCLCMDNAVIGATION_
