
/***********************************************************************/
/*!
 * \file   spi_tclBDCLRespMediaData.h
 * \brief  MediaMetadata Call backs output interface
 *************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    MediaMetadata Call backs output interface
AUTHOR:         pok6kor
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification

\endverbatim
 *************************************************************************/
#ifndef _SPI_TCLBDCLRESPMEDIADATA_H_
#define _SPI_TCLBDCLRESPMEDIADATA_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "BDCLTypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class  spi_tclBDCLRespMediaData.h
 * \brief  Media Metadata info  are updated to Application using this
 *****************************************************************************/
class spi_tclBDCLRespMediaData:public RespBase
{

   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespMediaData::spi_tclBDCLRespMediaData()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespMediaData()
       * \brief   Default Constructor
       * \sa      ~spi_tclBDCLRespMediaData()
       **************************************************************************/
      spi_tclBDCLRespMediaData():RespBase(e16BDCL_MEDIADATA_REGID){}

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespMediaData::~spi_tclBDCLRespMediaData()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLRespMediaData()
       * \brief   Destructor
       * \sa      spi_tclBDCLRespMediaData()
       **************************************************************************/
      virtual ~spi_tclBDCLRespMediaData(){}

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespMediaData::vMediaMetadataCallback()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vMediaMetadataCallback()
       * \brief   method to update  the MediaPlaybackStatusCallback
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vMediaMetadataCallback(const trBdclMediaMetadata* rBDCLMediaDataMetadata){};

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespMediaData::vProgressBarCallback()
       ***************************************************************************/
      /*!
       * \fn      virtual t_Void vProgressBarCallback()
       * \brief   method to update  the Progress bar info
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vProgressBarCallback(const t_U32 u32ProgressBarInfo){};

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespMediaData(const spi_tclBDCLRespMediaData...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespMediaData(const spi_tclBDCLRespMediaData& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLRespMediaData()
       ***************************************************************************/
      spi_tclBDCLRespMediaData(const spi_tclBDCLRespMediaData& corfoSrc);


      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespMediaData& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespMediaData& operator=(const spi_tclBDCLRespMediaData& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLRespMediaData(const spi_tclBDCLRespMediaData& otrSrc)
       ***************************************************************************/
      spi_tclBDCLRespMediaData& operator=(const spi_tclBDCLRespMediaData& corfoSrc);


      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/


      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/


}; //class spi_tclBDCLRespMediaData

#endif //_SPI_TCLBDCLRESPMEDIADATA_H_
///////////////////////////////////////////////////////////////////////////////
// <EOF>
