/***********************************************************************/
/*!
 * \file  spi_tclBDCLMediaDataDispatcher.h
 * \brief Message Dispatcher for Media Data Messages. implemented using
 *       double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Media Data Messages
 AUTHOR:         pok6kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification

 \endverbatim
 *************************************************************************/
#ifndef SPI_TCLBDCLMEDIADATADISPATCHER_H_
#define SPI_TCLBDCLMEDIADATADISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/


#include "BDCLTypes.h"
#include "SPITypes.h"
/**************Forward Declarations******************************************/
class spi_tclBDCLMediaDataDispatcher;

/****************************************************************************/
/*!
 * \class BDCLMediaDataMsgBase
 * \brief Base Message type for all MediaData messages
 ****************************************************************************/
class BDCLMediaDataMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  BDCLMediaDataMsgBase::BDCLMediaDataMsgBase
       ***************************************************************************/
      /*!
       * \fn      BDCLMediaDataMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      BDCLMediaDataMsgBase();

      /***************************************************************************
       ** FUNCTION:  BDCLMediaDataMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLMediaDataDispatcher* poMediaDataDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param poMediaDataDispatcher : pointer to Message dispatcher for MediaData
       * \retval t_Void
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclBDCLMediaDataDispatcher* poMediaDataDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  BDCLMediaDataMsgBase::~BDCLMediaDataMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~BDCLMediaDataMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLMediaDataMsgBase()
      {

      }
};

/****************************************************************************/
/*!
 * \class BDCLMetaDataMsg
 * \brief MediaData attestation response message
 ****************************************************************************/
class BDCLMetaDataMsg: public BDCLMediaDataMsgBase
{
   public:
      trBdclMediaMetadata *m_prBDCLMediaMetadata;

      /***************************************************************************
       ** FUNCTION:  BDCLMetaDataMsg::BDCLMetaDataMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLMetaDataMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLMetaDataMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLMetaDataMsg::~BDCLMetaDataMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLMetaDataMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLMetaDataMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLMetaDataMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLMediaDataDispatcher* poMediaDataDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poMediaDataDispatcher : pointer to Message dispatcher for MediaData
       * \retval t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLMediaDataDispatcher* poMediaDataDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLMetaDataMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLMetaDataMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval t_Void
       **************************************************************************/
      t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class BDCLProgressBarMsg
 * \brief ProgressBar attestation response message
 ****************************************************************************/
class BDCLProgressBarMsg: public BDCLMediaDataMsgBase
{
   public:
      t_U32 u32ProgressBarInfo;

      /***************************************************************************
       ** FUNCTION:  BDCLMetaDataMsg::BDCLMetaDataMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLMetaDataMsg()
       * \brief   Default constructor
       **************************************************************************/
       BDCLProgressBarMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLMetaDataMsg::~BDCLMetaDataMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLMetaDataMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLProgressBarMsg(){}

      /***************************************************************************
       ** FUNCTION:  BDCLMetaDataMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLMediaDataDispatcher* poMediaDataDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poMediaDataDispatcher : pointer to Message dispatcher for MediaData
       * \retval t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLMediaDataDispatcher* poMediaDataDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLMetaDataMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vAllocateMsg(){}

      /***************************************************************************
       ** FUNCTION:  BDCLMetaDataMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval t_Void
       **************************************************************************/
      t_Void vDeAllocateMsg(){}
};
/****************************************************************************/
/*!
 * \class spi_tclBDCLMediaDataDispatcher
 * \brief Message Dispatcher for MediaData Messages
 ****************************************************************************/
class spi_tclBDCLMediaDataDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLMediaDataDispatcher::spi_tclBDCLMediaDataDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLMediaDataDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclBDCLMediaDataDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLMediaDataDispatcher::~spi_tclBDCLMediaDataDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLMediaDataDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclBDCLMediaDataDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLMediaDataDispatcher::vHandleMediaDataMsg(BDCLMetaDataMsg* poBDCLAppInactiveMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleMediaDataMsg(BDCLMetaDataMsg* poBDCLAppInactiveMsg)
       * \brief   Handles Messages of BDCLMetaDataMsg type
       * \param   poBDCLMetaDataMsg : pointer to BDCLMetaDataMsg.
       * \retval  t_Void
       **************************************************************************/
      t_Void vHandleMediaDataMsg(BDCLMetaDataMsg* poBDCLMetaDataMsg) const;

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLMediaDataDispatcher::vHandleMediaDataMsg(BDCLMetaDataMsg* poBDCLAppInactiveMsg)
       ***************************************************************************/
      /*!
       * \fn      vHandleMediaDataMsg(BDCLMetaDataMsg* poBDCLAppInactiveMsg)
       * \brief   Handles Messages of BDCLMetaDataMsg type
       * \param   poBDCLMetaDataMsg : pointer to BDCLMetaDataMsg.
       * \retval  t_Void
       **************************************************************************/
      t_Void vHandleMediaDataMsg(BDCLProgressBarMsg* poProgressBarInfo)const;
};

#endif /* SPI_TCLBDCLMEDIADATADISPATCHER_H_ */
