/***********************************************************************/
/*!
* \file  spi_tclBDCLCmdMediaData.h
* \brief  Implementation of the Class spi_tclBDCLCmdMediaData
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLCMDMEDIADATA_
#define SPI_TCLBDCLCMDMEDIADATA_

#include <memory>
#include "BDCLTypes.h"
#include "BDCL_WrapperTypes.h"
#include "spi_tclBDCLMsgQInterface.h"
#include "spi_tclBDCLMediaDataDispatcher.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
class spi_tclBDCLMediaDataProxyIntf;


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
typedef std::shared_ptr < spi_tclBDCLMediaDataProxyIntf >    t_SptrBDCLMediaDataProxy;


/*!
 * \class spi_tclBDCLCmdMediaData
 * \brief
 */
class spi_tclBDCLCmdMediaData
{
   public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLCmdMediaData()
       ***************************************************************************/
      /*!
       * \fn       spi_tclBDCLCmdMediaData()
       * \brief    Constructor
       * \sa       ~spi_tclBDCLCmdMediaData()
       **************************************************************************/
      spi_tclBDCLCmdMediaData();

      /***************************************************************************
       ** FUNCTION:   ~spi_tclBDCLCmdMediaData()
       ***************************************************************************/
      /*!
       * \fn       ~spi_tclBDCLCmdMediaData()
       * \brief    Destructor
       * \sa       spi_tclBDCLCmdMediaData()
       **************************************************************************/
     virtual ~spi_tclBDCLCmdMediaData();

      /***************************************************************************
       ** FUNCTION:  t_Bool bInitialize()
       ***************************************************************************/
      /*!
       * \fn      bInitialize()
       * \brief
       * \sa      vUninitialize()
       **************************************************************************/
      t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Bool vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      vUninitialize()
       * \brief
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUninitialize();

      /***************************************************************************
       ** FUNCTION:  static t_Void vMediaInfoCb(...)
       ***************************************************************************/
      /*!
       * \fn      vMediaInfoCb()
       * \brief   Performs initialization for Media Info with BDCL device
       * \param   prMediaInfo [IN]: Structure containing BDCL Media info
       **************************************************************************/
      static t_Void vMediaInfoCb(S_MEDIA_INFO* prMediaInfo);

      /***************************************************************************
       ** FUNCTION:  static t_Void vProgessBarInfoCb(...)
       ***************************************************************************/
      /*!
       * \fn      vProgessBarInfoCb()
       * \brief   Performs initialization of Progress bar info
       * \param   prProgressBarInfo [IN]: Structure containing BDCL Progress Bar info
       **************************************************************************/
      static t_Void vProgessBarInfoCb(S_MEDIA_PROGRESS_BAR* prProgressBarInfo);

   private:

      /***************************************************************************
       ** FUNCTION: spi_tclBDCLCmdMediaData(const spi_tclBDCLCmdMediaData&)
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLCmdMediaData(const spi_tclBDCLCmdMediaData&)
       * \brief   Copy constructor not implemented
       **************************************************************************/
      spi_tclBDCLCmdMediaData(const spi_tclBDCLCmdMediaData&);

      /***************************************************************************
       ** FUNCTION: const spi_tclBDCLCmdMediaData & operator=(const spi_tclBDCLCmdMediaData&);
       ***************************************************************************/
      /*!
       * \fn      const spi_tclBDCLCmdMediaData & operator=(const spi_tclBDCLCmdMediaData&);
       * \brief   assignment operator not implemented
       **************************************************************************/
      const spi_tclBDCLCmdMediaData & operator=(const spi_tclBDCLCmdMediaData&);

      //! Pointer to MediaData proxy
      t_SptrBDCLMediaDataProxy m_spoMediaDataProxy;
};
#endif //SPI_TCLBDCLCMDMEDIADATA_
