/***********************************************************************/
/*!
* \file  spi_tclBDCLVideoProxyIntf.h
* \brief  Implementation of the Class spi_tclBDCLVideoProxyIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLBDCLVIDEOPROXYINTF_
#define SPI_TCLBDCLVIDEOPROXYINTF_

#include "BaseTypes.h"
#include "BDCL_WrapperTypes.h"

//! Forward declarations

class spi_tclBDCLVideoProxyIntf
{

   public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLVideoProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLVideoProxyIntf()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLVideoProxyIntf()
       **************************************************************************/
      spi_tclBDCLVideoProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  ~spi_tclBDCLVideoProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLVideoProxyIntf()
       * \brief   Destructor
       * \sa      spi_tclBDCLVideoProxyIntf()
       **************************************************************************/
      virtual ~spi_tclBDCLVideoProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void vRegisterVideoCallbacks(trBdclVideoCbs rVideoCbs)
       ***************************************************************************/
      /*!
       * \fn      vRegisterVideoCallbacks
       * \brief   Interface to register callbacks for video events
       * \param   rVideoCbs [IN]: Contains Video callbacks
       **************************************************************************/
      virtual t_Void vRegisterVideoCallbacks(trBdclVideoCbs rVideoCbs) = 0;

};
#endif //SPI_TCLBDCLVIDEOPROXYINTF_
