/***********************************************************************/
/*!
* \file  spi_tclBDCLLibProxy.h
* \brief  Implementation of the proxy library to Carlife stack
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/

#ifndef SPI_TCLBDCLLIBPROXY_
#define SPI_TCLBDCLLIBPROXY_

#include <bdcl/CCarLifeLib.h>

#include "spi_tclBDCLCoreDataIntf.h"
#include "spi_tclBDCLAudioProxyIntf.h"
#include "spi_tclBDCLBluetoothProxyIntf.h"
#include "spi_tclBDCLCarDataProxyIntf.h"
#include "spi_tclBDCLInputProxyIntf.h"
#include "spi_tclBDCLMediaDataProxyIntf.h"
#include "spi_tclBDCLSessionProxyIntf.h"
#include "spi_tclBDCLVideoProxyIntf.h"
#include "spi_tclBDCLNavigationProxyIntf.h"
#include "BDCL_WrapperTypes.h"
#include "BaseTypes.h"
#include "BDCLTypes.h"
#include "SPITypes.h"
#include "Lock.h"


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

class spi_tclBDCLLibProxy :
   public spi_tclBDCLCoreDataIntf,
   public spi_tclBDCLAudioProxyIntf,
   public spi_tclBDCLBluetoothProxyIntf,
   public spi_tclBDCLCarDataProxyIntf,
   public spi_tclBDCLInputProxyIntf,
   public spi_tclBDCLMediaDataProxyIntf,
   public spi_tclBDCLSessionProxyIntf,
   public spi_tclBDCLVideoProxyIntf,
   public spi_tclBDCLNavigationProxyIntf
{

public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLLibProxy()
       ***************************************************************************/
      /*!
       * \fn       spi_tclBDCLLibProxy()
       * \brief    Constructor
       * \sa       ~spi_tclBDCLLibProxy()
       **************************************************************************/
      spi_tclBDCLLibProxy();

      /***************************************************************************
       ** FUNCTION:   ~spi_tclBDCLLibProxy()
       ***************************************************************************/
      /*!
       * \fn       ~spi_tclBDCLLibProxy()
       * \brief    Destructor
       * \sa       spi_tclBDCLLibProxy()
       **************************************************************************/
      virtual ~spi_tclBDCLLibProxy();

      /***************************************************************************
       ** FUNCTION:  t_CoreCallbackDealer* poGetCoreCallbackDealer()
       ***************************************************************************/
      /*!
       * \fn      poGetCoreCallbackDealer()
       * \brief   Returns a pointer to CoreCallbackDealer instance
       **************************************************************************/
      virtual t_CoreCallbackDealer* poGetCoreCallbackDealer()
      {
         return m_poCallbackDealer;
      }

      /***************************************************************************
       ** FUNCTION:   t_Void vRegisterVRCallbacks()
       ***************************************************************************/
      /*!
       * \fn      vRegisterVRCallbacks()
       * \brief   Interface to register for VR callbacks with BDCL stack
       * \param   rVoiceRecCbs [IN]: Structure containing VR callbacks
       **************************************************************************/
      virtual t_Void vRegisterVRCallbacks(trBdclVoiceRecognitionCbs rVoiceRecCbs);

      /***************************************************************************
       ** FUNCTION:   t_Void vRegisterSessionCallbacks()
       ***************************************************************************/
      /*!
       * \fn      vRegisterSessionCallbacks()
       * \brief   Interface to register callbacks to Session events
       * \param   rSessionCbs [IN]: Contains Session callback
       **************************************************************************/
      virtual t_Void vRegisterSessionCallbacks(trBdclSessionCbs rSessionCbs);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendHUInfo()
       ***************************************************************************/
      /*!
       * \fn      vSendHUInfo()
       * \brief   Sends HU info to BDCL device
       * \param   corfrHUInfo [IN]: Structure containing HU info
       **************************************************************************/
      virtual t_Void vSendHUInfo(const trBdclHUInfo& corfrHUInfo);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendCmdModuleControl()
       ***************************************************************************/
      /*!
       * \fn      vSendCmdModuleControl
       * \brief   Sends a Command Module Control message to CL device
       * \param   u32ModuleID [IN]: Indicates Module ID
       * \param   u32StatusID [IN]: Status of the module
       **************************************************************************/
      virtual t_Void vSendCmdModuleControl(t_U32 u32ModuleID, t_U32 u32StatusID);

      /***************************************************************************
       ** FUNCTION:  t_Void vSendFeatureConfigList()
       ***************************************************************************/
      /*!
       * \fn     vSendFeatureConfigList
       * \brief  Sends Feature configuration information to BDCL device
       * \retval corfrFeatConfigList [IN] : Indicates feature config info
       **************************************************************************/
      t_Void vSendFeatureConfigList(const tBdclFeatureConfigList& corfrFeatConfigList);

      /***************************************************************************
       ** FUNCTION:   t_Void vRegisterVideoCallbacks()
       ***************************************************************************/
      /*!
       * \fn      vRegisterVideoCallbacks
       * \brief   Interface to register callbacks for video events
       * \param   rVideoCbs [IN]: Contains Video callbacks
       **************************************************************************/
      virtual t_Void vRegisterVideoCallbacks(trBdclVideoCbs rVideoCbs);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendKeyCode()
       ***************************************************************************/
      /*!
       * \fn      vSendKeyCode
       * \brief   Interface to send hard key events to BDCL device
       * \param   u32KeyCode [IN]: Hard key code
       **************************************************************************/
      virtual t_Void vSendKeyCode(t_U32 u32KeyCode);

      /***************************************************************************
       ** FUNCTION:   t_Void vRegisterBTCallbacks()
       ***************************************************************************/
      /*!
       * \fn      vRegisterBTCallbacks
       * \brief   Interface to register Bluetooth callbacks
       * \param   rBluetoothCbs [IN]: Structure containing Bluetooth callback information
       **************************************************************************/
      virtual t_Void vRegisterBTCallbacks(trBdclBluetoothCbs rBluetoothCbs);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendHUBTOOBInfo()
       ***************************************************************************/
      /*!
       * \fn      vSendHUBTOOBInfo
       * \brief   Interface to send Bluetooth OOB information to BDCL device
       * \param   prOOBInfo [IN]: Structure containing Bluetooth OOB information
       **************************************************************************/
      virtual t_Void vSendHUBTOOBInfo(trBdclBluetoothOOBInfo* prOOBInfo);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendBTHfpIndication()
       ***************************************************************************/
      /*!
       * \fn      vSendBTHfpIndication
       * \brief   Interface to send status of the phonecall to BDCL device when Carlife UI is active
       * \param   prHfpIndicationInfo [IN]: Structure containing BT HFP indication information
       **************************************************************************/
      virtual t_Void vSendBTHfpIndication(trBdclBluetoothHFPIndication* prHfpIndicationInfo);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendBTHfpConnection()
       ***************************************************************************/
      /*!
       * \fn      vSendBTHfpConnection
       * \brief   Interface to update BT HFP connection status to BDCL device
       * \param   prHfpConnInfo [IN]: Structure containing HFP connection status information
       **************************************************************************/
      virtual t_Void vSendBTHfpConnection(trBdclBluetoothHFPConn* prHfpConnInfo);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendBTHfpResponse()
       ***************************************************************************/
      /*!
       * \fn      vSendBTHfpResponse
       * \brief   Interface to send result of HFP request to BDCL device
       * \param   rHfpRespInfo [IN]: Structure containing the result of HFP request
       **************************************************************************/
      virtual t_Void vSendBTHfpResponse(trBdclBluetoothHFPResponse* prHfpRespInfo);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendBTHfpStatusResponse()
       ***************************************************************************/
      /*!
       * \fn      vSendBTHfpStatusResponse
       * \brief   Interface to send send response to BDCL device about HU MIC status
       * \param   rHfpStatusRespInfo [IN]: Structure containing HU MIC status
       **************************************************************************/
      virtual t_Void vSendBTHfpStatusResponse(trBdclBluetoothHFPStatusResponse* prHfpStatusRespInfo);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendBTStartIdentifyRequest()
       ***************************************************************************/
      /*!
       * \fn      vSendBTStartIdentifyRequest
       * \brief   Interface to send StartIdentifyRequest message to BDCL device
       * \param   strAddress [IN]: String contains HeadUnits BT address
       **************************************************************************/
      virtual t_Void vSendBTStartIdentifyRequest(t_String szAddress);

      /***************************************************************************
       ** FUNCTION:   t_Void vRegisterCarDataCallbacks()
       ***************************************************************************/
      /*!
       * \fn      vSendKeyCode
       * \brief   Interface to send hard key events to BDCL device
       * \param   u32KeyCode [IN]: Hard key code
       **************************************************************************/
      virtual t_Void vRegisterCarDataCallbacks(trBdclCarDataCbs rCarDataCbs);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendCarGPS()
       ***************************************************************************/
      /*!
       * \fn      vSendCarGPS()
       * \brief   Sends Car GPS Data
       * \param   rCarGpsInfo [IN]: Structure containing BDCL GPS Data
       **************************************************************************/
      virtual t_Void vSendCarGPS(trBdclCarGPS rCarGpsInfo);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendCarAcceleration()
       ***************************************************************************/
      /*!
       * \fn     vSendCarAcceleration()
       * \brief  Sends Car Acceleration Data
       * \param  rCarAccelerationInfo [IN]: Structure containing BDCL Acceleration Data
       **************************************************************************/
      virtual t_Void vSendCarAcceleration(trAccSensorData rCarAccelerationInfo);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendCarGyro()
       ***************************************************************************/
      /*!
       * \fn      vSendCarGyro()
       * \brief   Sends Car Gyro Data
       * \param   rCarGyroInfo [IN]: Structure containing BDCL Gyro Data
       **************************************************************************/
      virtual t_Void vSendCarGyro(trGyroSensorData rCarGyroInfo);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendCarOil()
       ***************************************************************************/
      /*!
       * \fn      vSendCarOil()
       * \brief   Sends Car Oil Data
       * \param   rCarOilInfo [IN]: Structure containing BDCL Oil Data
       **************************************************************************/
      virtual t_Void vSendCarOil(trBdclCarOil rCarOilInfo);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendCarVelocity()
       ***************************************************************************/
      /*!
       * \fn      vSendCarVelocity()
       * \brief   Sends Car Velocity Data
       * \param   rCarVelocityInfo [IN]: Structure containing BDCL Velocity Data
       **************************************************************************/
      virtual t_Void vSendCarVelocity(trBdclCarVelocity rCarVelocityInfo);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendCarGearState()
       ***************************************************************************/
      /*!
       * \fn      vSendCarGearState()
       * \brief   Sends Car Gear Data
       * \param   s32GearState [IN]:  BDCL Gear Data
       **************************************************************************/
      virtual t_Void vSendCarGearState(tenBdclGearState rGearStateInfo);

      /***************************************************************************
       ** FUNCTION:   t_Void vSendDataSubscribeDone()
       ***************************************************************************/
      /*!
       * \fn      vSendDataSubscribeDone()
       * \brief   Sends Data Subscribe done
       * \param   rBDCLCarDataSubscriptionDone[IN]: Structure containing BDCL Car Subscription Data
       **************************************************************************/
      virtual t_Void vSendDataSubscribeDone(const tBdclCarDataInfoList rCarDataInfoList);

      /***************************************************************************
       ** FUNCTION:   t_Void vRegisterMediaDataCallbacks()
       ***************************************************************************/
      /*!
       * \fn      vRegisterMediaDataCallbacks
       * \brief   Interface to register callbacks to MediaData events
       * \param   rMediaDataCbs [IN]: Contains Media Data callback pointers
       **************************************************************************/
      virtual t_Void vRegisterMediaDataCallbacks(trBdclMediaDataCbs rMediaDataCbs);

      /***************************************************************************
       ** FUNCTION:  t_Void vSendCarLifeDataSubscribe(tBdclCarLifeInfoList rCarlifeInfoList)
       ***************************************************************************/
      /*!
       * \fn      vSendCarLifeDataSubscribe
       * \brief   To send Carlife Subscription message to BDCL on MD.
       * \param   rCarLifeInfoList [IN]: Contains list of Car Life Module info
       **************************************************************************/
       t_Void vSendCarLifeDataSubscribe(tBdclCarLifeInfoList rCarLifeInfoList);

      /***************************************************************************
       ** FUNCTION:  t_Void vSendCarLifeDataSubscribeStart(tBdclCarLifeInfoList rCarlifeInfoStartList)
       ***************************************************************************/
      /*!
       * \fn      vSendCarLifeDataSubscribeStart
       * \brief   To send Carlife Subscription Start message to BDCL on MD.
       * \param   rCarLifeInfoStartList [IN]: Contains list of Car Life Module info
       **************************************************************************/
       t_Void vSendCarLifeDataSubscribeStart(tBdclCarLifeInfoList rCarLifeInfoStartList);

      /***************************************************************************
       ** FUNCTION:  t_Void vSendCarLifeDataSubscribeStop(tBdclCarLifeInfoList rCarlifeInfoStartList)
       ***************************************************************************/
      /*!
       * \fn      vSendCarLifeDataSubscribeStop
       * \brief   To send Carlife Subscription Stop message to BDCL on MD.
       * \param   rCarLifeInfoStopList [IN]: Contains list of Car Life Module info
       **************************************************************************/
       t_Void vSendCarLifeDataSubscribeStop(tBdclCarLifeInfoList rCarLifeInfoStopList);

      /***************************************************************************
       ** FUNCTION:  t_Void vSendCarLifeDataSubscribe(tBdclCarLifeInfoList rCarlifeInfoList)
       ***************************************************************************/
      /*!
       * \fn      vSendCarLifeDataSubscribe
       * \brief   To send Carlife Subscription message to BDCL on MD.
       * \param   rCarLifeInfoList [IN]: Contains list of Car Life Module info
       **************************************************************************/
      virtual t_Void vSendCarLifeDataSubscribe(const tBdclCarLifeInfoList& corfrCarLifeInfoList);

      /***************************************************************************
       ** FUNCTION:  t_Void vSendCarLifeDataSubscribeStart(tBdclCarLifeInfoList rCarlifeInfoStartList)
       ***************************************************************************/
      /*!
       * \fn      vSendCarLifeDataSubscribeStart
       * \brief   To send Carlife Subscription Start message to BDCL on MD.
       * \param   rCarLifeInfoStartList [IN]: Contains list of Car Life Module info
       **************************************************************************/
       virtual t_Void vSendCarLifeDataSubscribeStart(const tBdclCarLifeInfoList& corfrCarLifeInfoStartList);

      /***************************************************************************
       ** FUNCTION:  t_Void vSendCarLifeDataSubscribeStop(tBdclCarLifeInfoList rCarlifeInfoStartList)
       ***************************************************************************/
      /*!
       * \fn      vSendCarLifeDataSubscribeStop
       * \brief   To send Carlife Subscription Stop message to BDCL on MD.
       * \param   rCarLifeInfoStopList [IN]: Contains list of Car Life Module info
       **************************************************************************/
	  virtual t_Void vSendCarLifeDataSubscribeStop(const tBdclCarLifeInfoList& corfrCarLifeInfoStopList);
	  
      /***************************************************************************
       ** FUNCTION:   t_Void vRegisterNavigationCallbacks()
       ***************************************************************************/
      /*!
       * \fn      vRegisterNavigationCallbacks
       * \brief   Interface to register callbacks to Navigation events
       * \param   rMediaDataCbs [IN]: Contains Navigation callback pointers
       **************************************************************************/
      virtual t_Void vRegisterNavigationCallbacks(trBdclNavigationCbs rNavigationCbs);

private:
    /***************************************************************************
     ** FUNCTION: spi_tclBDCLLibProxy(const spi_tclBDCLLibProxy &rfcoObject)
     ***************************************************************************/
    /*!
     * \fn      spi_tclBDCLLibProxy(const spi_tclBDCLLibProxy &rfcoObject)
     * \brief   Copy constructor not implemented hence made private
     **************************************************************************/
    spi_tclBDCLLibProxy(const spi_tclBDCLLibProxy& rfcoObject);

    /***************************************************************************
     ** FUNCTION: const spi_tclBDCLLibProxy & operator=(
     **                                 const spi_tclBDCLLibProxy &rfcoObject);
     ***************************************************************************/
    /*!
     * \fn      const spi_tclBDCLLibProxy & operator=(const spi_tclBDCLLibProxy &rfcoObject);
     * \brief   assignment operator not implemented hence made private
     **************************************************************************/
    const spi_tclBDCLLibProxy& operator=(const spi_tclBDCLLibProxy& rfcoObject);
	
	//! Pointer to Carlife Lib
    CCarLifeLib* m_poCCarLifeLib;

    t_CoreCallbackDealer* m_poCallbackDealer;

    //! Lock object to protect usage of Carlife Lib
    Lock  m_oLock;

};

#endif //SPI_TCLBDCLLIBPROXY_
