/***********************************************************************/
/*!
* \file  spi_tclBDCLInputProxyIntf.h
* \brief  Implementation of the Class spi_tclBDCLInputProxyIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         tch5kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLBDCLINPUTPROXYINTF_
#define SPI_TCLBDCLINPUTPROXYINTF_

#include "BaseTypes.h"

//! Forward declarations

class spi_tclBDCLInputProxyIntf
{

   public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLInputProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLInputProxyIntf()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLInputProxyIntf()
       **************************************************************************/
      spi_tclBDCLInputProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  ~spi_tclBDCLInputProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLInputProxyIntf()
       * \brief   Destructor
       * \sa      spi_tclBDCLInputProxyIntf()
       **************************************************************************/
      virtual ~spi_tclBDCLInputProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void vSendKeyCode(t_S32 s32KeyCode)
       ***************************************************************************/
      /*!
       * \fn      vSendKeyCode
       * \brief   Interface to send hard key events to BDCL device
       * \param   u32KeyCode [IN]: Hard key code
       **************************************************************************/
      virtual t_Void vSendKeyCode(t_U32 u32KeyCode) = 0;

};
#endif //SPI_TCLBDCLINPUTPROXYINTF_
