/***********************************************************************/
/*!
* \file  spi_tclBDCLCarDataProxyIntf.h
* \brief  Implementation of the Class spi_tclBDCLCarDataProxyIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLBDCLCARDATAPROXYINTF_
#define SPI_TCLBDCLCARDATAPROXYINTF_

#include "BaseTypes.h"
#include "BDCLTypes.h"
#include "BDCL_WrapperTypes.h"
#include "SPITypes.h"

class spi_tclBDCLCarDataProxyIntf
{

   public:

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLCarDataProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLCarDataProxyIntf()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLCarDataProxyIntf()
       **************************************************************************/
      spi_tclBDCLCarDataProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  ~spi_tclBDCLCarDataProxyIntf()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLCarDataProxyIntf()
       * \brief   Destructor
       * \sa      spi_tclBDCLCarDataProxyIntf()
       **************************************************************************/
      virtual ~spi_tclBDCLCarDataProxyIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void vRegisterCarDataCallbacks(...)
       ***************************************************************************/
      /*!
       * \fn      vRegisterCarDataCallbacks
       * \brief   Interface to register callbacks to Car Data events
       * \param   rCarDataCbs [IN]: Contains Media Data callback pointers
       **************************************************************************/
      virtual t_Void vRegisterCarDataCallbacks(trBdclCarDataCbs rCarDataCbs) = 0;

      /***************************************************************************
       ** FUNCTION: t_Void vSendCarAcceleration(...)
       ***************************************************************************/
      /*!
       * \fn     vSendCarAcceleration()
       * \brief  Sends Car Acceleration Data
       * \param  rCarAccelerationInfo [IN]: Structure containing BDCL Acceleration Data
       **************************************************************************/
      virtual t_Void vSendCarAcceleration(trAccSensorData rCarAccelerationInfo) = 0;

      /***************************************************************************
       ** FUNCTION: t_Void vSendCarGPS(...)
       ***************************************************************************/
      /*!
       * \fn      vSendCarGPS()
       * \brief   Sends Car GPS Data
       * \param   rCarGpsInfo [IN]: Structure containing BDCL GPS Data
       **************************************************************************/
      virtual t_Void vSendCarGPS(trBdclCarGPS rCarGpsInfo) = 0;

      /***************************************************************************
       ** FUNCTION: t_Void vSendCarGyro(...)
       ***************************************************************************/
      /*!
       * \fn      vSendCarGyro()
       * \brief   Sends Car Gyro Data
       * \param   rCarGyroInfo [IN]: Structure containing BDCL Gyro Data
       **************************************************************************/
      virtual t_Void vSendCarGyro(trGyroSensorData rCarGyroInfo) = 0;

      /***************************************************************************
       ** FUNCTION: t_Void vSendCarOil(...)
       ***************************************************************************/
      /*!
       * \fn      vSendCarOil()
       * \brief   Sends Car Oil Data
       * \param   rCarOilInfo [IN]: Structure containing BDCL Oil Data
       **************************************************************************/
      virtual t_Void vSendCarOil(trBdclCarOil rCarOilInfo) = 0;

      /***************************************************************************
       ** FUNCTION: t_Void vSendCarVelocity(...)
       ***************************************************************************/
      /*!
       * \fn      vSendCarVelocity()
       * \brief   Sends Car Velocity Data
       * \param   rCarVelocityInfo [IN]: Structure containing BDCL Velocity Data
       **************************************************************************/
      virtual t_Void vSendCarVelocity(trBdclCarVelocity rCarVelocityInfo) = 0;

      /***************************************************************************
       ** FUNCTION: t_Void vSendCarGearState(...)
       ***************************************************************************/
      /*!
       * \fn      vSendCarGearState()
       * \brief   Sends Car Gear Data
       * \param   s32GearState [IN]:  BDCL Gear Data
       **************************************************************************/
      virtual t_Void vSendCarGearState(tenBdclGearState s32GearState) = 0;

      /***************************************************************************
       ** FUNCTION: t_Void vSendDataSubscribeDone(...)
       *********************************************************************************************/
      /*!
       * \fn      vSendDataSubscribeDone()
       * \brief   Sends Data Subscribe done
       * \param   rBDCLCarDataSubscriptionDone[IN]: Structure containing BDCL Car Subscription Data
       * ******************************************************************************************/
      virtual t_Void vSendDataSubscribeDone(const tBdclCarDataInfoList rCarDataInfoList) = 0;

};
#endif //SPI_TCLBDCLCARDATAPROXYINTF_
