/***********************************************************************/
/*!
 * \file  spi_tclBDCLMsgQThreadable.cpp
 * \brief implements threading based on MsgQthreader for BDCL Wrappers
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    implements threading based on MsgQthreader for BDCL Wrappers
 AUTHOR:         pok6kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification


 \endverbatim
 *************************************************************************/

#include "SPITypes.h"
#include "BDCLTypes.h"
#include "spi_tclBDCLMsgQThreadable.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
 #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
  #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
  #include "trcGenProj/Header/spi_tclBDCLMsgQThreadable.cpp.trc.h"
 #endif
#endif

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLMsgQThreadable::spi_tclBDCLMsgQThreadable()
 ***************************************************************************/
spi_tclBDCLMsgQThreadable::spi_tclBDCLMsgQThreadable():
   m_poAudioDispatcher(NULL),
   m_poBluetoothDispatcher(NULL),
   m_poSessionDispatcher(NULL),
   m_poVideoDispatcher(NULL),
   m_poCarDataDispatcher(NULL),
   m_poMediaDataDispatcher(NULL),
   m_poNavigationDispatcher(NULL)
{
   ETG_TRACE_USR1((" spi_tclBDCLMsgQThreadable::spi_tclBDCLMsgQThreadable() entered "));

   m_poAudioDispatcher = new spi_tclBDCLAudioDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poAudioDispatcher);

   m_poBluetoothDispatcher = new spi_tclBDCLBluetoothDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poBluetoothDispatcher);

   m_poCarDataDispatcher = new spi_tclBDCLCarDataDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poCarDataDispatcher);

   m_poMediaDataDispatcher = new spi_tclBDCLMediaDataDispatcher();
   SPI_NORMAL_ASSERT(NULL == m_poMediaDataDispatcher);

   m_poSessionDispatcher = new spi_tclBDCLSessionDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poSessionDispatcher);

   m_poVideoDispatcher = new spi_tclBDCLVideoDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poVideoDispatcher);

   m_poNavigationDispatcher = new spi_tclBDCLNavigationDispatcher;
   SPI_NORMAL_ASSERT(NULL == m_poNavigationDispatcher)
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLMsgQThreadable::~spi_tclBDCLMsgQThreadable()
 ***************************************************************************/

spi_tclBDCLMsgQThreadable::~spi_tclBDCLMsgQThreadable()
{
   ETG_TRACE_USR1((" spi_tclBDCLMsgQThreadable::~spi_tclBDCLMsgQThreadable() entered "));

   RELEASE_MEM(m_poAudioDispatcher);
   RELEASE_MEM(m_poBluetoothDispatcher);
   RELEASE_MEM(m_poCarDataDispatcher);
   RELEASE_MEM(m_poMediaDataDispatcher);
   RELEASE_MEM(m_poSessionDispatcher);
   RELEASE_MEM(m_poVideoDispatcher);
   RELEASE_MEM(m_poNavigationDispatcher);

}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLMsgQThreadable::vExecute
 ***************************************************************************/

t_Void spi_tclBDCLMsgQThreadable::vExecute(tShlMessage *poMessage)
{
   ETG_TRACE_USR1((" spi_tclBDCLMsgQThreadable::vExecute entered"));

   if ((NULL != poMessage) && (NULL != poMessage->pvBuffer))
   {
      trMsgBase *prMsgBase = static_cast<trMsgBase*> (poMessage->pvBuffer);
      if (NULL != prMsgBase)
      {
         t_U32 u32ServiceID = prMsgBase->u32GetServiceID();
         ETG_TRACE_USR1(("[PARAM]::vExecute: ServiceID %d ", u32ServiceID));

         //! Handle message to corresponding dispatcher based on Service ID
         switch (u32ServiceID)
         {
            case e32MODULEID_BDCLAUDIO:
            {
               BDCLAudioMsgBase* poAudioMsgBase = static_cast<BDCLAudioMsgBase*> (poMessage->pvBuffer);
               if (NULL != poAudioMsgBase)
               {
                  poAudioMsgBase->vDispatchMsg(m_poAudioDispatcher);
               }
            }
               break;
            case e32MODULEID_BDCLBLUETOOTH:
            {
               BDCLBluetoothMsgBase* poBluetoothMsgBase = static_cast<BDCLBluetoothMsgBase*> (poMessage->pvBuffer);
               if (NULL != poBluetoothMsgBase)
               {
                  poBluetoothMsgBase->vDispatchMsg(m_poBluetoothDispatcher);
               }
            }
               break;
            case e32MODULEID_BDCLSESSION:
            {
               BDCLSessionMsgBase *poSessionMsgBase = static_cast<BDCLSessionMsgBase*> (poMessage->pvBuffer);
               if (NULL != poSessionMsgBase)
               {
                  poSessionMsgBase->vDispatchMsg(m_poSessionDispatcher);
               }
            }
               break;
            case e32MODULEID_BDCLVIDEO:
            {
               BDCLVideoMsgBase* poVideoMsgBase = static_cast<BDCLVideoMsgBase*> (poMessage->pvBuffer);
               if (NULL != poVideoMsgBase)
               {
                  poVideoMsgBase->vDispatchMsg(m_poVideoDispatcher);
               }
            }
               break;
            case e32MODULEID_BDCLCARDATA:
            {
               BDCLCarDataMsgBase* poCarDataMsgBase = static_cast<BDCLCarDataMsgBase*> (poMessage->pvBuffer);
               if (NULL != poCarDataMsgBase)
               {
                  poCarDataMsgBase->vDispatchMsg(m_poCarDataDispatcher);
               }
            }
               break;
            case e32MODULEID_BDCLMEDIADATA:
            {
               BDCLMetaDataMsg* poMetaDataMsgBase = static_cast<BDCLMetaDataMsg*> (poMessage->pvBuffer);
               if (NULL != poMetaDataMsgBase)
               {
                  poMetaDataMsgBase->vDispatchMsg(m_poMediaDataDispatcher);
               }
            }
               break;
            case e32MODULEID_BDCLNAVIGATIONTBT:
            {
                BDCLNavigationMsgBase* poNavMsgBase = static_cast<BDCLNavigationMsgBase*> (poMessage->pvBuffer);
               if (NULL != poNavMsgBase)
               {
                   poNavMsgBase->vDispatchMsg(m_poNavigationDispatcher);
               }
            }
               break;
            default:
               ETG_TRACE_ERR(("[ERR]::vExecute: ServiceID %d messages not processed ", u32ServiceID));
               break;
         }//switch (u32ServiceID)

         t_U8 *pu8Buffer = static_cast<t_PU8> (poMessage->pvBuffer);
         RELEASE_ARRAY_MEM(pu8Buffer);
      }//if (NULL != prMsgBase)

      RELEASE_MEM(poMessage);
   }//if ((NULL != poMessage) && (NULL != poMessage->pvBuffer))
}   

/***************************************************************************
 ** FUNCTION:  tShlMessage* spi_tclBDCLMsgQThreadable::poGetMsgBuffer()
 ***************************************************************************/
tShlMessage* spi_tclBDCLMsgQThreadable::poGetMsgBuffer(size_t siBuffer)
{
   ETG_TRACE_USR1((" spi_tclBDCLMsgQThreadable::poGetMsgBuffer entered "));
   tShlMessage* poMessage = new tShlMessage;

   if (NULL != poMessage)
   {
      if (0 < siBuffer)
      {
         //! Allocate the requested memory
         poMessage->pvBuffer = new t_U8[siBuffer];
      }
      else
      {
         poMessage->pvBuffer = NULL;
      } // if(0 < siBuffer)

      if (NULL != poMessage->pvBuffer)
      {
         poMessage->size = siBuffer;
      }
      else
      {
         //! Free the message as internal allocation failed.
         delete poMessage;
         poMessage = NULL;
      }
   }

   return poMessage;
}
