/***********************************************************************/
/*!
 * \file  spi_tclBDCLMsgQInterface.cpp
 * \brief interface for writing data to Q to use the MsgQ based
 *        threading model for BDCL Wrapper
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    interface for writing data to Q to use the MsgQ based
 threading model for BDCL Wrapper
 AUTHOR:         pok6kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification


 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/
#include "spi_tclBDCLMsgQInterface.h"
#include "MessageQueue.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
 #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
  #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
  #include "trcGenProj/Header/spi_tclBDCLMsgQInterface.cpp.trc.h"
 #endif
#endif

using namespace shl::thread;

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLMsgQInterface::spi_tclBDCLMsgQInterface()
 ***************************************************************************/
spi_tclBDCLMsgQInterface::spi_tclBDCLMsgQInterface() :
   m_poBDCLMsgQThreadable(NULL), m_poBDCLMsgQThreader(NULL)
{
   ETG_TRACE_USR1(("spi_tclBDCLMsgQInterface::spi_tclBDCLMsgQInterface entered "));

   m_poBDCLMsgQThreadable = new spi_tclBDCLMsgQThreadable();
   SPI_NORMAL_ASSERT(NULL == m_poBDCLMsgQThreadable);

   m_poBDCLMsgQThreader = new MsgQThreader(m_poBDCLMsgQThreadable);
   SPI_NORMAL_ASSERT(NULL == m_poBDCLMsgQThreader);

   if (NULL != m_poBDCLMsgQThreader)
   {
      m_poBDCLMsgQThreader->bRunThread();
      m_poBDCLMsgQThreader->vSetThreadName("BDCLRespQ");
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLMsgQInterface::~spi_tclBDCLMsgQInterface()
 ***************************************************************************/
spi_tclBDCLMsgQInterface::~spi_tclBDCLMsgQInterface()
{
   ETG_TRACE_USR1((" spi_tclBDCLMsgQInterface::~spi_tclBDCLMsgQInterface() entered \n"));

   if (NULL != m_poBDCLMsgQThreader)
   {
      //Terminate the Message Queue threader before deleting it.
      MessageQueue *poMsgQ = m_poBDCLMsgQThreader->poGetMessageQueu();
      trMsgBase oMsgQTermMsg;
      poMsgQ->s16Push(static_cast<t_Void*> (&oMsgQTermMsg), 0, 1, e8_TCL_THREAD_TERMINATE_MESSAGE);

      //Wait for the message queue thread to join.
      Threader::vWaitForTermination(m_poBDCLMsgQThreader->pGetThreadID());
   }

   RELEASE_MEM(m_poBDCLMsgQThreader);
   RELEASE_MEM(m_poBDCLMsgQThreadable);
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLMsgQInterface::bWriteMsgToQ
 ***************************************************************************/
t_Bool spi_tclBDCLMsgQInterface::bWriteMsgToQ(trMsgBase *prMsgBase, t_U32 u32MsgSize)
{
   ETG_TRACE_USR1((" spi_tclBDCLMsgQInterface::bWriteMsgToQ entered \n"));
   t_Bool bRetQ = false;

   if (NULL != m_poBDCLMsgQThreader)
   {
      //! Get the MsgQ form threader and push the message to Q
      MessageQueue *poMsgQ = m_poBDCLMsgQThreader->poGetMessageQueu();
      if ((NULL != poMsgQ) && (NULL != prMsgBase))
      {
         t_S32 s32RetMsgQ = poMsgQ->s16Push(static_cast<t_Void*> (prMsgBase), u32MsgSize);
         bRetQ = (0 == s32RetMsgQ);
      } // if ((NULL != poMsgQ) && (NULL != prMsgBase))
   } //if (NULL != m_poAAPMsgQThreader)

   if (false == bRetQ)
   {
      ETG_TRACE_ERR(("Write to MsgQ failed  \n"));
   }

   return bRetQ;
}
