/***********************************************************************/
/*!
* \file  spi_tclBDCLManager.cpp
* \brief  Implementation of the Class spi_tclBDCLManager
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "spi_tclBDCLManager.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_BDCLWRAPPER
      #include "trcGenProj/Header/spi_tclBDCLManager.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/
/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
 ** FUNCTION:   spi_tclBDCLManager()
 ***************************************************************************/
spi_tclBDCLManager::spi_tclBDCLManager():
      m_spoCmdAudio(NULL),
      m_spoCmdBluetooth(NULL),
      m_spoCmdCarData(NULL),
      m_spoCmdInput(NULL),
      m_spoCmdMediaData(NULL),
      m_spoCmdNavigation(NULL),
      m_spoCmdSession(NULL),
      m_spoCmdVideo(NULL)
{
   ETG_TRACE_USR1(("spi_tclBDCLManager::spi_tclBDCLManager entered "));

   m_spoCmdAudio = t_SptrBDCLCmdAudio(new spi_tclBDCLCmdAudio);
   SPI_NORMAL_ASSERT(!m_spoCmdAudio);

   m_spoCmdBluetooth = t_SptrBDCLCmdBluetooth(new spi_tclBDCLCmdBluetooth);
   SPI_NORMAL_ASSERT(!m_spoCmdBluetooth);
   
   m_spoCmdCarData = t_SptrBDCLCmdCarData(new spi_tclBDCLCmdCarData);
   SPI_NORMAL_ASSERT(!m_spoCmdCarData);

   m_spoCmdInput = t_SptrBDCLCmdInput(new spi_tclBDCLCmdInput);
   SPI_NORMAL_ASSERT(!m_spoCmdInput);

   m_spoCmdMediaData = t_SptrBDCLCmdMediaData(new spi_tclBDCLCmdMediaData);
   SPI_NORMAL_ASSERT(!m_spoCmdMediaData);

   m_spoCmdNavigation = t_SptrBDCLCmdNavigation(new spi_tclBDCLCmdNavigation);
   SPI_NORMAL_ASSERT(!m_spoCmdNavigation);

   m_spoCmdSession = t_SptrBDCLCmdSession(new spi_tclBDCLCmdSession);
   SPI_NORMAL_ASSERT(!m_spoCmdSession);

   m_spoCmdVideo = t_SptrBDCLCmdVideo(new spi_tclBDCLCmdVideo);
   SPI_NORMAL_ASSERT(!m_spoCmdVideo);

   ETG_TRACE_USR1(("spi_tclBDCLManager::spi_tclBDCLManager left "));
}

/***************************************************************************
 ** FUNCTION:   spi_tclBDCLManager()
 ***************************************************************************/
spi_tclBDCLManager::~spi_tclBDCLManager()
{
   ETG_TRACE_USR1(("spi_tclBDCLManager::~spi_tclBDCLManager entered "));
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLCmdAudio spoGetCmdAudioInstance()
 ***************************************************************************/
t_SptrBDCLCmdAudio spi_tclBDCLManager::spoGetCmdAudioInstance()
{
	return m_spoCmdAudio;
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLCmdBluetooth spoGetCmdBluetoothInstance()
 ***************************************************************************/
t_SptrBDCLCmdBluetooth spi_tclBDCLManager::spoGetCmdBluetoothInstance()
{
	return m_spoCmdBluetooth;
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLCmdCarData spoGetCmdCarDataInstance()
 ***************************************************************************/
t_SptrBDCLCmdCarData spi_tclBDCLManager::spoGetCmdCarDataInstance()
{
   return m_spoCmdCarData;
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLCmdInput spoGetCmdInputInstance()
 ***************************************************************************/
t_SptrBDCLCmdInput spi_tclBDCLManager::spoGetCmdInputInstance()
{
	return m_spoCmdInput;
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLCmdMediaData spoGetCmdMediaDataInstance()
 ***************************************************************************/
t_SptrBDCLCmdMediaData spi_tclBDCLManager::spoGetCmdMediaDataInstance()
{
   return m_spoCmdMediaData;
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLCmdMediaData spoGetCmdNavigationInstance()
 ***************************************************************************/
t_SptrBDCLCmdNavigation spi_tclBDCLManager::spoGetCmdNavigationInstance()
{
   return m_spoCmdNavigation;
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLCmdSession spoGetCmdSessionInstance()
 ***************************************************************************/
t_SptrBDCLCmdSession spi_tclBDCLManager::spoGetCmdSessionInstance()
{
	return m_spoCmdSession;
}

/***************************************************************************
 ** FUNCTION:    t_SptrBDCLCmdVideo spoGetCmdVideoInstance()
 ***************************************************************************/
t_SptrBDCLCmdVideo spi_tclBDCLManager::spoGetCmdVideoInstance()
{
   return m_spoCmdVideo;
}

/***************************************************************************
 ** FUNCTION:  t_Bool bRegisterObject(RespBase *poRespReg)
 ***************************************************************************/
t_Bool spi_tclBDCLManager::bRegisterObject(RespBase *poRespBase)
{
   ETG_TRACE_USR1(("spi_tclBDCLManager::bRegisterObject  Entered \n"));
   RespRegister *pRespRegister = RespRegister::getInstance();
   t_Bool bRetReg = false;
   if (NULL != pRespRegister)
   {
      bRetReg = pRespRegister->bRegisterObject(poRespBase);
   }
   return bRetReg;
}

/***************************************************************************
 ** FUNCTION:  t_Bool bUnRegisterObject(RespBase *poRespReg)
 ***************************************************************************/
t_Bool spi_tclBDCLManager::bUnRegisterObject(RespBase *poRespBase)
{
   ETG_TRACE_USR1(("spi_tclBDCLManager::bUnRegisterObject  Entered \n"));
   RespRegister *pRespRegister = RespRegister::getInstance();
   t_Bool bRetReg = false;
   if (NULL != pRespRegister)
   {
      bRetReg = pRespRegister->bUnregisterObject(poRespBase);
   }
   return bRetReg;
}

///////////////////////////////////////////////////////////////////////////////
// <EOF>
