/***********************************************************************/
/*!
* \file  spi_tclBDCLMsgQThreadable.h
* \brief implements threading based on MsgQthreader for BDCL Wrappers
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    implements threading based on MsgQthreader for BDCL Wrappers
AUTHOR:         pok6kor
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification


\endverbatim
*************************************************************************/

#ifndef SPI_TCLBDCLMSGQTHREADER_H_
#define SPI_TCLBDCLMSGQTHREADER_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "MsgQThreadable.h"
#include "spi_tclBDCLAudioDispatcher.h"
#include "spi_tclBDCLBluetoothDispatcher.h"
#include "spi_tclBDCLCarDataDispatcher.h"
#include "spi_tclBDCLMediaDataDispatcher.h"
#include "spi_tclBDCLSessionDispatcher.h"
#include "spi_tclBDCLVideoDispatcher.h"
#include "spi_tclBDCLNavigationDispatcher.h"

using namespace shl::thread;

/****************************************************************************/
/*!
* \class spi_tclBDCLMsgQThreadable
* \brief implements threading based on MsgQthreader for BDCL Wrappers
*
* Responsible for calling the respective dispatchers and to allocate memory
* when a message arrives on Q
*
****************************************************************************/

class spi_tclBDCLMsgQThreadable : public MsgQThreadable
{
   public:

      /***************************************************************************
      ** FUNCTION:  spi_tclBDCLMsgQThreadable::spi_tclBDCLMsgQThreadable()
      ***************************************************************************/
      /*!
      * \fn      spi_tclBDCLMsgQThreadable()
      * \brief   Default Constructor
      * \sa      ~spi_tclBDCLMsgQThreadable()
      **************************************************************************/
      spi_tclBDCLMsgQThreadable();

      /***************************************************************************
      ** FUNCTION:  spi_tclBDCLMsgQThreadable::~spi_tclBDCLMsgQThreadable()
      ***************************************************************************/
      /*!
      * \fn      ~spi_tclBDCLMsgQThreadable()
      * \brief   Destructor
      * \sa      spi_tclBDCLMsgQThreadable()
      **************************************************************************/
      ~spi_tclBDCLMsgQThreadable();

   protected:
      /***************************************************************************
      ** FUNCTION:  spi_tclBDCLMsgQThreadable::vExecute
      ***************************************************************************/
      /*!
      * \fn      t_Void vExecute(tShlMessage *poMessage)
      * \brief   Responsible for posting the message to respective dispatchers
      * \param   poMessage : message received from MsgQ for dispatching
      * \retval  t_Void
      **************************************************************************/
      virtual t_Void vExecute(tShlMessage *poMessage);

      /***************************************************************************
      ** FUNCTION:  spi_tclBDCLMsgQThreadable::tShlMessage* poGetMsgBuffer(size_t )
      ***************************************************************************/
      /*!
      * \fn      tShlMessage* poGetMsgBuffer(size_t )
      * \brief  This function will be called for requesting the storage allocation for received
      *           message
      * \param siBuffer: size of the buffer to be allocated for the received message
      * \retval tShlMessage
      **************************************************************************/
      virtual tShlMessage* poGetMsgBuffer(size_t siBuffer);

   private:
   
      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLMsgQThreadable(const spi_tclBDCLMsgQThreadable...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLMsgQThreadable(
       *                             const spi_tclBDCLMsgQThreadable& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLMsgQThreadable()
       ***************************************************************************/
       spi_tclBDCLMsgQThreadable(const spi_tclBDCLMsgQThreadable& corfoSrc);


      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLMsgQThreadable& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLMsgQThreadable& operator=(
       *                          const spi_tclBDCLMsgQThreadable& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLMsgQThreadable(const spi_tclBDCLMsgQThreadable& otrSrc)
       ***************************************************************************/
       spi_tclBDCLMsgQThreadable& operator=(const spi_tclBDCLMsgQThreadable& corfoSrc);   

      spi_tclBDCLAudioDispatcher*         m_poAudioDispatcher;

      spi_tclBDCLBluetoothDispatcher*     m_poBluetoothDispatcher;

      spi_tclBDCLCarDataDispatcher*       m_poCarDataDispatcher;

      spi_tclBDCLMediaDataDispatcher*     m_poMediaDataDispatcher;

      spi_tclBDCLSessionDispatcher*       m_poSessionDispatcher;

      spi_tclBDCLVideoDispatcher*         m_poVideoDispatcher;

      spi_tclBDCLNavigationDispatcher*    m_poNavigationDispatcher;

};


#endif /* SPI_TCLBDCLMSGQTHREADER_H_ */
