/***********************************************************************/
/*!
 * \file  spi_tclBDCLCarDataDispatcher.h
 * \brief Message Dispatcher for Car Data Messages. implemented using
 *       double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Car Data Messages
 AUTHOR:         pok6kor
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification

 \endverbatim
 *************************************************************************/
#ifndef SPI_TCLBDCLCARDATADISPATCHER_H_
#define SPI_TCLBDCLCARDATADISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/

#include "RespRegister.h"
#include "BDCLTypes.h"
#include "SPITypes.h"
/**************Forward Declarations******************************************/
class spi_tclBDCLCarDataDispatcher;

/****************************************************************************/
/*!
 * \class BDCLCarDataMsgBase
 * \brief Base Message type for all CarData messages
 ****************************************************************************/
class BDCLCarDataMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  BDCLCarDataMsgBase::BDCLCarDataMsgBase
       ***************************************************************************/
      /*!
       * \fn      BDCLCarDataMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      BDCLCarDataMsgBase();

      /***************************************************************************
       ** FUNCTION:  BDCLCarDataMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLCarDataDispatcher* poCarDataDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param   poCarDataDispatcher : pointer to Message dispatcher for CarData
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclBDCLCarDataDispatcher* poCarDataDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  BDCLCarDataMsgBase::~BDCLCarDataMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~BDCLCarDataMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLCarDataMsgBase()
      {

      }
};

/****************************************************************************/
/*!
 * \class BDCLCarDataSubscribeMsg
 * \brief CarData attestation response message
 ****************************************************************************/
class BDCLCarDataSubscribeMsg: public BDCLCarDataMsgBase
{
   public:
      tBdclCarDataInfoList *m_pCarDataSubscriptionList;
      /***************************************************************************
       ** FUNCTION:  BDCLCarDataSubscribeMsg::BDCLCarDataSubscribeMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLCarDataSubscribeMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLCarDataSubscribeMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLCarDataSubscribeMsg::~BDCLCarDataSubscribeMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLCarDataSubscribeMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLCarDataSubscribeMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLCarDataSubscribeMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLCarDataDispatcher* poCarDataDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param  poCarDataDispatcher : pointer to Message dispatcher for CarData
       * \retval t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLCarDataDispatcher* poCarDataDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLMetaDataMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLMetaDataMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval t_Void
       **************************************************************************/
      t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class BDCLCarDataSubscribeStartMsg
 * \brief CarData attestation response message
 ****************************************************************************/
class BDCLCarDataSubscribeStartMsg: public BDCLCarDataMsgBase
{
   public:
      tBdclCarDataInfoList *m_pCarDataSubscriptionStartList;
      /***************************************************************************
       ** FUNCTION:  BDCLCarDataSubscribeStartMsg::BDCLCarDataSubscribeStartMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLCarDataSubscribeStartMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLCarDataSubscribeStartMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLCarDataSubscribeStartMsg::~BDCLCarDataSubscribeStartMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLCarDataSubscribeStartMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLCarDataSubscribeStartMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLCarDataSubscribeStartMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLCarDataDispatcher* poCarDataDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poCarDataDispatcher : pointer to Message dispatcher for CarData
       * \retval  t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLCarDataDispatcher* poCarDataDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLCarDataSubscribeStartMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLCarDataSubscribeStartMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class BDCLCarDataSubscribeStopMsg
 * \brief CarData attestation response message
 ****************************************************************************/
class BDCLCarDataSubscribeStopMsg: public BDCLCarDataMsgBase
{
   public:
      tBdclCarDataInfoList *m_pCarDataSubscriptionStopList;
      /***************************************************************************
       ** FUNCTION:  BDCLCarDataSubscribeStopMsg::BDCLCarDataSubscribeStopMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLCarDataSubscribeStopMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLCarDataSubscribeStopMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLCarDataSubscribeStopMsg::~BDCLCarDataSubscribeStopMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLCarDataSubscribeStopMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLCarDataSubscribeStopMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLCarDataSubscribeStopMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLCarDataDispatcher* poCarDataDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poCarDataDispatcher : pointer to Message dispatcher for CarData
       * \retval  t_Void
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLCarDataDispatcher* poCarDataDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLCarDataSubscribeStopMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       * \retval  t_Void
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLCarDataSubscribeStopMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       * \retval t_Void
       **************************************************************************/
      t_Void vDeAllocateMsg();
};



/****************************************************************************/
/*!
 * \class spi_tclBDCLCarDataDispatcher
 * \brief Message Dispatcher for CarData Messages
 ****************************************************************************/
class spi_tclBDCLCarDataDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLCarDataDispatcher::spi_tclBDCLCarDataDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLCarDataDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclBDCLCarDataDispatcher(){}

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLCarDataDispatcher::~spi_tclBDCLCarDataDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLCarDataDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclBDCLCarDataDispatcher(){}

      /**************************************************************************************
       ** FUNCTION:  spi_tclBDCLCarDataDispatcher::vHandleCarDataMsg(BDCLCarDataSubscribeMsg*)
       ***************************************************************************/
      /*!
       * \fn      vHandleCarDataMsg(BDCLCarDataSubscribeMsg* poBDCLCarDataSubscribeMsg)
       * \brief   Handles Messages of BDCLCarDataSubscribeMsg type
       * \param   poBDCLMetaDataMsg : pointer to BDCLCarDataSubscribeMsg.
       * \retval  t_Void
       **************************************************************************/
      t_Void vHandleCarDataMsg(BDCLCarDataSubscribeMsg* poBDCLCarDataSubscribeMsg) const;
      /**************************************************************************************
       ** FUNCTION:  spi_tclBDCLCarDataDispatcher::vHandleCarDataMsg(BDCLCarDataSubscribeMsg*)
       ***************************************************************************/
      /*!
       * \fn      vHandleCarDataMsg(BDCLCarDataSubscribeMsg* poBDCLCarDataSubscribeMsg)
       * \brief   Handles Messages of BDCLCarDataSubscribeMsg type
       * \param   poBDCLMetaDataMsg : pointer to BDCLCarDataSubscribeMsg.
       * \retval  t_Void
       **************************************************************************/
      t_Void vHandleCarDataMsg(BDCLCarDataSubscribeStartMsg* poBDCLCarDataSubscribeStartMsg) const;    
      /**************************************************************************************
       ** FUNCTION:  spi_tclBDCLCarDataDispatcher::vHandleCarDataMsg(BDCLCarDataSubscribeMsg*)
       ***************************************************************************/
      /*!
       * \fn      vHandleCarDataMsg(BDCLCarDataSubscribeMsg* poBDCLCarDataSubscribeMsg)
       * \brief   Handles Messages of BDCLCarDataSubscribeMsg type
       * \param   poBDCLMetaDataMsg : pointer to BDCLCarDataSubscribeMsg.
       * \retval  t_Void
       **************************************************************************/
      t_Void vHandleCarDataMsg(BDCLCarDataSubscribeStopMsg* poBDCLCarDataSubscribeStopMsg) const;

};

#endif /* SPI_TCLBDCLMEDIADATADISPATCHER_H_ */
