/***********************************************************************/
/*!
* \file  spi_tclBDCLRespBluetooth.h
* \brief BDCL Bluetooth Output Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    BDCL Bluetooth Output Interface
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
04.05.2017  | pok6kor               | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLRESPBLUETOOTH_H_
#define SPI_TCLBDCLRESPBLUETOOTH_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include <vector>
#include "RespBase.h"
#include "BDCLTypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclBDCLRespBluetooth
* \brief BDCL Bluetooth Output Interface
*
* updates all the registered clients, whenever there is
* an update on BDCL Bluetooth
*
****************************************************************************/
class spi_tclBDCLRespBluetooth:public RespBase
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespBluetooth::spi_tclBDCLRespBluetooth()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespBluetooth()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLRespBluetooth()
       **************************************************************************/
      spi_tclBDCLRespBluetooth():RespBase(e16BDCL_BLUETOOTH_REGID)
      {
      }

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespBluetooth::~spi_tclBDCLRespBluetooth()
       ***************************************************************************/
      /*!
       * \fn      virtual ~spi_tclBDCLRespBluetooth()
       * \brief   Destructor
       * \sa      spi_tclBDCLRespBluetooth(RegID enRegId)
       **************************************************************************/
      virtual ~spi_tclBDCLRespBluetooth()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespBluetooth::vOnNaviNextTurnInfoMsg()
       ***************************************************************************/
      /*!
       * \fn      vOnBluetoothOOBInfoMsg
       * \brief   Triggered when BDCL device gets Bluetooth OOB Info Msg
       * \param   cprInfo [IN]: Structure containing BDCL BluetoothOOBInfo
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnBluetoothOOBInfoMsg(const trBdclBluetoothOOBInfo* cprInfo)
      {
      };

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespBluetooth::vOnBluetoothHFPRequestMsg()
       ***************************************************************************/
      /*!
       * \fn      vOnBluetoothHFPRequestMsg
       * \brief   Triggered when BDCL devices sends BT HFP Request
       * \param   cprInfo [IN]: Structure containing BT HFP Request info
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnBluetoothHFPRequestMsg(const trBdclBluetoothHFPRequest* cprInfo)
      {
      };

      /*******************************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespBluetooth::vOnStartBluetoothAutoPairMsg()
       *******************************************************************************************/
      /*!
       * \fn      vOnStartBluetoothAutoPairMsg
       * \brief   Triggered when BDCL devices sends Start BT Autopair
       * \param   cprInfo [IN]: Structure containing Start BT Autopair info
       * \retval  t_Void
       *******************************************************************************************/
      virtual t_Void vOnStartBluetoothAutoPairMsg(const trBdclStartBluetoothAutopair* cprInfo)
      {
      };

      /*******************************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespBluetooth::vOnBluetoothHFPStatusRequestMsg()
       *******************************************************************************************/
      /*!
       * \fn      vOnBluetoothHFPStatusRequestMsg
       * \brief   Triggered when BDCL devices sends BT HFP Status Request
       * \param   enType [IN]: Structure containing BT HFP Status Request info
       * \retval  t_Void
       *******************************************************************************************/
      virtual t_Void vOnBluetoothHFPStatusRequestMsg(const tenBdclStatusType enType)
      {
      };

      /*******************************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespBluetooth::vOnBluetoothIdentifyResultIndMsg()
       *******************************************************************************************/
      /*!
       * \fn      vOnBluetoothIdentifyResultIndMsg
       * \brief   Triggered when BDCL devices sends BT Identify result
       * \param   cprInfo [IN]: Structure containing BT Identify result info
       * \retval  t_Void
       *******************************************************************************************/
      virtual t_Void vOnBluetoothIdentifyResultIndMsg(const trBdclBluetoothIdentifyResultInd* cprInfo)
      {
      };

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespBluetooth::spi_tclBDCLRespBluetooth()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespBluetooth(
       *          const spi_tclBDCLRespBluetooth& corfoSrc))
       * \brief   Parameterized Constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \sa      spi_tclBDCLRespBluetooth(RegID enRegId)
       **************************************************************************/
      spi_tclBDCLRespBluetooth(const spi_tclBDCLRespBluetooth& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespBluetooth& operator=( const spi_tclMLV...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespBluetooth& operator=(
       *                          const spi_tclBDCLRespBluetooth& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLRespBluetooth(const spi_tclBDCLRespBluetooth& otrSrc)
       ***************************************************************************/
      spi_tclBDCLRespBluetooth& operator=(const spi_tclBDCLRespBluetooth& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/


}; //class spi_tclBDCLRespBluetooth

#endif // SPI_TCLBDCLRESPBLUETOOTH_H_

///////////////////////////////////////////////////////////////////////////////
// <EOF>
