/***********************************************************************/
/*!
* \file  spi_tclBDCLCmdBluetooth.h
* \brief  Implementation of the Class spi_tclBDCLCmdBluetooth
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
05.05.2017    pok6kor			        Initial Version
\endverbatim
*************************************************************************/

#ifndef SPI_TCLBDCLCMDBLUETOOTH_
#define SPI_TCLBDCLCMDBLUETOOTH_

#include <memory>
#include "BDCLTypes.h"
#include "BDCL_WrapperTypes.h"
#include "spi_tclBDCLMsgQInterface.h"
#include "spi_tclBDCLBluetoothDispatcher.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
class spi_tclBDCLBluetoothProxyIntf;
typedef std::shared_ptr< spi_tclBDCLBluetoothProxyIntf >    t_SptrBDCLBluetoothProxy;

/*!
 * \class spi_tclBDCLCmdBluetooth
 * \brief
 */
class spi_tclBDCLCmdBluetooth
{

public:
	/***************************************************************************
	 ** FUNCTION:spi_tclBDCLCmdBluetooth()
	 ***************************************************************************/
	/*!
	 * \fn        spi_tclBDCLCmdBluetooth()
	 * \brief     Constructor
	 * \sa     ~spi_tclBDCLCmdBluetooth()
	 **************************************************************************/
	spi_tclBDCLCmdBluetooth();

	/***************************************************************************
	 ** FUNCTION:~spi_tclBDCLCmdNavigation()
	 ***************************************************************************/
	/*!
	 * \fn      ~spi_tclBDCLCmdNavigation()
	 * \brief  Destructor
	 * \sa     spi_tclBDCLCmdNavigation()
	 **************************************************************************/
	virtual ~spi_tclBDCLCmdBluetooth();

	/***************************************************************************
	 ** FUNCTION:t_Bool bInitialize()
	 ***************************************************************************/
	/*!
	 * \fn      
	 * \brief   bInitialize()
	 * \param   Performs initialization for Bluetooth with BDCL device
    * \sa      vUninitialize()
	 **************************************************************************/
	t_Bool bInitialize();

	/***************************************************************************
	 ** FUNCTION:
	 ***************************************************************************/
	/*!
	 * \fn      vUninitialize()
	 * \brief   Performs cleanup of Bluetooth with BDCL device
    * \sa      bInitialize()
	 **************************************************************************/
	void vUninitialize();

   /***************************************************************************
    ** FUNCTION:  static t_Void vOnMDBluetoothOOBInfoCb(...)
    ***************************************************************************/
   /*!
    * \fn      vOnMDBluetoothOOBInfoCb()
    * \brief   Interface to receive message MSG_CMD_MD_BT_OOB_INFO
    * \param   prInfo [IN]: Structure containing BDCL BluetoothOOBInfo
    **************************************************************************/
   static t_Void vOnMDBluetoothOOBInfoCb(S_BT_OOB_INFO* prInfo);

   /***************************************************************************
    ** FUNCTION:  static t_Void vOnBluetoothHFPRequestCb(...)
    ***************************************************************************/
   /*!
    * \fn      vOnBluetoothHFPRequestCb()
    * \brief   Interface to receive message MSG_CMD_BT_HFP_REQUEST
    * \param   prBTHFPRequestInfo [IN]: Structure containing BDCL BluetoothHFPRequest
    **************************************************************************/
   static t_Void vOnBluetoothHFPRequestCb(S_BT_HFP_REQUEST* prBTHFPRequestInfo);

   /***************************************************************************
    ** FUNCTION:  static t_Void vOnStartBluetoothAutopairCb(...)
    ***************************************************************************/
   /*!
    * \fn      vOnStartBluetoothAutopairCb()
    * \brief   Interface to receive message MSG_CMD_START_BT_AUTOPAIR
    * \param   prStartBTAutopairReqInfo [IN]: Structure containing BDCL BluetoothAutopair
    **************************************************************************/
   static t_Void vOnStartBluetoothAutopairCb(S_BT_START_PAIR_REQ* prStartBTAutopairReqInfo);

   /***************************************************************************
    ** FUNCTION:  static t_Void vOnBluetoothHFPStatusRequestCb(...)
    ***************************************************************************/
   /*!
    * \fn      vOnBluetoothHFPStatusRequestCb()
    * \brief   Interface to receive message MSG_CMD_BT_HFP_STATUS_REQUEST
    * \param   prBTHFPStatusReqInfo [IN]: Structure containing BDCL Bluetooth HFP Status Request
    **************************************************************************/
   static t_Void vOnBluetoothHFPStatusRequestCb(S_BT_HFP_STATUS_REQUEST* prBTHFPStatusReqInfo);

   /***************************************************************************
    ** FUNCTION:  static t_Void vOnBluetoothIdentifyResultIndCb(...)
    ***************************************************************************/
   /*!
    * \fn      vOnBluetoothIdentifyResultIndCb()
    * \brief   Interface to receive message MSG_CMD_BT_IDENTIFY_RESULT_IND
    * \param   prBTIdentityResultIndInfo [IN]: Structure containing BDCL Bluetooth Identify Result
    **************************************************************************/
   static t_Void vOnBluetoothIdentifyResultIndCb(S_BT_INDENTIFY_RESULT_IND* prBTIdentityResultIndInfo);

      /***************************************************************************
    ** FUNCTION:   t_Bool bSendHUBluetoothOOBInfo(...)
    ***************************************************************************/
   /*!
    * \fn      bSendHUBluetoothOOBInfo()
    * \brief   Interface to send message MSG_CMD_HU_BT_OOB_INFO msg
    ***************************************************************************/
   t_Bool bSendHUBluetoothOOBInfo(trBdclBluetoothOOBInfo *prOOBInfo);

   /***************************************************************************
    **** FUNCTION:   t_Bool bSendBluetoothHFPIndication(...)
    *******************************************************************************/
   /*!
    * \fn      bSendBluetoothHFPIndication()
    * \brief   Interface to send message MSG_CMD_BT_HFP_INDICATION msg
    ****************************************************************************/
   t_Bool bSendBluetoothHFPIndication(trBdclBluetoothHFPIndication *prHFPIndication);

   /***************************************************************************
    ** FUNCTION:   t_Bool bSendBluetoothHFPConn(...)
    ***************************************************************************/
   /*!
    * \fn      bSendBluetoothHFPConn()
    * \brief   Interface to send message MSG_CMD_BT_HFP_CONNECTION msg
    **************************************************************************/
   t_Bool bSendBluetoothHFPConn(trBdclBluetoothHFPConn *prHFPConn);

   /***************************************************************************
    ** FUNCTION:   t_Bool bSendBluetoothHFPResponse(...)
    ***************************************************************************/
   /*!
    * \fn      bSendBluetoothHFPResponse()
    * \brief   Interface to send message MSG_CMD_BT_HFP_RESPONSE msg
    **************************************************************************/
   t_Bool bSendBluetoothHFPResponse(trBdclBluetoothHFPResponse *prHFPResponse);

   /***************************************************************************
    ** FUNCTION:   t_Bool bSendBluetoothHFPStatusResponse(...)
    ***************************************************************************/
   /*!
    * \fn      bSendBluetoothHFPStatusResponse()
    * \brief   Interface to send message MSG_CMD_BT_HFP_STATUS_RESPONSE msg
    **************************************************************************/
   t_Bool bSendBluetoothHFPStatusResponse(trBdclBluetoothHFPStatusResponse *prHFPStatusResponse);

   /***************************************************************************
    ** FUNCTION:   t_Bool bSendBluetoothStartIndentifyReq(...)
    ***************************************************************************/
   /*!
    * \fn      bSendBluetoothStartIndentifyReq()
    * \brief   Interface to send message MSG_CMD_BT_START_IDENTIFY_REQ msg
    * \Param   [IN] szBTMacAddress : BT MAC address in the format AA:BB:CC:DD:EE
    **************************************************************************/
   t_Bool bSendBluetoothStartIndentifyReq(t_String szBTMacAddress);

private:

   /***************************************************************************
    ** FUNCTION: spi_tclBDCLCmdBluetooth(const spi_tclBDCLCmdBluetooth&)
    ***************************************************************************/
   /*!
    * \fn      spi_tclBDCLCmdBluetooth(const spi_tclBDCLCmdBluetooth&)
    * \brief   Copy constructor not implemented
    **************************************************************************/
	spi_tclBDCLCmdBluetooth(const spi_tclBDCLCmdBluetooth&);

   /***************************************************************************
    ** FUNCTION: const spi_tclBDCLCmdBluetooth & operator=(const spi_tclBDCLCmdBluetooth&);
    ***************************************************************************/
   /*!
    * \fn      const spi_tclBDCLCmdBluetooth & operator=(const spi_tclBDCLCmdBluetooth&);
    * \brief   assignment operator not implemented
    **************************************************************************/
   const spi_tclBDCLCmdBluetooth & operator=(const spi_tclBDCLCmdBluetooth&);

   //! Pointer to Bluetooth proxy
   t_SptrBDCLBluetoothProxy m_spoBluetoothProxy;
};
#endif //SPI_TCLBDCLCMDBLUETOOTH_
