/***********************************************************************/
/*!
 * \file  spi_tclBDCLBluetoothDispatcher.h
 * \brief Message Dispatcher for Bluetooth Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Bluetooth Messages
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
04.05.2017  | pok6kor               | Initial Version

\endverbatim
 *************************************************************************/
#ifndef SPI_TCLBDCLBLUETOOTHDISPATCHER_H_
#define SPI_TCLBDCLBLUETOOTHDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "SPITypes.h"
#include "BDCLTypes.h"

//!Forward declarations
class spi_tclBDCLBluetoothDispatcher;

/****************************************************************************/
/*!
 * \class BDCLBluetoothMsgBase
 * \brief Base Message type for all Bluetooth messages
 ****************************************************************************/
class BDCLBluetoothMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothMsgBase::BDCLBluetoothMsgBase
       ***************************************************************************/
      /*!
       * \fn      BDCLBluetoothMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      BDCLBluetoothMsgBase();

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLBluetoothDispatcher* poBluetoothDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclBDCLBluetoothDispatcher* poBluetoothDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothMsgBase::~BDCLBluetoothMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~BDCLBluetoothMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLBluetoothMsgBase()
      {
      }
};

/****************************************************************************/
/*!
 * \class BDCLBluetoothOOBInfoMsg
 * \brief Bluetooth OOB info message
 ****************************************************************************/
class BDCLBluetoothOOBInfoMsg: public BDCLBluetoothMsgBase
{
   public:

      trBdclBluetoothOOBInfo* m_prBluetoothOOBInfo;

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothOOBInfoMsg::BDCLBluetoothOOBInfoMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLBluetoothOOBInfoMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLBluetoothOOBInfoMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothOOBInfoMsg::~BDCLBluetoothOOBInfoMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLBluetoothOOBInfoMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLBluetoothOOBInfoMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothOOBInfoMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLBluetoothDispatcher* poBluetoothDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLBluetoothDispatcher* poBluetoothDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLNaviNextTurnInfoMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLNaviNextTurnInfoMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class BDCLBluetoothHFPRequestMsg
 * \brief Response message for controlling Bluetooth phone call function
 ****************************************************************************/
class BDCLBluetoothHFPRequestMsg: public BDCLBluetoothMsgBase
{
   public:

      trBdclBluetoothHFPRequest* m_prBluetoothHFPRequest;

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothHFPRequestMsg::BDCLBluetoothHFPRequestMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLBluetoothHFPRequestMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLBluetoothHFPRequestMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothHFPRequestMsg::~BDCLBluetoothHFPRequestMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLBluetoothHFPRequestMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLBluetoothHFPRequestMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothHFPRequestMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLBluetoothDispatcher* poBluetoothDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLBluetoothDispatcher* poBluetoothDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLNaviAssitantGuideInfoMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLConnExceptionMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();

};

/****************************************************************************/
/*!
 * \class BDCLStartBluetoothAutopairMsg
 * \brief REsponse message to start BT Autopair process
 ****************************************************************************/
class BDCLStartBluetoothAutopairMsg: public BDCLBluetoothMsgBase
{
   public:

      trBdclStartBluetoothAutopair* m_prStartBluetoothAutopair;

      /***************************************************************************
       ** FUNCTION:  BDCLStartBluetoothAutopairMsg::BDCLStartBluetoothAutopairMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLStartBluetoothAutopairMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLStartBluetoothAutopairMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLStartBluetoothAutopairMsg::~BDCLStartBluetoothAutopairMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLStartBluetoothAutopairMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLStartBluetoothAutopairMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothHFPRequestMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLBluetoothDispatcher* poBluetoothDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLBluetoothDispatcher* poBluetoothDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLNaviAssitantGuideInfoMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLConnExceptionMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();

};

/****************************************************************************/
/*!
 * \class BDCLBluetoothHFPStatusRequestMsg
 * \brief Response message to obtain MIC status
 ****************************************************************************/
class BDCLBluetoothHFPStatusRequestMsg: public BDCLBluetoothMsgBase
{
   public:

      tenBdclStatusType enType;

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothHFPStatusRequestMsg::BDCLBluetoothHFPStatusRequestMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLBluetoothHFPStatusRequestMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLBluetoothHFPStatusRequestMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothHFPStatusRequestMsg::~BDCLBluetoothHFPStatusRequestMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLBluetoothHFPStatusRequestMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLBluetoothHFPStatusRequestMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothHFPRequestMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLBluetoothDispatcher* poBluetoothDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLBluetoothDispatcher* poBluetoothDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLNaviAssitantGuideInfoMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLConnExceptionMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg()
      {

      }

};

/****************************************************************************/
/*!
 * \class BDCLBluetoothIdentifyResultIndMsg
 * \brief Response message to indicate the result of BT mark
 ****************************************************************************/
class BDCLBluetoothIdentifyResultIndMsg: public BDCLBluetoothMsgBase
{
   public:

      trBdclBluetoothIdentifyResultInd* m_prBluetoothIdentifyResultInd;

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothIdentifyResultIndMsg::BDCLBluetoothIdentifyResultIndMsg
       ***************************************************************************/
      /*!
       * \fn      BDCLBluetoothIdentifyResultIndMsg()
       * \brief   Default constructor
       **************************************************************************/
      BDCLBluetoothIdentifyResultIndMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothIdentifyResultIndMsg::~BDCLBluetoothIdentifyResultIndMsg
       ***************************************************************************/
      /*!
       * \fn      ~BDCLBluetoothIdentifyResultIndMsg()
       * \brief   Destructor
       **************************************************************************/
      virtual ~BDCLBluetoothIdentifyResultIndMsg()
      {
      }

      /***************************************************************************
       ** FUNCTION:  BDCLBluetoothHFPRequestMsg::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclBDCLBluetoothDispatcher* poBluetoothDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclBDCLBluetoothDispatcher* poBluetoothDispatcher);

      /***************************************************************************
       ** FUNCTION:  BDCLNaviAssitantGuideInfoMsg::vAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  BDCLConnExceptionMsg::vDeAllocateMsg
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();

};

/****************************************************************************/
/*!
 * \class spi_tclBDCLBluetoothDispatcher
 * \brief Message Dispatcher for Bluetooth Messages
 ****************************************************************************/
class spi_tclBDCLBluetoothDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::spi_tclBDCLBluetoothDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLBluetoothDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclBDCLBluetoothDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::~spi_tclBDCLBluetoothDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLBluetoothDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclBDCLBluetoothDispatcher();

      /**********************************************************************************************
       ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLBluetoothOOBInfoMsg* )
       **********************************************************************************************/
      /*!
       * \fn      vHandleBluetoothMsg(BDCLBluetoothOOBInfoMsg* poBDCLMDInfoMsg)
       * \brief   Handles Messages of BDCLBluetoothOOBInfoMsg type
       * \param   poBDCLBluetoothOOBInfoMsg : pointer to BDCLBluetoothOOBInfoMsg.
       **************************************************************************/
      t_Void vHandleBluetoothMsg(BDCLBluetoothOOBInfoMsg* poBDCLBluetoothOOBInfoMsg) const;

      /******************************************************************************************
       ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLBluetoothHFPRequestMsg* )
       ***************************************************************************/
      /*!
       * \fn      vHandleBluetoothMsg(BDCLBluetoothHFPRequestMsg* poBDCLNaviAssitantGuideInfoMsg)
       * \brief   Handles Messages of BDCLBluetoothHFPRequestMsg type
       * \param   poBDCLNaviAssitantGuideInfoMsg : pointer to BDCLBluetoothHFPRequestMsg.
       **************************************************************************/
      t_Void vHandleBluetoothMsg(BDCLBluetoothHFPRequestMsg* poBDCBluetoothHFPRequestMsg) const;

      /******************************************************************************************
       ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLStartBluetoothAutopairMsg* )
       ***************************************************************************/
      /*!
       * \fn      vHandleBluetoothMsg(BDCLStartBluetoothAutopairMsg* poBDCLNaviAssitantGuideInfoMsg)
       * \brief   Handles Messages of BDCLStartBluetoothAutopairMsg type
       * \param   poBDCLStartBluetoothAutopairMsg : pointer to BDCLStartBluetoothAutopairMsg.
       **************************************************************************/
      t_Void vHandleBluetoothMsg(BDCLStartBluetoothAutopairMsg* poBDCLStartBluetoothAutopairMsg) const;

      /******************************************************************************************
       ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLBluetoothHFPStatusRequestMsg* )
       ***************************************************************************/
      /*!
       * \fn      vHandleBluetoothMsg(BDCLBluetoothHFPStatusRequestMsg* poBDCLBluetoothHFPStatusRequestMsg)
       * \brief   Handles Messages of BDCLBluetoothHFPStatusRequestMsg type
       * \param   poBDCLBluetoothHFPStatusRequestMsg : pointer to BDCLBluetoothHFPStatusRequestMsg.
       **************************************************************************/
      t_Void vHandleBluetoothMsg(BDCLBluetoothHFPStatusRequestMsg* poBDCLBluetoothHFPStatusRequestMsg) const;

      /******************************************************************************************************
       ** FUNCTION:  spi_tclBDCLBluetoothDispatcher::vHandleBluetoothMsg(BDCLBluetoothIdentifyResultIndMsg* )
       *******************************************************************************************************/
      /*!
       * \fn      vHandleBluetoothMsg(BDCLBluetoothIdentifyResultIndMsg* poBDCLBluetoothIdentifyResultIndMsg)
       * \brief   Handles Messages of BDCLBluetoothIdentifyResultIndMsg type
       * \param   poBDCLBluetoothIdentifyResultIndMsg : pointer to BDCLBluetoothIdentifyResultIndMsg.
       ******************************************************************************************************/
      t_Void vHandleBluetoothMsg(BDCLBluetoothIdentifyResultIndMsg* poBDCLBluetoothIdentifyResultIndMsg) const;

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLBluetoothDispatcher(const spi_tclBDCLBluetoothDispatcher...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLBluetoothDispatcher(
       *                             const spi_tclBDCLBluetoothDispatcher& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLBluetoothDispatcher()
       ***************************************************************************/
      spi_tclBDCLBluetoothDispatcher(const spi_tclBDCLBluetoothDispatcher& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLBluetoothDispatcher& operator=( const spi_tclBDCL...
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLBluetoothDispatcher& operator=(
       *                          const spi_tclBDCLBluetoothDispatcher& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclBDCLBluetoothDispatcher(const spi_tclBDCLBluetoothDispatcher& corfoSrc)
       ***************************************************************************/
      spi_tclBDCLBluetoothDispatcher& operator=(const spi_tclBDCLBluetoothDispatcher& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/
};


#endif /* SPI_TCLBDCLNAVIGATIONDISPATCHER_H_ */

///////////////////////////////////////////////////////////////////////////////
// <EOF>
