/***********************************************************************/
/*!
* \file   BDCL_WrapperTypes.h
* \brief  to define the types required for Baidu Carlfe wrapper
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/


#ifndef _BDCLWRAPPERTYPES_H_
#define _BDCLWRAPPERTYPES_H_

#include <bdcl/CommonUtil.h>
#include <bdcl/bdclErrorCodes.h>

#include "BaseTypes.h"

typedef adit::bdcl::bdclInitStatus           tBdclInitStatus;
typedef adit::bdcl::bdclErrorCodes           tBdclErrorCodes;
typedef adit::bdcl::carlifeConnectException  tBdclConnectException;

struct trBdclSessionCbs
{
   t_Void (*fvOnMDInfo)(S_MD_INFO* prInfo);
   t_Void (*fvOnModuleStatus)(S_MODULE_STATUS_LIST_MOBILE* prModuleStatusList);
   t_Void (*fvOnExit)();
   t_Void (*fvOnFeatureConfigRequest)();

   trBdclSessionCbs():fvOnMDInfo(NULL), fvOnModuleStatus(NULL), fvOnExit(NULL),fvOnFeatureConfigRequest(NULL)
   {
   }
};

struct trBdclBluetoothCbs
{
   t_Void (*fvOnBluetoothOOBInfo)(S_BT_OOB_INFO* prOOBInfo);
   t_Void (*fvOnBluetoothHFPRequest)(S_BT_HFP_REQUEST* prBTHFPRequestInfo);
   t_Void (*fvOnBluetoothStartAutoPairRequest)(S_BT_START_PAIR_REQ* prStartBTAutopairReqInfo);
   t_Void (*fvOnBluetoothHFPStatusRequest)(S_BT_HFP_STATUS_REQUEST* prBTHFPStatusReqInfo);
   t_Void (*fvOnBluetoothIdentifyResultInd)(S_BT_INDENTIFY_RESULT_IND* prBTIdentityResultIndInfo);

   trBdclBluetoothCbs():fvOnBluetoothOOBInfo(NULL), fvOnBluetoothHFPRequest(NULL),
            fvOnBluetoothStartAutoPairRequest(NULL), fvOnBluetoothHFPStatusRequest(NULL),
            fvOnBluetoothIdentifyResultInd(NULL)
   {
   }
};

struct trBdclCarDataCbs
{
   t_Void (*fvOnCarDataSubscribe)(S_VEHICLE_INFO_LIST* prSubscribeData);
   t_Void (*fvOnCarDataSubcribeStart)(S_VEHICLE_INFO_LIST* prSubscribeData);
   t_Void (*fvOnCarDataSubscribeStop)(S_VEHICLE_INFO_LIST* prSubscribeData);

   trBdclCarDataCbs():fvOnCarDataSubscribe(NULL), fvOnCarDataSubcribeStart(NULL),
            fvOnCarDataSubscribeStop(NULL)
   {
   }
};

struct trBdclVideoCbs
{
   t_Void (*fvOnHeartBeat)();
   t_Void (*fvOnForeground)();
   t_Void (*fvOnBackground)();
   t_Void (*fvOnGotoForeground)();
   //TODO - remove below callbacks if unused
   t_Void (*fvOnScreenOn)();
   t_Void (*fvOnScreenOff)();
   t_Void (*fvOnScreenUserPresent)();
   t_Void (*fvOnGotoDeskTop)();

   trBdclVideoCbs():fvOnHeartBeat(NULL), fvOnForeground(NULL),
            fvOnBackground(NULL), fvOnGotoForeground(NULL),
            fvOnScreenOn(NULL), fvOnScreenOff(NULL),
            fvOnScreenUserPresent(NULL), fvOnGotoDeskTop(NULL)
   {
   }
};

struct trBdclMediaDataCbs
{
   t_Void (*fvOnMediaInfo)(S_MEDIA_INFO* prMediaInfo);
   t_Void (*fvOnProgressBarInfo)(S_MEDIA_PROGRESS_BAR* prInfo);

   trBdclMediaDataCbs():fvOnMediaInfo(NULL), fvOnProgressBarInfo(NULL)
   {
   }
};

struct trBdclNavigationCbs
{
   t_Void (*fvOnCarlifeSubscriptionDone)(S_SUBSCRIBE_MOBILE_CARLIFE_INFO_LIST *prSubscribeInfoList);
   t_Void (*fvOnNaviNextTurnInfo)(S_NAVI_NEXT_TURN_INFO *prNextTurnInfo);
   t_Void (*fvOnNaviAssitantGuideInfo)(S_NAVI_ASSITANT_GUIDE_INFO *prAssistantGuideInfo);

   trBdclNavigationCbs():fvOnCarlifeSubscriptionDone(NULL),
            fvOnNaviNextTurnInfo(NULL), fvOnNaviAssitantGuideInfo(NULL)
   {
   }
};

struct trBdclVoiceRecognitionCbs
{
   t_Void (*fvOnVRModuleStatus)(S_VR_STATUS_LIST* prStatus);
   
   trBdclVoiceRecognitionCbs():fvOnVRModuleStatus(NULL)
   {
   }
};

#endif
//ifndef
