/***********************************************************************/
/*!
* \file  spi_tclBDCLAudioDispatcher.cpp
* \brief Message Dispatcher for Audio Messages
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Audio Messages
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
24.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/

#include "RespRegister.h"
#include "spi_tclBDCLAudioDispatcher.h"
#include "spi_tclBDCLRespAudio.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclBDCLAudioDispatcher.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleAudioMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  BDCLAudioMsgBase::BDCLAudioMsgBase
 ***************************************************************************/
BDCLAudioMsgBase::BDCLAudioMsgBase()
{
   ETG_TRACE_USR1(("BDCLAudioMsgBase::BDCLAudioMsgBase Entered "));
   vSetServiceID (e32MODULEID_BDCLAUDIO);
}

/***************************************************************************
 ** FUNCTION:  BDCLAudioRequestMsg::BDCLAudioRequestMsg
 ***************************************************************************/
BDCLAudioRequestMsg::BDCLAudioRequestMsg()
{
   ETG_TRACE_USR1(("BDCLAudioRequestMsg::BDCLAudioRequestMsg Entered"));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLAudioRequestMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLAudioRequestMsg, spi_tclBDCLAudioDispatcher);

/***************************************************************************
 ** FUNCTION:  BDCLVRModuleStatusMsg::BDCLVRModuleStatusMsg
 ***************************************************************************/
BDCLVRModuleStatusMsg::BDCLVRModuleStatusMsg() : m_enVRState(e8CL_VR_STATUS_NOT_SUPPORT)
{
   ETG_TRACE_USR1(("BDCLVRModuleStatusMsg::BDCLVRModuleStatusMsg Entered"));
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  BDCLVRModuleStatusMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(BDCLVRModuleStatusMsg, spi_tclBDCLAudioDispatcher);

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLAudioDispatcher::spi_tclBDCLAudioDispatcher
 ***************************************************************************/
spi_tclBDCLAudioDispatcher::spi_tclBDCLAudioDispatcher()
{
   ETG_TRACE_USR1(("spi_tclBDCLAudioDispatcher::spi_tclBDCLAudioDispatcher Entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLAudioDispatcher::~spi_tclBDCLAudioDispatcher
 ***************************************************************************/
spi_tclBDCLAudioDispatcher::~spi_tclBDCLAudioDispatcher()
{
   ETG_TRACE_USR1(("spi_tclBDCLAudioDispatcher::~spi_tclBDCLAudioDispatcher Entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLAudioDispatcher::vHandleAudioMsg(BDCLAudioRequestMsg* poMsg)
 ***************************************************************************/
t_Void spi_tclBDCLAudioDispatcher::vHandleAudioMsg(BDCLAudioRequestMsg* poMsg) const
{
   if (NULL != poMsg)
   {
      ETG_TRACE_USR1(("spi_tclBDCLAudioDispatcher::vHandleAudioMsg:AudioRequest entered for %d ",
               ETG_ENUM(BDCL_AUD_REQUEST, (poMsg->m_rAudioRequest).enAudRequest)));
      CALL_REG_OBJECTS(spi_tclBDCLRespAudio,
               e16BDCL_AUDIO_REGID,
               vOnAudioRequest(poMsg->m_rAudioRequest));
   }
}

/***************************************************************************
 ** FUNCTION:  spi_tclBDCLAudioDispatcher::vHandleAudioMsg(BDCLVRModuleStatusMsg* poMsg)
 ***************************************************************************/
t_Void spi_tclBDCLAudioDispatcher::vHandleAudioMsg(BDCLVRModuleStatusMsg* poMsg) const
{
   ETG_TRACE_USR1(("spi_tclBDCLAudioDispatcher::vHandleAudioMsg:VRModuleStatus entered"));
   if (NULL != poMsg)
   {
      CALL_REG_OBJECTS(spi_tclBDCLRespAudio,
               e16BDCL_AUDIO_REGID,
               vOnVRModuleStatus(poMsg->m_enVRState));
   }
}


///////////////////////////////////////////////////////////////////////////////
// <EOF>
