/***********************************************************************/
/*!
* \file  spi_tclBDCLRespAudio.h
* \brief BDCL Audio Output Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    BDCL Audio Output Interface
AUTHOR:         rur1kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
24.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLBDCLRESPAUDIO_H_
#define _SPI_TCLBDCLRESPAUDIO_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "BDCLTypes.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclBDCLRespAudio
* \brief BDCL Audio Output Interface
****************************************************************************/
class spi_tclBDCLRespAudio:public RespBase
{

   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespAudio::spi_tclBDCLRespAudio()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespAudio()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLRespAudio()
       **************************************************************************/
      spi_tclBDCLRespAudio() :
         RespBase(e16BDCL_AUDIO_REGID)
      {
      }

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespAudio::~spi_tclBDCLRespAudio()
       ***************************************************************************/
      /*!
       * \fn      virtual ~spi_tclBDCLRespAudio()
       * \brief   Destructor
       * \sa      spi_tclBDCLRespAudio(RegID enRegId)
       **************************************************************************/
      virtual ~spi_tclBDCLRespAudio()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespAudio::vOnAudioRequest(...)
       ***************************************************************************/
      /*!
       * \fn      vOnAudioRequest
       * \brief   Triggered when BDCL device starts audio streaming
       * \param   crfrAudioRequest: [IN] Structure containing audio request info
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnAudioRequest(const trBdclAudioRequest& crfrAudioRequest)
      {

      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclBDCLRespAudio::vOnVRModuleStatus(...)
       ***************************************************************************/
      /*!
       * \fn      vOnVRModuleStatus
       * \brief   Triggered when MD VR state changes
       * \param   enVRModuleState: [IN] VR state enumeration
       * \retval  t_Void
       **************************************************************************/
      virtual t_Void vOnVRModuleStatus(tenBdclVRState enVRModuleState)
      {

      }

      /***************************************************************************
       ****************************END OF PUBLIC***********************************
       ***************************************************************************/

   protected:

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespAudio::spi_tclBDCLRespAudio()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespAudio(const spi_tclBDCLRespAudio& corfoSrc))
       * \brief   Parameterized Constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \sa      spi_tclBDCLRespAudio(RegID enRegId)
       **************************************************************************/
      spi_tclBDCLRespAudio(const spi_tclBDCLRespAudio& corfoSrc);

      /***************************************************************************
       ** FUNCTION:  spi_tclBDCLRespAudio& operator=()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLRespAudio& operator=(const spi_tclBDCLRespAudio& corfoSrc)
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \sa      spi_tclBDCLRespAudio(const spi_tclBDCLRespAudio& otrSrc)
       ***************************************************************************/
      spi_tclBDCLRespAudio& operator=(const spi_tclBDCLRespAudio& corfoSrc);

      /***************************************************************************
       ****************************END OF PROTECTED********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *********************************PRIVATE************************************
       ***************************************************************************/

      /***************************************************************************
       ****************************END OF PRIVATE *********************************
       ***************************************************************************/


}; //class spi_tclBDCLRespVideo

#endif /* _SPI_TCLBDCLRESPAUDIO_H_ */

///////////////////////////////////////////////////////////////////////////////
// <EOF>
