/***********************************************************************/
/*!
* \file  spi_tclBDCLAudioSourceAdapt.h
* \brief  Implementation of the Class spi_tclBDCLAudioSourceAdapt
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         pok6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
21.04.2017  | Ramya Murthy          | Initial Version

\endverbatim
*************************************************************************/
#ifndef SPI_TCLBDCLAUDIOSOURCEADAPT_
#define SPI_TCLBDCLAUDIOSOURCEADAPT_

#include <bdcl/AilAudioSource.h>

#include "BaseTypes.h"
#include "BDCLTypes.h"
#include "BDCL_WrapperTypes.h"
#include "Lock.h"
#include "spi_tclAudioSettingsIntf.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
typedef std::unique_ptr< adit::bdcl::AditAudioSource >  tSptrAditAudioSource;

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

class spi_tclBDCLAudioSourceAdapt : public adit::bdcl::IAditAudioSourceCallbacks
{

public:
      /***************************************************************************
       ** FUNCTION:   spi_tclBDCLAudioSourceAdapt()
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLAudioSourceAdapt()
       * \brief   Constructor
       * \sa      ~spi_tclBDCLAudioSourceAdapt()
       **************************************************************************/
      spi_tclBDCLAudioSourceAdapt();

      /***************************************************************************
       ** FUNCTION:  ~spi_tclBDCLAudioSourceAdapt()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclBDCLAudioSourceAdapt()
       * \brief   Destructor
       * \sa      spi_tclBDCLAudioSourceAdapt()
       **************************************************************************/
      ~spi_tclBDCLAudioSourceAdapt();

      /***************************************************************************
       ** FUNCTION:  t_Bool bInitialize()
       ***************************************************************************/
      /*!
       * \fn      bInitialize()
       * \brief   Initializes session by creating and registering Audio Source
       * \retval  true : initialized successfull.
       * \retval  false : Initialization failed
       * \param   crfszAudioPipeConfig: [IN] Audio device configuration
       * \sa      vUnintialize()
       **************************************************************************/
      t_Bool bInitialize(const t_String& crfszAudioPipeConfig);

      /***************************************************************************
       ** FUNCTION:  t_Void vUninitialize()
       ***************************************************************************/
      /*!
       * \fn      vUninitialize()
       * \brief   Uninitializes session
       * \sa      bInitialize()
       **************************************************************************/
      t_Void vUninitialize();

      /***************************************************************************
       ** FUNCTION:  t_Bool bMicrophoneRequestCompleted( )
       ***************************************************************************/
      /*!
       * \fn      t_Bool bMicrophoneRequestCompleted()
       * \brief   Function to open/close microphone.
       * \retval  true  : bMicrophoneRequestCompleted returns SUCCESS
       * \retval  false : bMicrophoneRequestCompleted returns FAILURE
       * \sa      None
       **************************************************************************/
      t_Bool bMicrophoneRequestCompleted(t_Bool bMicOpen);

      /***************************************************************************
       ** FUNCTION:  t_Void vSetAudioSettingsInstance (spi_tclAudioSettingsIntf* poAudioSettingsIntf)
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetAudioSettingsInstance()
       * \brief   Function to set Audio settings pointer.
       * \param   poAudioSettingsIntf: [IN] Audio settings pointer
       * \sa      None
       **************************************************************************/

      t_Void vSetAudioSettingsInstance (spi_tclAudioSettingsIntf* poAudioSettingsIntf);

private:

      /***************************************************************************
       ** FUNCTION: spi_tclBDCLAudioSourceAdapt(const spi_tclBDCLAudioSourceAdapt&)
       ***************************************************************************/
      /*!
       * \fn      spi_tclBDCLAudioSourceAdapt(const spi_tclBDCLAudioSourceAdapt&)
       * \brief   Copy constructor not implemented
       **************************************************************************/
      spi_tclBDCLAudioSourceAdapt(const spi_tclBDCLAudioSourceAdapt&);

      /***************************************************************************
       ** FUNCTION: const spi_tclBDCLAudioSourceAdapt & operator=(const spi_tclBDCLAudioSourceAdapt&);
       ***************************************************************************/
      /*!
       * \fn      const spi_tclBDCLAudioSourceAdapt & operator=(const spi_tclBDCLAudioSourceAdapt&);
       * \brief   assignment operator not implemented
       **************************************************************************/
      const spi_tclBDCLAudioSourceAdapt & operator=(const spi_tclBDCLAudioSourceAdapt&);

      /***************************************************************************
       ** FUNCTION:  void onMicRecordWakeupStart()
       ***************************************************************************/
      /*!
       * \fn      onMicRecordWakeupStart()
       * \brief   Callback to receive Mic Wakeup msg from MD
       **************************************************************************/
      virtual void onMicRecordWakeupStart();

      /***************************************************************************
       ** FUNCTION:  void onMicRecordRecognitionStart()
       ***************************************************************************/
      /*!
       * \fn      onMicRecordRecognitionStart()
       * \brief   Callback to receive Mic open msg from MD
       **************************************************************************/
      virtual void onMicRecordRecognitionStart();

      /***************************************************************************
       ** FUNCTION:  void onMicRecordEnd()
       ***************************************************************************/
      /*!
       * \fn      onMicRecordEnd()
       * \brief   Callback to receive Mic close msg from MD
       **************************************************************************/
      virtual void onMicRecordEnd();

      /***************************************************************************
       ** FUNCTION:  void onError()
       ***************************************************************************/
      /*!
       * \fn      onError()
       * \brief   Callback to receive Mic record errors
       **************************************************************************/
      virtual void onError(tBdclErrorCodes inErrorCode);

      /***************************************************************************
       ** FUNCTION:  t_Void vSetAudioStreamConfig( )
       ***************************************************************************/
      /*!
       * \fn      t_Void vSetAudioStreamConfig()
       * \brief   Function to set the Audio configuration for specific streams.
       * \param   crfszAudioPipeConfig: [IN] Audio device configuration
       **************************************************************************/
      t_Void vSetAudioStreamConfig(const t_String& crfszAudioPipeConfig);

      /***************************************************************************
       ** FUNCTION:  void vOnVRModuleStatusCb()
       ***************************************************************************/
      /*!
       * \fn      t_Void vOnVRModuleStatusCb()
       * \brief   Callback handler for VR Module Status message
       * \param   prModuleStatusList: [IN] Structure containing VR module status
       *             information of BDCL device
       **************************************************************************/
      static t_Void vOnVRModuleStatusCb(S_VR_STATUS_LIST* prModuleStatusList);

      //! Pointer to an Audio sink object
      tSptrAditAudioSource m_spoAudioSource;

      //! Lock object for Audio Endpoint
      Lock  m_oAudSourceLock;

      t_Bool m_bIsMicOpened;
	  
      //!pointer for Audio Settings interface class
      spi_tclAudioSettingsIntf* m_poAudioSettings;

};
#endif //SPI_TCLBDCLAUDIOSOURCEADAPT_
