/***********************************************************************/
/*!
 * \file  spi_tclAAPAppMngr.cpp
 * \brief AAP App Mngr Implementation
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    AAP App Mngr Implementation
 AUTHOR:         Shiva Kumar Gurija
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                        | Modification
 20.03.2015  | Shiva Kumar Gurija            | Initial Version
 26.05.2015  | Tejaswini H B                 | Added Lint comments to suppress C++11 Errors
 26.02.2016  | Rachana L Achar               | AAP Navigation implementation
 10.03.2016  | Rachana L Achar               | AAP Notification implementation

 \endverbatim
 *************************************************************************/

/******************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |----------------------------------------------------------------------------*/

//#include "spi_tclAAPcmdMediaPlayback.h"
#include "spi_tclAAPManager.h"
#include "spi_tclAppMngrDefines.h"
#include "spi_tclAAPAppMngr.h"

#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_APPMNGR
#include "trcGenProj/Header/spi_tclAAPAppMngr.cpp.trc.h"
#endif
#endif

/******************************************************************************
 | defines and macros and constants(scope: module-local)
 |----------------------------------------------------------------------------*/
static const t_U32 scou32UnknownDevId = 0;

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
/***************************************************************************
 ** FUNCTION:  spi_tclDiPoAppMngr::spi_tclDiPoAppMngr()
 ***************************************************************************/
spi_tclAAPAppMngr::spi_tclAAPAppMngr() :
         m_poAAPManager(NULL), m_u32SelectedDevId(scou32UnknownDevId)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::spi_tclAAPAppMngr()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclAAPAppMngr::~spi_tclAAPAppMngr()
 ***************************************************************************/
spi_tclAAPAppMngr::~spi_tclAAPAppMngr()
{
   ETG_TRACE_USR1((" spi_tclAAPAppMngr::~spi_tclAAPAppMngr()"));
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclAAPAppMngr::bInitialize()
 ***************************************************************************/
t_Bool spi_tclAAPAppMngr::bInitialize()
{
   ETG_TRACE_USR1((" spi_tclAAPAppMngr::bInitialize() "));

   t_Bool bInitSuccess = false;
   spi_tclAAPManager* poAAPManager = spi_tclAAPManager::getInstance();

   if ((NULL != poAAPManager) && (true == poAAPManager->bRegisterObject((spi_tclAAPRespNavigation*) this))
            && (true == poAAPManager->bRegisterObject((spi_tclAAPRespNotification*) this))
            && (true == poAAPManager->bRegisterObject((spi_tclAAPRespMediaPlayback*) this))
            && (true == poAAPManager->bRegisterObject((spi_tclAAPRespVendorExtsn*) this)))
   {
      bInitSuccess = true;
   } // if (NULL != poAAPManager)

   ETG_TRACE_USR2(("bInitialise() left with result = %u", bInitSuccess));
   return bInitSuccess;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclAAPAppMngr::vUnInitialize()
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vUnInitialize()
{
   ETG_TRACE_USR1(("spi_tclAAPDataService::bUninitialise() entered"));

   t_Bool bUnInitSuccess = false;
   spi_tclAAPManager* poAAPManager = spi_tclAAPManager::getInstance();

   if ((NULL != poAAPManager) && (poAAPManager->bUnRegisterObject((spi_tclAAPRespNavigation*) this))
            && (poAAPManager->bUnRegisterObject((spi_tclAAPRespNotification*) this))
            && (poAAPManager->bUnRegisterObject((spi_tclAAPRespMediaPlayback*) this))
            && (poAAPManager->bUnRegisterObject((spi_tclAAPRespVendorExtsn*) this)))
   {
      bUnInitSuccess = true;
   }

   ETG_TRACE_USR2(("vUnInitialize() left with result = %u", bUnInitSuccess));
}
/***************************************************************************
 ** FUNCTION:  t_Void  spi_tclAAPAppMngr::vRegisterAppMngrCallbacks()
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vRegisterAppMngrCallbacks(const trAppMngrCallbacks& corfrAppMngrCbs)
{
   //Add code
   m_rAppMngrCallbacks = corfrAppMngrCbs;
}

/***************************************************************************
 ** FUNCTION:  t_Void  spi_tclAAPAppMngr::vInitializeAppMngrEndpoints()
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vInitializeAppMngrEndpoints()
{
   ETG_TRACE_USR2(("[DESC]:spi_tclAAPAppMngr::vInitializeAppMngrEndpoints entered"));
   spi_tclAAPManager* poAAPManager = spi_tclAAPManager::getInstance();

   if(NULL != poAAPManager)
   {
      //! Initialise Navigation Endpoint
      spi_tclAAPCmdNavigation* poCmdNavigation = poAAPManager->poGetNavigationInstance();
      if (((m_bAAPConfigData.bAAPNavigationEnable == true) ||
      (m_bAAPConfigData.bTBTUpdateEnabled == true)) && (NULL != poCmdNavigation))
      {
         poCmdNavigation->bInitializeNavigationStatus();
      }

      //! Initialise MediaPlayback Endpoint
      spi_tclAAPCmdMediaPlayback* poAAPCmdMediaPlayback = poAAPManager->poGetMediaPlaybackInstance();
      if((m_bAAPConfigData.bAAPMediaPlaybackEnable == true) && (NULL != poAAPCmdMediaPlayback))
      {
         poAAPCmdMediaPlayback->bInitializeMediaPlayback();
      }

      //! Initialise Notification Endpoint
      spi_tclAAPCmdNotification* poCmdNotification = poAAPManager->poGetNotificationInstance();
      if ((m_bAAPConfigData.bAAPNotificationEnable == true) && (NULL != poCmdNotification))
      {
         poCmdNotification->bInitializeNotification();
      }

   }
}

/***************************************************************************
 ** FUNCTION:  t_Void  spi_tclAAPAppMngr::vInitializeAppMngrEndpoints()
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vUninitializeAppMngrEndpoints()
{
   ETG_TRACE_USR2(("[DESC]:spi_tclAAPAppMngr::vUninitializeAppMngrEndpoints entered"));
   spi_tclAAPManager* poAAPManager = spi_tclAAPManager::getInstance();

   if(NULL != poAAPManager)
   {
      //! UnInitialise Navigation Endpoint
      spi_tclAAPCmdNavigation* poCmdNavigation = poAAPManager->poGetNavigationInstance();
      if (((m_bAAPConfigData.bAAPNavigationEnable == true) ||
      (m_bAAPConfigData.bTBTUpdateEnabled == true)) && (NULL != poCmdNavigation))
      {
         poCmdNavigation->vUninitializeNavigationStatus();
      }

      //! UnInitialise MediaPlayback Endpoint
      spi_tclAAPCmdMediaPlayback* poAAPCmdMediaPlayback = poAAPManager->poGetMediaPlaybackInstance();
      if((m_bAAPConfigData.bAAPMediaPlaybackEnable == true) && (NULL != poAAPCmdMediaPlayback))
      {
         poAAPCmdMediaPlayback->vUninitialiseMediaPlayback();
      }

      //! UnInitialise Notification Endpoint
      spi_tclAAPCmdNotification* poCmdNotification = poAAPManager->poGetNotificationInstance();
      if ((m_bAAPConfigData.bAAPNotificationEnable == true) && (NULL != poCmdNotification))
      {
         poCmdNotification->vUninitializeNotification();
      }

   }
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclAAPAppMngr::vSelectDevice()
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vSelectDevice(const trSelectDeviceRequest& corfrSelectReq)
{

   /*lint -esym(40,fpvSelectDeviceResult)fpvSelectDeviceResult Undeclared identifier */
   ETG_TRACE_USR2(("[DESC]:spi_tclAAPAppMngr::vSelectDevice entered :Device id - 0x%x", corfrSelectReq.m_u32DeviceHandle));

   if (e8DEVCONNREQ_SELECT == corfrSelectReq.m_enDevConnReq)
   {
      m_u32SelectedDevId = corfrSelectReq.m_u32DeviceHandle;
      vInitializeAppMngrEndpoints();
   }
   else
   {
      m_u32SelectedDevId = 0;
      vUninitializeAppMngrEndpoints();
   }

   if (NULL != m_rAppMngrCallbacks.fpvSelectDeviceResult)
   {
      (m_rAppMngrCallbacks.fpvSelectDeviceResult)(true);
   }//if(NULL != m_rAppMngrCallbacks.fpvSelectDeviceResult)
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclAAPAppMngr::vOnSelectDeviceResult()
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vOnSelectDeviceResult(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq,
const tenResponseCode coenRespCode)
{
   ETG_TRACE_USR1(("spi_tclAAPBluetooth::vOnSPISelectDeviceResponse() entered "));
   SPI_INTENTIONALLY_UNUSED(coenConnReq);
   SPI_INTENTIONALLY_UNUSED(cou32DevId);
   if (e8FAILURE == coenRespCode)
   {
      vUninitializeAppMngrEndpoints();
   }
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclAAPAppMngr::bLaunchApp()
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vLaunchApp(const t_U32 cou32DevId,
	      t_U32 u32AppId,
	      const trUserContext& rfrcUsrCntxt,
	      tenDiPOAppType enDiPOAppType,
	      t_String szTelephoneNumber,
	      tenEcnrSetting enEcnrSetting)
{
   /*lint -esym(40,fpvLaunchAppResult)fpvLaunchAppResult Undeclared identifier */
   ETG_TRACE_USR1((" spi_tclAAPAppMngr::vLaunchApp:Dev-0x%x App-0x%x,Apptype: %d", cou32DevId, u32AppId, ETG_ENUM(DIPO_APP_TYPE,
            enDiPOAppType)));

   SPI_INTENTIONALLY_UNUSED(enEcnrSetting);
   SPI_INTENTIONALLY_UNUSED(szTelephoneNumber);

   spi_tclAAPManager* poAAPManager = spi_tclAAPManager::getInstance();
   spi_tclAAPCmdInputIntf* poAAPCmdInputInstance =
            (NULL != poAAPManager) ? (poAAPManager->poGetInputInstance()) : (NULL);

   if (NULL != poAAPCmdInputInstance)
   {
      switch (enDiPOAppType)
      {
         case e8DIPO_NOT_USED:
         case e8DIPO_NO_URL:
         {
            // Just ask for video focus.
            ETG_TRACE_USR1((" spi_tclAAPAppMngr::vLaunchApp:NO URL"));
         }
            break;
         case e8DIPO_MAPS:
         {
            //Send Key code for Navigation
            poAAPCmdInputInstance->vReportkey(cou32DevId, e8KEY_PRESS, e32DEV_NAV);
            poAAPCmdInputInstance->vReportkey(cou32DevId, e8KEY_RELEASE, e32DEV_NAV);
         }
            break;
         case e8DIPO_MOBILEPHONE:
         {
            // Send Key event for Telephony
            poAAPCmdInputInstance->vReportkey(cou32DevId, e8KEY_PRESS, e32APP_KEYCODE_TELEPHONY);
            poAAPCmdInputInstance->vReportkey(cou32DevId, e8KEY_RELEASE, e32APP_KEYCODE_TELEPHONY);
         }
            break;
         case e8DIPO_MUSIC:
         {
            //Send Key event for Music
            poAAPCmdInputInstance->vReportkey(cou32DevId, e8KEY_PRESS, e32DEV_MEDIA);
            poAAPCmdInputInstance->vReportkey(cou32DevId, e8KEY_RELEASE, e32DEV_MEDIA);
         }
            break;
         case e8DIPO_SIRI_BUTTONUP:
         {
            //Send Key event for Voice rec button down
            poAAPCmdInputInstance->vReportkey(cou32DevId, e8KEY_RELEASE, e32DEV_SEARCH);
         }
            break;
         case e8DIPO_SIRI_BUTTONDOWN:
         {
            //Send Key event for voice rec button up
            poAAPCmdInputInstance->vReportkey(cou32DevId, e8KEY_PRESS, e32DEV_SEARCH);
         }
            break;
         default:
         {
            // Unsupported Application Type
            ETG_TRACE_USR1((" spi_tclAAPAppMngr::vLaunchApp:Unsupported"));
         }
            break;
      } //switch (enDiPOAppType)
   } //if (NULL != poAAPCmdInputInstance)

   if (NULL != m_rAppMngrCallbacks.fpvLaunchAppResult)
   {
      (m_rAppMngrCallbacks.fpvLaunchAppResult)(cou32DevId, u32AppId, enDiPOAppType, e8NO_ERRORS, rfrcUsrCntxt);
   } //if( NULL != m_rAppMngrCallbacks.fpvLaunchAppResult)
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclAAPAppMngr::vTerminateApp()
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vTerminateApp(const t_U32 cou32DevId, const t_U32 cou32AppId,
         const trUserContext& rfrcUsrCntxt)
{
   /*lint -esym(40,fpvTerminateAppResult) fpvTerminateAppResult is not referenced */
   ETG_TRACE_USR1((" spi_tclAAPAppMngr::vTerminateApp:Dev-0x%x App-0%x", cou32DevId, cou32AppId));

   //Post the success as a Result to tcl App Mngr
   if (NULL != m_rAppMngrCallbacks.fpvTerminateAppResult)
   {
      (m_rAppMngrCallbacks.fpvTerminateAppResult)(cou32DevId, cou32AppId, e8NO_ERRORS, rfrcUsrCntxt);
   } //if( NULL != m_rAppMngrCallbacks.fpvTerminateAppResult )
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclAAPAppMngr::vGetAppIconData()
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vGetAppIconData(t_String szAppIconUrl, const trUserContext& rfrcUsrCntxt)
{
   /*lint -esym(40,fpvCbAppIconDataResult) fpvCbAppIconDataResult is not referenced */
   SPI_INTENTIONALLY_UNUSED(szAppIconUrl);
   //Post response to HMI
   if (NULL != m_rAppMngrCallbacks.fpvCbAppIconDataResult)
   {
      (m_rAppMngrCallbacks.fpvCbAppIconDataResult)(e8ICON_INVALID, NULL, 0, rfrcUsrCntxt);
   } //if( NULL != m_rAppMngrCallbacks.fpvCbAppIconDataResult)
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclAAPAppMngr::bCheckAppValidity()
 ***************************************************************************/
t_Bool spi_tclAAPAppMngr::bCheckAppValidity(const t_U32 cou32DevId, const t_U32 cou32AppId)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::bCheckAppValidity"));
   SPI_INTENTIONALLY_UNUSED(cou32DevId);
   SPI_INTENTIONALLY_UNUSED(cou32AppId);
   return true;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclAAPAppMngr::vSetVehicleConfig();
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vSetVehicleConfig(tenVehicleConfiguration enVehicleConfig, t_Bool bSetConfig)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr:vSetVehicleConfig()-%d bSetConfig-%d \n", enVehicleConfig, ETG_ENUM(BOOL,
            bSetConfig)));
   SPI_INTENTIONALLY_UNUSED(bSetConfig);
   SPI_INTENTIONALLY_UNUSED(enVehicleConfig);
}

/***********************************************************************************************************************
 ** FUNCTION:  spi_tclAAPAppMngr::vNavigationStatusCallback(..)
 ************************************************************************************************************************/
t_Void spi_tclAAPAppMngr::vNavigationStatusCallback(tenNavAppState enNavAppState)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::vNavigationStatusCallback entered"));
   ETG_TRACE_USR2(("[DESC]:vNavigationStatusCallback: DeviceHandle = 0x%x,Device Category = %d,Navigation Status = %d", m_u32SelectedDevId, ETG_ENUM(DEVICE_CATEGORY,
            e8DEV_TYPE_ANDROIDAUTO), ETG_ENUM(NAVIGATION_STATUS, enNavAppState)));
   if ((NULL != m_rAppMngrCallbacks.fvUpdateNavStatusData) && (0 != m_u32SelectedDevId))
   {
      trNavStatusData rNavStatusData;
      rNavStatusData.u32DeviceHandle = m_u32SelectedDevId;
      rNavStatusData.enDeviceCategory = e8DEV_TYPE_ANDROIDAUTO;
      rNavStatusData.enNavAppState = enNavAppState;
      (m_rAppMngrCallbacks.fvUpdateNavStatusData)(rNavStatusData);
   }
   if ((NULL != m_rAppMngrCallbacks.fvUpdateTurnByTurnInfo) && (0 != m_u32SelectedDevId))
   {
      //@TODO: Please remove the above code once TBT update is adopted by HMI.
      trTurnByTurnInfo rTurnByTurnInfo;
      rTurnByTurnInfo.enDeviceCategory = e8DEV_TYPE_ANDROIDAUTO;
      rTurnByTurnInfo.u32DeviceHandle = m_u32SelectedDevId;
      rTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationNextTurnDataValid = false;
      rTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationNextTurnDistanceDataValid = false;
      rTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationStatusValid = true;
      rTurnByTurnInfo.rAAutoTBTUpdate.enAAutoNavigationStatus = static_cast<tenAAutoNavigationAppState>(enNavAppState);
      m_rAppMngrCallbacks.fvUpdateTurnByTurnInfo(rTurnByTurnInfo);
   }
}

/******************************************************************************************************************************
 ** FUNCTION:  spi_tclAAPAppMngr::vNavigationNextTurnCallback(..)
 ********************************************************************************************************************************/
t_Void spi_tclAAPAppMngr::vNavigationNextTurnCallback(t_String szRoadName, tenAAPNavNextTurnSide enAAPNavNextTurnSide,
         tenAAPNavNextTurnType enAAPNavNextTurnType, t_String szImage, t_S32 s32TurnAngle, t_S32 s32TurnNumber)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::vNavigationNextTurnCallback entered"));
   ETG_TRACE_USR2(("[DESC]:vNavigationNextTurnCallback: DeviceHandle = 0x%x,Device Category = %d,Road Name = %s", m_u32SelectedDevId, ETG_ENUM(DEVICE_CATEGORY,
            e8DEV_TYPE_ANDROIDAUTO), szRoadName.c_str()));
   ETG_TRACE_USR2(("[DESC]:vNavigationNextTurnCallback: Next Turn side = %d,Next Turn Event = %d,Turn Angle =%d,"
            "Turn Number = %d,Image = %s", ETG_ENUM(NEXTTURN_SIDE, enAAPNavNextTurnSide), ETG_ENUM(NEXTTURN_EVENT,
            enAAPNavNextTurnType), s32TurnAngle, s32TurnNumber, szImage.c_str()));

   if ((NULL != m_rAppMngrCallbacks.fvUpdateNavNextTurnData) && (0 != m_u32SelectedDevId))
   {
      trNavNextTurnData rNavNextTurnData;
      rNavNextTurnData.u32DeviceHandle = m_u32SelectedDevId;
      rNavNextTurnData.enDeviceCategory = e8DEV_TYPE_ANDROIDAUTO;
      rNavNextTurnData.szRoadName = szRoadName;
      rNavNextTurnData.enAAPNavNextTurnSide = enAAPNavNextTurnSide;
      rNavNextTurnData.enAAPNavNextTurnType = enAAPNavNextTurnType;
      rNavNextTurnData.szImage = szImage;
      rNavNextTurnData.s32TurnAngle = s32TurnAngle;
      rNavNextTurnData.s32TurnNumber = s32TurnNumber;
      (m_rAppMngrCallbacks.fvUpdateNavNextTurnData)(rNavNextTurnData);
   }
   if ((NULL != m_rAppMngrCallbacks.fvUpdateTurnByTurnInfo) && (0 != m_u32SelectedDevId))
   {
      //@TODO: Please remove the above code once TBT update is adopted by HMI.
      trTurnByTurnInfo rTurnByTurnInfo;
      rTurnByTurnInfo.enDeviceCategory = e8DEV_TYPE_ANDROIDAUTO;
      rTurnByTurnInfo.u32DeviceHandle = m_u32SelectedDevId;
      rTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationNextTurnDataValid = true;
      rTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationNextTurnDistanceDataValid = false;
      rTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationStatusValid = false;
      rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData.szRoadName = szRoadName;
      rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData.s32TurnAngle = s32TurnAngle;
      rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData.s32TurnNumber = s32TurnNumber;
      rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData.enTurnSide =
               static_cast<tenAAutoTurnSide>(enAAPNavNextTurnSide);
      rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData.enNextTurnEvent =
               static_cast<tenAAutoNextTurnEvent>(enAAPNavNextTurnType);

      if (0 < szImage.size() && szImage.size() < STR_ALBUMART_MAX_SIZE)
      {
         for (t_U32 u32Index = 0; u32Index < szImage.size(); ++u32Index)
         {
            rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData.u8Image.push_back(szImage[u32Index]);
         }
      }
      m_rAppMngrCallbacks.fvUpdateTurnByTurnInfo(rTurnByTurnInfo);
   }
}

/**********************************************************************************************************************************
 ** FUNCTION:  spi_tclAAPAppMngr::vMock_NavigationNextTurnCallback(..)
 ***********************************************************************************************************************************/
t_Void spi_tclAAPAppMngr::vMock_NavigationNextTurnCallback(tenAAutoTurnSide enAAPNavNextTurnSide,
         tenAAutoNextTurnEvent enAAPNavNextTurnType, t_S32 s32TurnAngle)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::vMock_NavigationNextTurnCallback entered"));
   if ((NULL != m_rAppMngrCallbacks.fvUpdateTurnByTurnInfo) && (0 != m_u32SelectedDevId))
   {
      trTurnByTurnInfo rTurnByTurnInfo;
      rTurnByTurnInfo.enDeviceCategory = e8DEV_TYPE_ANDROIDAUTO;
      rTurnByTurnInfo.u32DeviceHandle = m_u32SelectedDevId;
      rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData.enTurnSide =
               static_cast<tenAAutoTurnSide>(enAAPNavNextTurnSide);
      rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData.enNextTurnEvent =
               static_cast<tenAAutoNextTurnEvent>(enAAPNavNextTurnType);
      rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData.s32TurnAngle = s32TurnAngle;
      ETG_TRACE_USR4(("[PARAM]::vMock_NavigationNextTurnCallback u32DeviceHandle = %d, enDeviceCategory = %d, szRoadName = %s",
               rTurnByTurnInfo.u32DeviceHandle,rTurnByTurnInfo.enDeviceCategory , rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData.szRoadName.c_str()));
      ETG_TRACE_USR4(("[PARAM]::vMock_NavigationNextTurnCallback enAAPNavNextTurnSide = %d, enAAPNavNextTurnType = %d, s32TurnAngle = %d",
               rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData.enTurnSide,
               rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData.enNextTurnEvent,
               rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnData.s32TurnAngle));

      m_rAppMngrCallbacks.fvUpdateTurnByTurnInfo(rTurnByTurnInfo);
   }
}

/**********************************************************************************************************************************
 ** FUNCTION:  spi_tclAAPAppMngr::vSendNavigationNextTurnDistanceData(..)
 ***********************************************************************************************************************************/
t_Void spi_tclAAPAppMngr::vNavigationNextTurnDistanceCallback(t_S32 s32DistanceMeters, t_S32 s32TimeSeconds,
         t_S32 s32DisplayDistance, tenAAPNavNextTurnDistanceUnits enDistanceUnits)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::vNavigationNextTurnDistanceCallback entered"));
   ETG_TRACE_USR2(("[DESC]:vNavigationNextTurnDistanceCallback: DeviceHandle = 0x%x,Device Category = %d,Distance = %d, Time = %d", m_u32SelectedDevId, ETG_ENUM(DEVICE_CATEGORY,
            e8DEV_TYPE_ANDROIDAUTO), s32DistanceMeters, s32TimeSeconds));
   if ((NULL != m_rAppMngrCallbacks.fvUpdateNavNextTurnDistanceData) && (0 != m_u32SelectedDevId))
   {
      trNavNextTurnDistanceData rNavNextTurnDistanceData;
      rNavNextTurnDistanceData.u32DeviceHandle = m_u32SelectedDevId;
      rNavNextTurnDistanceData.enDeviceCategory = e8DEV_TYPE_ANDROIDAUTO;
      rNavNextTurnDistanceData.s32Distance = s32DistanceMeters;
      rNavNextTurnDistanceData.s32Time = s32TimeSeconds;
      (m_rAppMngrCallbacks.fvUpdateNavNextTurnDistanceData)(rNavNextTurnDistanceData);
   }
   if ((NULL != m_rAppMngrCallbacks.fvUpdateTurnByTurnInfo) && (0 != m_u32SelectedDevId))
   {
      //@TODO: Please remove the above code once TBT update is adopted by HMI.
      trTurnByTurnInfo rTurnByTurnInfo;
      rTurnByTurnInfo.enDeviceCategory = e8DEV_TYPE_ANDROIDAUTO;
      rTurnByTurnInfo.u32DeviceHandle = m_u32SelectedDevId;
      rTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationNextTurnDataValid = false;
      rTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationNextTurnDistanceDataValid = true;
      rTurnByTurnInfo.rAAutoTBTUpdate.isAAutoNavigationStatusValid = false;
      rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnDistanceData.s32DistanceInMeters = s32DistanceMeters;
      rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnDistanceData.s32TimeInSec = s32TimeSeconds;
      rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnDistanceData.s32DistanceToManeuver = s32DisplayDistance;
      rTurnByTurnInfo.rAAutoTBTUpdate.AAutoNavigationNextTurnDistanceData.enManeuverDistanceUnits =
               static_cast<tenTBTDistanceUnits>(enDistanceUnits);

      m_rAppMngrCallbacks.fvUpdateTurnByTurnInfo(rTurnByTurnInfo);
   }
}

/***********************************************************************************************************************
 ** FUNCTION:  spi_tclAAPAppMngr::vNotificationSubscriptionStatusCallback(..)
 ************************************************************************************************************************/
t_Void spi_tclAAPAppMngr::vNotificationSubscriptionStatusCallback(t_Bool bNotifSubscribed)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::vNotificationSubscriptionStatusCallback entered"));
   ETG_TRACE_USR2(("[DESC]:vNotificationSubscriptionStatusCallback: DeviceHandle = 0x%x,Device Category = %d,Subscription Status = %d", m_u32SelectedDevId, ETG_ENUM(DEVICE_CATEGORY,
            e8DEV_TYPE_ANDROIDAUTO), ETG_ENUM(BOOL, bNotifSubscribed)));
}

/***********************************************************************************************************************
 ** FUNCTION:  spi_tclAAPAppMngr::vNotificationCallback(..)
 ************************************************************************************************************************/
t_Void spi_tclAAPAppMngr::vNotificationCallback(const t_String& corfszNotifText, t_Bool bHasId,
         const t_String& corfszId, t_Bool bHasIcon, t_U8 *pu8Icon, t_U32 u32IconSize)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::vNotificationCallback entered"));
   ETG_TRACE_USR2(("[DESC]:vNotificationCallback: DeviceHandle = 0x%x, Device Category = %d, Notification text = %s", m_u32SelectedDevId, ETG_ENUM(DEVICE_CATEGORY,
            e8DEV_TYPE_ANDROIDAUTO), corfszNotifText.c_str()));
   ETG_TRACE_USR2(("[DESC]:vNotificationCallback: Has Notification Id = %d, Notification Id = %s", ETG_ENUM(BOOL,
            bHasId), corfszId.c_str()));
   ETG_TRACE_USR2(("[DESC]:vNotificationCallback: Has Notification Icon = %d, Icon size = %d", ETG_ENUM(BOOL, bHasIcon), u32IconSize));

   if ((NULL != m_rAppMngrCallbacks.fvUpdateNotificationData) && (0 != m_u32SelectedDevId))
   {
      trNotificationData rNotificationData;
      rNotificationData.u32DeviceHandle = m_u32SelectedDevId;
      rNotificationData.enDeviceCategory = e8DEV_TYPE_ANDROIDAUTO;
      rNotificationData.szNotifText = corfszNotifText;
      rNotificationData.bHasId = bHasId;
      rNotificationData.szId = corfszId;
      rNotificationData.bHasIcon = bHasIcon;
      rNotificationData.pu8Icon = pu8Icon;
      rNotificationData.u32IconSize = u32IconSize;
      (m_rAppMngrCallbacks.fvUpdateNotificationData)(rNotificationData);
   }
}

/***********************************************************************************************************************
 ** FUNCTION:  spi_tclAAPAppMngr::vAckNotification(..)
 ************************************************************************************************************************/
t_Void spi_tclAAPAppMngr::vAckNotification(t_U32 u32DeviceHandle, const t_String& corfszNotifId)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::vAckNotification entered"));
   ETG_TRACE_USR2(("[DESC]:vAckNotification: DeviceHandle = 0x%x, Device Category = %d,"
            "Notification Id = %s", u32DeviceHandle, ETG_ENUM(DEVICE_CATEGORY, e8DEV_TYPE_ANDROIDAUTO), corfszNotifId.c_str()));

   spi_tclAAPManager* poAAPManager = spi_tclAAPManager::getInstance();
   spi_tclAAPCmdNotificationIntf* poCmdNotification =
            (NULL != poAAPManager) ? (poAAPManager->poGetNotificationInstance()) : (NULL);
   if ((NULL != poCmdNotification) && (0 != u32DeviceHandle))
   {
      poCmdNotification->vAckNotification(u32DeviceHandle, corfszNotifId);
   }
}

/***********************************************************************************************************************
 ** FUNCTION:  spi_tclAAPAppMngr::vVendorExtsnDataCallback(..)
 ************************************************************************************************************************/
t_Void spi_tclAAPAppMngr::vVendorExtsnDataCallback(const t_U8* poVendorExtsnData, size_t u8LengthOfData)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::vVendorExtsnDataCallback entered"));
   if (NULL != m_rAppMngrCallbacks.fvUpdateVendorExtsnData)
   {
      (m_rAppMngrCallbacks.fvUpdateVendorExtsnData)(poVendorExtsnData, u8LengthOfData);
   }
}

/***********************************************************************************************************************
 ** FUNCTION:  spi_tclAAPAppMngr::vVendorExtsnDataCallback(..)
 ************************************************************************************************************************/
t_Void spi_tclAAPAppMngr::vSendVendorExtsn(t_U8* poVendorExtsnData, size_t uLengthOfData,
         const trUserContext &rfrcUsrCntxt)
{
   SPI_INTENTIONALLY_UNUSED(rfrcUsrCntxt);
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::vSendVendorExtsn entered"));
   spi_tclAAPCmdVendorExtsnIntf* poCmdVendorExtsn =
            (NULL != m_poAAPManager) ? (m_poAAPManager->poGetVendorExtsnInstance()) : (NULL);
   if ((NULL != poCmdVendorExtsn) && (uLengthOfData > 0))
   {
      poCmdVendorExtsn->vSendData(poVendorExtsnData, uLengthOfData);
   }
}
/***********************************************************************************************************************
 ** FUNCTION:  spi_tclAAPAppMngr::vSetConfigData(..)
 ************************************************************************************************************************/
t_Void spi_tclAAPAppMngr::vSetConfigData(const trConfigData& rfrConfigData)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::vSetConfigData entered"));
   m_bAAPConfigData = rfrConfigData;
}

//Adding metadata functions

/***************************************************************************
 ** FUNCTION:  t_Bool  spi_tclAAPAppMngr::vMediaPlaybackStatusCallback()
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vMediaPlaybackStatusCallback(const trAAPMediaPlaybackStatus* prAAPMediaPlaybackStatus)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::vMediaPlaybackStatusCallback entered \n"));

   trUserContext rfcorUsrCntxt;
   t_Bool bSolicited = false;

   if (NULL != prAAPMediaPlaybackStatus)
   {
      ETG_TRACE_USR4(("spi_tclAAPAppMngr :: vMediaPlaybackStatusCallback - Data Received from AAP : PlayBackState = %d, Shuffle = %d, Repeat_ALL = %d, "
               "Repeat_ONE = %d ", prAAPMediaPlaybackStatus->u32State, ETG_ENUM(BOOL,
               prAAPMediaPlaybackStatus->bShuffle), ETG_ENUM(BOOL, prAAPMediaPlaybackStatus->bRepeat), ETG_ENUM(BOOL,
               prAAPMediaPlaybackStatus->bRepeatOne)));

      ETG_TRACE_USR4(("spi_tclAAPAppMngr::vMediaPlaybackStatusCallback - Data Received from AAP : Media Source = %s ", prAAPMediaPlaybackStatus->cMediaSource));

      m_rAppMediaPlaytime.u32ElapsedPlayTime = prAAPMediaPlaybackStatus->u32PlaybackSeconds;
      ETG_TRACE_USR4(("spi_tclAAPAppMngr::vMediaPlaybackStatusCallback - Total play time = %d", m_rAppMediaPlaytime.u32TotalPlayTime));
      ETG_TRACE_USR4(("spi_tclAAPAppMngr::vMediaPlaybackStatusCallback - Current play time = %d", m_rAppMediaPlaytime.u32ElapsedPlayTime));

      // Get Info about Play back state (i.e. stopped, playing, paused)
      tenMediaPlayBackState enMediaPlayBackState =
               static_cast<tenMediaPlayBackState>((prAAPMediaPlaybackStatus->u32State) - 1);
      if (enMediaPlayBackState != m_rAppMediaMetaData.enMediaPlayBackState)
      {
         m_rAppMediaMetaData.enMediaPlayBackState = enMediaPlayBackState;
         bSolicited = true;
         ETG_TRACE_USR4(("spi_tclAAPAppMngr::vMediaPlaybackStatusCallback - Play Back state = %d", ETG_ENUM(PLAYBACK_STATE,
                  m_rAppMediaMetaData.enMediaPlayBackState)));
      }

      // Get Info about shuffle
      tenMediaPlayBackShuffleState enMediaPlayBackShuffleState =
               (prAAPMediaPlaybackStatus->bShuffle) ? (e8SHUFFLE_ON) : (e8SHUFFLE_OFF);
      if (enMediaPlayBackShuffleState != m_rAppMediaMetaData.enMediaPlayBackShuffleState)
      {
         m_rAppMediaMetaData.enMediaPlayBackShuffleState = enMediaPlayBackShuffleState;
         bSolicited = true;
         ETG_TRACE_USR4(("spi_tclAAPAppMngr::vMediaPlaybackStatusCallback - Shuffle state = %d", ETG_ENUM(SHUFFLE_MODE,
                  m_rAppMediaMetaData.enMediaPlayBackShuffleState)));
      }

      // Set the playback repeat all and repeat one states
      vSetPlaybackRepeatState(prAAPMediaPlaybackStatus, bSolicited);

      //Set the playback media source
      vSetPlaybackMediaSource(prAAPMediaPlaybackStatus, bSolicited);
   }
   //! Forward Play time data to Connection Manager
   if (NULL != (m_rAppMngrCallbacks.fvAppMediaPlaytime))
   {
      (m_rAppMngrCallbacks.fvAppMediaPlaytime)(m_rAppMediaPlaytime, rfcorUsrCntxt);
   } //if (NULL != (m_rDiPoConnCallbacks.fvAppMediaPlaytime))

   //! Forward meta data to Connection Manager
   if (NULL != (m_rAppMngrCallbacks.fvAppMediaMetaData) && (true == bSolicited))
   {
      (m_rAppMngrCallbacks.fvAppMediaMetaData)(m_rAppMediaMetaData, rfcorUsrCntxt);
   } //if (NULL != (m_rDiPoConnCallbacks.fvAppMediaMetaData))
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclAAPAppMngr::vSetPlaybackRepeatState(const...
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vSetPlaybackRepeatState(const trAAPMediaPlaybackStatus* coprAAPMediaPlaybackStatus,
         t_Bool& bSolicited)
{
   // Get Info about repeat all and repeat one states
   tenMediaPlayBackRepeatState enMediaPlayBackRepeatAllState =
            (true == coprAAPMediaPlaybackStatus->bRepeat) ?
                     (e8REPEAT_ALL) : (m_rAppMediaMetaData.enMediaPlayBackRepeatState);

   tenMediaPlayBackRepeatState enMediaPlayBackRepeatOneState =
            (true == coprAAPMediaPlaybackStatus->bRepeatOne) ?
                     (e8REPEAT_ONE) : (m_rAppMediaMetaData.enMediaPlayBackRepeatState);

   // Set the repeat all state of AppMedia metadata
   if ((enMediaPlayBackRepeatAllState != m_rAppMediaMetaData.enMediaPlayBackRepeatState))
   {
      m_rAppMediaMetaData.enMediaPlayBackRepeatState = enMediaPlayBackRepeatAllState;
      bSolicited = true;
      ETG_TRACE_USR2(("spi_tclAAPAppMngr::vMediaPlaybackStatusCallback - Repeat All state = %d", m_rAppMediaMetaData.enMediaPlayBackRepeatState));
   } // if((enMediaPlayBackRepeatAllState != m_rAppMediaMetaData.enMediaPlayBackRepeatState))

   // Set the repeat one state of AppMedia metadata
   else if (enMediaPlayBackRepeatOneState != m_rAppMediaMetaData.enMediaPlayBackRepeatState)
   {
      m_rAppMediaMetaData.enMediaPlayBackRepeatState = enMediaPlayBackRepeatOneState;
      bSolicited = true;
      ETG_TRACE_USR2(("spi_tclAAPAppMngr::vMediaPlaybackStatusCallback - Repeat One state = %d", m_rAppMediaMetaData.enMediaPlayBackRepeatState));
   } // else if (enMediaPlayBackRepeatOneState != m_rAppMediaMetaData.enMediaPlayBackRepeatState)
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclAAPAppMngr::vSetPlaybackMediaSource(const...
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vSetPlaybackMediaSource(const trAAPMediaPlaybackStatus* coprAAPMediaPlaybackStatus,
         t_Bool& bSolicited)
{
   //Set the media source of the app media metadata
   if (0 != strcmp(m_rAppMediaMetaData.szAppName.c_str(), coprAAPMediaPlaybackStatus->cMediaSource))
   {
      m_rAppMediaMetaData.szAppName.assign(coprAAPMediaPlaybackStatus->cMediaSource, STR_METADATA_LENGTH);
      bSolicited = true;
      ETG_TRACE_USR2(("spi_tclAAPAppMngr:: vSetPlaybackMediaSource - Media Source  = %s", m_rAppMediaMetaData.szAppName.c_str()));
   } //if (0 != strcmp(m_rAppMediaMetaData.szAppName.c_str(),coprAAPMediaPlaybackStatus->cMediaSource))
}

/***************************************************************************
 ** FUNCTION:  t_Bool  spi_tclAAPAppMngr::vMediaPlaybackMetadataCallback()
 ***************************************************************************/
t_Void spi_tclAAPAppMngr::vMediaPlaybackMetadataCallback(trAAPMediaPlaybackMetadata *prAAPMediaPlaybackMetadata)
{
   ETG_TRACE_USR1(("spi_tclAAPAppMngr::vMediaPlaybackMetadataCallback entered \n"));

   trUserContext rfcorUsrCntxt;
   m_rAppMediaMetaData.bMediaMetadataValid = true;

   if (NULL != prAAPMediaPlaybackMetadata)
   {
      m_rAppMediaMetaData.szArtist.assign(prAAPMediaPlaybackMetadata->cArtist, STR_METADATA_LENGTH);
      m_rAppMediaMetaData.szAlbum.assign(prAAPMediaPlaybackMetadata->cAlbum, STR_METADATA_LENGTH);
      m_rAppMediaMetaData.szTitle.assign(prAAPMediaPlaybackMetadata->cSong, STR_METADATA_LENGTH);

      m_rAppMediaMetaData.szImageMIMEType = "";
      m_rAppMediaMetaData.rAppMediaAlbumArt.u8Items.clear();
      m_rAppMediaMetaData.u32ImageSize = static_cast<t_U32>(prAAPMediaPlaybackMetadata->sImageSize);
      if (0 != (prAAPMediaPlaybackMetadata->sImageSize))
      {
         m_rAppMediaMetaData.szImageMIMEType = "PNG";
         for (size_t uIndex = 0; uIndex < (prAAPMediaPlaybackMetadata->sImageSize); uIndex++)
         {
            m_rAppMediaMetaData.rAppMediaAlbumArt.u8Items.push_back(prAAPMediaPlaybackMetadata->cAlbum_art[uIndex]);
         }
      }

      m_rAppMediaMetaData.u8MediaRating = static_cast<t_U8>(prAAPMediaPlaybackMetadata->u32Rating);
      m_rAppMediaPlaytime.u32TotalPlayTime = prAAPMediaPlaybackMetadata->u32DurationSeconds;

      //@ToDo should send TotalPlaytime metadata.

      ETG_TRACE_USR4(("spi_tclAAPAppMngr::vMediaPlaybackMetadataCallback - MetadataValid  = %d, \n", ETG_ENUM(BOOL,
               m_rAppMediaMetaData.bMediaMetadataValid)));
      ETG_TRACE_USR4(("spi_tclAAPAppMngr::vMediaPlaybackMetadataCallback - Song  = %s", m_rAppMediaMetaData.szTitle.c_str()));
      ETG_TRACE_USR4(("spi_tclAAPAppMngr::vMediaPlaybackMetadataCallback - Album  = %s", m_rAppMediaMetaData.szAlbum.c_str()));
      ETG_TRACE_USR4(("spi_tclAAPAppMngr::vMediaPlaybackMetadataCallback - Artist  = %s", m_rAppMediaMetaData.szArtist.c_str()));
      ETG_TRACE_USR4(("spi_tclAAPAppMngr::vMediaPlaybackMetadataCallback - MediaRating  = %d ", m_rAppMediaMetaData.u8MediaRating));
      ETG_TRACE_USR4(("spi_tclAAPAppMngr::vMediaPlaybackMetadataCallback - Image MIME Type  = %s ", m_rAppMediaMetaData.szImageMIMEType.c_str()));

   }

   if (NULL != (m_rAppMngrCallbacks.fvAppMediaMetaData))
   {
      (m_rAppMngrCallbacks.fvAppMediaMetaData)(m_rAppMediaMetaData, rfcorUsrCntxt);
   } //if (NULL != (m_rDiPoConnCallbacks.fvAppMetadata))

   if (NULL != (m_rAppMngrCallbacks.fvAppMediaPlaytime))
   {
      (m_rAppMngrCallbacks.fvAppMediaPlaytime)(m_rAppMediaPlaytime, rfcorUsrCntxt);
   } //if (NULL != (m_rAppMngrCallbacks.fvAppMediaPlaytime))
}

//lint restore
///////////////////////////////////////////////////////////////////////////////
// <EOF>
