/***************************************************************************/
/*!
* \file  spi_tclAAPCmdVendorExtsn
* \brief Interface to interact with AAP Vendor Extension Endpoint
****************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface to interact with AAP Vendor Extension Endpoint
AUTHOR:         Noopur R K
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
08.06.2017  | Noopur R K            | Initial Version

\endverbatim
*****************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include <algorithm>

#include "Lock.h"
#include "AAPTypes.h"
#include "spi_tclAAPCmdVendorExtsn.h"
#include "spi_tclAAPSessionDataIntf.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_AAPWRAPPER
      #include "trcGenProj/Header/spi_tclAAPCmdVendorExtsn.cpp.trc.h"
   #endif
#endif
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
*********************************PUBLIC*************************************
***************************************************************************/

/***************************************************************************
** FUNCTION:  spi_tclAAPCmdVendorExtsn::spi_tclAAPCmdVendorExtsn()
***************************************************************************/
/***************************************************************************
** FUNCTION:  spi_tclAAPCmdVendorExtsn::spi_tclAAPCmdVendorExtsn()
***************************************************************************/
/*lint -esym(40,nullptr) nullptr is not referenced */
spi_tclAAPCmdVendorExtsn::spi_tclAAPCmdVendorExtsn() : m_poVendorExtsnEndpoint(NULL)
{
   ETG_TRACE_USR1(("spi_tclAAPCmdVendorExtsn::spi_tclAAPCmdVendorExtsn entered "));
}

/***************************************************************************
** FUNCTION:  spi_tclAAPCmdVendorExtsn::~spi_tclAAPCmdVendorExtsn()
***************************************************************************/
spi_tclAAPCmdVendorExtsn::~spi_tclAAPCmdVendorExtsn()
{
   /*lint -esym(40,nullptr) nullptr is not referenced */
   ETG_TRACE_USR1(("~spi_tclAAPCmdVendorExtsn() entered "));

}

/***************************************************************************
** FUNCTION:  spi_tclAAPCmdVendorExtsn::InitialiseVendorExtsnEndpoint()
***************************************************************************/
t_Void spi_tclAAPCmdVendorExtsn::vInitialiseVendorExtsnEndpoint()
{
   ETG_TRACE_USR1(("~spi_tclAAPCmdVendorExtsn::vInitialiseVendorExtsnEndpoint entered "));
   t_Bool bRegSuccess = false;
   spi_tclAAPSessionDataIntf oSessionDataIntf;
   shared_ptr<GalReceiver> spoGalReceiver = oSessionDataIntf.poGetGalReceiver();

   if ((spoGalReceiver != nullptr) && (NULL == m_poVendorExtsnEndpoint))
   {
      ETG_TRACE_USR1(("spi_tclAAPCmdBluetooth::vInitialiseVendorExtsnEndpoint: Creating Vendor Extension Endpoint "));
      m_poVendorExtsnEndpoint = new spi_tclAAPVendorExtsnEndpoint((t_U8)e32SESSIONID_VENDOREXTSN, spoGalReceiver->messageRouter());
      SPI_NORMAL_ASSERT(NULL == m_poVendorExtsnEndpoint);

      if(NULL != m_poVendorExtsnEndpoint)
      {
         //m_poVendorExtensionCbs = new spi_tclAAPVendorExtensionCbs();
         //m_poVendorExtsnEndpoint->registerCallbacks(m_poVendorExtensionCbs);
         bRegSuccess = spoGalReceiver->registerService(m_poVendorExtsnEndpoint);
      }
   }
   SPI_INTENTIONALLY_UNUSED(bRegSuccess);
}

/***************************************************************************
** FUNCTION:  spi_tclAAPCmdVendorExtsn::UnitialiseVendorExtsnEndpoint()
***************************************************************************/
t_Void spi_tclAAPCmdVendorExtsn::vUninitialiseVendorExtsnEndpoint()
{
   ETG_TRACE_USR1(("~spi_tclAAPCmdVendorExtsn::vUninitialiseVendorExtsnEndpoint entered "));
   RELEASE_MEM(m_poVendorExtsnEndpoint);
   //m_poVendorExtensionCbs = nullptr;
}

/***************************************************************************
** FUNCTION:  spi_tclAAPCmdVendorExtsn::~spi_tclAAPCmdVendorExtsn()
***************************************************************************/
t_Void spi_tclAAPCmdVendorExtsn::vSendData(t_Void *poData, size_t u8LengthOfData)
{
   ETG_TRACE_USR1(("spi_tclAAPCmdVendorExtsn::vSendData entered "));
   m_oEndpointLock.s16Lock();
   if(NULL != m_poVendorExtsnEndpoint)
   {
      m_poVendorExtsnEndpoint->sendData(poData,u8LengthOfData);
   }
   m_oEndpointLock.vUnlock();
}
/////////////////////////////EOF
