/*!
 *******************************************************************************
 * \file              spi_tclAAPRespVendorExtsn.h
 * \brief             AAP Wrapper Response class for Vendor Extension
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:   AAP Wrapper Response class for Vendor Extension
 COPYRIGHT:     &copy; RBEI

 HISTORY:
Date        |  Author               | Modifications
08.06.2017  |  Noopur R K           | Initial Version
28.08.2019  | Pavan Hiremath        | Commented Input parameter names to fix compiler warnings.

 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLAAPRESPVENDOREXTSN_H_
#define _SPI_TCLAAPRESPVENDOREXTSN_H_

#include "AAPTypes.h"
#include "RespBase.h"



class spi_tclAAPRespVendorExtsn: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclAAPRespVendorExtsn::spi_tclAAPRespVendorExtsn()
    ***************************************************************************/
   /*!
    * \fn      spi_tclAAPRespVendorExtsn()
    * \brief   Constructor
    * \sa      spi_tclAAPRespVendorExtsn()
    **************************************************************************/
   spi_tclAAPRespVendorExtsn(): RespBase(e16AAP_VENDOREXTSN_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclAAPRespVendorExtsn::~spi_tclAAPRespVendorExtsn()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclAAPRespVendorExtsn()
    * \brief   Destructor
    * \sa      spi_tclAAPRespVendorExtsn()
    **************************************************************************/
   virtual ~spi_tclAAPRespVendorExtsn() {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclAAPRespVendorExtsn::vVendorExtsnDataCallback()
    ***************************************************************************/
   /*!
    * \fn      virtual vVendorExtsnDataCallback()
    * \brief   Callback for the receive vendor extension data
    * \param   poVendorExtsnData : pointer to the vendor extension data
    * \param   u8LengthOfData    : Length of the data received from the message
    **************************************************************************/
   virtual t_Void vVendorExtsnDataCallback(const t_U8* /*poVendorExtsnData*/, size_t /*u8LengthOfData*/){}

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclAAPRespVendorExtsn(const spi_tclAAPRespVendorExtsn...
   ***************************************************************************/
   /*!
   * \fn      spi_tclAAPRespVendorExtsn(const spi_tclAAPRespVendorExtsn& corfoSrc)
   * \brief   Copy constructor - Do not allow the creation of copy constructor
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclAAPRespVendorExtsn()
   ***************************************************************************/
   spi_tclAAPRespVendorExtsn(const spi_tclAAPRespVendorExtsn& corfoSrc);


   /***************************************************************************
   ** FUNCTION:  spi_tclAAPRespVendorExtsn& operator=( const spi_tclAAP...
   ***************************************************************************/
   /*!
   * \fn      spi_tclAAPRespVendorExtsn& operator=(const spi_tclAAPRespVendorExtsn& corfoSrc))
   * \brief   Assignment operator
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclAAPRespVendorExtsn(const spi_tclAAPRespVendorExtsn& otrSrc)
   ***************************************************************************/
   spi_tclAAPRespVendorExtsn& operator=(const spi_tclAAPRespVendorExtsn& corfoSrc);


   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/
private:
};

#endif /* _SPI_TCLAAPRESPBLUETOOTH_H_ */
