/*******************************************************************************
 * \file              spi_tclAAPTransportCbs.cpp
 * \brief             Class implementing transport callbacks from GALreceiver
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Class implementing callbacks from GALreceiver
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 07.08.2017 |  Noopur R K                  | Initial Version

 \endverbatim
 ******************************************************************************/
/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/

#include "spi_tclAAPMsgQInterface.h"
#include "spi_tclAAPSessionDispatcher.h"
#include "spi_tclAAPTransportCbs.h"
#include "spi_tclAAPSession.h"
#include "Timer.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_AAPWRAPPER
#include "trcGenProj/Header/spi_tclAAPTransportCbs.cpp.trc.h"
#endif
#endif

static timer_t srTranportErrorTimerId;
t_Bool bTransportErrorTimerRunning = false;
static const t_U32 cou32TransportTimerVal = 5000;

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclAAPTransportCbs::spi_tclAAPTransportCbs(...)
 ***************************************************************************/
spi_tclAAPTransportCbs::spi_tclAAPTransportCbs()
{
   ETG_TRACE_USR1(("spi_tclAAPTransportCbs::spi_tclAAPTransportCbs() entered"));
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclAAPTransportCbs::~spi_tclAAPTransportCbs(...)
 ***************************************************************************/
spi_tclAAPTransportCbs::~spi_tclAAPTransportCbs()
{
   ETG_TRACE_USR1(("spi_tclAAPTransportCbs::~spi_tclAAPTransportCbs() entered"));
   if(true == bTransportErrorTimerRunning)
   {
      vStopTimer();
   }
}

//! Galreceiver callbacks
/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclAAPTransportCbs::notifyErrorCallback(...)
 ***************************************************************************/
void spi_tclAAPTransportCbs::notifyStatusCallback(GalReceiverTransportStatus galTransportErrorStatus)
{
   ETG_TRACE_USR1(("spi_tclAAPTransportCbs::notifyErrorCallback() entered"));

   ETG_TRACE_USR2(("Errorcode :%d occured",ETG_ENUM(TRANSPORT_ERROR,galTransportErrorStatus)));
/*   The following errors are handled
      * WRITE_SUCCESS     =  0
      * WRITE_ERR_FATAL   = -1
      * WRITE_ERR_IO      = -2
      * WRITE_ERR_TIMEOUT = -3
      * READ_SUCCESS      = -4
      * READ_ERR_FATAL    = -5
      * READ_ERR_IO       = -6
      * READ_ERR_TIMEOUT  = -7
      * UNKNOWN_ERR       = -8*/
   switch(galTransportErrorStatus)
   {
      case GalReceiverTransportStatus::WRITE_SUCCESS:
      case GalReceiverTransportStatus::READ_SUCCESS:
      {
         if(bTransportErrorTimerRunning == true)
         {
            ETG_TRACE_USR2(("spi_tclAAPTransportCbs::notifyErrorCallback() Timer running status : %d",ETG_ENUM(BOOL,bTransportErrorTimerRunning)));
            ETG_TRACE_USR2(("Error timer is stopped"));
            vStopTimer();
         }
         break;
      }
      case GalReceiverTransportStatus::READ_ERR_FATAL:
      case GalReceiverTransportStatus::WRITE_ERR_FATAL:
      case GalReceiverTransportStatus::WRITE_ERR_IO:
      case GalReceiverTransportStatus::WRITE_ERR_TIMEOUT:
      case GalReceiverTransportStatus::READ_ERR_IO:
      case GalReceiverTransportStatus::READ_ERR_TIMEOUT:
      {
         ETG_TRACE_USR2(("spi_tclAAPTransportCbs::notifyErrorCallback() starting timer"));
         ETG_TRACE_USR2(("spi_tclAAPTransportCbs::notifyErrorCallback() Timer running status : %d",ETG_ENUM(BOOL,bTransportErrorTimerRunning)));
         vStartTimer();
         break;
      }
      case GalReceiverTransportStatus::UNKNOWN_ERR:
      {
         break;
      }
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclAAPVideoResourceMngr::vStartTimer()
***************************************************************************/
t_Void spi_tclAAPTransportCbs::vStartTimer()
{
   m_oTransportErrorLock.s16Lock();
   Timer* poTimer = Timer::getInstance();
   ETG_TRACE_USR4(("spi_tclAAPTransportCbs::vStartTimer() entered"));
   ETG_TRACE_USR1(("spi_tclAAPTransportCbs::notifyErrorCallback() Timer running status : %d",ETG_ENUM(BOOL,bTransportErrorTimerRunning)));
   if((NULL != poTimer) && (false == bTransportErrorTimerRunning))
   {
      poTimer->StartTimer(srTranportErrorTimerId,cou32TransportTimerVal, 0, this,
         &spi_tclAAPTransportCbs::bTransportErrorTimerCb, NULL);

      ETG_TRACE_USR4(("[DESC]:Transport Error Timer started"));

      bTransportErrorTimerRunning = true;
      ETG_TRACE_USR1(("spi_tclAAPTransportCbs::notifyErrorCallback() Timer running status : %d",ETG_ENUM(BOOL,bTransportErrorTimerRunning)));
   }//End of if(NULL != poTimer)
   m_oTransportErrorLock.vUnlock();
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclAAPTransportCbs::bTransportErrorTimerCb()
***************************************************************************/
t_Bool spi_tclAAPTransportCbs::bTransportErrorTimerCb(timer_t rTimerID, t_Void *pvObject, const t_Void *pvUserData)
{
   ETG_TRACE_USR4(("spi_tclAAPTransportCbs::bTransportErrorTimerCb() entered"));
   ETG_TRACE_USR1(("spi_tclAAPTransportCbs::bTransportErrorTimerCb() Timer running status : %d",ETG_ENUM(BOOL,bTransportErrorTimerRunning)));
   SPI_INTENTIONALLY_UNUSED(rTimerID);
   SPI_INTENTIONALLY_UNUSED(pvObject);
   SPI_INTENTIONALLY_UNUSED(pvUserData);
   bTransportErrorTimerRunning = false;
   ETG_TRACE_USR4(("[DESC]:Transport Error Timer has expired"));
   //session message to be populated with session error and to be dispatched
   AAPSessionStatusMsg oSessionStatus;
   spi_tclAAPMsgQInterface *poMsgQinterface = spi_tclAAPMsgQInterface::getInstance();
   oSessionStatus.m_enSessionstatus = e8_SESSION_ERROR;
   if (NULL != poMsgQinterface)
   {
      poMsgQinterface->bWriteMsgToQ(&oSessionStatus, sizeof(oSessionStatus));
   }
   return true;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclAAPTransportCbs::vStopTimer()
***************************************************************************/
t_Void spi_tclAAPTransportCbs::vStopTimer()
{
   m_oTransportErrorLock.s16Lock();
   Timer* poTimer = Timer::getInstance();
   ETG_TRACE_USR4(("spi_tclAAPTransportCbs::vStopTimer() entered"));
   ETG_TRACE_USR1(("spi_tclAAPTransportCbs::notifyErrorCallback() Timer running status : %d",ETG_ENUM(BOOL,bTransportErrorTimerRunning)));
   if ((NULL != poTimer) && (true == bTransportErrorTimerRunning))
   {
      poTimer->CancelTimer(srTranportErrorTimerId);
      ETG_TRACE_USR4(("[DESC]:Transport Error Timer Stopped"));

      bTransportErrorTimerRunning = false;
   }//End of if (NULL != poTimer)...
   ETG_TRACE_USR1(("spi_tclAAPTransportCbs::notifyErrorCallback() Timer running status : %d",ETG_ENUM(BOOL,bTransportErrorTimerRunning)));
   m_oTransportErrorLock.vUnlock();
}


//////////////EOF
