/*!
 *******************************************************************************
 * \file              spi_tclAAPCmdMediaPlayback.cpp
 * \brief             MediaMetadata wrapper for Android Auto
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    MediaMetadata wrapper for Android Auto
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 25.05.2015 |  Vinoop                      | Initial Version
 11.07.2015 | Ramya Murthy                 | Fix for same session ID being used for multiple Endpoints

 \endverbatim
 ******************************************************************************/
/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "spi_tclAAPCmdMediaPlayback.h"
#include "spi_tclAAPSessionDataIntf.h"
#include "SPITypes.h"
#include "spi_tclMediaPlaybackCbs.h"
#include "RespBase.h"
//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_AAPWRAPPER
      #include "trcGenProj/Header/spi_tclAAPCmdMediaPlayback.cpp.trc.h"
   #endif
#endif
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
/***************************************************************************
** FUNCTION:  spi_tclAAPCmdMediaPlayback::spi_tclAAPCmdMediaPlayback()
***************************************************************************/
spi_tclAAPCmdMediaPlayback::spi_tclAAPCmdMediaPlayback():
m_poMediaPlaybackStatusEndpoint(NULL)
{
   ETG_TRACE_USR1((" spi_tclAAPCmdMediaPlayback::spi_tclAAPCmdMediaPlayback entered "));

}

/***************************************************************************
** FUNCTION:  spi_tclAAPCmdMediaPlayback::~spi_tclAAPCmdMediaPlayback()
***************************************************************************/
spi_tclAAPCmdMediaPlayback::~spi_tclAAPCmdMediaPlayback()
{
   ETG_TRACE_USR1((" spi_tclAAPCmdMediaPlayback::~spi_tclAAPCmdMediaPlayback entered "));
   m_oEndpointLock.s16Lock();
   RELEASE_MEM(m_poMediaPlaybackStatusEndpoint);
   m_spoPlaybackStatusCbs = nullptr;
   m_oEndpointLock.vUnlock();
}

/***************************************************************************
** FUNCTION:t_Bool spi_tclAAPCmdMediaPlayback::~spi_tclAAPCmdMediaPlayback()
***************************************************************************/
t_Bool spi_tclAAPCmdMediaPlayback::bInitializeMediaPlayback()
{
    /*lint -esym(40,nullptr)nullptr Undeclared identifier */
    ETG_TRACE_USR1((" spi_tclAAPCmdMediaPlayback::bInitializeMediaPlayback entered "));
   //! Get Galreciever using Session Data Interface
   spi_tclAAPSessionDataIntf oSessionDataIntf;
   shared_ptr<GalReceiver> poGalReceiver = oSessionDataIntf.poGetGalReceiver();
   t_Bool bRetVal = false;

   vUninitialiseMediaPlayback();
   m_oEndpointLock.s16Lock();
   if ((poGalReceiver != nullptr) && (NULL == m_poMediaPlaybackStatusEndpoint))
   {
       m_poMediaPlaybackStatusEndpoint =
         new (std::nothrow) MediaPlaybackStatusEndpoint(e32SESSIONID_AAPMEDIAPLAYBACK, poGalReceiver->messageRouter());
      if ((NULL != m_poMediaPlaybackStatusEndpoint))
      {
         m_spoPlaybackStatusCbs = new spi_tclMediaPlaybackCbs();
         m_poMediaPlaybackStatusEndpoint->registerCallbacks(m_spoPlaybackStatusCbs);
         bRetVal = poGalReceiver->registerService(m_poMediaPlaybackStatusEndpoint);
         ETG_TRACE_USR4(("spi_tclAAPCmdMediaPlayback::Registration with GalReceiver : %d\n",ETG_ENUM(BOOL,bRetVal)));
      }
   }//if ((poGalReceiver != nullptr) && (NULL == m_poMediaPlaybackStatusEndpoint))
   m_oEndpointLock.vUnlock();
   return true;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclAAPCmdMediaPlayback::vUninitialiseMediaPlayback()
***************************************************************************/
t_Void spi_tclAAPCmdMediaPlayback::vUninitialiseMediaPlayback()
{
   /*lint -esym(40,nullptr)nullptr Undeclared identifier */
   ETG_TRACE_USR1(("spi_tclAAPCmdMediaPlayback::vUninitialiseMediaPlayback() entered "));
   m_oEndpointLock.s16Lock();
   RELEASE_MEM(m_poMediaPlaybackStatusEndpoint);
   m_spoPlaybackStatusCbs = nullptr;
   m_oEndpointLock.vUnlock();
}

///////////////////////////////////////////////////////////////////////////////
// <EOF>

