/*!
 *******************************************************************************
 * \file              spi_tclAAPCmdMediaPlayback.h
 * \brief             MediaMetadata wrapper for Android Auto
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    MediMetadata wrapper for Android Auto
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 24.05.2015 |  Vinoop                      | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCL_AAP_CMD_MEDIAPLAYBACK_H_
#define _SPI_TCL_AAP_CMD_MEDIAPLAYBACK_H_

#include <aauto/MediaPlaybackStatusEndpoint.h>

#include "Lock.h"
#include "BaseTypes.h"
#include "spi_tclMediaPlaybackCbs.h"

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclAAPCmdMediaPlayback
 * \brief
 */

class spi_tclAAPCmdMediaPlayback
{
public:

/***************************************************************************
*********************************PUBLIC*************************************
***************************************************************************/

/***************************************************************************
** FUNCTION:  spi_tclAAPCmdMediaPlayback::spi_tclAAPCmdMediaPlayback();
***************************************************************************/
/*!
* \fn     spi_tclAAPCmdMediaPlayback()
* \brief  Default Constructor
* \sa     spi_tclAAPCmdMediaPlayback()
**************************************************************************/
spi_tclAAPCmdMediaPlayback();

/***************************************************************************
** FUNCTION:  virtual spi_tclAAPCmdMediaPlayback::~spi_tclAAPCmdMediaPlayback()
***************************************************************************/
/*!
* \fn      virtual ~spi_tclAAPCmdMediaPlayback()
* \brief   Virtual Destructor
* \sa      spi_tclAAPCmdMediaPlayback()
**************************************************************************/
virtual  ~spi_tclAAPCmdMediaPlayback();

/***************************************************************************
 ** FUNCTION:  spi_tclAAPCmdMediaPlayback::bInitialize()
 ***************************************************************************/
/*!
 * \fn      bInitialize()
 * \brief   Creates MediaPlayback endpoints and registers callbacks
 * \sa      bInitialize()
 **************************************************************************/
t_Bool  bInitializeMediaPlayback();

/***************************************************************************
** FUNCTION:  t_Void spi_tclAAPCmdMediaPlayback::vUninitialiseMediaPlayback()
***************************************************************************/
/*!
* \fn      t_Void spi_tclAAPCmdMediaPlayback
* \brief   Uninitialises and destroys an instance of MediaPlayback Endpoint
* \retval  t_Void
* \sa      bInitializeMediaPlayback()
***************************************************************************/
t_Void vUninitialiseMediaPlayback();

private:

      /***************************************************************************
       ** FUNCTION:  spi_tclAAPCmdMediaPlayback(const spi_tclAAPCmdMediaPlayback...
       ***************************************************************************/
      /*!
       * \fn      spi_tclAAPCmdMediaPlayback(
       *                             const spi_tclAAPCmdMediaPlayback& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclAAPCmdMediaPlayback()
       ***************************************************************************/
       spi_tclAAPCmdMediaPlayback(const spi_tclAAPCmdMediaPlayback& corfoSrc);


      /***************************************************************************
       ** FUNCTION:  spi_tclAAPCmdMediaPlayback& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclAAPCmdMediaPlayback& operator=(
       *                          const spi_tclAAPCmdMediaPlayback& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclAAPCmdMediaPlayback(const spi_tclAAPCmdMediaPlayback& otrSrc)
       ***************************************************************************/
       spi_tclAAPCmdMediaPlayback& operator=(const spi_tclAAPCmdMediaPlayback& corfoSrc);

      //! MediaPlaybackStatusEndpoint Endpoint
      MediaPlaybackStatusEndpoint *m_poMediaPlaybackStatusEndpoint;

      //! Pointer to class containing callbacks for GAL receiver
      shared_ptr<IMediaPlaybackStatusCallbacks> m_spoPlaybackStatusCbs;

      //! Lock object for MediaPlaybackStatus endpoint
      Lock  m_oEndpointLock;

};
#endif
///////////////////////////////////////////////////////////////////////////////
// <EOF>
