/*!
 *******************************************************************************
 * \file              spi_tclAAPManager.h
 * \brief            AAP Wrapper Manager
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    AAP Wrapper Manager to provide interface to SPI
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 22.08.2013 |  Pruthvi Thej Nagaraju       | Initial Version
 24.03.2015 |  SHITANSHU SHEKHAR		   | Added Sensor pointer
 26.02.2016 |  Rachana L Achar             | AAP Navigation implementation
 10.03.2016 |  Rachana L Achar             | AAP Notification implementation

 \endverbatim
 ******************************************************************************/
#ifndef SPI_TCLAAPMANAGER_H_
#define SPI_TCLAAPMANAGER_H_

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/
#include "GenericSingleton.h"
#include "RespRegister.h"
#include "spi_tclAAPCmdSession.h"
#include "spi_tclAAPCmdBluetooth.h"
#include "spi_tclAAPCmdInput.h"
#include "spi_tclAAPCmdVideo.h"
#include "spi_tclAAPCmdSensor.h"
#include "spi_tclAAPCmdAudio.h"
#include "spi_tclAAPCmdMediaPlayback.h"
#include "spi_tclAAPCmdNavigation.h"
#include "spi_tclAAPCmdNotification.h"
#include "spi_tclAAPCmdVendorExtsn.h"

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*!
 * \class spi_tclAAPManager
 * \brief Manager class  to provide interface for SPI to interact with
 *        AAPWrapper classes
 *
 */
class spi_tclAAPManager: public GenericSingleton<spi_tclAAPManager>
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclAAPManager::~spi_tclAAPManager();
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclAAPManager()
       * \brief   Destructor
       * \sa      spi_tclAAPManager()
       **************************************************************************/
      ~spi_tclAAPManager();

      /***************************************************************************
       ** FUNCTION:    spi_tclAAPCmdSession* poGetSessionInstance()
       ***************************************************************************/
      /*!
       * \fn       spi_tclAAPCmdSession* poGetSessionInstance()
       * \brief   Get Session command class's instance
       **************************************************************************/
      spi_tclAAPCmdSession* poGetSessionInstance();

      /***************************************************************************
       ** FUNCTION:    spi_tclAAPCmdBluetooth* poGetBluetoothInstance()
       ***************************************************************************/
      /*!
       * \fn       spi_tclAAPCmdBluetooth* poGetBluetoothInstance()
       * \brief   Get Bluetooth command class's instance
       **************************************************************************/
      spi_tclAAPCmdBluetooth* poGetBluetoothInstance();

      /***************************************************************************
       ** FUNCTION:    spi_tclAAPCmdInput* poGetInputInstance()
       ***************************************************************************/
      /*!
       * \fn       poGetInputInstance* poGetInputInstance()
       * \brief   Get Input command class's instance
       **************************************************************************/
      spi_tclAAPCmdInput* poGetInputInstance();

      /***************************************************************************
       ** FUNCTION:    spi_tclAAPCmdSensor* poGetSensorInstance()
       ***************************************************************************/
      /*!
       * \fn       poGetSensorInstance* poGetSensorInstance()
       * \brief   Get Sensor command class's instance
       **************************************************************************/
      spi_tclAAPCmdSensor* poGetSensorInstance();

      /***************************************************************************
       ** FUNCTION:    spi_tclAAPCmdVideo* poGetVideoInstance()
       ***************************************************************************/
      /*!
       * \fn       spi_tclAAPCmdVideo* poGetVideoInstance()
       * \brief   Get command video class's instance
       **************************************************************************/
      spi_tclAAPCmdVideo* poGetVideoInstance();	

      /***************************************************************************
       ** FUNCTION:    spi_tclAAPCmdAudio* poGetAudioInstance()
       ***************************************************************************/
      /*!
       * \fn       spi_tclAAPCmdAudio* poGetAudioInstance()
       * \brief    Get Audio command class's instance
       **************************************************************************/
      spi_tclAAPCmdAudioIntf* poGetAudioInstance();
	  
      /***************************************************************************
       ** FUNCTION:    spi_tclAAPCmdMediaPlayback* poGetMediaPlaybackInstance()
       ***************************************************************************/
      /*!
       * \fn       spi_tclAAPCmdMediaPlayback* poGetMediaPlaybackInstance()
       * \brief    Get media playback class's instance
       **************************************************************************/
      spi_tclAAPCmdMediaPlayback* poGetMediaPlaybackInstance();

      /***************************************************************************
       ** FUNCTION:    spi_tclAAPCmdNavigation* poGetNavigationInstance()
       ***************************************************************************/
      /*!
       * \fn       spi_tclAAPCmdNavigation* poGetNavigationInstance()
       * \brief    Get navigation command class's instance
       **************************************************************************/
      spi_tclAAPCmdNavigation* poGetNavigationInstance();

      /***************************************************************************
       ** FUNCTION:    spi_tclAAPCmdNotification* poGetNotificationInstance()
       ***************************************************************************/
      /*!
       * \fn       spi_tclAAPCmdNotification* poGetNotificationInstance()
       * \brief    Get notification command class's instance
       **************************************************************************/
      spi_tclAAPCmdNotification* poGetNotificationInstance();
	  
      /***************************************************************************
       ** FUNCTION:    spi_tclAAPCmdNotification* poGetVendorExtsnInstance()
       ***************************************************************************/
      /*!
       * \fn       spi_tclAAPCmdVendorExtsn* poGetVendorExtsnInstance()
       * \brief    Get Vendor Extension command class's instance
       **************************************************************************/
      spi_tclAAPCmdVendorExtsn* poGetVendorExtsnInstance();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclAAPManager::bRegisterObject(RespBase *poRespBase)
       ***************************************************************************/
      /*!
       * \fn       t_Bool spi_tclAAPManager::bRegisterObject(RespBase *poRespBase)
       * \brief   Registers the response class object
       * \ret      returns true on success
       **************************************************************************/
      t_Bool bRegisterObject(RespBase *poRespBase);

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclAAPManager::bUnRegisterObject(RespBase *poRespBase)
       ***************************************************************************/
      /*!
       * \fn       t_Bool spi_tclAAPManager::bUnRegisterObject(RespBase *poRespBase)
       * \brief    Unregisters the response class object
       * \ret      returns true on success
       **************************************************************************/
      t_Bool bUnRegisterObject(RespBase *poRespBase);

      //! Base Singleton class
      friend class GenericSingleton<spi_tclAAPManager> ;

      /***************************************************************************
       *******************************PRIVATE************************************
       **************************************************************************/
   private:
   
      /***************************************************************************
       ** FUNCTION:  spi_tclAAPManager(const spi_tclAAPManager...
       ***************************************************************************/
      /*!
       * \fn      spi_tclAAPManager(
       *                             const spi_tclAAPManager& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclAAPManager()
       ***************************************************************************/
       spi_tclAAPManager(const spi_tclAAPManager& corfoSrc);


      /***************************************************************************
       ** FUNCTION:  spi_tclAAPManager& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclAAPManager& operator=(
       *                          const spi_tclAAPManager& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclAAPManager(const spi_tclAAPManager& otrSrc)
       ***************************************************************************/
       spi_tclAAPManager& operator=(const spi_tclAAPManager& corfoSrc);	   
   
      //! Session command class pointer
      spi_tclAAPCmdSession*      m_poCmdSession;

      //! Bluetooth command class pointer
      spi_tclAAPCmdBluetooth* m_poCmdBluetooth;

      //! Input command class object
      spi_tclAAPCmdInput *m_poCmdInput;

      //! Sensor command class object
      spi_tclAAPCmdSensor *m_poCmdSensor;

      //! Video Command Class object
      spi_tclAAPCmdVideo* m_poCmdVideo;

      //! Audio command class object
      spi_tclAAPCmdAudioIntf *m_poCmdAudio;

      //! Metadata command class object
      spi_tclAAPCmdMediaPlayback *m_poCmdMediaPlayback;

      //! Navigation command class object
      spi_tclAAPCmdNavigation *m_poCmdNavigation;

      //! Notification command class object
      spi_tclAAPCmdNotification *m_poCmdNotification;

      spi_tclAAPCmdVendorExtsn *m_poCmdVendorExtsn;

      /***************************************************************************
       ** FUNCTION:  spi_tclAAPManager::spi_tclAAPManager()
       ***************************************************************************/
      /*!
       * \fn      spi_tclAAPManager()
       * \brief   Default Constructor
       * \sa      ~spi_tclAAPManager()
       **************************************************************************/
      spi_tclAAPManager();
};

#endif // SPI_TCLAAPMANAGER_H_

