/*
 * spi_tclAAPCmdNavigationIntf.h
 *
 *  Created on: Mar 14, 2019
 *      Author: OLR5KOR
 */

#ifndef SPI_TCLAAPCMDNAVIGATIONINTF_H_
#define SPI_TCLAAPCMDNAVIGATIONINTF_H_
#include "SPITypes.h"
#include "BaseTypes.h"
#include "AAPTypes.h"
class spi_tclAAPCmdNavigationIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclAAPCmdNavigation::spi_tclAAPCmdNavigation()
   ***************************************************************************/
   /*!
   * \fn      spi_tclAAPCmdNavigation()
   * \brief   Default Constructor
   * \sa      ~spi_tclAAPCmdNavigation()
   ***************************************************************************/
	spi_tclAAPCmdNavigationIntf(){};

   /***************************************************************************
   ** FUNCTION:  spi_tclAAPCmdNavigation::~spi_tclAAPCmdNavigation()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclAAPCmdNavigation()
   * \brief   Destructor
   * \sa      spi_tclAAPCmdNavigation()
   ***************************************************************************/
	virtual ~spi_tclAAPCmdNavigationIntf(){};

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclAAPCmdNavigation::bInitializeNavigationStatus()
   ***************************************************************************/
   /*!
   * \fn      t_Bool bInitializeNavigationStatus()
   * \brief   Creates and initialises an instance of Navigation Endpoint
   * \retval  t_Bool  :  True if the Navigation Endpoint is initialised, else False
   * \sa      bUninitializeNavigationStatus()
   ***************************************************************************/
   virtual t_Bool bInitializeNavigationStatus()=0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAAPCmdNavigation::bUninitializeNavigationStatus()
   ***************************************************************************/
   /*!
   * \fn      t_Void bUninitializeNavigationStatus()
   * \brief   Uninitialises and destroys an instance of Navigation Endpoint
   * \retval  t_Void
   * \sa      bInitializeNavigationStatus()
   ***************************************************************************/
   virtual t_Void vUninitializeNavigationStatus()=0;

};

#endif /* SPI_TCLAAPCMDNAVIGATIONINTF_H_ */
