//  *****************************************************************************
//  * FILE:         FunctionIDs.h
//  * SW_COMPONENT: VD-Sensor
//  * DESCRIPTION:  defines FunctionIDs for messages
//  * AUTHOR:       CM-DI/ESA1-Fischer
//  * COPYRIGHT:    (c) 2002 Blaupunkt GmbH
//  * HISTORY:
//  * 26.03.02 Rev. 1.0 CM-DI/ESA1-Fischer
//  *          Initial Revision.
//  *****************************************************************************
#ifndef FunctionIDs_h
#define FunctionIDs_h 1

// odometer-data
#define VDS_C_U16_FKTID_ODOMDATA_INIT                (tU16)0x0001   //Removed from cmb_fi version 5.0.0  
#define VDS_C_U16_FKTID_ODOMDATA_UPDATE              (tU16)0x0002
// gyro-data                                         
#define VDS_C_U16_FKTID_GYRODATA_INIT                (tU16)0x0003   //Removed from cmb_fi version 5.0.0  
#define VDS_C_U16_FKTID_GYRODATA_UPDATE              (tU16)0x0004   //Removed from cmb_fi version 5.0.0
// gps-data                                          
#define VDS_C_U16_FKTID_GPSDATA                      (tU16)0x0005   //Removed from cmb_fi version 5.0.0   
#define VDS_C_U16_FKTID_GPSDATA_VALID_CONTENT        (tU16)0x0006   //Removed from cmb_fi version 5.0.0  
// odometer-parameter                                 
#define VDS_C_U16_FKTID_TYRE_WIDTH                   (tU16)0x0007   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_TYRE_HEIGHT_WIDTH_RATIO      (tU16)0x0008   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_RIM_DIAMETER                 (tU16)0x0009   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_TYRE_CONDITION               (tU16)0x000A   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_TYRE_CIRCUMFERENCE           (tU16)0x000B   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_PULSES_PER_TYRE_CIRCUM       (tU16)0x000C   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_CALC_ODOM_CALIBRATION        (tU16)0x000D   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_DISTCAL                      (tU16)0x000E
#define VDS_C_U16_FKTID_TYRE_EXPANSION               (tU16)0x000F   //Removed from cmb_fi version 5.0.0     
// gyro-parameter                                    
#define VDS_C_U16_FKTID_GYRO_MANUFACTURER            (tU16)0x0010   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GYRO_TYPE                    (tU16)0x0011   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GYRO_BIT_RESOLUTION          (tU16)0x0012 
#define VDS_C_U16_FKTID_GYRO_OFFSET                  (tU16)0x0013   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GYRO_SCALEFACTOR             (tU16)0x0014   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_SET_DEFAULT_GYRO_PARAM       (tU16)0x0015   //Removed from cmb_fi version 5.0.0
// gps-parameter                                     
#define VDS_C_U16_FKTID_GPS_COMM_PROTOCOL            (tU16)0x0016   //Removed from cmb_fi version 5.0.0   
#define VDS_C_U16_FKTID_GPS_TEMPERATURE              (tU16)0x0017
#define VDS_C_U16_FKTID_GPS_FILTERMODE               (tU16)0x0018   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GPS_TESTMODE                 (tU16)0x0019   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GPS_XOCOMPENSATION           (tU16)0x001A   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GPS_ANTENNACURRENT           (tU16)0x001B
// gyro-parameter                                    
#define VDS_C_U16_FKTID_GYRO_ADCBITRANGE             (tU16)0x001C   //Removed from cmb_fi version 5.0.0    
// system clock parameter                            
#define VDS_C_U16_FKTID_TIME_OF_DAY                  (tU16)0x001D
// Prepare manual calibration of odometer            
#define VDS_C_U16_FKTID_ODO_PREP_MAN_CALIB           (tU16)0x001E
// Initiate manual calibration of odometer           
#define VDS_C_U16_FKTID_ODO_MAN_CALIB                (tU16)0x001F
// Gyro selftest                                          ---> not available for E1/E2
#define VDS_C_U16_FKTID_GYRO_SELFTEST                (tU16)0x0020
// Check Valid Date                                       ---> not available for E1/E2
#define VDS_C_U16_FKTID_OSAL_TIME_EVENT              (tU16)0x0021   //Removed from cmb_fi version 5.0.0
// Odometer usage mode                               
#define VDS_C_U16_FKTID_ODOMETER_USAGE               (tU16)0x0022   //Removed from cmb_fi version 5.0.0

#define VDS_C_U16_FKTID_GPSEXTDATA                   (tU16)0x0026
#define VDS_C_U16_FKTID_GPSSETHINTS                  (tU16)0x0027   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GPSSETEXTHINTS               (tU16)0x0028   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GPSFRONTEND                  (tU16)0x0029
#define VDS_C_U16_FKTID_GPSOSCILLATOR                (tU16)0x002a   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GPSFRONTENDTEST              (tU16)0x002b   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GYROERROR                    (tU16)0x002c   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GPSTESTADDITIONALDATA        (tU16)0x002d   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GPSTCDATA                    (tU16)0x002e
#define VDS_C_U16_FKTID_UPDATEDIAGLOG                (tU16)0x002f
#define VDS_C_U16_FKTID_ABSDATA                      (tU16)0x0030
#define VDS_C_U16_FKTID_STEERINGDATA                 (tU16)0x0031   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_ODOMETERRANGE                (tU16)0x0032   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GYRODIAGRAWVALUES            (tU16)0x0033   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GPSEXTTESTMODE               (tU16)0x0034   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GPSPOSITION                  (tU16)0x0035   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_FACTORYSETTINGS              (tU16)0x0036
#define VDS_C_U16_FKTID_DRIVEDIRECTION               (tU16)0x0037   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GALASPEED                    (tU16)0x0038   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_DEACTIVATEGPSENCODER         (tU16)0x0039   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_UPDATEFACTORYSETTINGS        (tU16)0x003A
#define VDS_C_U16_FKTID_GPSNOISELEVELTIMEPOSVALIDITY (tU16)0x003B   //Removed from cmb_fi version 5.0.0
/*3D Gyro/Acc  */
#define VDS_C_U16_FKTID_GYRO3DDIAGRAWVALUES          (tU16)0x003C   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_ACC3DDIAGRAWVALUES           (tU16)0x003D   //Removed from cmb_fi version 5.0.0
#define VDS_C_U16_FKTID_GYRO3DGETHWINFO              (tU16)0x0040
#define VDS_C_U16_FKTID_GYRO3DDATAUPDATE             (tU16)0x0041
#define VDS_C_U16_FKTID_ACC3DGETHWINFO               (tU16)0x0042
#define VDS_C_U16_FKTID_ACC3DDATAUPDATE              (tU16)0x0043
#define VDS_C_U16_FKTID_GYROTEMPERATURE              (tU16)0x0044
#define VDS_C_U16_FKTID_GNSSSATSYSTEM                (tU16)0x0045
#define VDS_C_U16_FKTID_GNSSWNEPOCH                  (tU16)0x0046
#define VDS_C_U16_FKTID_TIMEMODE                     (tU16)0x0047
#define VDS_C_U16_FKTID_GNSSCONFIGDATA               (tU16)0x0048
#define VDS_C_U16_FKTID_GNSSDATA                     (tU16)0x0049
#define VDS_C_U16_FKTID_GNSSANTENNA                  (tU16)0x004a
#define VDS_C_U16_FKTID_ALLSENSORDATA                (tU16)0x004b
#define VDS_C_U16_FKTID_VDSVERSIONINFO               (tU16)0x004c
#define SENSOR_LOCATIONFI_C_U16_GYROSELFTEST         (tU16)0x004d
#define SENSOR_LOCATIONFI_C_U16_ACCSELFTEST          (tU16)0x004e
//   SENSOR_LOCATIONFI_C_U16_ACCTEMPERATURE = 0x4f
#define VDS_C_U16_FKTID_DIAGGNSSSATSYSTEM      (tU16)0x0050
#define VDS_C_U16_FKTID_MAX_ID                       (tU16)0x0050


// CCA_C_U16_SRV_SENSORS-service-versions
#define VDS_C_U16_SRV_SENSORS_MAJOR_VERSION     (tU16)1
#define VDS_C_U16_SRV_SENSORS_MINOR_VERSION     (tU16)2
#define VDS_C_U16_SRV_SENSORS_PATCH_VERSION     (tU16)0

/* For CCA_C_U16_SRV_DIAGLOG */
#define VDS_C_U16_FKTID_DIAGLOG_SAVETESTRESULT (tU16)0x0001

/* For CCA_C_U16_SRV_SPM */
#define VDS_C_U16_FKTID_SPM_CVMEVENT (tU16)0x0038

// error-codes
#define VDS_E_DATA_UNAVAILABLE            (tU16)0xFFFF
#define VDS_E_INTERNAL_ERROR              (tU16)0xFFFE
#define VDS_E_INVALID_TYRETYPE            (tU16)0xFFFD
#define VDS_E_INVALID_TYRECIRCUMFERENCE   (tU16)0xFFFC
#define VDS_E_INVALID_PULSESPERTYRECIRCUM (tU16)0xFFFB
#define VDS_E_FILTERMODE_UNAVAILABLE      (tU16)0xFFFA
#define VDS_E_TEMPERATURE_UNAVAILABLE     (tU16)0xFFF9
#define VDS_E_GPS_TEST_NOT_RUNNING        (tU16)0xFFF8
#define VDS_E_ODO_MAN_CALIB_NOT_RUNNING   (tU16)0xFFF7
#define VDS_E_ODO_MAN_CALIB_UNAVAILABLE   (tU16)0xFFF6
#define VDS_E_GYRO_SELFTEST_UNAVAILABLE   (tU16)0xFFF5

// also used:
//AMT_C_U16_ERROR_TEMPORARY_NOT_AVAILABLE
//AMT_C_U16_ERROR_PARAMETER_OUT_OF_RANGE
//AMT_C_U16_ERROR_UNKNOWN_FCT_ID
//AMT_C_U16_ERROR_UPREG_FAILURE
//AMT_C_U16_ERROR_RELUPREG_FAILURE
//AMT_C_U16_ERROR_UNKNOWN_SVC_ID
//AMT_C_U16_ERROR_UNSPECIFIED
//AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED

#endif
