//	*****************************************************************************
//	* FILE:         vds_err_basemessages.h
//	* SW_COMPONENT: VD-Sensor
//	* DESCRIPTION:  base-messages for vdsensor-communication
//	* AUTHOR:       R. Schedel
//	* COPYRIGHT:    (c) 2003 Blaupunkt GmbH
//	* HISTORY:
//	* 05.06.03 R. Schedel
//	*          Initial Revision.
//	*****************************************************************************

#ifndef vds_err_basemessages_h
#define vds_err_basemessages_h 1

#if defined( VARIANT_S_FTR_ENABLE_FORDTPEX ) || defined( VARIANT_S_FTR_ENABLE_VWRNSLL ) || defined( VARIANT_S_FTR_ENABLE_PARAMOUNT) || defined( VARIANT_S_FTR_ENABLE_HUL6)

class vds_tclErrMsg0 : public amt_tclServiceDataMsg0
{
public:
	vds_tclErrMsg0 (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode);
	vds_tclErrMsg0 (amt_tclBaseMessage *poBaseMessage);
};

class vds_tclErrMsgBool : public amt_tclServiceDataMsg1<tBool>
{
public:
	vds_tclErrMsgBool (tU16 u16Source, tU16 u16Target, tU16 u16FunctionID, tU8 u8OpCode, tBool bValue);
	vds_tclErrMsgBool (amt_tclBaseMessage *poBaseMessage);
};

// following classes were replaced with base-messages:


// Sensor Error CCA messages

// Invalid Odometer

class vds_tclErrorInvalidOdometerGet : public vds_tclErrMsg0
{
public:
   vds_tclErrorInvalidOdometerGet (tU16 u16Source, tU16 u16Target);
   vds_tclErrorInvalidOdometerGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorInvalidOdometerUpReg : public vds_tclErrMsg0
{
public:
	vds_tclErrorInvalidOdometerUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclErrorInvalidOdometerUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorInvalidOdometerRelUpReg : public vds_tclErrMsg0
{
public:
	vds_tclErrorInvalidOdometerRelUpReg (tU16 u16Source, tU16 u16Target);
	vds_tclErrorInvalidOdometerRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorInvalidOdometerStatus : public vds_tclErrMsgBool
{
public:
   vds_tclErrorInvalidOdometerStatus (tU16 u16Source, tU16 u16Target, tBool bValue);
   vds_tclErrorInvalidOdometerStatus (amt_tclBaseMessage *poBaseMessage);
};

// GpsAntennaBreak

class vds_tclErrorGpsAntennaBreakGet : public vds_tclErrMsg0
{
public:
   vds_tclErrorGpsAntennaBreakGet (tU16 u16Source, tU16 u16Target);
   vds_tclErrorGpsAntennaBreakGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorGpsAntennaBreakUpReg : public vds_tclErrMsg0
{
public:
   vds_tclErrorGpsAntennaBreakUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclErrorGpsAntennaBreakUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorGpsAntennaBreakRelUpReg : public vds_tclErrMsg0
{
public:
   vds_tclErrorGpsAntennaBreakRelUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclErrorGpsAntennaBreakRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorGpsAntennaBreakStatus : public vds_tclErrMsgBool
{
public:
   vds_tclErrorGpsAntennaBreakStatus (tU16 u16Source, tU16 u16Target, tBool bValue);
   vds_tclErrorGpsAntennaBreakStatus (amt_tclBaseMessage *poBaseMessage);
};

// GpsAntennaShort

class vds_tclErrorGpsAntennaShortGet : public vds_tclErrMsg0
{
public:
   vds_tclErrorGpsAntennaShortGet (tU16 u16Source, tU16 u16Target);
   vds_tclErrorGpsAntennaShortGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorGpsAntennaShortUpReg : public vds_tclErrMsg0
{
public:
   vds_tclErrorGpsAntennaShortUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclErrorGpsAntennaShortUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorGpsAntennaShortRelUpReg : public vds_tclErrMsg0
{
public:
   vds_tclErrorGpsAntennaShortRelUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclErrorGpsAntennaShortRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorGpsAntennaShortStatus : public vds_tclErrMsgBool
{
public:
   vds_tclErrorGpsAntennaShortStatus (tU16 u16Source, tU16 u16Target, tBool bValue);
   vds_tclErrorGpsAntennaShortStatus (amt_tclBaseMessage *poBaseMessage);
};

// GyroExtensivTest

class vds_tclErrorGyroExtensivTestGet : public vds_tclErrMsg0
{
public:
   vds_tclErrorGyroExtensivTestGet (tU16 u16Source, tU16 u16Target);
   vds_tclErrorGyroExtensivTestGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorGyroExtensivTestUpReg : public vds_tclErrMsg0
{
public:
   vds_tclErrorGyroExtensivTestUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclErrorGyroExtensivTestUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorGyroExtensivTestRelUpReg : public vds_tclErrMsg0
{
public:
   vds_tclErrorGyroExtensivTestRelUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclErrorGyroExtensivTestRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorGyroExtensivTestStatus : public vds_tclErrMsgBool
{
public:
   vds_tclErrorGyroExtensivTestStatus (tU16 u16Source, tU16 u16Target, tBool bValue);
   vds_tclErrorGyroExtensivTestStatus (amt_tclBaseMessage *poBaseMessage);
};

// OdometerNoInfo

class vds_tclErrorOdometerNoInfoGet : public vds_tclErrMsg0
{
public:
   vds_tclErrorOdometerNoInfoGet (tU16 u16Source, tU16 u16Target);
   vds_tclErrorOdometerNoInfoGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorOdometerNoInfoUpReg : public vds_tclErrMsg0
{
public:
   vds_tclErrorOdometerNoInfoUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclErrorOdometerNoInfoUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorOdometerNoInfoRelUpReg : public vds_tclErrMsg0
{
public:
   vds_tclErrorOdometerNoInfoRelUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclErrorOdometerNoInfoRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorOdometerNoInfoStatus : public vds_tclErrMsgBool
{
public:
   vds_tclErrorOdometerNoInfoStatus (tU16 u16Source, tU16 u16Target, tBool bValue);
   vds_tclErrorOdometerNoInfoStatus (amt_tclBaseMessage *poBaseMessage);
};

// OdometerError

class vds_tclErrorOdometerErrorGet : public vds_tclErrMsg0
{
public:
   vds_tclErrorOdometerErrorGet (tU16 u16Source, tU16 u16Target);
   vds_tclErrorOdometerErrorGet (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorOdometerErrorUpReg : public vds_tclErrMsg0
{
public:
   vds_tclErrorOdometerErrorUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclErrorOdometerErrorUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorOdometerErrorRelUpReg : public vds_tclErrMsg0
{
public:
   vds_tclErrorOdometerErrorRelUpReg (tU16 u16Source, tU16 u16Target);
   vds_tclErrorOdometerErrorRelUpReg (amt_tclBaseMessage *poBaseMessage);
};
class vds_tclErrorOdometerErrorStatus : public vds_tclErrMsgBool
{
public:
   vds_tclErrorOdometerErrorStatus (tU16 u16Source, tU16 u16Target, tBool bValue);
   vds_tclErrorOdometerErrorStatus (amt_tclBaseMessage *poBaseMessage);
};

#endif // VARIANT_S_FTR_ENABLE_FORDTPEX

#endif /*vds_err_basemessages_h*/
