/************************************************************************
 * FILE:         vds_trace.h
 * PROJECT:      VASCO
 * SW-COMPONENT: VDSensor
 *----------------------------------------------------------------------
 * DESCRIPTION:  prototypes to handle traces
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2002 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      |   Modification                         | Author
 * 20.09.02  |   Initial revision                     | CM-DI/ESA1-Fischer
 *
 *
 *************************************************************************/

#ifndef vds_tcltracehandler_h
#define vds_tcltracehandler_h 1

#define VDS_S_IMPORT_INTERFACE_MESSAGE_INTERFACES
#define VDS_S_IMPORT_INTERFACE_SENSOR_DEFINES
#define VDS_S_IMPORT_INTERFACE_SENSOR_DATATYPES
#define VDS_S_IMPORT_INTERFACE_TRACE
#include "vds_internal_if.h"

typedef enum
{
   VDS_EN_TRACE_HANDLER_SINK_VD_SENSOR = 0x01,
   VDS_EN_TRACE_HANDLER_SINK_GPS = 0x02,
   VDS_EN_TRACE_HANDLER_SINK_ODO = 0x03,
   VDS_EN_TRACE_HANDLER_SINK_GYRO = 0x04,
   VDS_EN_TRACE_HANDLER_SINK_ABS = 0x05,
   VDS_EN_TRACE_HANDLER_SINK_STEER = 0x06,
   VDS_EN_TRACE_HANDLER_SINK_KDS = 0x07,
   VDS_EN_TRACE_HANDLER_SINK_INTERNAL = 0x08
} VDS_EN_TRACE_HANDLER_SINKS;

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Handles the incoming trace messages (commands) from the TTFis to the device.
//!
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
class vds_tclTraceHandler
{
   public:

      /*! \brief File descriptor for the /dev/trace. */
      OSAL_tIODescriptor inithTrace;
      tclMsgGpsIf *poMsgGpsIf;

      // ***************** F U N C T I O N  H E A D E R **************************
      //
      //  DESCRIPTION:
      //
      // brief
      //   Default Constructor.
      //
      // return
      //   None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // -------------------------------------------------------------------------
      //**************************************************************************
      vds_tclTraceHandler ( tclMsgGpsIf *poMsgGpsIf );
      //virtual ~vds_tclTraceHandler();

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      // brief
      //    Registers to the TTFis Device
      //
      // return
      //    None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      tVoid vRegisterToTtfis ( OSAL_tIODescriptor hTrace );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      // brief
      //   Unregisters from TTFis Device
      //
      // return
      //   None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      tVoid vUnregisterToTtfis ( OSAL_tIODescriptor hTrace );

   private:
      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //! \brief
      //!   Handles the incomming message from TTFis. Depending on the device for
      //!   which the instruction (from the incoming mesage) is meant for,
      //!   appropriate calls are made to the device and trace messages are also sent
      //!   to TTFis.
      //!
      //! \return
      //!   None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      tVoid vChannelMgr ( const tUChar* puchData );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      // brief
      //    Wrapper function to the vChannelMgr method.  Passes the argument to the
      //    method only if the Trace handler is not NULL.
      //
      //   return
      //    None
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      static tVoid vChannelMgrWrapper ( const tUChar* puchData );

      static vds_tclTraceHandler *poTraceHandler;
      OSAL_tIODescriptor hGps;
      OSAL_tIODescriptor hOdo;
      OSAL_tIODescriptor hGyro;
      OSAL_tIODescriptor hAbs;
      OSAL_tIODescriptor hSteer;
};

#endif
