/*******************************************************************************
 * COPYRIGHT RESERVED, 2015 Robert Bosch Car Multimedia GmbH.
 * All rights reserved. The reproduction, distribution and utilization of this
 * document as well as the communication of its contents to others without 
 * explicit authorization is prohibited. Offenders will be held liable for the 
 * payment of damage. All rights reserved in the event of the grant of a patent,
 * utility model or design.
 *******************************************************************************/
/**
 * @file
 *
 * @brief    [short description]
 *
 * [long description]
 * 
 * @author   CM-DI/ECO1 Joachim Friess
 *
 * @par History:
 *
 ******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_TYPES
#include "sensor_fi_if.h"

/**************************************************************************//**
 * @brief Function declarations
 ******************************************************************************/
static tVoid
vVdsCopyOsalToFiOneAxes ( const OSAL_trSensorHwInfo &rOsalHwInfoAxes,
                          sensor_fi_tcl_SensorHwInfo &rFiAxes );


/**************************************************************************//**
 * @brief copy hwinfo from OSAL struct to fi class
 ******************************************************************************/
static tVoid
vVdsCopyOsalToFiOneAxes ( const OSAL_trSensorHwInfo &rOsalHwInfoAxes,
                          sensor_fi_tcl_SensorHwInfo &rFiAxes )
/**************************************************************************//**
 * [long description]
 ******************************************************************************/
{
   rFiAxes.AdcRangeMin           = rOsalHwInfoAxes.u32AdcRangeMin;
   rFiAxes.AdcRangeMax           = rOsalHwInfoAxes.u32AdcRangeMax;
   rFiAxes.SampleMin             = rOsalHwInfoAxes.u32SampleMin;
   rFiAxes.SampleMax             = rOsalHwInfoAxes.u32SampleMax;
   rFiAxes.MinNoiseValue         = rOsalHwInfoAxes.f32MinNoiseValue;
   rFiAxes.EstimOffset           = rOsalHwInfoAxes.f32EstimOffset;
   rFiAxes.MinOffset             = rOsalHwInfoAxes.f32MinOffset;
   rFiAxes.MaxOffset             = rOsalHwInfoAxes.f32MaxOffset;
   rFiAxes.DriftOffset           = rOsalHwInfoAxes.f32DriftOffset;
   rFiAxes.MaxUnsteadOffset      = rOsalHwInfoAxes.f32MaxUnsteadOffset;
   rFiAxes.BestCalibOffset       = rOsalHwInfoAxes.f32BestCalibOffset;
   rFiAxes.EstimScaleFactor      = rOsalHwInfoAxes.f32EstimScaleFactor;
   rFiAxes.MinScaleFactor        = rOsalHwInfoAxes.f32MinScaleFactor;
   rFiAxes.MaxScaleFactor        = rOsalHwInfoAxes.f32MaxScaleFactor;
   rFiAxes.DriftScaleFactor      = rOsalHwInfoAxes.f32DriftScaleFactor;
   rFiAxes.MaxUnsteadScaleFactor = rOsalHwInfoAxes.f32MaxUnsteadScaleFactor;
   rFiAxes.BestCalibScaleFactor  = rOsalHwInfoAxes.f32BestCalibScaleFactor;
   rFiAxes.DriftOffsetTime       = rOsalHwInfoAxes.f32DriftOffsetTime;
   rFiAxes.DriftScaleFactorTime  = rOsalHwInfoAxes.f32DriftScaleFactorTime;
};

/**************************************************************************//**
 * @brief copy hwinfo from ioctrl struct to fi class
 ******************************************************************************/
tVoid
vVdsCopyOsalToFiHwInfo (const OSAL_trIOCtrlHwInfo &rHwInfo,
                        sensor_fi_tcl_3dMountAngles &MountAngles, 
                        sensor_fi_tcl_SensorHwInfo &rRAxes,       
                        sensor_fi_tcl_SensorHwInfo &rSAxes,
                        sensor_fi_tcl_SensorHwInfo &rTAxes)
/**************************************************************************//**
 * takes the OSALIO struct of type OSAL_trIOCtrlHwInfo and copy it 
 * the sensor_location_fi class sensor_fi_hwinfo. Since there is one
 * class for the Gyro and one for the Acc the member elements
 * MountAngles and the axes are passed sepereatly
 ******************************************************************************/
{
   MountAngles.AngRX = rHwInfo.rMountAngles.u8AngRX;
   MountAngles.AngRY = rHwInfo.rMountAngles.u8AngRY;
   MountAngles.AngRZ = rHwInfo.rMountAngles.u8AngRZ;
   MountAngles.AngSX = rHwInfo.rMountAngles.u8AngSX;
   MountAngles.AngSY = rHwInfo.rMountAngles.u8AngSY;
   MountAngles.AngSZ = rHwInfo.rMountAngles.u8AngSZ;
   MountAngles.AngTX = rHwInfo.rMountAngles.u8AngTX;
   MountAngles.AngTY = rHwInfo.rMountAngles.u8AngTY;
   MountAngles.AngTZ = rHwInfo.rMountAngles.u8AngTZ;

   vVdsCopyOsalToFiOneAxes( rHwInfo.rRAxes, rRAxes );
   vVdsCopyOsalToFiOneAxes( rHwInfo.rSAxes, rSAxes );
   vVdsCopyOsalToFiOneAxes( rHwInfo.rTAxes, rTAxes );
};
