#ifndef tclSensorMsgDispatcher_h
#define tclSensorMsgDispatcher_h 1

#define VDS_C_S32_DISPATCHER_UNINITIALIZED      (tS32)0
#define VDS_C_S32_DISPATCHER_INITIALIZED        (tS32)1

// errors
#define VDS_E_DISPATCHER_ALLOC_ERROR            -1
#define VDS_E_DISPATCHER_FKT_ID_NOT_SUPPORTED   -2
#define VDS_E_DISPATCHER_UNINITIALIZED          -3
#define VDS_E_DISPATCHER_SETDATA_ERROR          -4
#define VDS_E_DISPATCHER_IF_ERROR               -5
#define VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED   -6
#define VDS_E_DISPATCHER_UNKNOWN_ERROR          -7
#define VDS_E_DISPATCHER_SUBSCRIBER_ERROR       -8

// see additional typedef at the end of this file!
/*!
 * \brief Defines the interface for Sensormessage dispatcher
*/
class tclSensorMsgDispatcher
{

   public:
      tclSensorMsgDispatcher();

      ~tclSensorMsgDispatcher();

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //    initializes SensorMsgDispatcher, sets pointer to Msg__If-objects
      //
      //  PARAMETER :
      //    tclMsgGpsIf *poGpsIf (->I)
      //       gps-interface
      //    tclMsgGyroIf *poGyroIf (->I)
      //       gyro-interface
      //    tclMsgOdometerIf *poOdometerIf (->I)
      //       odometer-interface
      //    vds_tclMsgAbsIf *poMsgAbsIf (->I)
      //       Abs-interface
      //    vds_tclMsgSteeringIf *poMsgSteeringIf (->I)
      //       Steering-interface
      //    tclMsgIerrorIf poIerrorIf (->I)
      //       error-interface
      //  RETURNVALUE: tS32
      //    Succes code in case of success is:
      //       VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //       VDS_E_INVALID_PARAMETER :   Invalid Parameter
      //       VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 04.04.02          CM-DI/ESA1-Fischer               Initial Revision.
      //******************************************************************************
      tS32 s32Init (
         tclMsgGpsIf *poGpsIf,
         tclMsgGyroIf *poGyroIf,
         tclMsgAccIf *poAccIf,
         tclMsgOdometerIf *poOdometerIf,
         vds_tclMsgAbsIf *poMsgAbsIf
         #ifdef VARIANT_S_FTR_IERROR_MESSAGE
         , tclMsgIerrorIf *poIerrorIf
#endif
      );
      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //  brief
      //    closes sensor-message-dispatcher
      //
      //  PARAMETER :
      //    None
      //  RETURNVALUE: tS32
      //    Succes code in case of success is:
      //       VDS_E_NO_ERROR : Success\n
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 04.04.02          CM-DI/ESA1-Fischer               Initial Revision.
      //******************************************************************************
      tS32 s32Close ();

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //   brief
      //    dispatches sensor-msg,an answer- or error-message will be created
      //
      //   parameter
      //     amt_tclServiceData *poServiceData (->I)
      //     received message
      //     amt_tclServiceData **ppoResponseMessage (->O)
      //     pointer to response-message
      //     amt_tclServiceDataError **ppoErrorMessage (->O)
      //     pointer to response-error-message
      //   return
      //    Succes code in case of success is:
      //       VDS_E_NO_ERROR : Success\n
      //   Error code in case of failure are:\n
      //       VDS_E_INVALID_PARAMETER :   Invalid Parameter
      //       VDS_E_DISPATCHER_FKT_ID_NOT_SUPPORTED :   Function ID not supported
      //       VDS_E_DISPATCHER_UNINITIALIZED : Dispatcher uninitialized
      //       VDS_E_INVALID_PARAMETER : Invalid Parameter
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 04.04.02           CM-DI/ESA1-Fischer              Initial Revision
      //******************************************************************************
      tS32 s32DispatchSensorMsg ( amt_tclServiceData *poServiceData, amt_tclServiceData **ppoResponseMessage, amt_tclServiceDataError **ppoErrorMessage );

//#ifdef VARIANT_S_FTR_ENABLE_TRITON_SUPPORT
#if defined(VARIANT_S_FTR_ENABLE_TRITON_SUPPORT) && !defined (VARIANT_S_FTR_DISABLE_DIAGLOG)

    // ***************** F U N C T I O N  H E A D E R *****************************
    //
    //  DESCRIPTION:
    //
    // brief
    //   Dispatches Diaglog message received for "SendNextTestResutl" by Diaglog Server.
    // Parameter
    //   poServiceData - Service Data Information
    // return
    //   None
    //  HISTORY:
    // Date            |  Author                       | MODIFICATION
    // ----------------------------------------------------------------------------
    // 16.12.2010    sak9kor (RBEI/ECF1)  Initial Version
    //******************************************************************************
      tVoid vDispatchDiaglogMsg ( amt_tclServiceData* poServiceData );
      // Additional Public Declarations
#endif
   protected:
      // Additional Protected Declarations

   private:

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //brief
      // Dispatches sensor message received for "OdometerData_Update" property from client.
      //   Reply or error message will be created which will be used to send client as response.
      // PARAMETER:
      //              amt_tclServiceData *poServiceData (->I)
      //                  received message
      //              amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //              amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      // return
      //  Succes code in case of success is:
      //     VDS_E_NO_ERROR : Success\n
      //  Error code in case of failure are:\n
      //    VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //    VDS_E_DISPATCHER_UNKNOWN_ERROR :  Dispather Unknown error
      //    VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 04.04.02        | CM-DI/ESA1-Fischer            | Initial Revision.
      //******************************************************************************
      tS32 s32DispatchOdometerDataUpdate ( amt_tclServiceData *poServiceData, amt_tclServiceData **ppoResponseMessage, amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      // brief
      // Dispatches sensor message received for "Gyro3dGetHwInfo" method from client.
      // Reply or error message will be created which will be used to send
      // client as response.
      //
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //    return
      //    Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //      VDS_E_DISPATCHER_IF_ERROR             : Dispather IF error
      //      VDS_E_DISPATCHER_ALLOC_ERROR          : Allocation error
      //      VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 04.05.2011      | Joachim Friess (CM-AI/PJ-CF31)| Initial Version
      //******************************************************************************
      tS32 s32DispatchGyro3dGetHwInfo ( amt_tclServiceData *poServiceData, 
                                        amt_tclServiceData **ppoResponseMessage, 
                                        amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      // brief
      // Dispatches sensor message received for "Gyro3dData_Update" property from client.
      // Reply or error message will be created which will be used to send
      // client as response.
      //
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //    return
      //    Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //      VDS_E_DISPATCHER_IF_ERROR             : Dispather IF error
      //      VDS_E_DISPATCHER_ALLOC_ERROR          : Allocation error
      //      VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 04.05.2011      | Joachim Friess (CM-AI/PJ-CF31)| Initial Version
      //******************************************************************************
      tS32 s32DispatchGyro3dDataUpdate ( amt_tclServiceData *poServiceData, 
                                         amt_tclServiceData **ppoResponseMessage, 
                                         amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      // brief
      // Dispatches sensor message received for "ACC3dGetHwInfo" method from client.
      // Reply or error message will be created which will be used to send
      // client as response.
      //
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //    return
      //    Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //      VDS_E_DISPATCHER_IF_ERROR             : Dispather IF error
      //      VDS_E_DISPATCHER_ALLOC_ERROR          : Allocation error
      //      VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 04.05.2011      | Joachim Friess (CM-AI/PJ-CF31)| Initial Version
      //******************************************************************************
      tS32 s32DispatchAcc3dGetHwInfo ( amt_tclServiceData *poServiceData, 
                                       amt_tclServiceData **ppoResponseMessage, 
                                       amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      // brief
      // Dispatches sensor message received for "Acc3dData_Update" property from client.
      // Reply or error message will be created which will be used to send
      // client as response.
      //
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //    return
      //    Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //      VDS_E_DISPATCHER_IF_ERROR             :   Dispather IF error
      //      VDS_E_DISPATCHER_ALLOC_ERROR          : Allocation error
      //      VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 04.05.2011      | Joachim Friess (CM-AI/PJ-CF31)| Initial Version
      //******************************************************************************
      tS32 s32DispatchAcc3dDataUpdate ( amt_tclServiceData *poServiceData, 
                                        amt_tclServiceData **ppoResponseMessage, 
                                        amt_tclServiceDataError **ppoErrorMessage );


      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      // brief
      //    Dispatches sensor message received for "GPSExtData" property from client.
      //    Reply or error message will be created which will be used to send client as response.
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      // return
      //    Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //      VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //      VDS_E_DISPATCHER_UNKNOWN_ERROR :  Unknown error
      //      VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      tS32 s32DispatchGpsExtData (
         amt_tclServiceData *poServiceData,
         amt_tclServiceData **ppoResponseMessage,
         amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      // brief
      //    Dispatches sensor message received for "AllSensorData" property from client.
      //    Reply or error message will be created which will be used to send client as response.
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      // return
      //    Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //      VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //      VDS_E_DISPATCHER_UNKNOWN_ERROR :  Unknown error
      //      VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      tS32 s32DispatchAllSensorData
      (
         amt_tclServiceData *poServiceData,
           amt_tclServiceData **ppoResponseMessage,
         amt_tclServiceDataError **ppoErrorMessage
      );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      // brief
      //    Dispatches sensor message received for "GnssConfigData" property from client.
      //    Reply or error message will be created which will be used to send client as response.
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      // return
      //    Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //      VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //      VDS_E_DISPATCHER_UNKNOWN_ERROR :  Unknown error
      //      VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************       
      tS32 s32DispatchGnssConfigData
      (
         //!  (I) : pointer to income message
         amt_tclServiceData *poServiceData,
         //!  (O) : pointer to a location where a pointer to the reply message is
         //!  written if the input message is handled successfully
         amt_tclServiceData **ppoResponseMessage,
         //! (O) : pointer to a location where a pointer to an error message is
         //! written if an error occurred during handling of the input message
         amt_tclServiceDataError **ppoErrorMessage
      );
      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      // brief
      //    Dispatches sensor message received for "VdsVersionInfo" property from client.
      //    Reply or error message will be created which will be used to send client as response.
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      // return
      //    Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //      VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //      VDS_E_DISPATCHER_UNKNOWN_ERROR :  Unknown error
      //      VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************       
      tS32 s32DispatchVdsVersionInfo
      (
         //!  (I) : pointer to income message
         amt_tclServiceData *poServiceData,
         //!  (O) : pointer to a location where a pointer to the reply message is
         //!  written if the input message is handled successfully
         amt_tclServiceData **ppoResponseMessage,
         //! (O) : pointer to a location where a pointer to an error message is
         //! written if an error occurred during handling of the input message
         amt_tclServiceDataError **ppoErrorMessage
      );
      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      // brief
      //    Process sensor message received for "DiagGnssSatSystem" property from client.
      //    Reply or error message will be created which will be used to send client as response.
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      // return
      //    Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //      VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //      VDS_E_DISPATCHER_UNKNOWN_ERROR :  Unknown error
      //      VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************       
      tS32 s32DispatchDiagGnssSatSystem
      (
         //!  (I) : pointer to income message
         amt_tclServiceData *poServiceData,
         //!  (O) : pointer to a location where a pointer to the reply message is
         //!  written if the input message is handled successfully
         amt_tclServiceData **ppoResponseMessage,
         //! (O) : pointer to a location where a pointer to an error message is
         //! written if an error occurred during handling of the input message
         amt_tclServiceDataError **ppoErrorMessage
      );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      // brief
      //    Dispatches sensor message received for "GnssData" property from client.
      //    Reply or error message will be created which will be used to send client as response.
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      // return
      //    Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //    Error code in case of failure are:\n
      //      VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //      VDS_E_DISPATCHER_UNKNOWN_ERROR :  Unknown error
      //      VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************       
      tS32 s32DispatchGnssData
      (
         amt_tclServiceData *poServiceData,
         amt_tclServiceData **ppoResponseMessage,
         amt_tclServiceDataError **ppoErrorMessage
      );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //     brief
      //       Dispatches sensor message received for "GPSTightCouplingData" property from client.
      //       Reply or error message will be created which will be used to send client as response.
      //
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //    return
      //       Succes code in case of success is:
      //         VDS_E_NO_ERROR : Success\n
      //       Error code in case of failure are:\n
      //         VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //         VDS_E_DISPATCHER_UNKNOWN_ERROR :  Unknown error
      //         VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      tS32 s32DispatchGpsTightCouplingData (
         amt_tclServiceData *poServiceData,
         amt_tclServiceData **ppoResponseMessage,
         amt_tclServiceDataError **ppoErrorMessage );

      /* -- insert generated code here -- */

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //    brief
      //   Dispatches sensor message received for "UpdateDiagLog" Method from client.
      //   Reply or error message will be created which will be used to send client as response.
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //    return
      //   Succes code in case of success is:
      //       VDS_E_NO_ERROR : Success\n
      //   Error code in case of failure are:\n
      //       VDS_E_DISPATCHER_ALLOC_ERROR :  Allocation Error
      //       VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      tS32 s32DispatchUpdateDiagLog (
         amt_tclServiceData *poServiceData,
         amt_tclServiceData **ppoResponseMessage,
         amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //    brief
      //   Dispatches sensor message received for "ABSData" property from client.
      //   Reply or error message will be created which will be used to send client as response.
      //
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //   return
      //   Succes code in case of success is:
      //      VDS_E_NO_ERROR : Success\n
      //   Error code in case of failure are:\n
      //     VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //     VDS_E_DISPATCHER_UNKNOWN_ERROR :  Dispather Unknown error
      //     VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      tS32 s32DispatchAbsData (
         amt_tclServiceData *poServiceData,
         amt_tclServiceData **ppoResponseMessage,
         amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //   brief
      //   Dispatches sensor message received for "Factory Settings" Method from client.
      //   Reply or error message will be created which will be used to send client as response.
      //
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //    return
      //   Succes code in case of success is:
      //     VDS_E_NO_ERROR : Success\n
      //   Error code in case of failure are:\n
      //     VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //     VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
      //     VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      tS32 s32DispatchFactorySettings (
         amt_tclServiceData *poServiceData,
         amt_tclServiceData **ppoResponseMessage,
         amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //    brief
      //   Dispatches sensor message received for "UpdateFactory Settings" Method from client.
      //   Reply or error message will be created which will be used to send client as response.
      //!
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //    return
      //   Succes code in case of success is:
      //     VDS_E_NO_ERROR : Success\n
      //   Error code in case of failure are:\n
      //     VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //     VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
      //     VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //******************************************************************************
      tS32 s32DispatchUpdateFactorySettings (
         amt_tclServiceData *poServiceData,
         amt_tclServiceData **ppoResponseMessage,
         amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //    brief
      //       Dispatches sensor message received for "DistanceCalibration" property from client.
      //       Reply or error message will be created which will be used to send client as response.
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //   return
      //   Succes code in case of success is:
      //     VDS_E_NO_ERROR : Success\n
      //   Error code in case of failure are:\n
      //     VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //     VDS_E_DISPATCHER_UNKNOWN_ERROR : Unknown error
      //     VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author               | MODIFICATION
      // ----------------------------------------------------------------------------
      // 04.04.02       | CM-DI/ESA1-Fischer     | Initial Revision.
      //******************************************************************************
      tS32 s32DispatchDistanceCalibration ( amt_tclServiceData *poServiceData, amt_tclServiceData **ppoResponseMessage, amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //   brief
      //   Dispatches sensor message received for "TimeofDay" property from client.
      //   Reply or error message will be created which will be used to send client as response.
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //   return
      //   Succes code in case of success is:
      //     VDS_E_NO_ERROR : Success\n
      //   Error code in case of failure are:\n
      //     VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //     VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
      //     VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 8.04.03           CM-CR/EES4-Bode                  Initial Revision.
      //******************************************************************************
      tS32 s32DispatchTimeOfDay ( amt_tclServiceData *poServiceData, amt_tclServiceData **ppoResponseMessage, amt_tclServiceDataError **ppoErrorMessage );

#ifdef VARIANT_S_FTR_GYRO_SELFTEST
      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //   brief
      //   Dispatches sensor message received for "IErrorMsgt" property from client.
      //   Reply or error message will be created which will be used to send client as response.
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //   return
      //   Succes code in case of success is:
      //     VDS_E_NO_ERROR : Success\n
      //   Error code in case of failure are:\n
      //     VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //     VDS_E_DISPATCHER_UNKNOWN_ERROR : Unknown error
      //     VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //    03.06.03        R. Schedel                 Initial Revision.
      //******************************************************************************
      tS32 s32DispatchIErrorMsg ( amt_tclServiceData *poServiceData, amt_tclServiceData **ppoResponseMessage, amt_tclServiceDataError **ppoErrorMessage );
#endif

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //    /brief dispatces the gyro temperature property
      //    
      //
      //   PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //
      //    /return
      //   Succes code in case of success is:
      //     VDS_E_NO_ERROR : Success\n
      //   Error code in case of failure are:\n
      //     VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //     VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
      //     VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 17.09.12          CM-DI/PJ-CF31                  added.
      //******************************************************************************
      tS32 s32DispatchGyroTemperature ( amt_tclServiceData       *poServiceData,
                                        amt_tclServiceData      **ppoResponseMessage,
                                        amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //    /brief dispatches the gnssSatSystem property
      //
      //   PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //
      //    /return
      //   Succes code in case of success is:
      //     VDS_E_NO_ERROR : Success\n
      //   Error code in case of failure are:\n
      //     VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //     VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
      //     VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 17.09.12          CM-DI/PJ-CF31                  added.
      //******************************************************************************
      tS32 s32DispatchGnssSatSystem ( amt_tclServiceData       *poServiceData,
                                      amt_tclServiceData      **ppoResponseMessage,
                                      amt_tclServiceDataError **ppoErrorMessage );
      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //    /brief dispatches the GnssWnEpoch property
      //
      //   PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //
      //    /return
      //   Succes code in case of success is:
      //     VDS_E_NO_ERROR : Success\n
      //   Error code in case of failure are:\n
      //     VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //     VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
      //     VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 04.12.12          CM-DI/PJ-CF31 fsj2hi             added.
      //******************************************************************************
      tS32 s32DispatchGnssWnEpoch( amt_tclServiceData       *poServiceData,
                                   amt_tclServiceData      **ppoResponseMessage,
                                   amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //    /brief dispatches the TimeMode property
      //
      //   PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //
      //    /return
      //   Succes code in case of success is:
      //     VDS_E_NO_ERROR : Success\n
      //   Error code in case of failure are:\n
      //     VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
      //     VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
      //     VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
      //
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 17.09.12          CM-DI/PJ-CF31 fsj2hi             added.
      //******************************************************************************
      tS32 s32DispatchTimeMode ( amt_tclServiceData       *poServiceData,
                                 amt_tclServiceData      **ppoResponseMessage,
                                 amt_tclServiceDataError **ppoErrorMessage );


      tS32 s32DispatchAccSelftest ( amt_tclServiceData *poServiceData, 
                                    amt_tclServiceData **ppoResponseMessage, 
                                    amt_tclServiceDataError **ppoErrorMessage );

      tS32 s32DispatchGyroSelftest ( amt_tclServiceData *poServiceData,
                                     amt_tclServiceData **ppoResponseMessage, 
                                     amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //    brief
      //      adds subscriber to subscriber-list. whenever a value is changed, the subscriber-list will
      //      be checked and a state-message will be sent
      //   PARAMETER:
      //        amt_tclServiceData *poServiceData (->I)
      //        received message
      //        amt_tclServiceDataError **ppoErrorMessage (->O)
      //        pointer to response-error-message
      //    return
      //        Subscriber pointer:  if add subscriber is successfull:
      //        NULL : If error occurs while creating subscriber
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 05.04.02          CM-DI/ESA1-Fischer               Initial Revision.
      // 17.05.02          CM-DI/ESA1-Fischer               return-value changed.
      //******************************************************************************
      tclSubscriberManager * poAddSubscriber ( amt_tclServiceData *poServiceData, amt_tclServiceDataError **ppoErrorMessage );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //    brief
      //       returns subscriber with given id from subscriber-list.
      //    PARAMETERS:
      //       amt_tclServiceData *poServiceData - Pointer to ServiceData
      //    return
      //     Subscriber pointer:  if get subscriber is successfull:
      //     NULL : If error occurs while creating subscriber
      //  HISTORY:
      //    Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      //    17.05.02          CM-DI/ESA1-Fischer               Initial Revision.
      //******************************************************************************
      tclSubscriberManager * poGetSubscriber (const amt_tclServiceData *poServiceData );

      // ***************** F U N C T I O N  H E A D E R *****************************
      //
      //  DESCRIPTION:
      //
      //    brief
      //    deletes subscribers with given ids from subscriber-list.
      //  PARAMETER:
      //               amt_tclServiceData *poServiceData (->I)
      //                  received message
      //               amt_tclServiceData **ppoResponseMessage (->O)
      //                  pointer to response-message
      //               amt_tclServiceDataError **ppoErrorMessage (->O)
      //                  pointer to response-error-message
      //    return
      //   Succes code in case of success is:
      //     VDS_E_NO_ERROR : Success\n
      //  HISTORY:
      // Date            |  Author                       | MODIFICATION
      // ----------------------------------------------------------------------------
      // 05.04.02          CM-DI/ESA1-Fischer               Initial Revision.
      // 21.05.02          CM-DI/ESA1-Fischer               Parameter ppoResponseMessage added.
      //******************************************************************************
      tS32 s32DeleteSubscriber ( const amt_tclServiceData *poServiceData, amt_tclServiceData **ppoResponseMessage, amt_tclServiceDataError **ppoErrorMessage );

      // Data Members for Class Attributes

      tclMsgGpsIf *poMsgGpsIf;
      tclMsgGyroIf *poMsgGyroIf;
      tclMsgAccIf *poMsgAccIf;
      tclMsgOdometerIf *poMsgOdometerIf;
      vds_tclMsgAbsIf *poMsgAbsIf;
      //vds_tclMsgSteeringIf *poMsgSteeringIf;
#ifdef VARIANT_S_FTR_IERROR_MESSAGE
      tclMsgIerrorIf *poMsgIerrorIf;
#endif
      tS32 s32InternalState;

#ifdef VARIANT_S_FTR_IERROR_MESSAGE
      typedef tS32 ( tclSensorMsgDispatcher:: **tppfDispatchMsgTable )( amt_tclServiceData *poServiceData, amt_tclServiceData **, amt_tclServiceDataError ** );
#endif
      tS32 ( tclSensorMsgDispatcher:: **ppfDispatchMsgTable )( amt_tclServiceData *poServiceData, amt_tclServiceData **, amt_tclServiceDataError ** );

      // Additional Private Declarations
#ifdef VARIANT_S_FTR_IERROR_MESSAGE
      tS32 ( tclSensorMsgDispatcher:: **ppfDispatchIErrorMsgTable )( amt_tclServiceData *poServiceData, amt_tclServiceData **, amt_tclServiceDataError ** );
#endif
};

// vds_tpfMsgDispatcher is a pointer to a class-member-function
typedef tS32( tclSensorMsgDispatcher::*vds_tpfMsgDispatcher )(
   class amt_tclServiceData *,
   class amt_tclServiceData **,
   class amt_tclServiceDataError ** );

// Class tclSensorMsgDispatcher

#endif
