#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#if OSAL_OS==OSAL_NUCLEUS
#define SYSTEM_S_IMPORT_INTERFACE_ERRMEM_DEF
#include "system_pif.h"
#endif //OSAL_OS==OSAL_NUCLEUS

#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_TYPES
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_ERRORCODES
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_FUNCTIONIDS
#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_SERVICEINFO
#include "sensor_fi_if.h"
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "fi_msgfw_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "midw_fi_if.h"


#define SENSOR_S_IMPORT_INTERFACE_SERVER
#include "vds2_if.h"

//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_TYPES
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_DIAGLOGFI_SERVICEINFO
#include "midw_fi_if.h"
//#include "midw_diaglogfitypes.h"
//#include "midw_diaglogfiserviceinfo.h"


#define VDS_S_IMPORT_INTERFACE_AIL_VDSENSOR
#define VDS_S_IMPORT_INTERFACE_MESSAGE_INTERFACES
#define VDS_S_IMPORT_INTERFACE_MESSAGE_DISPATCHER
#define VDS_S_IMPORT_INTERFACE_TRACE
#include "vds_internal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
/*Since gyro temperature propery doesn't provide the time interval option, hence
we consider to send the gyro temperature every 10 seconds to the subscribers*/
#define GYRO_TEMPERATURE_MSG_INTERVAL 10


tS32 s32GetAllSensorDataMsg
(
   //! (I) : Pointer to Service data
   amt_tclServiceData const *poServiceData,
   //! (I) : Pointer to Subscriber data
   tclSubscriberManager *poSubscriber,
   //! (O) : pointer to a location where a pointer to the reply message is available
   amt_tclServiceData **ppoResponseMessage,
   //! (I) :Next elements to read
   Vds_AllSenDataNextElemToSend &rNextElmToRead
);

void vGetTimeStamp( tPU32 pu32TimeStamp );


#ifdef VARIANT_S_FTR_ENABLE_TRITON_SUPPORT
tU16 *pu16_ITCListBufferpointer = OSAL_NULL;
#endif

//Duplicate pointers of Message interface objects.
static tclMsgGpsIf *poMsgGpsIfDup=OSAL_NULL;
static tclMsgGyroIf *poMsgGyroIfDup=OSAL_NULL;
static tclMsgAccIf *poMsgAccIfDup=OSAL_NULL;
static tclMsgOdometerIf *poMsgOdometerIfDup=OSAL_NULL;
static vds_tclMsgAbsIf *poMsgAbsIfDup=OSAL_NULL;


// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Constructor for  tclSensorMsgDispatcher
//!
//! \return
//!  None
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tclSensorMsgDispatcher::tclSensorMsgDispatcher()
      : poMsgGpsIf( OSAL_NULL ),
        poMsgGyroIf( OSAL_NULL ),
        poMsgAccIf(OSAL_NULL),
        poMsgOdometerIf( OSAL_NULL ),
        poMsgAbsIf( OSAL_NULL ),
        //poMsgSteeringIf( OSAL_NULL ),
#ifdef VARIANT_S_FTR_IERROR_MESSAGE
        poMsgIerrorIf( OSAL_NULL ),
#endif
        s32InternalState( VDS_C_S32_DISPATCHER_UNINITIALIZED ),
        ppfDispatchMsgTable( OSAL_NULL )
#ifdef VARIANT_S_FTR_IERROR_MESSAGE
        ,ppfDispatchIErrorMsgTable( OSAL_NULL )
#endif
{
   vTraceMsg( VDS_C_TRACELEVEL_COMPONENT,
	      "tclSensorMsgDispatcher::tclSensorMsgDispatcher()" );
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Destructor for  tclSensorMsgDispatcher
//!
//! \return
//!  None
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tclSensorMsgDispatcher::~tclSensorMsgDispatcher()
{
   vTraceMsg( VDS_C_TRACELEVEL_COMPONENT,
          "tclSensorMsgDispatcher::~tclSensorMsgDispatcher()" );
   poMsgGpsIf = OSAL_NULL;
   poMsgGyroIf = OSAL_NULL;
   poMsgOdometerIf = OSAL_NULL;
   poMsgAbsIf = OSAL_NULL;
   poMsgAccIf = OSAL_NULL;
   //poMsgSteeringIf = OSAL_NULL;
   #ifdef VARIANT_S_FTR_IERROR_MESSAGE
   poMsgIerrorIf = OSAL_NULL;
   #endif

   if( NULL != ppfDispatchMsgTable )
   {
      delete [] ppfDispatchMsgTable;
      ppfDispatchMsgTable = NULL;
   }

   #ifdef VARIANT_S_FTR_IERROR_MESSAGE
   if ( NULL != ppfDispatchIErrorMsgTable )
   {
      delete [] ppfDispatchIErrorMsgTable;
      ppfDispatchIErrorMsgTable = NULL;
   }
   #endif

   s32InternalState = VDS_C_S32_DISPATCHER_UNINITIALIZED;
}
// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   initializes SensorMsgDispatcher, sets pointer to Msg__If-objects
//!
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_INVALID_PARAMETER :   Invalid Parameter
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32Init
(
   //!  (I) : pointer to Gps Interface
   tclMsgGpsIf *poGpsIf,
   //!  (I) : pointer to Gyro Interface
   tclMsgGyroIf *poGyroIf,
   //!  (I) : pointer to Accelerometer Interface
   tclMsgAccIf *poAccIf,
   //!  (I) : pointer to Odo Interface
   tclMsgOdometerIf *poOdometerIf,
   //!  (I) : pointer to Abs Interface
   vds_tclMsgAbsIf * poAbsIf
   #ifdef VARIANT_S_FTR_IERROR_MESSAGE
   //!  (I) : pointer to error Interface
   , tclMsgIerrorIf *poIerrorIf
   #endif
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;

   vTraceMsg( VDS_C_TRACELEVEL_COMPONENT,
          "tclSensorMsgDispatcher::s32Init() start" );

   // param-check
   if( NULL != poGpsIf )
   {
      poMsgGpsIf = poGpsIf;
      poMsgGpsIfDup =poGpsIf;
   }
   else
   {
      s32RetVal = VDS_E_INVALID_PARAMETER;
   }
   
   if( NULL != poGyroIf )
   {
      poMsgGyroIf = poGyroIf;
      poMsgGyroIfDup = poGyroIf;
   }

   if( NULL != poAccIf)
   {
      poMsgAccIf =  poAccIf;
      poMsgAccIfDup = poAccIf;
   }

   if( NULL != poOdometerIf )
   {
      poMsgOdometerIf = poOdometerIf;
      poMsgOdometerIfDup = poOdometerIf;
   }

   if( NULL != poAbsIf )
   {
      poMsgAbsIf = poAbsIf;
      poMsgAbsIfDup = poAbsIf;
   }

   #ifdef VARIANT_S_FTR_IERROR_MESSAGE
   if( NULL != poIerrorIf )
   {
      poMsgIerrorIf = poIerrorIf;
   }
   else
   {
      s32RetVal = VDS_E_INVALID_PARAMETER;
   }
   #endif

   if( VDS_E_NO_ERROR == s32RetVal )
   {
      // create msg-table
      ppfDispatchMsgTable = new vds_tpfMsgDispatcher[ VDS_C_U16_FKTID_MAX_ID + 1 ];

      if( NULL != ppfDispatchMsgTable )
      {
         // reset msg-table
         OSAL_pvMemorySet( ppfDispatchMsgTable, 0,
                           ( VDS_C_U16_FKTID_MAX_ID + 1 )*sizeof( vds_tpfMsgDispatcher ) );
         // set msg-table

         ppfDispatchMsgTable[ VDS_C_U16_FKTID_ODOMDATA_UPDATE ] =
                         &tclSensorMsgDispatcher::s32DispatchOdometerDataUpdate;

         /* ppfDispatchMsgTable[ VDS_C_U16_FKTID_DISTCAL ] = */
         /*                 &tclSensorMsgDispatcher::s32DispatchDistanceCalibration; */

         ppfDispatchMsgTable[ VDS_C_U16_FKTID_UPDATEDIAGLOG  ] =
                         &tclSensorMsgDispatcher::s32DispatchUpdateDiagLog;		 
         ppfDispatchMsgTable[ VDS_C_U16_FKTID_ABSDATA   ] =
                         &tclSensorMsgDispatcher::s32DispatchAbsData;

         ppfDispatchMsgTable[VDS_C_U16_FKTID_GNSSSATSYSTEM] =
            &tclSensorMsgDispatcher::s32DispatchGnssSatSystem;		 

         ppfDispatchMsgTable[ VDS_C_U16_FKTID_GNSSWNEPOCH ] =
                         &tclSensorMsgDispatcher::s32DispatchGnssWnEpoch;	

         ppfDispatchMsgTable[ VDS_C_U16_FKTID_UPDATEFACTORYSETTINGS ] =
                         &tclSensorMsgDispatcher::s32DispatchUpdateFactorySettings;

         ppfDispatchMsgTable[ VDS_C_U16_FKTID_GYRO3DGETHWINFO ] =
                         &tclSensorMsgDispatcher::s32DispatchGyro3dGetHwInfo;

         ppfDispatchMsgTable[ SENSOR_LOCATIONFI_C_U16_GYROSELFTEST ] =
                         &tclSensorMsgDispatcher::s32DispatchGyroSelftest;

         ppfDispatchMsgTable[ SENSOR_LOCATIONFI_C_U16_ACCSELFTEST] =
                         &tclSensorMsgDispatcher::s32DispatchAccSelftest;

         ppfDispatchMsgTable[ VDS_C_U16_FKTID_GYRO3DDATAUPDATE ] =
                         &tclSensorMsgDispatcher::s32DispatchGyro3dDataUpdate;

         ppfDispatchMsgTable[ VDS_C_U16_FKTID_ACC3DGETHWINFO ] =
                         &tclSensorMsgDispatcher::s32DispatchAcc3dGetHwInfo;

         ppfDispatchMsgTable[ VDS_C_U16_FKTID_ACC3DDATAUPDATE ] =
                         &tclSensorMsgDispatcher::s32DispatchAcc3dDataUpdate;

         ppfDispatchMsgTable[ VDS_C_U16_FKTID_GYROTEMPERATURE ] =
                         &tclSensorMsgDispatcher::s32DispatchGyroTemperature;

         /* ppfDispatchMsgTable[ VDS_C_U16_FKTID_TIMEMODE ] = */
         /*                 &tclSensorMsgDispatcher::s32DispatchTimeMode; */

         ppfDispatchMsgTable[ VDS_C_U16_FKTID_GNSSDATA ] =
                          &tclSensorMsgDispatcher::s32DispatchGnssData;

         ppfDispatchMsgTable[ VDS_C_U16_FKTID_GNSSCONFIGDATA ] =
                          &tclSensorMsgDispatcher::s32DispatchGnssConfigData;

         ppfDispatchMsgTable[VDS_C_U16_FKTID_ALLSENSORDATA] =
                          &tclSensorMsgDispatcher::s32DispatchAllSensorData;

         ppfDispatchMsgTable[VDS_C_U16_FKTID_VDSVERSIONINFO] =
                          &tclSensorMsgDispatcher::s32DispatchVdsVersionInfo;

         ppfDispatchMsgTable[VDS_C_U16_FKTID_DIAGGNSSSATSYSTEM] =
                       &tclSensorMsgDispatcher::s32DispatchDiagGnssSatSystem;


      }
      else
      {
         s32RetVal = VDS_E_DISPATCHER_ALLOC_ERROR;
      }
   }

   //The following function IDs and the VARIANT_S_FTR_IERROR_MESSAGE macro
   //are not defined.What to do with this,Can be removed or not.
   #ifdef VARIANT_S_FTR_IERROR_MESSAGE

   if ( VDS_E_NO_ERROR == s32RetVal )
   {
      // create msg-table
      ppfDispatchIErrorMsgTable = new vds_tpfMsgDispatcher[ VDS_C_U16_FKTID_ERR_MAX_ID + 1 ];

      if ( NULL != ppfDispatchIErrorMsgTable )
      {
         // reset msg-table
         OSAL_pvMemorySet( ppfDispatchIErrorMsgTable, 0,
                           ( VDS_C_U16_FKTID_ERR_MAX_ID + 1 )*sizeof( vds_tpfMsgDispatcher ) );
         // set msg-table
         // for now all fktid's will share one dispatch entry function
         ppfDispatchIErrorMsgTable[ VDS_C_U16_FKTID_ERR_INVAL_ODOM        ] =
            &tclSensorMsgDispatcher::s32DispatchIErrorMsg;
         ppfDispatchIErrorMsgTable[ VDS_C_U16_FKTID_ERR_GPS_ANT_BREAK     ] =
            &tclSensorMsgDispatcher::s32DispatchIErrorMsg;
         ppfDispatchIErrorMsgTable[ VDS_C_U16_FKTID_ERR_GPS_ANT_SHORT     ] =
            &tclSensorMsgDispatcher::s32DispatchIErrorMsg;
         ppfDispatchIErrorMsgTable[ VDS_C_U16_FKTID_ERR_GYRO_EXT_TEST     ] =
            &tclSensorMsgDispatcher::s32DispatchIErrorMsg;
         ppfDispatchIErrorMsgTable[ VDS_C_U16_FKTID_ERR_ODOM_NOINFO       ] =
            &tclSensorMsgDispatcher::s32DispatchIErrorMsg;
         ppfDispatchIErrorMsgTable[ VDS_C_U16_FKTID_ERR_ODOM_ERROR        ] =
            &tclSensorMsgDispatcher::s32DispatchIErrorMsg;
      }
      else
      {
         s32RetVal = VDS_E_DISPATCHER_ALLOC_ERROR;
      }
   }

   #endif
   
   s32InternalState = VDS_C_S32_DISPATCHER_INITIALIZED;
   
   vTraceMsg( VDS_C_TRACELEVEL_COMPONENT,
              "tclSensorMsgDispatcher::s32Init() ended with %i", s32RetVal );

   return s32RetVal;

}
// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   closes sensor-message-dispatcher
//!
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32Close ()
{
   s32InternalState = VDS_C_S32_DISPATCHER_UNINITIALIZED;

   if ( NULL != ppfDispatchMsgTable )
   {
      delete [] ppfDispatchMsgTable;
      ppfDispatchMsgTable = NULL;
   }

   #ifdef VARIANT_S_FTR_IERROR_MESSAGE
   if ( NULL != ppfDispatchIErrorMsgTable )
   {
      delete [] ppfDispatchIErrorMsgTable;
      ppfDispatchIErrorMsgTable = NULL;
   }
   #endif
   
   poMsgGpsIf      = NULL;
   poMsgGyroIf     = NULL;
   poMsgOdometerIf = NULL;
   poMsgAbsIf      = OSAL_NULL;
   //poMsgSteeringIf      = OSAL_NULL;
   #ifdef VARIANT_S_FTR_IERROR_MESSAGE
   poMsgIerrorIf   = NULL;
   #endif

   return VDS_E_NO_ERROR;
}
// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   dispatches sensor-msg,an answer- or error-message will be created
//!
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_INVALID_PARAMETER :   Invalid Parameter
//!   - \c VDS_E_DISPATCHER_FKT_ID_NOT_SUPPORTED :   Function ID not supported
//!   - \c VDS_E_DISPATCHER_UNINITIALIZED : Dispatcher uninitialized
//!   - \c VDS_E_INVALID_PARAMETER : Invalid Parameter
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchSensorMsg
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message
   //!        is written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) :  pointer to a location where a pointer to an error message is
   //!        written if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;

   if (  NULL != poServiceData
         && NULL != ppoResponseMessage
         && NULL != ppoErrorMessage )
   {

      tU16 u16FunctionId = poServiceData->u16GetFunctionID();

      #ifdef VARIANT_S_FTR_IERROR_MESSAGE
      
      tU16 u16ServiceId = poServiceData->u16GetServiceID();
      tU16 u16MaxFktId = 0;

      if ( CCA_C_U16_SRV_SENSORS == u16ServiceId )
      {
         u16MaxFktId = VDS_C_U16_FKTID_MAX_ID;
         //ppfActualDispatchTable = ppfDispatchMsgTable;
      }
      else if ( CCA_C_U16_SRV_SENSORS_IERROR == u16ServiceId )
      {
         u16MaxFktId = VDS_C_U16_FKTID_ERR_MAX_ID;
         //ppfActualDispatchTable = ppfDispatchIErrorMsgTable;
      }
      else
         return VDS_E_INVALID_PARAMETER;

      if ( u16FunctionId <= u16MaxFktId )
      
      #else //VARIANT_S_FTR_IERROR_MESSAGE
      
      if ( u16FunctionId <= VDS_C_U16_FKTID_MAX_ID )
      #endif
      {

         if ( s32InternalState == VDS_C_S32_DISPATCHER_INITIALIZED )
         {
            #ifdef VARIANT_S_FTR_IERROR_MESSAGE
            if ( CCA_C_U16_SRV_SENSORS == u16ServiceId )
            {
               if ( ppfDispatchMsgTable != OSAL_NULL )
               {
                  if ( NULL != ppfDispatchMsgTable[ u16FunctionId ] )
                  {
                     s32RetVal = ( this->*ppfDispatchMsgTable[ u16FunctionId ] )( poServiceData, ppoResponseMessage, ppoErrorMessage );
                  }
                  else
                  {
                     // Error: FunctionID not supported
                     // error code defined in amt_ccamessages.h
                     vTraceMsg( VDS_C_TRACELEVEL_ERROR, "Unsupported function id 0x%x", u16FunctionId );
                     *ppoErrorMessage = new amt_tclServiceDataError( poServiceData, AMT_C_U16_ERROR_UNKNOWN_FCT_ID );
                     s32RetVal = VDS_E_DISPATCHER_FKT_ID_NOT_SUPPORTED;
                  }
               }
            }
            else if ( CCA_C_U16_SRV_SENSORS_IERROR == u16ServiceId )
            {
               if ( ( ppfDispatchIErrorMsgTable != OSAL_NULL )
                     && ( u16FunctionId < VDS_C_U16_FKTID_ERR_MAX_ID ) )
               {
                  if ( NULL != ppfDispatchIErrorMsgTable[ u16FunctionId ] )
                  {
                     s32RetVal = ( this->*ppfDispatchIErrorMsgTable[ u16FunctionId ] )( poServiceData, ppoResponseMessage, ppoErrorMessage );
                  }
                  else
                  {
                     // Error: FunctionID not supported
                     // error code defined in amt_ccamessages.h
                     vTraceMsg( VDS_C_TRACELEVEL_ERROR, "Unsupported function id 0x%x", u16FunctionId );
                     *ppoErrorMessage = new amt_tclServiceDataError( poServiceData, AMT_C_U16_ERROR_UNKNOWN_FCT_ID );
                     s32RetVal = VDS_E_DISPATCHER_FKT_ID_NOT_SUPPORTED;
                  }
               }
            }
            #else
            if ( ppfDispatchMsgTable != OSAL_NULL )
            {
               if ( NULL != ppfDispatchMsgTable[ u16FunctionId ] )
               {
                  s32RetVal = ( this->*ppfDispatchMsgTable[ u16FunctionId ] )( poServiceData, ppoResponseMessage, ppoErrorMessage );
               }
            }
            #endif
            else
            {
               // Error: FunctionID not supported
               // error code defined in amt_ccamessages.h
               vTraceMsg( VDS_C_TRACELEVEL_ERROR, "Unsupported function id 0x%x", u16FunctionId );
               *ppoErrorMessage = new amt_tclServiceDataError( poServiceData, AMT_C_U16_ERROR_UNKNOWN_FCT_ID );
               s32RetVal = VDS_E_DISPATCHER_FKT_ID_NOT_SUPPORTED;
            }
         }
         else
         {
            vTraceMsg( VDS_C_TRACELEVEL_ERROR, "Unsupported function id 0x%x (disp. uninit.)", u16FunctionId );
            *ppoErrorMessage = new amt_tclServiceDataError( poServiceData, VDS_E_INTERNAL_ERROR );
            s32RetVal = VDS_E_DISPATCHER_UNINITIALIZED;
         }
      }
      else
      {
         vTraceMsg( VDS_C_TRACELEVEL_ERROR, "Unsupported function id 0x%x (>max)", u16FunctionId );
         *ppoErrorMessage = new amt_tclServiceDataError( poServiceData, AMT_C_U16_ERROR_UNKNOWN_FCT_ID );
         s32RetVal = VDS_E_INVALID_PARAMETER;
      }
   }
   else
   {
      s32RetVal = VDS_E_INVALID_PARAMETER;
   }

   //In case of error log it to error memory.
   if( ( s32RetVal != VDS_E_NO_ERROR ) &&
       ( poServiceData != OSAL_NULL ) )
   {
      tU16 u16FunctionId = poServiceData->u16GetFunctionID();
      tU16 u16SourceId = poServiceData->u16GetSourceAppID();
      tU8  u8OpCode = poServiceData->u8GetOpCode();
      tU16 u16ErrorCode;

      if ( ( ppoErrorMessage != OSAL_NULL ) &&
           ( *ppoErrorMessage != OSAL_NULL ) )
      {
         u16ErrorCode = ( *ppoErrorMessage )->u16GetErrorData();
      }
      else
      {
         u16ErrorCode = 0x1977; // This should stand out
      }

      vTraceMsg( TR_LEVEL_ERROR,
                 "VD Sensor: fnct = 0x%x, src = %d, opc = %d: error = %d, rv = %d",
                           u16FunctionId,u16SourceId,u8OpCode,u16ErrorCode,s32RetVal );
   }

   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Dispatches sensor message received for "OdometerData_Update" property from client.
//!   Reply or error message will be created which will be used to send client as response.
//!
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_UNKNOWN_ERROR :  Dispather Unknown error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
// 25.06.2009   | sak9kor (RBEI/ECF1)    | XML generated FI has been adapted
//                                                            instead manual generated FI
// 29.06.2009   | sak9kor (RBEI/ECF1)    | Replacing the old nomenclature of the
//                                                          objects (As per review comment
//                                                          from Mr.Peter Koenig)
//  10.08.2009    | sak9kor (RBEI/ECF1)   | One more parameter has been added in
//                                                            s32GetOdomMessage function call
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchOdometerDataUpdate
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message
   //!        is written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) :  pointer to a location where a pointer to an error message is written
   //!        if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;

   // lock msg-if
   if ( ( poMsgOdometerIf != OSAL_NULL ) && ( poMsgOdometerIf->oCS.bEnter() ) )
   {
      // get opcode from message
      tU8  u8OpCode  = poServiceData->u8GetOpCode();

      switch ( u8OpCode )
      {
         case AMT_C_U8_CCAMSG_OPCODE_GET:
         {
            // create status-message
            // if check for subscriber is successful, no response and error-message will be created!
            // Get the index for the latest record
            tU32 u32NextElemToRead = poMsgOdometerIf->u32GetLastOdoElemIndex();
            // get odometer-message
            tS32 s32ElemsCreated = poMsgOdometerIf->s32GetOdomMessage(
                                 poServiceData,
                                 OSAL_NULL,
                                 ppoResponseMessage,
                                 OSAL_NULL,
                                 0,
                                 u32NextElemToRead,
                                 FALSE );

            if (  s32ElemsCreated <= 0
                  || OSAL_NULL == *ppoResponseMessage )
            {
               if ( VDS_E_ODOMIF_DATA_UNAVAILABLE == s32ElemsCreated )
               {
#if defined (VARIANT_S_FTR_ODOMETER_VIA_CAN)
                  s32ElemsCreated = poMsgOdometerIf->s32GetEmptyOdomMessage(
                                       poServiceData,
                                       ppoResponseMessage );
                  vTraceMsg( VDS_C_TRACELEVEL_COMPONENT, "Created empty odometer message" );
#else
                  *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError(
                                        poServiceData, VDS_E_DATA_UNAVAILABLE );
                  s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
#endif
               }
               else
               {
                  *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError(
                                        poServiceData, VDS_E_INTERNAL_ERROR );
                  s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
               }
            }
         } // end case AMT_C_U8_CCAMSG_OPCODE_GET
         break;
         case AMT_C_U8_CCAMSG_OPCODE_UPREG:
         {
            // create status-message
            tU32 u32NextElemToRead = 0;
            // get odometer-message
            tS32 s32ElemsCreated = poMsgOdometerIf->s32GetOdomMessage(
                                 poServiceData,
                                 OSAL_NULL,
                                 ppoResponseMessage,
                                 OSAL_NULL,
                                 0,
                                 u32NextElemToRead,
                                 TRUE );
#if defined (VARIANT_S_FTR_ODOMETER_VIA_CAN)

            if ( VDS_E_ODOMIF_DATA_UNAVAILABLE == s32ElemsCreated )
            {
               s32ElemsCreated = poMsgOdometerIf->s32GetEmptyOdomMessage(
                                    poServiceData,
                                    ppoResponseMessage );
               vTraceMsg( VDS_C_TRACELEVEL_COMPONENT, "Created empty odometer message" );
               tclSubscriberManager *poSubscriber = OSAL_NULL;

               if ( OSAL_NULL != ( poSubscriber = poAddSubscriber( poServiceData, ppoErrorMessage ) ) )
               {
                  // tclAilVDSensor-lock when sending messages needed
                  poSubscriber->vSetMessageLockNeeded( TRUE );
                  poSubscriber->vSetInitMessageSent( FALSE );
                  // set next elem to read
                  poSubscriber->vSetNextElemToRead( u32NextElemToRead );
               }
               else
               {
                  s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
                  OSAL_DELETE *ppoResponseMessage;
                  *ppoResponseMessage = OSAL_NULL;
               }
            }
            else
#endif
               if (  s32ElemsCreated > 0
                     && OSAL_NULL != *ppoResponseMessage )
               {
                  tclSubscriberManager *poSubscriber = poAddSubscriber( poServiceData, ppoErrorMessage );

                  if ( OSAL_NULL != poSubscriber )
                  {
                     // tclAilVDSensor-lock when sending messages needed
                     poSubscriber->vSetMessageLockNeeded( TRUE );
                     poSubscriber->vSetInitMessageSent( TRUE );
                     // set next elem to read
                     poSubscriber->vSetNextElemToRead( u32NextElemToRead );
                  }
                  else
                  {
                     s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
                     OSAL_DELETE *ppoResponseMessage;
                     *ppoResponseMessage = OSAL_NULL;
                  }
               }
               else
               {
                  if ( VDS_E_ODOMIF_DATA_UNAVAILABLE == s32ElemsCreated )
                     *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError(
                                           poServiceData, VDS_E_DATA_UNAVAILABLE );
                  else
                     *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError(
                                           poServiceData, VDS_E_INTERNAL_ERROR );

                  s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
               }
         }
         break;
         case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
         {
            // send status-message
            tclSubscriberManager *poSubscriber = poGetSubscriber( poServiceData );

            if ( OSAL_NULL !=  poSubscriber  )
            {
               // create status-message
               // if check for subscriber is successful, no response and error-message will be created!
               tU32 u32NextElemToRead = poSubscriber->u32GetNextElemToRead() - 1; // avoid 'no data left'
               // get odometer-message
               tS32 s32ElemsCreated = poMsgOdometerIf->s32GetOdomMessage(
                                    poServiceData,
                                    OSAL_NULL,
                                    ppoResponseMessage,
                                    OSAL_NULL,
                                    0,
                                    u32NextElemToRead,
                                    FALSE,
                                    TRUE );

               if (  s32ElemsCreated <= 0
                     || OSAL_NULL == *ppoResponseMessage )
               {
                  if ( VDS_E_ODOMIF_DATA_UNAVAILABLE == s32ElemsCreated )
                     *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError(
                                           poServiceData, VDS_E_DATA_UNAVAILABLE );
                  else
                     *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError(
                                           poServiceData, VDS_E_INTERNAL_ERROR );

                  s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
               }
            }

            // delete subscriber
            if ( VDS_E_NO_ERROR != s32DeleteSubscriber( poServiceData, ppoResponseMessage, ppoErrorMessage ) )
            {
               s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
            }
         }
         break;
         default:
         {
            // Error: OpCode not supported
            *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED );
            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      } // end switch opcode

      poMsgOdometerIf->oCS.vLeave();
   }
   else
   {
      *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, VDS_E_INTERNAL_ERROR );
      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }

   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Dispatches sensor message received for "ABSData" property from client.
//!   Reply or error message will be created which will be used to send client as response.
//!
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_UNKNOWN_ERROR :  Dispather Unknown error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
// 27.07.2009   | sak9kor (RBEI/ECF1)    | NEW,NULL and DELETE have been replaced by
//                                                            OSAL calls
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchAbsData
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message
   //!        is written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) :  pointer to a location where a pointer to an error message is written
   //!        if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;

   // lock msg-if
   if ( ( poMsgAbsIf != OSAL_NULL ) && ( poMsgAbsIf->oCS.bEnter() ) )
   {
      // get opcode from message
      tU8  u8OpCode      = poServiceData->u8GetOpCode();

      switch ( u8OpCode )
      {
         case AMT_C_U8_CCAMSG_OPCODE_GET:
         {
            // create status-message
            // if check for subscriber is successful, no response and error-message will be created!
            // Get the index for the latest record
            tU32 u32NextElemToRead = poMsgAbsIf->u32GetLastAbsElemIndex();
            // get gyro-message
            tS32 s32ElemsCreated = poMsgAbsIf->s32GetAbsMessage(
                                 ppoResponseMessage,
                                 u32NextElemToRead,
                                 poServiceData->u16GetSourceAppID(),
                                 FALSE );

            if (  s32ElemsCreated <= 0
                  || OSAL_NULL == *ppoResponseMessage )
            {
               if ( VDS_E_GYROIF_DATA_UNAVAILABLE == s32ElemsCreated )
                  *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError(
                                        poServiceData, VDS_E_DATA_UNAVAILABLE );
               else
                  *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError(
                                        poServiceData, VDS_E_INTERNAL_ERROR );

               s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
            }
         } // end case AMT_C_U8_CCAMSG_OPCODE_GET
         break;
         case AMT_C_U8_CCAMSG_OPCODE_UPREG:
         {
            // create status-message
            tU32 u32NextElemToRead = 0;
            // get gyro-message
            tS32 s32ElemsCreated = poMsgAbsIf->s32GetAbsMessage(
                                 ppoResponseMessage,
                                 u32NextElemToRead,
                                 poServiceData->u16GetSourceAppID(),
                                 TRUE );

            if (  s32ElemsCreated >= 0
                  && OSAL_NULL != *ppoResponseMessage )
            {
               tclSubscriberManager *poSubscriber = poAddSubscriber( poServiceData, ppoErrorMessage );

               if ( OSAL_NULL != poSubscriber  )
               {
                  // tclAilVDSensor-lock when sending messages needed
                  poSubscriber->vSetMessageLockNeeded( TRUE );
                  poSubscriber->vSetInitMessageSent( TRUE );
                  // set next elem to read
                  poSubscriber->vSetNextElemToRead( u32NextElemToRead );
               }
               else
               {
                  s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
                  OSAL_DELETE *ppoResponseMessage;
                  *ppoResponseMessage = OSAL_NULL;
               }
            }
            else
            {
               if ( VDS_E_GYROIF_DATA_UNAVAILABLE == s32ElemsCreated )
                  *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError(
                                        poServiceData, VDS_E_DATA_UNAVAILABLE );
               else
                  *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError(
                                        poServiceData, VDS_E_INTERNAL_ERROR );

               s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
            }
         }
         break;
         case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
         {
            // send status-message
            tclSubscriberManager *poSubscriber = poGetSubscriber( poServiceData );

            if ( OSAL_NULL != poSubscriber )
            {
               // create status-message
               // if check for subscriber is successful, no response and error-message will be created!
               tU32 u32NextElemToRead = poSubscriber->u32GetNextElemToRead() - 1; // avoid 'no data left'
               // get gyro-message
               tS32 s32ElemsCreated = poMsgAbsIf->s32GetAbsMessage(
                                    ppoResponseMessage,
                                    u32NextElemToRead,
                                    poSubscriber->u16GetTargetAppId(),
                                    FALSE,
                                    TRUE );

               if (  s32ElemsCreated <= 0
                     || OSAL_NULL == *ppoResponseMessage )
               {
                  if ( VDS_E_GYROIF_DATA_UNAVAILABLE == s32ElemsCreated )
                     *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError(
                                           poServiceData, VDS_E_DATA_UNAVAILABLE );
                  else
                     *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError(
                                           poServiceData, VDS_E_INTERNAL_ERROR );

                  s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
               }
            }

            // delete subscriber
            if ( VDS_E_NO_ERROR != s32DeleteSubscriber( poServiceData, ppoResponseMessage, ppoErrorMessage ) )
            {
               s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
            }
         }
         break;
         default:
         {
            // Error: OpCode not supported
            *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED );
            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      } // end switch opcode

      poMsgAbsIf->oCS.vLeave();
   }
   else
   {
      *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, VDS_E_INTERNAL_ERROR );
      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }

   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Dispatches sensor message received for "UpdateFactory Settings" Method from client.
//!   Reply or error message will be created which will be used to send client as response.
//!
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR :  Allocation error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
// 12.08.2009   | sak9kor (RBEI/ECF1)    | XML generated FI has been adapted
//                                                            instead manual generated FI
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchUpdateFactorySettings
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message is written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) :  pointer to a location where a pointer to an error message is written if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;
   vTraceMsg( VDS_C_TRACELEVEL_ERROR, "s32DispatchUpdateFactorySettings" );

   // lock msg-if
   if ( ( poMsgGpsIf != OSAL_NULL ) &&
         ( poMsgOdometerIf != OSAL_NULL ) &&
         ( poMsgGpsIf->bCritSectionBegin() ) )
   {
      // get opcode from message
      tU8  u8OpCode = poServiceData->u8GetOpCode();

      switch ( u8OpCode )
      {
         case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
         {
            /* Create the object for XML generated FI for Set OP type*/
            sensor_locationfi_tclMsgUpdateFactorySettingsMethodStart oUpdateFactorySettings;
            vds_trOdometerDefSetData DefSetData = {0,0,0};
            /* Create the object of visitor message*/
            fi_tclVisitorMessage oVisitor( poServiceData );

            /* Get the complete data for OdometerCalibration method received from client*/
            if ( OSAL_OK == oVisitor.s32GetData( oUpdateFactorySettings, SENSOR_LOCATIONFI_C_U16_SERVICE_MAJORVERSION ) )
            {
               // get use-tyre-value from message
               DefSetData.u8DefSetGroup = (tU8)oUpdateFactorySettings.DefSetGroup.enType;
               DefSetData.u8DefSetMode = (tU8)oUpdateFactorySettings.DefSetMode.enType;
            }

            /* Create the object for XML generated FI for method result*/
            sensor_locationfi_tclMsgUpdateFactorySettingsMethodResult oUpdateFactorySettingsMethodResult;
            oUpdateFactorySettingsMethodResult.DefSetGroup.enType = ( sensor_fi_tcl_e8_DefSetGroups::tenType )DefSetData.u8DefSetGroup;
            oUpdateFactorySettingsMethodResult.DefSetMode.enType = ( sensor_fi_tcl_e8_DefSetMode::tenType )DefSetData.u8DefSetMode;
            oUpdateFactorySettingsMethodResult.DefSetStateSuccessful = DefSetData.bDefSetStateSuccess;
            /* Create the object of visitor message*/
            fi_tclVisitorMessage* poResultMessage = OSAL_NEW  fi_tclVisitorMessage( oUpdateFactorySettingsMethodResult, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );

            if ( OSAL_NULL != poResultMessage )
            {
               tU32 u32TimeStamp = 0;
               vGetTimeStamp( &u32TimeStamp );

               if ( poResultMessage->bIsValid() )
               {
                  // create answer-message
                  poResultMessage->vInitServiceData
                  (  CCA_C_U16_APP_SENSOR,
                     poServiceData->u16GetSourceAppID(),     // Source, Target
                     AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                     0,                            // StreamCounter
                     poServiceData->u16GetRegisterID(),  // RegisterID
                     poServiceData->u16GetCmdCounter(),  // nCmdCounter,
                     poServiceData->u16GetServiceID(),   // nServiceID,
                     SENSOR_LOCATIONFI_C_U16_UPDATEFACTORYSETTINGS,// nFunctionID,
                     AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,   // OpCode
                     0,                            // Asynchronous Completion Token (ACT)
                     AMT_C_U16_DEFAULT_NULL,       // Source Sub
                     AMT_C_U16_DEFAULT_NULL,       // Target Sub
                     u32TimeStamp                 //TimeStamp
                  );
               }

               *ppoResponseMessage = static_cast<amt_tclServiceData *>( poResultMessage );
            }
            else
            {
               *ppoErrorMessage =
                  OSAL_NEW amt_tclServiceDataError(
                     poServiceData, VDS_E_INTERNAL_ERROR );
               s32RetVal = VDS_E_DISPATCHER_ALLOC_ERROR;
            }
         } // end case AMT_C_U8_CCAMSG_OPCODE_METHODSTART
         break;
         default:
         {
            // Error: OpCode not supported
            *ppoErrorMessage =
               OSAL_NEW amt_tclServiceDataError(
                  poServiceData, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED );
            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      } // end switch opcode

      // leave critical section
      poMsgGpsIf->vCritSectionEnd();
   }
   else
   {
      *ppoErrorMessage =
         OSAL_NEW amt_tclServiceDataError(
            poServiceData, VDS_E_INTERNAL_ERROR );
      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }

   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Dispatches sensor message received for "UpdateDiagLog" Method from client.
//!   Reply or error message will be created which will be used to send client as response.
//!
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR :  Allocation Error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
// 29.07.2009   | sak9kor (RBEI/ECF1)    | XML generated FI has been adapted
//                                                            instead manual generated FI
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchUpdateDiagLog
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message is written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) :  pointer to a location where a pointer to an error message is written if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;
   // get opcode from message
   tU8  u8OpCode      = poServiceData->u8GetOpCode();

   switch ( u8OpCode )
   {
      case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         if ( tclAilVDSensor::poThisAppInterface != OSAL_NULL )
         {
            tclAilVDSensor::poThisAppInterface->vToggleDiagLog( );
         }

         /* Create the object for XML generated FI for method result*/
         sensor_locationfi_tclMsgUpdateDiagLogMethodResult oResult;
         /* Create the object of visitor message*/
         fi_tclVisitorMessage* poResultMessage = OSAL_NEW  fi_tclVisitorMessage( oResult , VDS_C_U16_SRV_SENSORS_MAJOR_VERSION);

         if ( OSAL_NULL != poResultMessage )
         {
            tU32 u32TimeStamp = 0;
            vGetTimeStamp( &u32TimeStamp );

            if ( poResultMessage->bIsValid() )
            {
               // create answer-message
               poResultMessage->vInitServiceData
               (  CCA_C_U16_APP_SENSOR,
                  poServiceData->u16GetSourceAppID(),     // Source, Target
                  AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                  0,                            // StreamCounter
                  poServiceData->u16GetRegisterID(),  // RegisterID
                  poServiceData->u16GetCmdCounter(),  // nCmdCounter,
                  poServiceData->u16GetServiceID(),   // nServiceID,
                  SENSOR_LOCATIONFI_C_U16_UPDATEDIAGLOG,// nFunctionID,
                  AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,   // OpCode
                  0,                            // Asynchronous Completion Token (ACT)
                  AMT_C_U16_DEFAULT_NULL,       // Source Sub
                  AMT_C_U16_DEFAULT_NULL,       // Target Sub
                  u32TimeStamp                 //TimeStamp
               );
            }

            *ppoResponseMessage = static_cast<amt_tclServiceData *>( poResultMessage );
         }
         else
         {
            *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, VDS_E_INTERNAL_ERROR );
            s32RetVal = VDS_E_DISPATCHER_ALLOC_ERROR;
         }
      } // end case AMT_C_U8_CCAMSG_OPCODE_METHODSTART
      break;
      default:
      {
         // Error: OpCode not supported
         *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED );
         s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
      }
      break;
   } // end switch opcode

   return s32RetVal;
}

#if (defined(VARIANT_S_FTR_ENABLE_TRITON_SUPPORT) && !defined(VARIANT_S_FTR_DISABLE_DIAGLOG))
// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Dispatches Diaglog message received for "SendNextTestResutl" by Diaglog Server.
//!
//! \return
//!   None
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
// 16.12.2010    sak9kor (RBEI/ECF1)  Initial Version
//******************************************************************************
tVoid tclSensorMsgDispatcher::vDispatchDiaglogMsg
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData
)
{
   
   // enter critical section
   if ( ( poMsgGpsIf != OSAL_NULL ) && ( poMsgGpsIf->bCritSectionBegin() ))
   {
      // get opcode from message
      tU8 u8OpCode = poServiceData->u8GetOpCode();

      switch ( u8OpCode )
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {

        #if defined VARIANT_S_FTR_ENABLE_DIAGLOG_GMGE
            tBool bStatus;
            midw_diaglogfi_tclMsgSendNextTestResultStatus oSendNextTestResultStatus;
            fi_tclVisitorMessage oVisitor( poServiceData );
            //oVisitor.s32GetData(oSendNextTestResultStatus);
            if ( OSAL_OK == oVisitor.s32GetData( oSendNextTestResultStatus, MIDW_DIAGLOGFI_C_U16_SERVICE_MAJORVERSION ) )
            {
               // get status and number of ITCLIST elements
               bStatus = oSendNextTestResultStatus.NextTestResultStruct.Status;
               tS32 s32ITCListelements = (tS32)oSendNextTestResultStatus.NextTestResultStruct.ITCList.size();
               //if status is true, it means diaglog is interested in knowing the Antenna Status information
               if(bStatus == TRUE)
               {
                   //Allocate a memory for the available ITCList size
                   /*If the ITCListelement size is zero it means Diaglog interseted in all
                     possible antenna Status information i.e. Antenna Open, Short to Battey
                     and short to ground*/
                   if(s32ITCListelements == 0)
                   {
                     //perform the Antenna Status for all the 3 DTCs
                     }
                   else
                   {
                       pu16_ITCListBufferpointer =(tU16*)OSAL_pvMemoryAllocate((tU32)s32ITCListelements * sizeof(tU16));
                       if(pu16_ITCListBufferpointer == OSAL_NULL)
                       {
                            vTraceMsg( VDS_C_TRACELEVEL_ERROR, "MemAlloc Failed for DiaglogSendNextTestResult");
                        
                       }
                       else
                       {
                           for(int i=0;i<s32ITCListelements;i++)
                           {
                             *(pu16_ITCListBufferpointer+i) = oSendNextTestResultStatus.NextTestResultStruct.ITCList[i];
                           }                                                                
                       }
                   }

               }//  end of if(bStatus == TRUE)
               else
               {
                   vTraceMsg( VDS_C_TRACELEVEL_ERROR, "Diaglog sent state as FALSE for SendNextTestResult property"); 
               }
            }
            else
            {
                vTraceMsg( VDS_C_TRACELEVEL_ERROR, "Visitor message s32GetData function failed"); 
            }
        #endif
         }//
        
         break; 

         default:
         {
            vTraceMsg( VDS_C_TRACELEVEL_ERROR, "INVALID OPCODE FOR DIAGLOG");
         }
         break;
      } // end switch opcode

      // leave critical section
      poMsgGpsIf->vCritSectionEnd();
   }// end of if ( ( poMsgGpsIf != OSAL_NULL ) && ( poMsgGpsIf->bCritSectionBegin() ))
      
}// end of vDispatchDiaglogMsg
#endif
// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Dispatches sensor message received for "IErrorMsgt" property from client.
//!   Reply or error message will be created which will be used to send client as response.
//!
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_UNKNOWN_ERROR :  Unknown Error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
#ifdef VARIANT_S_FTR_IERROR_MESSAGE
tS32 tclSensorMsgDispatcher::s32DispatchIErrorMsg
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message is written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) :  pointer to a location where a pointer to an error message is written if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;

   // lock msg-if
   if ( ( poMsgIerrorIf != OSAL_NULL ) && ( poMsgIerrorIf->bCritSectionBegin() ) )
   {
      // get opcode from message
      tU8  u8OpCode      = poServiceData->u8GetOpCode();

      switch ( u8OpCode )
      {
         case AMT_C_U8_CCAMSG_OPCODE_GET:
         {
            // create status-message
            // if check for subscriber is successful, no response and error-message will be created!
            // get ierror-message
            poMsgIerrorIf->s32GetIerrorMessage(
               ppoResponseMessage,
               poServiceData->u16GetFunctionID(),
               poServiceData->u16GetSourceAppID() );

            if ( NULL == *ppoResponseMessage )
            {
               *ppoErrorMessage = new amt_tclServiceDataError(
                  poServiceData, VDS_E_INTERNAL_ERROR );
               s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
            }
         } // end case AMT_C_U8_CCAMSG_OPCODE_GET
         break;
         case AMT_C_U8_CCAMSG_OPCODE_UPREG:
         {
            // create status-message
            // get ierror-message
            poMsgIerrorIf->s32GetIerrorMessage(
               ppoResponseMessage,
               poServiceData->u16GetFunctionID(),
               poServiceData->u16GetSourceAppID() );

            if ( NULL != *ppoResponseMessage )
            {
               tclSubscriberManager *poSubscriber = NULL;

               if ( NULL != ( poSubscriber = poAddSubscriber( poServiceData, ppoErrorMessage ) ) )
               {
                  // tclAilVDSensor-lock when sending messages needed
                  poSubscriber->vSetMessageLockNeeded( TRUE );
               }
               else
               {
                  s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
                  delete *ppoResponseMessage;
                  *ppoResponseMessage = NULL;
               }
            }
            else
            {
               *ppoErrorMessage = new amt_tclServiceDataError(
                  poServiceData, VDS_E_INTERNAL_ERROR );
               s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
            }
         }
         break;
         case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
         {
            // send status-message
            tclSubscriberManager *poSubscriber = NULL;

            if ( NULL != ( poSubscriber = poGetSubscriber( poServiceData ) ) )
            {
               // create status-message
               // if check for subscriber is successful, no response and error-message will be created!
               // get ierror-message
               poMsgIerrorIf->s32GetIerrorMessage(
                  ppoResponseMessage,
                  poServiceData->u16GetFunctionID(),
                  poSubscriber->u16GetTargetAppId() );

               if ( NULL == *ppoResponseMessage )
               {
                  *ppoErrorMessage = new amt_tclServiceDataError(
                     poServiceData, VDS_E_INTERNAL_ERROR );
                  s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
               }
            }

            // delete subscriber
            if ( VDS_E_NO_ERROR != s32DeleteSubscriber( poServiceData, ppoResponseMessage, ppoErrorMessage ) )
            {
               s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
            }
         }
         break;
         default:
         {
            // Error: OpCode not supported
            *ppoErrorMessage = new amt_tclServiceDataError( poServiceData, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED );
            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      } // end switch opcode

      poMsgIerrorIf->vCritSectionEnd();
   }
   else
   {
      *ppoErrorMessage = new amt_tclServiceDataError( poServiceData, VDS_E_INTERNAL_ERROR );
      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }

   return s32RetVal;
}
#endif // VARIANT_S_FTR_IERROR_MESSAGE

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief Dispatches sensor message received for "Gyro3dGetHwInfo" property from
//!   client. Reply or error message will be created which will be used to send
//!   client as response.
//
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
// 04.05.2011      | Joachim Friess (CM-AI/PJ-CF31) | Initial Version
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchGyro3dGetHwInfo ( 
   amt_tclServiceData *poServiceData, 
   amt_tclServiceData **ppoResponseMessage, 
   amt_tclServiceDataError **ppoErrorMessage )

{

   tS32 s32RetVal = VDS_E_NO_ERROR;
   // No response message is generated by this function.  Either an
   // error message is sent or the test is started and a method result
   // message is sent when it is finished.
   ( void ) ppoResponseMessage;

   // get opcode from message
   tU8 u8OpCode = poServiceData->u8GetOpCode();

   vTraceMsg( VDS_C_TRACELEVEL_ERROR, 
              "s32DispatchGyro3dGetHwInfo with Opcode:%d", 
              u8OpCode );

   switch ( u8OpCode )
   {
   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         /* Create the object for XML generated FI for method result*/
         sensor_locationfi_tclMsgGyro3dGetHwInfoMethodResult oResult;

         // copy 3dGyroHWInfo to result message
         oResult.Gyro3dHwInfo = tclSystemInformation::rInfo.rGyro.r3dGyroHWInfo;

         fi_tclVisitorMessage* poResultMessage = 
            OSAL_NEW  fi_tclVisitorMessage( oResult, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );

         tU32 u32TimeStamp = 0;
         vGetTimeStamp( &u32TimeStamp );

         if ( OSAL_NULL != poResultMessage )
         {
            if ( poResultMessage->bIsValid() )
            {
               // create answer-message
               poResultMessage->vInitServiceData
                  (  CCA_C_U16_APP_SENSOR,
                     poServiceData->u16GetSourceAppID(),     // Source, Target
                     AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                     0,                            // StreamCounter
                     poServiceData->u16GetRegisterID(),  // RegisterID
                     poServiceData->u16GetCmdCounter(),  // nCmdCounter,
                     poServiceData->u16GetServiceID(),   // nServiceID,
                     SENSOR_LOCATIONFI_C_U16_GYRO3DGETHWINFO,// nFunctionID,
                     AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,   // OpCode
                     0,                            // Asynchronous Completion Token (ACT)
                     AMT_C_U16_DEFAULT_NULL,       // Source Sub
                     AMT_C_U16_DEFAULT_NULL,       // Target Sub
                     u32TimeStamp                 //TimeStamp
                  );
            }
            
            *ppoResponseMessage = static_cast<amt_tclServiceData *>( poResultMessage );
         }

      } // end case AMT_C_U8_CCAMSG_OPCODE_METHODSTART
      break;
   default:
      {
         vTraceMsg( VDS_C_TRACELEVEL_ERROR, "s32DispatchGyro3dGetHwInfo opcode not supported" );
         // Error: OpCode not supported
         *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED );
         s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
      }
      break;
   } // end switch opcode

   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief Dispatches sensor message received for "Gyro3dData_Update" property
//!   from client. Reply or error message will be created which will be used to
//!   send client as response.
//
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
// 04.05.2011      | Joachim Friess (CM-AI/PJ-CF31) | Initial Version
//******************************************************************************

tS32 tclSensorMsgDispatcher::s32DispatchGyro3dDataUpdate
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message is
   //!  written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) : pointer to a location where a pointer to an error message is
   //! written if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{

   tS32 s32RetVal = VDS_E_NO_ERROR;

   // lock msg-if
   if ( ( poMsgGyroIf != OSAL_NULL ) && ( poMsgGyroIf->oCS.bEnter() ) )
   {
      // get opcode from message
      tU8 u8OpCode = poServiceData->u8GetOpCode();

      switch ( u8OpCode )
      {
         case AMT_C_U8_CCAMSG_OPCODE_GET:
         {
            // create status-message if check for subscriber is successful, no
            // response and error-message will be created!
            // Get the index for the latest record
            tU32 u32NextElemToRead = poMsgGyroIf->u32GetLastGyroElemIndex();
            // get gyro-message
            tS32 s32ElemsCreated = 
               poMsgGyroIf->s32Get3dGyroMessage( poServiceData,
                                                 OSAL_NULL,
                                                 ppoResponseMessage,
                                                 OSAL_NULL,
                                                 0,
                                                 u32NextElemToRead,
                                                 FALSE );

            if ( s32ElemsCreated <= 0
                 || 
                 OSAL_NULL == *ppoResponseMessage )
            {
               if ( VDS_E_GYROIF_DATA_UNAVAILABLE == s32ElemsCreated )
               {
                  *ppoErrorMessage = 
                     OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                                       VDS_E_DATA_UNAVAILABLE );
               }
               else
               {
                  *ppoErrorMessage = 
                     OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                                       VDS_E_INTERNAL_ERROR );
               }

               s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
            }
         } // end case AMT_C_U8_CCAMSG_OPCODE_GET
         break;
         case AMT_C_U8_CCAMSG_OPCODE_UPREG:
         {
            // create status-message
            tU32 u32NextElemToRead = 0;
            // get gyro-message
            tS32 s32ElemsCreated = 
               poMsgGyroIf->s32Get3dGyroMessage( poServiceData,
                                                 OSAL_NULL,
                                                 ppoResponseMessage,
                                                 OSAL_NULL,
                                                 0,
                                                 u32NextElemToRead,
                                                 TRUE );

            if ( s32ElemsCreated > 0
                 && 
                 OSAL_NULL != *ppoResponseMessage )
            {
               tclSubscriberManager *poSubscriber = poAddSubscriber( poServiceData,ppoErrorMessage );

               if ( OSAL_NULL != poSubscriber )
               {
                  // tclAilVDSensor-lock when sending messages needed
                  poSubscriber->vSetMessageLockNeeded( TRUE );
                  poSubscriber->vSetInitMessageSent( TRUE );
                  // set next elem to read
                  poSubscriber->vSetNextElemToRead( u32NextElemToRead );
               }
               else
               {
                  s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
                  OSAL_DELETE *ppoResponseMessage;
                  *ppoResponseMessage = OSAL_NULL;
               }
            }
            else
            {
               if ( VDS_E_GYROIF_DATA_UNAVAILABLE == s32ElemsCreated )
               {
                  *ppoErrorMessage = 
                     OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                                       VDS_E_DATA_UNAVAILABLE );
               }
               else
               {
                  *ppoErrorMessage = 
                     OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                                       VDS_E_INTERNAL_ERROR );

               }
               s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
            }
         }
         break;
         case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
         {
            // send status-message
            tclSubscriberManager *poSubscriber = poGetSubscriber( poServiceData );

            if ( OSAL_NULL != poSubscriber  )
            {
               // create status-message if check for subscriber is successful,
               // no response and error-message will be created!
               tU32 u32NextElemToRead = poSubscriber->u32GetNextElemToRead() - 1; // avoid 'no data left'
               // get gyro-message
               tS32 s32ElemsCreated = 
                  poMsgGyroIf->s32Get3dGyroMessage( poServiceData,
                                                    OSAL_NULL,
                                                    ppoResponseMessage,
                                                    OSAL_NULL,
                                                    0,
                                                    u32NextElemToRead,
                                                    FALSE,
                                                    TRUE );

               if (  s32ElemsCreated <= 0
                     || 
                     OSAL_NULL == *ppoResponseMessage )
               {
                  if ( VDS_E_GYROIF_DATA_UNAVAILABLE == s32ElemsCreated )
                  {
                     *ppoErrorMessage = 
                        OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                                          VDS_E_DATA_UNAVAILABLE );
                  }
                  else
                  {
                     *ppoErrorMessage = 
                        OSAL_NEW amt_tclServiceDataError(poServiceData, 
                                                         VDS_E_INTERNAL_ERROR );
                  }

                  s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
               }
            }

            // delete subscriber
            if ( VDS_E_NO_ERROR 
                 != 
                 s32DeleteSubscriber( poServiceData, 
                                      ppoResponseMessage, 
                                      ppoErrorMessage ) )
            {
               s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
            }
         }
         break;
         default:
         {
            // Error: OpCode not supported
            *ppoErrorMessage = 
               OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                                 AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED );

            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      } // end switch opcode

      poMsgGyroIf->oCS.vLeave();
   }
   else
   {
      *ppoErrorMessage = 
         OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                           VDS_E_INTERNAL_ERROR );

      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }

   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief Dispatches sensor message received for "ACC3dGetHwInfo" property from
//!   client. Reply or error message will be created which will be used to send
//!   client as response.
//
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
// 04.05.2011      | Joachim Friess (CM-AI/PJ-CF31) | Initial Version
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchAcc3dGetHwInfo ( amt_tclServiceData *poServiceData, 
                                 amt_tclServiceData **ppoResponseMessage, 
                                 amt_tclServiceDataError **ppoErrorMessage )


{
   tS32 s32RetVal = VDS_E_NO_ERROR;
   // No response message is generated by this function.  Either an
   // error message is sent or the test is started and a method result
   // message is sent when it is finished.
   ( void ) ppoResponseMessage;

   // get opcode from message
   tU8 u8OpCode = poServiceData->u8GetOpCode();

   vTraceMsg( VDS_C_TRACELEVEL_ERROR, 
              "s32DispatchAcc3dGetHwInfo with Opcode:%d", 
              u8OpCode );

   switch ( u8OpCode )
   {
   case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
      {
         /* Create the object for XML generated FI for method result*/
         sensor_locationfi_tclMsgAcc3dGetHwInfoMethodResult oResult;

         // copy 3dAccHWInfo to result message
         oResult.Acc3dHwInfo = tclSystemInformation::rInfo.rAcc.r3dAccHWInfo;

         fi_tclVisitorMessage* poResultMessage = 
            OSAL_NEW  fi_tclVisitorMessage( oResult , VDS_C_U16_SRV_SENSORS_MAJOR_VERSION);

         if(poResultMessage != OSAL_NULL)
         {
            tU32 u32TimeStamp = 0;
            vGetTimeStamp( &u32TimeStamp );

            if ( poResultMessage->bIsValid() )
            {
               // create answer-message
               poResultMessage->vInitServiceData
                  (  CCA_C_U16_APP_SENSOR,
                     poServiceData->u16GetSourceAppID(),     // Source, Target
                     AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                     0,                            // StreamCounter
                     poServiceData->u16GetRegisterID(),  // RegisterID
                     poServiceData->u16GetCmdCounter(),  // nCmdCounter,
                     poServiceData->u16GetServiceID(),   // nServiceID,
                     SENSOR_LOCATIONFI_C_U16_ACC3DGETHWINFO,// nFunctionID,
                     AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,   // OpCode
                     0,                            // Asynchronous Completion Token (ACT)
                     AMT_C_U16_DEFAULT_NULL,       // Source Sub
                     AMT_C_U16_DEFAULT_NULL,       // Target Sub
                     u32TimeStamp                 //TimeStamp
                  );
            }

            *ppoResponseMessage = static_cast<amt_tclServiceData *>( poResultMessage );
         }

      } // end case AMT_C_U8_CCAMSG_OPCODE_METHODSTART
      break;
   default:
      {
         vTraceMsg( VDS_C_TRACELEVEL_ERROR, "Acc3dGetHwInfo opcode not supported" );
         // Error: OpCode not supported
         *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED );
         s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
      }
      break;
   } // end switch opcode

   return s32RetVal;
}


// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief Dispatches sensor message received for "Acc3dData_Update" property
//!   from client. Reply or error message will be created which will be used to
//!   send client as response.
//
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
// 04.05.2011      | Joachim Friess (CM-AI/PJ-CF31) | Initial Version
// 24.05.2011      | Sainath Kalpuri(RBEI CM-AI/PJ-CF31) | Added the implementation
//                                                          of the property
//******************************************************************************
tS32 tclSensorMsgDispatcher::
s32DispatchAcc3dDataUpdate ( amt_tclServiceData *poServiceData, 
                             amt_tclServiceData **ppoResponseMessage, 
                             amt_tclServiceDataError **ppoErrorMessage  )
{

   tS32 s32RetVal = VDS_E_NO_ERROR;
   tU16 u16ErrorCode = VDS_E_INTERNAL_ERROR;
   tU32 u32NextElemToRead = 0;

   //Lock msg-if
   if ( ( poMsgAccIf == OSAL_NULL ) ||  !poMsgAccIf->oCS.bEnter()  )
   {
      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
      u16ErrorCode = VDS_E_INTERNAL_ERROR;
   }
   else
   {
      //Get opcode from message
      tU8 u8OpCode = poServiceData->u8GetOpCode();

      switch ( u8OpCode )
      {
         case AMT_C_U8_CCAMSG_OPCODE_GET:
         {

            //Get Acc message
            // Get the index for the latest record
            u32NextElemToRead = poMsgAccIf->u32GetLastAccElemIndex();
            tS32 s32ElemsCreated = poMsgAccIf->s32Get3dAccMessage( poServiceData,
                                                                   OSAL_NULL,
                                                                   ppoResponseMessage,
                                                                   OSAL_NULL,
                                                                   0,
                                                                   u32NextElemToRead,
                                                                   FALSE );
            if ( s32ElemsCreated <= 0 || OSAL_NULL == *ppoResponseMessage )
            {
               if ( VDS_E_ACCIF_DATA_UNAVAILABLE == s32ElemsCreated )
               {
                  u16ErrorCode = VDS_E_DATA_UNAVAILABLE;
               }
               else
               {
                  u16ErrorCode = VDS_E_INTERNAL_ERROR;
               }

               s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
            }
         }
         break;

         case AMT_C_U8_CCAMSG_OPCODE_UPREG:
         {
            //Get Acc message
            tS32 s32ElemsCreated = poMsgAccIf->s32Get3dAccMessage( poServiceData,
                                                                   OSAL_NULL,
                                                                   ppoResponseMessage,
                                                                   OSAL_NULL,
                                                                   0,
                                                                   u32NextElemToRead,
                                                                   TRUE );

            if ( s32ElemsCreated > 0 && OSAL_NULL != *ppoResponseMessage )
            {
               tclSubscriberManager *poSubscriber = poAddSubscriber( poServiceData,ppoErrorMessage );

               if ( OSAL_NULL != poSubscriber )
               {
                  // tclAilVDSensor-lock when sending messages needed
                  poSubscriber->vSetMessageLockNeeded( TRUE );
                  poSubscriber->vSetInitMessageSent( TRUE );
                  // set next elem to read
                  poSubscriber->vSetNextElemToRead( u32NextElemToRead );
               }
               else
               {
                  s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
                  u16ErrorCode = VDS_E_INTERNAL_ERROR;
                  OSAL_DELETE *ppoResponseMessage;
                  *ppoResponseMessage = OSAL_NULL;
               }
            }
            else
            {
               if ( VDS_E_ACCIF_DATA_UNAVAILABLE == s32ElemsCreated )
               {
                  u16ErrorCode = VDS_E_DATA_UNAVAILABLE;
               }
               else
               {
                  u16ErrorCode = VDS_E_INTERNAL_ERROR;
               }

               s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
            }
         }
         break;
         case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
         {
            // send status-message
            tclSubscriberManager *poSubscriber = poGetSubscriber( poServiceData );

            if ( OSAL_NULL != poSubscriber )
            {
               // create status-message if check for subscriber is successful,
               // no response and error-message will be created!
               u32NextElemToRead = poSubscriber->u32GetNextElemToRead() - 1; // avoid 'no data left'
               //Get Acc message
               tS32 s32ElemsCreated = poMsgAccIf->s32Get3dAccMessage( poServiceData,
                                                                      OSAL_NULL,
                                                                      ppoResponseMessage,
                                                                      OSAL_NULL,
                                                                      0,
                                                                      u32NextElemToRead,
                                                                      FALSE,
                                                                      TRUE );

               if (  s32ElemsCreated <= 0 || OSAL_NULL == *ppoResponseMessage )
               {
                  if ( VDS_E_ACCIF_DATA_UNAVAILABLE == s32ElemsCreated )
                  {
                     u16ErrorCode = VDS_E_DATA_UNAVAILABLE;
                  }
                  else
                  {
                     u16ErrorCode = VDS_E_INTERNAL_ERROR;
                  }

                  s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
               }
            }

            //Delete subscriber from the list.
            if ( VDS_E_NO_ERROR != s32DeleteSubscriber( poServiceData,ppoResponseMessage,ppoErrorMessage ) )
            {
               s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
               u16ErrorCode = VDS_E_INTERNAL_ERROR;
            }
         }
         break;
         default:
         {
            // Error: OpCode not supported
            u16ErrorCode = AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;

      }//End switch( opcode )

      poMsgAccIf->oCS.vLeave();
   }

   if( s32RetVal != VDS_E_NO_ERROR )
   {
      *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, u16ErrorCode );
   }

   return s32RetVal;

}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief property for geting the gyro temperature (not implemented yet)
//!   
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//!  
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchGyroTemperature
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message is
   //!  written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) : pointer to a location where a pointer to an error message is
   //! written if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;
   if ( ( poMsgGyroIf != OSAL_NULL ) && ( poMsgGyroIf->oCS.bEnter() ) )
   {
      // get opcode from message
      tU8  u8OpCode      = poServiceData->u8GetOpCode();

      switch ( u8OpCode )
      {
         case AMT_C_U8_CCAMSG_OPCODE_GET:
         {
            // get gps-temperature-message
            if (  poMsgGyroIf->s32GetGyroTemperatureMessage(
                     poServiceData,
                     OSAL_NULL,
                     ppoResponseMessage ) <= 0
                  || OSAL_NULL == *ppoResponseMessage )
            {
               *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, VDS_E_INTERNAL_ERROR );
               s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
            }		 
         }
         break;
         case AMT_C_U8_CCAMSG_OPCODE_UPREG:	
         {
            tclSubscriberManager *poSubscriber = poAddSubscriber( poServiceData, ppoErrorMessage );
            if ( OSAL_NULL != poSubscriber )
            {
               tU32 u32NextElemToRead = OSAL_ClockGetElapsedTime() / 1000; 
               poSubscriber->vSetMsgSendInterval( ( tU32 )GYRO_TEMPERATURE_MSG_INTERVAL);			   
               // tclAilVDSensor-lock when sending messages needed
               poSubscriber->vSetMessageLockNeeded( TRUE );
               poSubscriber->vSetInitMessageSent( TRUE );
               poSubscriber->vSetNextElemToRead( u32NextElemToRead );

               // get gyro-temperature-message
               if (  poMsgGyroIf->s32GetGyroTemperatureMessage(
                        poServiceData,
                        OSAL_NULL,
                        ppoResponseMessage ) <= 0
                     || OSAL_NULL == *ppoResponseMessage )
               {
                  *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, VDS_E_INTERNAL_ERROR );
                  s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
               }
            }
            else
            {
               s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
            }		
        }
        break;	
         case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
         {
             // send status-message
            if ( OSAL_NULL != poGetSubscriber( poServiceData ) )
            {
               // get gyro-temperature-message
               if (  poMsgGyroIf->s32GetGyroTemperatureMessage(
                        poServiceData,
                        OSAL_NULL,
                        ppoResponseMessage ) <= 0
                     || OSAL_NULL == *ppoResponseMessage )
               {
                  *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, VDS_E_INTERNAL_ERROR );
                  s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
               }
            }

            // delete subscriber
            if ( VDS_E_NO_ERROR != s32DeleteSubscriber( poServiceData, ppoResponseMessage, ppoErrorMessage ) )
            {
               s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
            }
         }
         break;    
         default:
         {
            // Error: OpCode not supported
            *ppoErrorMessage = 
               OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                                 AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED );

            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      } // end switch opcode

      // leave critical section
      poMsgGyroIf->oCS.vLeave();
   }
   else
   {
      *ppoErrorMessage = 
         OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                           VDS_E_INTERNAL_ERROR );

      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }
   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief property for getting/setting gnss satellite system non-persistantly. 
//|     Setting satellite system is done NON-persistently, rest is similar to "s32DispatchGnssSatSystem".
//!     Mostly for Diagnosis
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//!  
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchDiagGnssSatSystem
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message is
   //!  written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) : pointer to a location where a pointer to an error message is
   //! written if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;

   // lock msg-if
   if ( ( poMsgGpsIf != OSAL_NULL ) && ( poMsgGpsIf->bCritSectionBegin() ) )
   {
      // get opcode from message
      tU8  u8OpCode      = poServiceData->u8GetOpCode();

      switch ( u8OpCode )
      {
      case AMT_C_U8_CCAMSG_OPCODE_SET:
         {

            /* Create the object for XML generated FI for Set OP type*/
            sensor_locationfi_tclMsgDiagGnssSatSystemSet oMsgDiagGnssSatSystemSet;

            tU8 u8TargetGnssSatSys=0;
            tU8 u8ActGnssSatSys;
            /* Create the object of visitor message*/
            fi_tclVisitorMessage oVisitor( poServiceData );

            
            if ( OSAL_OK 
                 == 
                 oVisitor.s32GetData( oMsgDiagGnssSatSystemSet , 
                                      SENSOR_LOCATIONFI_C_U16_SERVICE_MAJORVERSION ) )
            {
               u8TargetGnssSatSys = oMsgDiagGnssSatSystemSet.TargetGnssSatSys.u8Value;
            }

            u8ActGnssSatSys = poMsgGpsIf->u8SetDiagGnssSatSys( u8TargetGnssSatSys );

            /* Create the object for XML generated FI for Set OP type */
            sensor_locationfi_tclMsgDiagGnssSatSystemStatus oMsgDiagGnssSatSystemStatus;
               
            oMsgDiagGnssSatSystemStatus.ActualGnssSatSys.u8Value = u8ActGnssSatSys;
            /* Create the object of visitor message and insert the class object*/
            fi_tclVisitorMessage* poResultMessage = 
               OSAL_NEW  fi_tclVisitorMessage( oMsgDiagGnssSatSystemStatus, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );

            if ( OSAL_NULL != poResultMessage )
            {
               tU32 u32TimeStamp = 0;
               vGetTimeStamp( &u32TimeStamp );

               if ( poResultMessage->bIsValid() )
               {
                  // create answer-message
                  poResultMessage->vInitServiceData (  
                     CCA_C_U16_APP_SENSOR,
                     poServiceData->u16GetSourceAppID(),    // Source, Target
                     AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                     0,                                     // StreamCounter
                     poServiceData->u16GetRegisterID(),     // RegisterID
                     poServiceData->u16GetCmdCounter(),     // nCmdCounter,
                     poServiceData->u16GetServiceID(),      // nServiceID,
                     SENSOR_LOCATIONFI_C_U16_DIAGGNSSSATSYSTEM,      // nFunctionID,
                     AMT_C_U8_CCAMSG_OPCODE_STATUS,         // OpCode
                     0,                                     // Asynchronous Completion Token (ACT)
                     AMT_C_U16_DEFAULT_NULL,                // Source Sub
                     AMT_C_U16_DEFAULT_NULL,                // Target Sub
                     u32TimeStamp                           // TimeStamp        
                  );
               }

               *ppoResponseMessage = static_cast<amt_tclServiceData *>( poResultMessage );

            }
            else
            {
               *ppoErrorMessage = 
                  OSAL_NEW amt_tclServiceDataError( poServiceData, VDS_E_INTERNAL_ERROR );

               s32RetVal = VDS_E_DISPATCHER_ALLOC_ERROR;
            }
         } // end case AMT_C_U8_CCAMSG_OPCODE_SET
         break;
      case AMT_C_U8_CCAMSG_OPCODE_GET:
         {

            tU8 u8ActGnssSatSys = poMsgGpsIf->u8GetGnssSatSys( );

            sensor_locationfi_tclMsgDiagGnssSatSystemStatus oMsgDiagGnssSatSystemStatus;

            oMsgDiagGnssSatSystemStatus.ActualGnssSatSys.u8Value = u8ActGnssSatSys;

            fi_tclVisitorMessage* poResultMessage = 
               OSAL_NEW  fi_tclVisitorMessage( oMsgDiagGnssSatSystemStatus, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );

               if ( OSAL_NULL != poResultMessage )
               {
                  tU32 u32TimeStamp = 0;
                  vGetTimeStamp( &u32TimeStamp );

                  if ( poResultMessage->bIsValid() )
                  {
                     // create answer-message
                     poResultMessage->vInitServiceData
                        (  CCA_C_U16_APP_SENSOR,
                           poServiceData->u16GetSourceAppID(),    // Source, Target
                           AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                           0,                                     // StreamCounter
                           poServiceData->u16GetRegisterID(),     // RegisterID
                           poServiceData->u16GetCmdCounter(),     // nCmdCounter,
                           poServiceData->u16GetServiceID(),      // nServiceID,
                           SENSOR_LOCATIONFI_C_U16_DIAGGNSSSATSYSTEM,      // nFunctionID,
                           AMT_C_U8_CCAMSG_OPCODE_STATUS,         // OpCode
                           0,                                     // Asynchronous Completion Token (ACT)
                           AMT_C_U16_DEFAULT_NULL,                // Source Sub
                           AMT_C_U16_DEFAULT_NULL,                // Target Sub
                           u32TimeStamp                           //TimeStamp
                        );
                  }

                  *ppoResponseMessage = 
                     static_cast<amt_tclServiceData *>( poResultMessage );
               }
               else
               {
                  *ppoErrorMessage = 
                     OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                                       VDS_E_INTERNAL_ERROR );

                  s32RetVal = VDS_E_DISPATCHER_ALLOC_ERROR;
               }
         } // end case AMT_C_U8_CCAMSG_OPCODE_GET
         break;
      default:
         {
            // Error: OpCode not supported
            *ppoErrorMessage = 
               OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                                 AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED );

            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      } // end switch opcode

      // leave critical section
      poMsgGpsIf->vCritSectionEnd();
   }
   else
   {
      *ppoErrorMessage = 
         OSAL_NEW amt_tclServiceDataError( poServiceData,
                                           VDS_E_INTERNAL_ERROR );

      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }
   return s32RetVal;
}


// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief property for getting/setting gnss satellite system persistently
//!   
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//!  
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchGnssSatSystem
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message is
   //!  written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) : pointer to a location where a pointer to an error message is
   //! written if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;

   // lock msg-if
   if ( ( poMsgGpsIf != OSAL_NULL ) && ( poMsgGpsIf->bCritSectionBegin() ) )
   {
      // get opcode from message
      tU8  u8OpCode      = poServiceData->u8GetOpCode();

      switch ( u8OpCode )
      {
      case AMT_C_U8_CCAMSG_OPCODE_SET:
         {

            /* Create the object for XML generated FI for Set OP type*/
            sensor_locationfi_tclMsgGnssSatSystemSet oMsgGnssSatSystemSet;

            tU8 u8TargetGnssSatSys=0;
            tU8 u8ActGnssSatSys;
            /* Create the object of visitor message*/
            fi_tclVisitorMessage oVisitor( poServiceData );

            
            if ( OSAL_OK 
                 == 
                 oVisitor.s32GetData( oMsgGnssSatSystemSet , 
                                      SENSOR_LOCATIONFI_C_U16_SERVICE_MAJORVERSION ) )
            {
               u8TargetGnssSatSys = oMsgGnssSatSystemSet.TargetGnssSatSys.u8Value;
            }

            u8ActGnssSatSys = poMsgGpsIf->u8SetGnssSatSys( u8TargetGnssSatSys );

            /* Create the object for XML generated FI for Set OP type */
            sensor_locationfi_tclMsgGnssSatSystemStatus oMsgGnssSatSystemStatus;
               
            oMsgGnssSatSystemStatus.ActualGnssSatSys.u8Value = u8ActGnssSatSys;
            /* Create the object of visitor message and insert the class object*/
            fi_tclVisitorMessage* poResultMessage = 
               OSAL_NEW  fi_tclVisitorMessage( oMsgGnssSatSystemStatus, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );

            if ( OSAL_NULL != poResultMessage )
            {
               tU32 u32TimeStamp = 0;
               vGetTimeStamp( &u32TimeStamp );

               if ( poResultMessage->bIsValid() )
               {
                  // create answer-message
                  poResultMessage->vInitServiceData (  
                     CCA_C_U16_APP_SENSOR,
                     poServiceData->u16GetSourceAppID(),    // Source, Target
                     AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                     0,                                     // StreamCounter
                     poServiceData->u16GetRegisterID(),     // RegisterID
                     poServiceData->u16GetCmdCounter(),     // nCmdCounter,
                     poServiceData->u16GetServiceID(),      // nServiceID,
                     SENSOR_LOCATIONFI_C_U16_GNSSSATSYSTEM,      // nFunctionID,
                     AMT_C_U8_CCAMSG_OPCODE_STATUS,         // OpCode
                     0,                                     // Asynchronous Completion Token (ACT)
                     AMT_C_U16_DEFAULT_NULL,                // Source Sub
                     AMT_C_U16_DEFAULT_NULL,                // Target Sub
                     u32TimeStamp                           // TimeStamp        
                  );
               }

               *ppoResponseMessage = static_cast<amt_tclServiceData *>( poResultMessage );

            }
            else
            {
               *ppoErrorMessage = 
                  OSAL_NEW amt_tclServiceDataError( poServiceData, VDS_E_INTERNAL_ERROR );

               s32RetVal = VDS_E_DISPATCHER_ALLOC_ERROR;
            }
         } // end case AMT_C_U8_CCAMSG_OPCODE_SET
         break;
      case AMT_C_U8_CCAMSG_OPCODE_GET:
         {

            tU8 u8ActGnssSatSys = poMsgGpsIf->u8GetGnssSatSys( );

            sensor_locationfi_tclMsgGnssSatSystemStatus oMsgGnssSatSystemStatus;

            oMsgGnssSatSystemStatus.ActualGnssSatSys.u8Value = u8ActGnssSatSys;

            fi_tclVisitorMessage* poResultMessage = 
               OSAL_NEW  fi_tclVisitorMessage( oMsgGnssSatSystemStatus, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );

               if ( OSAL_NULL != poResultMessage )
               {
                  tU32 u32TimeStamp = 0;
                  vGetTimeStamp( &u32TimeStamp );

                  if ( poResultMessage->bIsValid() )
                  {
                     // create answer-message
                     poResultMessage->vInitServiceData
                        (  CCA_C_U16_APP_SENSOR,
                           poServiceData->u16GetSourceAppID(),    // Source, Target
                           AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                           0,                                     // StreamCounter
                           poServiceData->u16GetRegisterID(),     // RegisterID
                           poServiceData->u16GetCmdCounter(),     // nCmdCounter,
                           poServiceData->u16GetServiceID(),      // nServiceID,
                           SENSOR_LOCATIONFI_C_U16_GNSSSATSYSTEM,      // nFunctionID,
                           AMT_C_U8_CCAMSG_OPCODE_STATUS,         // OpCode
                           0,                                     // Asynchronous Completion Token (ACT)
                           AMT_C_U16_DEFAULT_NULL,                // Source Sub
                           AMT_C_U16_DEFAULT_NULL,                // Target Sub
                           u32TimeStamp                           //TimeStamp
                        );
                  }

                  *ppoResponseMessage = 
                     static_cast<amt_tclServiceData *>( poResultMessage );
               }
               else
               {
                  *ppoErrorMessage = 
                     OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                                       VDS_E_INTERNAL_ERROR );

                  s32RetVal = VDS_E_DISPATCHER_ALLOC_ERROR;
               }
         } // end case AMT_C_U8_CCAMSG_OPCODE_GET
         break;
      default:
         {
            // Error: OpCode not supported
            *ppoErrorMessage = 
               OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                                 AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED );

            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      } // end switch opcode

      // leave critical section
      poMsgGpsIf->vCritSectionEnd();
   }
   else
   {
      *ppoErrorMessage = 
         OSAL_NEW amt_tclServiceDataError( poServiceData,
                                           VDS_E_INTERNAL_ERROR );

      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }
   return s32RetVal;
}



static void
vCopyFiToGnssUtcTimeDate ( const sensor_fi_tcl_TimeDate &rfFromFiTimeDate, 
                          OSAL_trGnssTimeUTC &rfToGnssUtcTimeDate )
{
   rfToGnssUtcTimeDate.u16Year        = rfFromFiTimeDate.td_year;
   rfToGnssUtcTimeDate.u8Month        = rfFromFiTimeDate.td_month;
   rfToGnssUtcTimeDate.u8Day          = rfFromFiTimeDate.td_day;
   rfToGnssUtcTimeDate.u8Hour         = rfFromFiTimeDate.td_hour;
   rfToGnssUtcTimeDate.u8Minute       = rfFromFiTimeDate.td_minute;
   rfToGnssUtcTimeDate.u8Second       = rfFromFiTimeDate.td_second;
   rfToGnssUtcTimeDate.u16Millisecond = rfFromFiTimeDate.td_milliSeconds;
   return;
};

static void 
vCopyGnssUtcToFiTimeDate ( const OSAL_trGnssTimeUTC &rfFromGnssUtcTimeDate, 
                          sensor_fi_tcl_TimeDate &rfToFiTimeDate )
{
   rfToFiTimeDate.td_year         =  rfFromGnssUtcTimeDate.u16Year;
   rfToFiTimeDate.td_month        =  rfFromGnssUtcTimeDate.u8Month;
   rfToFiTimeDate.td_day          =  rfFromGnssUtcTimeDate.u8Day;
   rfToFiTimeDate.td_hour         =  rfFromGnssUtcTimeDate.u8Hour;
   rfToFiTimeDate.td_minute       =  rfFromGnssUtcTimeDate.u8Minute;
   rfToFiTimeDate.td_second       =  rfFromGnssUtcTimeDate.u8Second;
   rfToFiTimeDate.td_milliSeconds =  rfFromGnssUtcTimeDate.u16Millisecond;
   return;
};

void
vCopyFiToOsalTimeDate( const sensor_fi_tcl_TimeDate &rfFromFiTimeDate,
                       OSAL_trTimeDate &rfToOsalTimeDate)
{
   rfToOsalTimeDate.s32Year   = rfFromFiTimeDate.td_year - 1900;        
   rfToOsalTimeDate.s32Month  = rfFromFiTimeDate.td_month;       
   rfToOsalTimeDate.s32Day    = rfFromFiTimeDate.td_day;         
   rfToOsalTimeDate.s32Hour   = rfFromFiTimeDate.td_hour;        
   rfToOsalTimeDate.s32Minute = rfFromFiTimeDate.td_minute;      
   rfToOsalTimeDate.s32Second = rfFromFiTimeDate.td_second;      
   return;
}


// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief property for setting the GNSS 20 year Epoch
//!   
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//!  
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchGnssWnEpoch
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message is
   //!  written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) : pointer to a location where a pointer to an error message is
   //! written if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;
   tU16 u16ErrToApp  = VDS_E_NO_ERROR;

   //Lock msg-if.
   if ( ( poMsgGpsIf != OSAL_NULL ) && ( poMsgGpsIf->bCritSectionBegin() ) )
   {
      //Get opcode from message.
      tU8  u8OpCode = poServiceData->u8GetOpCode();

      switch ( u8OpCode )
      {
         case AMT_C_U8_CCAMSG_OPCODE_SET:
         {
            OSAL_trGnssTimeUTC rTargetEpochUTC = { 0 };
            OSAL_trGnssTimeUTC rActualEpochUTC = { 0 };

            //Create the object for XML generated FI for Set OP type.
            sensor_locationfi_tclMsgGnssWnEpochSet oMsgGnssWnEpochSet;

            //Create the object of visitor message
            fi_tclVisitorMessage oVisitor( poServiceData );

            if ( OSAL_OK != oVisitor.s32GetData( oMsgGnssWnEpochSet,
                                                 SENSOR_LOCATIONFI_C_U16_SERVICE_MAJORVERSION ) )
            {
               u16ErrToApp = VDS_E_INTERNAL_ERROR;
               s32RetVal   = VDS_E_DISPATCHER_IF_ERROR;
            }
            else
            {
               //Copy Fi to GNSS.
               vCopyFiToGnssUtcTimeDate( oMsgGnssWnEpochSet.TargetWnDate,rTargetEpochUTC );
               //Set epoch.
               if ( true != poMsgGpsIf->bSetWnEpoch( rTargetEpochUTC,rActualEpochUTC) )
               {
                  u16ErrToApp = VDS_E_INTERNAL_ERROR;
                  s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
               }
               //Compose message and send.
               else
               {
                  //Create the object for XML generated FI for Set OP type.
                  sensor_locationfi_tclMsgGnssWnEpochStatus oMsgGnssWnEpochStatus;
                  //Copy GNSS to Fi.
                  vCopyGnssUtcToFiTimeDate( rActualEpochUTC, oMsgGnssWnEpochStatus.ActualWnDate );
                  //Create the object of visitor message and insert the class object.
                  fi_tclVisitorMessage* poResultMessage =
                                          OSAL_NEW  fi_tclVisitorMessage( oMsgGnssWnEpochStatus, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );

                  if ( OSAL_NULL != poResultMessage )
                  {
                     tU32 u32TimeStamp = 0;
                     vGetTimeStamp( &u32TimeStamp );

                     if ( poResultMessage->bIsValid() )
                     {
                        //Create answer-message.
                        poResultMessage->vInitServiceData (
                                CCA_C_U16_APP_SENSOR,
                                poServiceData->u16GetSourceAppID(),    // Source, Target
                                AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                                0,                                     // StreamCounter
                                poServiceData->u16GetRegisterID(),     // RegisterID
                                poServiceData->u16GetCmdCounter(),     // nCmdCounter,
                                poServiceData->u16GetServiceID(),      // nServiceID,
                                SENSOR_LOCATIONFI_C_U16_GNSSWNEPOCH,   // nFunctionID,
                                AMT_C_U8_CCAMSG_OPCODE_STATUS,         // OpCode
                                0,                                     // Asynchronous Completion Token (ACT)
                                AMT_C_U16_DEFAULT_NULL,                // Source Sub
                                AMT_C_U16_DEFAULT_NULL,                // Target Sub
                                u32TimeStamp                           // TimeStamp        
                              );
                     }

                     *ppoResponseMessage = static_cast<amt_tclServiceData *>( poResultMessage );
                  }
                  else
                  {
                     u16ErrToApp = VDS_E_INTERNAL_ERROR;
                     s32RetVal   = VDS_E_DISPATCHER_ALLOC_ERROR;
                  }
               }
            }
         }//End case AMT_C_U8_CCAMSG_OPCODE_SET
         break;
         
         case AMT_C_U8_CCAMSG_OPCODE_GET:
         {
            OSAL_trGnssTimeUTC rActualEpochUTC = { 0 };
            //Get epoch.
            if ( TRUE != poMsgGpsIf->bGetWnEpoch( rActualEpochUTC))
            {
               u16ErrToApp = VDS_E_INTERNAL_ERROR;
               s32RetVal   = VDS_E_DISPATCHER_IF_ERROR;
            }
            else
            {
               //Create the object for XML generated FI.
               sensor_locationfi_tclMsgGnssWnEpochStatus oMsgGnssWnEpochStatus;
               //Copy GNSS to Fi.
               vCopyGnssUtcToFiTimeDate( rActualEpochUTC, oMsgGnssWnEpochStatus.ActualWnDate );
               //Create the object of visitor message and insert the class object.
               fi_tclVisitorMessage* poResultMessage = 
                  OSAL_NEW  fi_tclVisitorMessage( oMsgGnssWnEpochStatus, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );

               if ( OSAL_NULL != poResultMessage )
               {
                  tU32 u32TimeStamp = 0;
                  vGetTimeStamp( &u32TimeStamp );

                  if ( poResultMessage->bIsValid() )
                  {
                     // create answer-message
                     poResultMessage->vInitServiceData
                           (  CCA_C_U16_APP_SENSOR,
                              poServiceData->u16GetSourceAppID(),    // Source, Target
                              AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                              0,                                     // StreamCounter
                              poServiceData->u16GetRegisterID(),     // RegisterID
                              poServiceData->u16GetCmdCounter(),     // nCmdCounter,
                              poServiceData->u16GetServiceID(),      // nServiceID,
                              SENSOR_LOCATIONFI_C_U16_GNSSWNEPOCH,      // nFunctionID,
                              AMT_C_U8_CCAMSG_OPCODE_STATUS,         // OpCode
                              0,                                     // Asynchronous Completion Token (ACT)
                              AMT_C_U16_DEFAULT_NULL,                // Source Sub
                              AMT_C_U16_DEFAULT_NULL,                // Target Sub
                              u32TimeStamp                           //TimeStamp
                           );
                  }

                  *ppoResponseMessage = 
                        static_cast<amt_tclServiceData *>( poResultMessage );
               }
               else
               {
                  u16ErrToApp = VDS_E_INTERNAL_ERROR;
                  s32RetVal   = VDS_E_DISPATCHER_ALLOC_ERROR;
               }
            }
         } // end case AMT_C_U8_CCAMSG_OPCODE_GET
         break;

         default:
         {
            //Error:OpCode not supported.
            u16ErrToApp = AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      }//End switch opcode.

      //Leave critical section
      poMsgGpsIf->vCritSectionEnd();
   }
   else
   {
      u16ErrToApp = VDS_E_INTERNAL_ERROR;
      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }

   //If error occurred create responce message with error.
   if( s32RetVal != VDS_E_NO_ERROR )
   {
      *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, u16ErrToApp );
   }

   return s32RetVal;
}

void
vCopyFiToVdsTimeMode ( const sensor_fi_tcl_e8_timeMode &rfenFromFiTimeMode,
                       vds_tenTimeMode &rfenToVdsTimeMode )
{
   switch (rfenFromFiTimeMode.enType)
   {
   case (sensor_fi_tcl_e8_timeMode::FI_EN_TIMEMODE_AUTO):
       rfenToVdsTimeMode = enTimeModeAuto;
      break;
   case (sensor_fi_tcl_e8_timeMode::FI_EN_TIMEMODE_MANUAL):
       rfenToVdsTimeMode = enTimeModeManual;
      break;
   case (sensor_fi_tcl_e8_timeMode::FI_EN_TIMEMODE_INVALID):
      rfenToVdsTimeMode = enTimeModeInvalid;
      break;
   case (sensor_fi_tcl_e8_timeMode::FI_EN_TIMEMODE_DEFAULT):
   default:
       rfenToVdsTimeMode = enTimeModeDefault;
       break;
   }
   return;
}

void
vCopyVdsToFiTimeMode ( const vds_tenTimeMode &rfenFromVdsTimeMode,
                       sensor_fi_tcl_e8_timeMode &rfenToFiTimeMode)
{
   switch (rfenFromVdsTimeMode)
   {
   case (enTimeModeAuto):
      rfenToFiTimeMode.enType = sensor_fi_tcl_e8_timeMode::FI_EN_TIMEMODE_AUTO;
      break;
   case (enTimeModeManual):
      rfenToFiTimeMode.enType = sensor_fi_tcl_e8_timeMode::FI_EN_TIMEMODE_MANUAL;
      break;
   case (enTimeModeInvalid):
      rfenToFiTimeMode.enType = sensor_fi_tcl_e8_timeMode::FI_EN_TIMEMODE_INVALID;
      break;
   case (enTimeModeDefault):
   default:
      rfenToFiTimeMode.enType = sensor_fi_tcl_e8_timeMode::FI_EN_TIMEMODE_DEFAULT;
   }
   return;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief property for getting/setting the time mode
//!   
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//!  
//******************************************************************************
#if 0
tS32 tclSensorMsgDispatcher::s32DispatchTimeMode
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message is
   //!  written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) : pointer to a location where a pointer to an error message is
   //! written if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;
   tBool bRet=FALSE;

   // lock msg-if
   if ( ( poMsgGpsIf != OSAL_NULL ) && ( poMsgGpsIf->bCritSectionBegin() ) )
   {
      // get opcode from message
      tU8  u8OpCode = poServiceData->u8GetOpCode();

      switch ( u8OpCode )
      {
      case AMT_C_U8_CCAMSG_OPCODE_SET:
         {
            /* Create the object for XML generated FI for Set OP type*/
            sensor_locationfi_tclMsgTimeModeSet oMsgTimeModeSet;

            /* Create the object of visitor message*/
            fi_tclVisitorMessage oVisitor( poServiceData );
            vds_tenTimeMode enTargetTimeMode = enTimeModeInvalid;
            vds_tenTimeMode enActualTimeMode = enTimeModeInvalid;
            OSAL_trTimeDate rTargetTime = {0};
            // OSAL_trGPSTimeUTC rActualTimeUtc = {0};

            if ( OSAL_OK 
                 == 
                 oVisitor.s32GetData( oMsgTimeModeSet , 
                                      SENSOR_LOCATIONFI_C_U16_SERVICE_MAJORVERSION ) )
            {
               vCopyFiToVdsTimeMode ( oMsgTimeModeSet.targetTimeMode , 
                                      enTargetTimeMode );
               
               vCopyFiToOsalTimeDate ( oMsgTimeModeSet.targetTimeDate,
                                       rTargetTime );

               bRet = poMsgGpsIf->bSetTimeMode ( enTargetTimeMode , rTargetTime);
               
               if (TRUE == bRet)
               {
                  bRet = poMsgGpsIf->bGetTimeMode( enActualTimeMode );
               }
            }

            /* Create the object for XML generated FI for Set OP type */
            sensor_locationfi_tclMsgTimeModeStatus oMsgTimeModeStatus;

            if (bRet)
            {
               vCopyVdsToFiTimeMode( enActualTimeMode , 
                                     oMsgTimeModeStatus.actualTimeMode );

            }
            /* Create the object of visitor message and insert the class object*/
            fi_tclVisitorMessage* poResultMessage = 
               OSAL_NEW  fi_tclVisitorMessage( oMsgTimeModeStatus, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );

            if ( OSAL_NULL != poResultMessage )
            {
               tU32 u32TimeStamp = 0;
               vGetTimeStamp( &u32TimeStamp );

               if ( poResultMessage->bIsValid() )
               {
                  // create answer-message
                  poResultMessage->vInitServiceData (  
                     CCA_C_U16_APP_SENSOR,
                     poServiceData->u16GetSourceAppID(),    // Source, Target
                     AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                     0,                                     // StreamCounter
                     poServiceData->u16GetRegisterID(),     // RegisterID
                     poServiceData->u16GetCmdCounter(),     // nCmdCounter,
                     poServiceData->u16GetServiceID(),      // nServiceID,
                     SENSOR_LOCATIONFI_C_U16_TIMEMODE,           // nFunctionID,
                     AMT_C_U8_CCAMSG_OPCODE_STATUS,         // OpCode
                     0,                                     // Asynchronous Completion Token (ACT)
                     AMT_C_U16_DEFAULT_NULL,                // Source Sub
                     AMT_C_U16_DEFAULT_NULL,                // Target Sub
                     u32TimeStamp                           // TimeStamp        
                  );
               }

               *ppoResponseMessage = static_cast<amt_tclServiceData *>( poResultMessage );

            }
            else
            {
               *ppoErrorMessage = 
                  OSAL_NEW amt_tclServiceDataError( poServiceData, VDS_E_INTERNAL_ERROR );

               s32RetVal = VDS_E_DISPATCHER_ALLOC_ERROR;
            }
         } // end case AMT_C_U8_CCAMSG_OPCODE_SET
         break;
      case AMT_C_U8_CCAMSG_OPCODE_GET:
         {
            vds_tenTimeMode enActualTimeMode = enTimeModeInvalid;
            sensor_locationfi_tclMsgTimeModeStatus oMsgTimeModeStatus;

            bRet = poMsgGpsIf->bGetTimeMode( enActualTimeMode );
            if (bRet)
            {
               vCopyVdsToFiTimeMode( enActualTimeMode , 
                                     oMsgTimeModeStatus.actualTimeMode );
            }

            fi_tclVisitorMessage* poResultMessage = 
               OSAL_NEW  fi_tclVisitorMessage( oMsgTimeModeStatus, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );

               if ( OSAL_NULL != poResultMessage )
               {
                  tU32 u32TimeStamp = 0;
                  vGetTimeStamp( &u32TimeStamp );

                  if ( poResultMessage->bIsValid() )
                  {
                     // create answer-message
                     poResultMessage->vInitServiceData
                        (  CCA_C_U16_APP_SENSOR,
                           poServiceData->u16GetSourceAppID(),    // Source, Target
                           AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                           0,                                     // StreamCounter
                           poServiceData->u16GetRegisterID(),     // RegisterID
                           poServiceData->u16GetCmdCounter(),     // nCmdCounter,
                           poServiceData->u16GetServiceID(),      // nServiceID,
                           SENSOR_LOCATIONFI_C_U16_TIMEMODE,      // nFunctionID,
                           AMT_C_U8_CCAMSG_OPCODE_STATUS,         // OpCode
                           0,                                     // Asynchronous Completion Token (ACT)
                           AMT_C_U16_DEFAULT_NULL,                // Source Sub
                           AMT_C_U16_DEFAULT_NULL,                // Target Sub
                           u32TimeStamp                           //TimeStamp
                        );
                  }

                  *ppoResponseMessage = 
                     static_cast<amt_tclServiceData *>( poResultMessage );
               }
               else
               {
                  *ppoErrorMessage = 
                     OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                                       VDS_E_INTERNAL_ERROR );

                  s32RetVal = VDS_E_DISPATCHER_ALLOC_ERROR;
               }
         } // end case AMT_C_U8_CCAMSG_OPCODE_GET
         break;
      default:
         {
            // Error: OpCode not supported
            *ppoErrorMessage = 
               OSAL_NEW amt_tclServiceDataError( poServiceData, 
                                                 AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED );

            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      } // end switch opcode

      // leave critical section
      poMsgGpsIf->vCritSectionEnd();
   }
   else
   {
      *ppoErrorMessage = 
         OSAL_NEW amt_tclServiceDataError( poServiceData,
                                           VDS_E_INTERNAL_ERROR );

      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }

   return s32RetVal;
}
#endif

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!  adds subscriber to subscriber-list. whenever a value is changed, the subscriber-list will
//!  be checked and a state-message will be sent
//!
//! \return
//!   - \c Subscriber pointer:  if add subscriber is successfull:
//!   - \c NULL : If error occurs while creating subscriber
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tclSubscriberManager * tclSensorMsgDispatcher::poAddSubscriber
(
   //!  (I) : pointer to received message
   amt_tclServiceData *poServiceData,
   //! (O) : pointer to response-error-message
   amt_tclServiceDataError **ppoErrorMessage
)
{
  tclSubscriberManager *poSubscriber = NULL;
   
   VDS_PREVIOUSLY_ASSIGNED_VALUE_INTENTIONALLY_UNUSED(poSubscriber);

   if ( NULL != poGetSubscriber ( poServiceData ) )
   {
      // subscriber exists already...
      // For now, do error trace but continue, in order not to break anything with this check.
      vTraceMsg( VDS_C_TRACELEVEL_ERROR, "VDSensor: AppId %d, svcid %d, fctid %d already subscribed!",
                 poServiceData->u16GetSourceAppID(), poServiceData->u16GetServiceID(),
                 poServiceData->u16GetFunctionID() );
      // ToDo: later on we should generate an error message like below, and return:
      //*ppoErrorMessage = new amt_tclServiceDataError( poServiceData, AMT_C_U16_ERROR_UPREG_FAILURE );
   }

   poSubscriber = new tclSubscriberManager
   (  poServiceData->u16GetRegisterID(),
      poServiceData->u16GetServiceID(),
      poServiceData->u16GetFunctionID(),
      poServiceData->u16GetSourceAppID(),
      poServiceData->u16GetSourceSubID(),
      poServiceData->u16GetCmdCounter(),
      poServiceData->u8GetACT() );

   if ( NULL != poSubscriber )
   {
      if ( VDS_E_NO_ERROR != poSubscriber->s32AddSubscriber() )
      {
         // delete subscriber
         delete poSubscriber;
         poSubscriber = NULL;
         *ppoErrorMessage = new amt_tclServiceDataError( poServiceData, AMT_C_U16_ERROR_UPREG_FAILURE );
      }
   }
   else
   {
      *ppoErrorMessage = new amt_tclServiceDataError( poServiceData, VDS_E_INTERNAL_ERROR );
   }

   return poSubscriber;
}
// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   returns subscriber with given id from subscriber-list.
//!
//! \return
//!   - \c Subscriber pointer:  if get subscriber is successfull:
//!   - \c NULL : If error occurs while creating subscriber
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tclSubscriberManager * tclSensorMsgDispatcher::poGetSubscriber
(
   //!  (I) : pointer to received message
   const amt_tclServiceData *poServiceData
)
{
   tclSubscriberManager *poReturnSubscriber = NULL;
   tU16 u16ServId = poServiceData->u16GetServiceID();
   tU16 u16FuncId = poServiceData->u16GetFunctionID();
   // get first subscriber with function-id
   tclSubscriberManager *poSubscriber = tclSubscriberManager::poGetSubscriberWithFId( NULL,
                                        u16ServId,
                                        u16FuncId );

   while ( NULL != poSubscriber )
   {
      // check register-id, target-app-id and act
      if (   poSubscriber->u16GetRegisterId()      == poServiceData->u16GetRegisterID()
             && poSubscriber->u16GetServiceId()  == poServiceData->u16GetServiceID()
             && poSubscriber->u16GetTargetAppId()   == poServiceData->u16GetSourceAppID()
             && poSubscriber->u16GetMessageSubId()  == poServiceData->u16GetSourceSubID() )
      {
         poReturnSubscriber = poSubscriber;
         break;
      }

      poSubscriber = tclSubscriberManager::poGetSubscriberWithFId( poSubscriber,
                     u16ServId,
                     u16FuncId );
   }

   return poReturnSubscriber;
}
// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   deletes subscribers with given ids from subscriber-list.
//!
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DeleteSubscriber
(
   //!  (I) : pointer to incoming message
   const amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message is written if the input message is handled successfully.
   amt_tclServiceData **ppoResponseMessage,
   //!  (O) : pointer to a location where a pointer to an error message is written if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( ppoResponseMessage );
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( ppoErrorMessage );
   tU16 u16ServId = poServiceData->u16GetServiceID();
   tU16 u16FuncId = poServiceData->u16GetFunctionID();
   // get first subscriber with function-id
   tclSubscriberManager *poSubscriber = tclSubscriberManager::poGetSubscriberWithFId( NULL,
                                        u16ServId,
                                        u16FuncId );
   tclSubscriberManager *poHelpSubscriber = poSubscriber;

   while ( NULL != poSubscriber )
   {
      // get following subscriber with function-id
      poHelpSubscriber = tclSubscriberManager::poGetSubscriberWithFId( poSubscriber,
                         u16ServId,
                         u16FuncId );

      // check register-id, target-app-id and act
      if (  poSubscriber->u16GetRegisterId() == poServiceData->u16GetRegisterID()
            && poSubscriber->u16GetServiceId()  == poServiceData->u16GetServiceID()
            && poSubscriber->u16GetTargetAppId()   == poServiceData->u16GetSourceAppID()
            && poSubscriber->u16GetMessageSubId()  == poServiceData->u16GetSourceSubID() )
      {
         // delete subscriber from list
         poSubscriber->s32DeleteSubscriber();
         delete poSubscriber;
      }

      poSubscriber = poHelpSubscriber;
   }

   return s32RetVal;
}
// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!   Gets the Aux Clock time value i.e. Low value
//!
//! \return
//!   None
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
// 30.06.2009   | sak9kor (RBEI/ECF1)    |Initial version
// 10.08.2009   | sak9kor (RBEI/ECF1)    | Function name has been changed to
//                                         vGetTimeStamp
//******************************************************************************
void vGetTimeStamp
(
   //!  (O) : pointer to a location where aux lowvalue will be updated
   tPU32 pu32TimeStamp
)
{
   OSAL_tIODescriptor  hDevice;
   OSAL_trIOCtrlAuxClockTicks  rIOAuxData = {0, 0};
   *pu32TimeStamp = 0;

   hDevice = OSAL_IOOpen( OSAL_C_STRING_DEVICE_AUXILIARY_CLOCK,
                          OSAL_EN_READONLY );

   if ( hDevice  == OSAL_ERROR )
   {
      vTraceMsg( VDS_C_TRACELEVEL_ERROR,
                 "vGetTimeStamp:Opening AuxClock Failed");
   }
   else
   {
      if( OSAL_ERROR == OSAL_s32IORead( hDevice,
                                        (tPS8)&rIOAuxData,
                                        sizeof( OSAL_trIOCtrlAuxClockTicks ) ) )
      {
         vTraceMsg( VDS_C_TRACELEVEL_ERROR,
                    "vGetTimeStamp:Reading AuxClock Failed");
      }
      else
      {
         *pu32TimeStamp = rIOAuxData.u32Low;
      }

      OSAL_s32IOClose ( hDevice );
   }
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief Dispatcher function of the proprty GnssConfigData.
//!   
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//!  
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************

tS32 tclSensorMsgDispatcher::s32DispatchGnssConfigData
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message is
   //!  written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) : pointer to a location where a pointer to an error message is
   //! written if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;
   tU16 u16ErrToApp = VDS_E_NO_ERROR;

   // lock msg-if
   if (( poMsgGpsIf != OSAL_NULL ) && ( poMsgGpsIf->bCritSectionBegin()))
   {
      switch ( poServiceData->u8GetOpCode() )
      {
         case AMT_C_U8_CCAMSG_OPCODE_GET:
         {
            if(( poMsgGpsIf->s32GetGnssConfigDataMsg(poServiceData,ppoResponseMessage) != VDS_E_NO_ERROR ) ||
               (OSAL_NULL == *ppoResponseMessage )
              )
            {
               u16ErrToApp = VDS_E_DATA_UNAVAILABLE;
               s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
            }
         }
         break;
         default:
         {
            // Error: OpCode not supported
            u16ErrToApp = AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      }

      poMsgGpsIf->vCritSectionEnd();
   }
   else
   {
      u16ErrToApp = VDS_E_INTERNAL_ERROR;
      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }
   
   //If error occurred create responce message with error.
   if( s32RetVal != VDS_E_NO_ERROR )
   {
      *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, u16ErrToApp );
   }

   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief Dispatcher function of the proprty GnssData.
//!
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//!  
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchGnssData
(
   //! (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //! (O) : pointer to a location where reply message is available.   
   amt_tclServiceData **ppoResponseMessage,
   //! (O) : pointer to a location where a pointer to an error message is
   //! written if an error occurred during handling of the input message   
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;
   tU16 u16ErrToApp = VDS_E_NO_ERROR;

   //Lock msg-if.
   if( (poMsgGpsIf != OSAL_NULL) && 
       (poMsgGpsIf->bCritSectionBegin()) )
   {
      tS32 s32ElemsCopied = 0;

      switch( poServiceData->u8GetOpCode() )
      {
         case AMT_C_U8_CCAMSG_OPCODE_GET:
         {
            tU32 u32NextElemToRead = poMsgGpsIf->u32GetLastGnssElemIndex();

            s32ElemsCopied = poMsgGpsIf->s32GetGnssDataMsg( poServiceData,
                                                            OSAL_NULL,
                                                            ppoResponseMessage,
                                                            u32NextElemToRead );

            if( (s32ElemsCopied <= 0) || (OSAL_NULL == *ppoResponseMessage))
            {
               if(VDS_E_GPSIF_DATA_UNAVAILABLE == s32ElemsCopied)
               {
                  u16ErrToApp = VDS_E_DATA_UNAVAILABLE;
               }
               else
               {
                  u16ErrToApp = VDS_E_INTERNAL_ERROR;
               }

               s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
            }
         }
         break;

         case AMT_C_U8_CCAMSG_OPCODE_UPREG:
         {
            tU32 u32NextElemToRead = poMsgGpsIf->u32GetLastGnssElemIndex();

            s32ElemsCopied = poMsgGpsIf->s32GetGnssDataMsg( poServiceData,
                                                            OSAL_NULL,
                                                            ppoResponseMessage,
                                                            u32NextElemToRead );

            if((s32ElemsCopied > 0) && (OSAL_NULL != *ppoResponseMessage ))
            {
               tclSubscriberManager *poSubscriber = poAddSubscriber( poServiceData, ppoErrorMessage );

               if( OSAL_NULL != poSubscriber )
               {
                  // tclAilVDSensor-lock when sending messages needed
                  poSubscriber->vSetMessageLockNeeded( TRUE );
                  poSubscriber->vSetInitMessageSent( TRUE );
                  // set next elem to read
                  poSubscriber->vSetNextElemToRead( u32NextElemToRead );
               }
               else
               {
                  s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
                  OSAL_DELETE *ppoResponseMessage;
                  *ppoResponseMessage = OSAL_NULL;
               }
            }
            else
            {
               if(VDS_E_GPSIF_DATA_UNAVAILABLE == s32ElemsCopied)
               {
                  u16ErrToApp = VDS_E_DATA_UNAVAILABLE;
               }
               else
               {
                  u16ErrToApp = VDS_E_INTERNAL_ERROR;
               }

               s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
            }
         }
         break;

         case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
         {

            tclSubscriberManager *poSubscriber = poGetSubscriber( poServiceData );

            if( OSAL_NULL != poSubscriber )
            {

               tU32 u32NextElemToRead = poSubscriber->u32GetNextElemToRead() - 1;

               s32ElemsCopied = poMsgGpsIf->s32GetGnssDataMsg( poServiceData,
                                                               OSAL_NULL,
                                                               ppoResponseMessage,
                                                               u32NextElemToRead );

               if( (s32ElemsCopied <= 0) || (OSAL_NULL == *ppoResponseMessage ))
               {
                  if(VDS_E_GPSIF_DATA_UNAVAILABLE == s32ElemsCopied)
                  {
                     u16ErrToApp = VDS_E_DATA_UNAVAILABLE;
                  }
                  else
                  {
                     u16ErrToApp = VDS_E_INTERNAL_ERROR;
                  }

                  s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
               }
            }

            //Delete subscriber.
            if ( VDS_E_NO_ERROR != s32DeleteSubscriber( poServiceData,
                                                        ppoResponseMessage,
                                                        ppoErrorMessage ) )
            {
               s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
            }
         }
         break;

         default:
         {
            u16ErrToApp = AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;

      }//End switch

      poMsgGpsIf->vCritSectionEnd();
   }
   else
   {
      u16ErrToApp = VDS_E_INTERNAL_ERROR;
      s32RetVal   = VDS_E_DISPATCHER_IF_ERROR;
   }

   //If error occurred,create an error message.
   if(s32RetVal != VDS_E_NO_ERROR)
   {
      *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, u16ErrToApp );
   }

   return s32RetVal;
}


// *********************** F U N C T I O N  H E A D E R ********************************
//
//  DESCRIPTION:
//
//! \brief Dispatcher function of the proprty AllSensorData.
//!
//! \return
//!       Succes code in case of success is:
//!             - \c  VDS_E_NO_ERROR : Success\n
//!       Error code in case of failure are:\n
//!             - \c VDS_E_DISPATCHER_IF_ERROR : Dispather IF error
//!             - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//!             - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//!             - \c VDS_E_DISPATCHER_UNKNOWN_ERROR :Unknown error.
//!
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchAllSensorData
(
   //! (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //! (O) : pointer to a location where a
   //!       pointer to the reply message is copied.
   amt_tclServiceData **ppoResponseMessage,
   //! (O) : pointer to a location where a
   //!       pointer to an error message is copied   
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;
   tU16 u16ErrToApp = 0;
   Vds_AllSenDataNextElemToSend rNextElmToRead={0,0,0,0,0};

   switch( poServiceData->u8GetOpCode() )
   {
      case AMT_C_U8_CCAMSG_OPCODE_GET:
      {
         if( OSAL_NULL != poMsgGpsIf )
         {
            rNextElmToRead.u32NextGnssElementToRead = poMsgGpsIf->u32GetLastGnssElemIndex();
         }
         if( OSAL_NULL != poMsgGyroIf )
         {
            rNextElmToRead.u32NextGyroElementToRead = poMsgGyroIf->u32GetLastGyroElemIndex();
         }
         if( OSAL_NULL != poMsgOdometerIf )
         {
            rNextElmToRead.u32NextOdoElementToRead  = poMsgOdometerIf->u32GetLastOdoElemIndex();
         }
         if( OSAL_NULL != poMsgAccIf )
         {
            rNextElmToRead.u32NextAccElementToRead  = poMsgAccIf->u32GetLastAccElemIndex();
         }
         if( OSAL_NULL != poMsgAbsIf )
         {
            rNextElmToRead.u32NextAbsElementToRead  = poMsgAbsIf->u32GetLastAbsElemIndex();
         }

         s32RetVal = s32GetAllSensorDataMsg( poServiceData,
                                             OSAL_NULL,
                                             ppoResponseMessage,
                                             rNextElmToRead);

         if( (s32RetVal != VDS_E_NO_ERROR) || (OSAL_NULL == *ppoResponseMessage) )
         {
            if(VDS_E_GPSIF_DATA_UNAVAILABLE == s32RetVal)
            {
               u16ErrToApp = VDS_E_DATA_UNAVAILABLE;
            }
            else
            {
               u16ErrToApp = VDS_E_INTERNAL_ERROR;
            }

            s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
         }
      }
      break;

      case AMT_C_U8_CCAMSG_OPCODE_UPREG:
      {
         rNextElmToRead.u32NextGnssElementToRead = 0;
         rNextElmToRead.u32NextGyroElementToRead = 0;
         rNextElmToRead.u32NextOdoElementToRead  = 0;
         rNextElmToRead.u32NextAccElementToRead  = 0;
         rNextElmToRead.u32NextAbsElementToRead  = 0;
         
         s32RetVal = s32GetAllSensorDataMsg( poServiceData,
                                             OSAL_NULL,
                                             ppoResponseMessage,
                                             rNextElmToRead);

         if ((s32RetVal == VDS_E_NO_ERROR) && (OSAL_NULL != *ppoResponseMessage ))
         {
            tclSubscriberManager *poSubscriber = poAddSubscriber( poServiceData, ppoErrorMessage );

            if ( OSAL_NULL !=  poSubscriber )
            {
               poSubscriber->vSetMessageLockNeeded( TRUE );
               poSubscriber->vSetInitMessageSent( TRUE );
               poSubscriber->vSetAllSen_NxtElmToRead(rNextElmToRead);
            }
            else
            {
               s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
               u16ErrToApp = VDS_E_INTERNAL_ERROR;
               OSAL_DELETE *ppoResponseMessage;
               *ppoResponseMessage = OSAL_NULL;
            }
         }
         else
         {
            if(VDS_E_GPSIF_DATA_UNAVAILABLE == s32RetVal)
            {
               u16ErrToApp = VDS_E_DATA_UNAVAILABLE;
            }
            else
            {
               u16ErrToApp = VDS_E_INTERNAL_ERROR;
            }

            s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
         }
      }
      break;

      case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
      {

         tclSubscriberManager *poSubscriber = poGetSubscriber( poServiceData );
         if( OSAL_NULL != poSubscriber )
         {
            poSubscriber->vGetAllSen_NxtElmToRead(rNextElmToRead);

            s32RetVal = s32GetAllSensorDataMsg( poServiceData,
                                                OSAL_NULL,
                                                ppoResponseMessage,
                                                rNextElmToRead);

            if ( (s32RetVal != VDS_E_NO_ERROR) || (OSAL_NULL == *ppoResponseMessage ))
            {
               if(VDS_E_GPSIF_DATA_UNAVAILABLE == s32RetVal)
               {
                  u16ErrToApp = VDS_E_DATA_UNAVAILABLE;
               }
               else
               {
                  u16ErrToApp = VDS_E_INTERNAL_ERROR;
               }
               s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
            }
         }

         if( VDS_E_NO_ERROR != s32DeleteSubscriber( poServiceData, ppoResponseMessage, ppoErrorMessage ) )
         {
            s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
         }

      }
      break;

      default:
      {
         u16ErrToApp = AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
         s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
      }
      break;
   }// end switch opcode

   //Create An Error Message If Any Error Occurred
   if(s32RetVal != VDS_E_NO_ERROR)
   {
      *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, u16ErrToApp );
   }

   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief Compose response message for "AllSensorData" property. 
//!
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_INVALID_PARAMETER :if input arguments are invalid.
//!   - \c VDS_E_GPSIF_ALLOC_ERROR :If failed to create object of visitor class
//!  
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************

tS32 s32GetAllSensorDataMsg
(
   //! (I) : Pointer to Service data
   amt_tclServiceData const *poServiceData,
   //! (I) : Pointer to Subscriber data
   tclSubscriberManager *poSubscriber,
   //! (O) : pointer to a location where a pointer to the reply message is available
   amt_tclServiceData **ppoResponseMessage,
   //! (I) :Next elements to read
   Vds_AllSenDataNextElemToSend &rNextElmToRead
)
{

   tU16 u16RegisterID  = 0;
   tU16 u16CmdCounter  = 0;
   tU16 u16TargetAppID = 0;
   tU16 u16ServiceID   = 0;
   tS32 s32RetVal = VDS_E_NO_ERROR;

   if( OSAL_NULL != poServiceData )
   {
      u16TargetAppID = poServiceData->u16GetSourceAppID();
      u16RegisterID  = poServiceData->u16GetRegisterID();
      u16CmdCounter  = poServiceData->u16GetCmdCounter();
      u16ServiceID   = poServiceData->u16GetServiceID();
   }
   else if( OSAL_NULL != poSubscriber )
   {
      u16TargetAppID = poSubscriber->u16GetTargetAppId();
      u16RegisterID  = poSubscriber->u16GetRegisterId();
      u16CmdCounter  = poSubscriber->u16GetCommandCntr();
      u16ServiceID   = poSubscriber->u16GetServiceId();
   }
   else
   {
      s32RetVal = VDS_E_INVALID_PARAMETER;
   }

   //Parameter Check.
   if(( VDS_E_NO_ERROR != s32RetVal ) || ( OSAL_NULL == ppoResponseMessage ))
   {
      s32RetVal = VDS_E_INVALID_PARAMETER;
      vTraceMsg( VDS_C_TRACELEVEL_ERROR,
                 "AllSenDataMsg:Invalid param  pSerData =%u  pSub =%u pResMsg =%u",
                 poServiceData,poSubscriber,ppoResponseMessage );
   }
   else
   {

      *ppoResponseMessage = OSAL_NULL;
      sensor_locationfi_tclMsgAllSensorDataStatus oAllSensorData;

      //Gnss data
      if( ( poMsgGpsIfDup != OSAL_NULL ) && poMsgGpsIfDup->bCritSectionBegin() )
      {
         //Even this call fails continue and send remaining sensors data.
         (tVoid)poMsgGpsIfDup->s32GetGnssRecords( &oAllSensorData.SensorDataBlock,
                                                  rNextElmToRead.u32NextGnssElementToRead );
         //In case of error printing trace in the above called function.
         poMsgGpsIfDup->vCritSectionEnd();
      }

      //Odometer data
      if( (poMsgOdometerIfDup != OSAL_NULL) && poMsgOdometerIfDup->oCS.bEnter() )
      {
         //Even this call fails continue and send remaining sensors data.
         (tVoid)poMsgOdometerIfDup->s32GetOdoRecords( &oAllSensorData.SensorDataBlock,
                                                      rNextElmToRead.u32NextOdoElementToRead );
         //In case of error printing traces in the above called function.
         poMsgOdometerIfDup->oCS.vLeave();
      }

      //Abs data
      if( (poMsgAbsIfDup != OSAL_NULL) && poMsgAbsIfDup->oCS.bEnter() )
      {
         //Even this call fails continue and send remaining sensors data.
         (tVoid)poMsgAbsIfDup->s32GetAbsRecords( &oAllSensorData.SensorDataBlock,
                                                 rNextElmToRead.u32NextAbsElementToRead );
         //In case of error printing traces in the above called function.
         poMsgAbsIfDup->oCS.vLeave();
      }

      //Gyro data
      if( ( poMsgGyroIfDup != OSAL_NULL ) && poMsgGyroIfDup->oCS.bEnter() )
      {
         //Even this call fails continue and send remaining sensors data.
        (tVoid)poMsgGyroIfDup->s32GetGyroRecords( &oAllSensorData.SensorDataBlock,
                                                  rNextElmToRead.u32NextGyroElementToRead );
         //In case of error printing traces in the above called function.
         poMsgGyroIfDup->oCS.vLeave();
      }

      //Acc data
      if( ( poMsgAccIfDup != OSAL_NULL ) && poMsgAccIfDup->oCS.bEnter() )
      {
         //Even this call fails continue and send remaining sensors data.
         (tVoid)poMsgAccIfDup->s32GetAccRecords( &oAllSensorData.SensorDataBlock,
                                                 rNextElmToRead.u32NextAccElementToRead );
         //In case of error printing traces in the above called function.
         poMsgAccIfDup->oCS.vLeave();
      }

      //Create the object of visitor message and insert the class object
      fi_tclVisitorMessage* poResultMessage = OSAL_NEW  fi_tclVisitorMessage( oAllSensorData, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );

      if(( OSAL_NULL != poResultMessage ) && (poResultMessage->bIsValid()) )
      {
         tU32 u32TimeStamp = 0;
         vGetTimeStamp( &u32TimeStamp );

         poResultMessage->vInitServiceData( CCA_C_U16_APP_SENSOR,                 // Source,
                                            u16TargetAppID,                       // Target
                                            AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    // StreamType
                                            0,                                    // StreamCounter
                                            u16RegisterID,                        // RegisterID
                                            u16CmdCounter,                        // nCmdCounter,
                                            u16ServiceID,                         // nServiceID,
                                            SENSOR_LOCATIONFI_C_U16_ALLSENSORDATA,// nFunctionID,
                                            AMT_C_U8_CCAMSG_OPCODE_STATUS,        // OpCode
                                            0,                                    // Asynchronous Completion Token (ACT)
                                            AMT_C_U16_DEFAULT_NULL,               // Source Sub
                                            AMT_C_U16_DEFAULT_NULL,               // Target Sub
                                            u32TimeStamp                          // TimeStamp
                                          );
         *ppoResponseMessage = poResultMessage;
      }
      else
      {
		 OSAL_DELETE poResultMessage;
		 poResultMessage = OSAL_NULL;
    	 s32RetVal = VDS_E_GPSIF_ALLOC_ERROR;
         vTraceMsg( VDS_C_TRACELEVEL_ERROR,"AllSenDataMsg:Failed to create response message");
      }
   }

   return s32RetVal;
}


// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief property for getting VD Sensor version information.
//!
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_ALLOC_ERROR : Allocation error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//!
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//********************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchVdsVersionInfo
(
   //!  (I) : pointer to income message
   amt_tclServiceData *poServiceData,
   //!  (O) : pointer to a location where a pointer to the reply message is
   //!  written if the input message is handled successfully
   amt_tclServiceData **ppoResponseMessage,
   //! (O) : pointer to a location where a pointer to an error message is
   //! written if an error occurred during handling of the input message
   amt_tclServiceDataError **ppoErrorMessage
)
{
   tS32 s32RetVal = VDS_E_NO_ERROR;
   
   if ( ( poMsgGpsIf != OSAL_NULL ) && ( poMsgGpsIf->bCritSectionBegin() ) )
   {
      // get opcode from message
      tU8  u8OpCode = poServiceData->u8GetOpCode();

      switch( u8OpCode )
      {
         case AMT_C_U8_CCAMSG_OPCODE_GET:
         {


            /* Create the object for XML generated FI for Set OP type */
            sensor_fi_tcl_VdsVersionInfo oMsgVdsVersion;

            /* TODO: evaluate these values e.g. reading registry*/
        oMsgVdsVersion.vdsVersion="Joachims-Testversion";
        oMsgVdsVersion.boardVersion="0xbeef";

            /* Create the object of visitor message and insert the class object*/
            fi_tclVisitorMessage* poResultMessage = 
               OSAL_NEW  fi_tclVisitorMessage( oMsgVdsVersion , VDS_C_U16_SRV_SENSORS_MAJOR_VERSION);

            if ( OSAL_NULL != poResultMessage )
            {
               tU32 u32TimeStamp = 0;
               vGetTimeStamp( &u32TimeStamp );

               if ( poResultMessage->bIsValid() )
               {
                  // create answer-message
                  poResultMessage->vInitServiceData (  
                     CCA_C_U16_APP_SENSOR,
                     poServiceData->u16GetSourceAppID(),    // Source, Target
                     AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                     0,                                     // StreamCounter
                     poServiceData->u16GetRegisterID(),     // RegisterID
                     poServiceData->u16GetCmdCounter(),     // nCmdCounter,
                     poServiceData->u16GetServiceID(),      // nServiceID,
                     SENSOR_LOCATIONFI_C_U16_VDSVERSIONINFO,// nFunctionID,
                     AMT_C_U8_CCAMSG_OPCODE_STATUS,         // OpCode
                     0,                                     // Asynchronous Completion Token (ACT)
                     AMT_C_U16_DEFAULT_NULL,                // Source Sub
                     AMT_C_U16_DEFAULT_NULL,                // Target Sub
                     u32TimeStamp                           // TimeStamp        
                  );

          *ppoResponseMessage = static_cast<amt_tclServiceData *>( poResultMessage );
               }
               else
               {
                   OSAL_DELETE poResultMessage;
                   poResultMessage = OSAL_NULL;
               }

        }  
        else
        {
           *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError(poServiceData,VDS_E_DATA_UNAVAILABLE );
           s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
        }
         }
         break;
         default:
         {
            // Error: OpCode not supported
            *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED );
            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      }//switch

      poMsgGpsIf->vCritSectionEnd();
   }
   else
   {
      *ppoErrorMessage = OSAL_NEW amt_tclServiceDataError( poServiceData, VDS_E_INTERNAL_ERROR );
      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }
   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!       Dispatches sensor message received for "GyroSelfTest" Method from client.
//!       Reply or error message will be created which will be used to send client as response.
//! \param
//!       *poServiceData - pointer to incoming message.
//!       **ppoResponseMessage - pointer to a location where a pointer to the
//!                              reply message is written if the input message is handled successfully.
//!       **ppoErrorMessage - pointer to a location where a pointer to an error message
//!                           is written if an error occurred during handling of the input message.
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_UNKNOWN_ERROR :  Unknown Error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************
tS32 tclSensorMsgDispatcher::s32DispatchGyroSelftest(
   amt_tclServiceData *poServiceData,
   amt_tclServiceData **ppoResponseMessage,
   amt_tclServiceDataError **ppoErrorMessage )
{
   tS32 s32RetVal = VDS_E_NO_ERROR;
   tU16 u16Error = VDS_E_NO_ERROR;
   tS32 s32SelfTestResult = 0;

   //Entering critical section.
   if( ( poMsgGyroIf != OSAL_NULL ) && ( poMsgGyroIf->oCS.bEnter() ) )
   {
      //Decide what to do based on OP-CODE.
      switch( poServiceData->u8GetOpCode() )
      {
         case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
         {
            //Start self test.
            if( poMsgGyroIf->bStartSelftest(&s32SelfTestResult) )
            {
               /* Create the object for XML generated FI for method result*/
               sensor_locationfi_tclMsgGyroSelfTestMethodResult oResult;
                   
               if(s32SelfTestResult == 1)
               {
                  oResult.bSuccess = TRUE;
               }
               else
               {
                  oResult.bSuccess = FALSE;
               }

               fi_tclVisitorMessage* poResultMessage = 
                  OSAL_NEW  fi_tclVisitorMessage( oResult, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );

               tU32 u32TimeStamp = 0;
               vGetTimeStamp( &u32TimeStamp );

               if ( OSAL_NULL != poResultMessage )
               {
                  if ( poResultMessage->bIsValid() )
                  {
                     // create answer-message
                     poResultMessage->vInitServiceData
                        (  CCA_C_U16_APP_SENSOR,
                           poServiceData->u16GetSourceAppID(),     // Source, Target
                           AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                           0,                            // StreamCounter
                           poServiceData->u16GetRegisterID(),  // RegisterID
                           poServiceData->u16GetCmdCounter(),  // nCmdCounter,
                           poServiceData->u16GetServiceID(),   // nServiceID,
                           SENSOR_LOCATIONFI_C_U16_GYROSELFTEST,// nFunctionID,
                           AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,   // OpCode
                           0,                            // Asynchronous Completion Token (ACT)
                           AMT_C_U16_DEFAULT_NULL,       // Source Sub
                           AMT_C_U16_DEFAULT_NULL,       // Target Sub
                           u32TimeStamp                 //TimeStamp
                           );
                  }
            
                  *ppoResponseMessage = static_cast<amt_tclServiceData *>( poResultMessage );
               }
               else
               {
                  s32RetVal = VDS_E_DISPATCHER_ALLOC_ERROR;
                  u16Error = VDS_E_INTERNAL_ERROR;
               }
            }
            else
            {
               s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
               u16Error = VDS_E_INTERNAL_ERROR;
            }

         }
         break;

         default:
         {
            //This OP-CODE is not supported by GyroSelf Test.
            u16Error = AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      }

      //Leave critical section.
      poMsgGyroIf->oCS.vLeave();
   }
   else
   {
      u16Error = VDS_E_INTERNAL_ERROR;
      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }

   if( s32RetVal != VDS_E_NO_ERROR )
   {
      *ppoErrorMessage = new amt_tclServiceDataError( poServiceData, u16Error );
   }

   return s32RetVal;
}

// ***************** F U N C T I O N  H E A D E R *****************************
//
//  DESCRIPTION:
//
//! \brief
//!       Dispatches sensor message received for "AccSelfTest" Method from client.
//!       Reply or error message will be created which will be used to send client as response.
//! \param
//!       *poServiceData - pointer to incoming message.
//!       **ppoResponseMessage - pointer to a location where a pointer to the
//!                              reply message is written if the input message is handled successfully.
//!       **ppoErrorMessage - pointer to a location where a pointer to an error message
//!                           is written if an error occurred during handling of the input message.
//! \return
//!   Succes code in case of success is:
//!   - \c  VDS_E_NO_ERROR : Success\n
//!   Error code in case of failure are:\n
//!   - \c VDS_E_DISPATCHER_IF_ERROR :   Dispather IF error
//!   - \c VDS_E_DISPATCHER_UNKNOWN_ERROR :  Unknown Error
//!   - \c VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED : Opcode not supported
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// ----------------------------------------------------------------------------
//******************************************************************************

tS32 tclSensorMsgDispatcher::s32DispatchAccSelftest
(
   amt_tclServiceData *poServiceData,

   amt_tclServiceData **ppoResponseMessage,

   amt_tclServiceDataError **ppoErrorMessage
)
{

   tS32 s32RetVal = VDS_E_NO_ERROR;
   tU16 u16Error = VDS_E_NO_ERROR;
   tS32 s32SelfTestResult = 0;


   //Entering critical section.
   if( ( poMsgAccIf != OSAL_NULL ) && ( poMsgAccIf->oCS.bEnter() ) )
   {
      //Decide what to do based on OP-CODE.
      switch( poServiceData->u8GetOpCode() )
      {
         case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
         {
            //Check whether test is already running.
            if( !poMsgAccIf->bIsSelftestRunning )
            {
               //Set self test running flag  
               poMsgAccIf->bIsSelftestRunning = TRUE;    

               //Start self test.
               if( poMsgAccIf->bStartSelftest(&s32SelfTestResult) )
               {
                   /* Create the object for XML generated FI for method result*/
                   sensor_locationfi_tclMsgAccSelfTestMethodResult oResult;
                   
                   if(s32SelfTestResult == 1)
                   {
                       oResult.bSuccess = TRUE;
                   }
                   else
                   {
                       oResult.bSuccess = FALSE;
                   }

                   fi_tclVisitorMessage* poResultMessage = 
                                OSAL_NEW  fi_tclVisitorMessage( oResult, VDS_C_U16_SRV_SENSORS_MAJOR_VERSION );
                                
                   tU32 u32TimeStamp = 0;
                   vGetTimeStamp( &u32TimeStamp );
                   if ( OSAL_NULL != poResultMessage )
                   {
                       if ( poResultMessage->bIsValid() )
                       {
                           // create answer-message
                           poResultMessage->vInitServiceData
                           (  CCA_C_U16_APP_SENSOR,
                              poServiceData->u16GetSourceAppID(),    // Source, Target
                              AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,     // StreamType
                              0,                                     // StreamCounter
                              poServiceData->u16GetRegisterID(),     // RegisterID
                              poServiceData->u16GetCmdCounter(),     // nCmdCounter,
                              poServiceData->u16GetServiceID(),      // nServiceID,
                              SENSOR_LOCATIONFI_C_U16_ACCSELFTEST,   // nFunctionID,
                              AMT_C_U8_CCAMSG_OPCODE_METHODRESULT,   // OpCode
                              0,                                     // Asynchronous Completion Token (ACT)
                              AMT_C_U16_DEFAULT_NULL,                // Source Sub
                              AMT_C_U16_DEFAULT_NULL,                // Target Sub
                              u32TimeStamp                           // TimeStamp
                           );
                        }

                        *ppoResponseMessage = static_cast<amt_tclServiceData *>( poResultMessage );
                   }
                   else
                   {
                      s32RetVal = VDS_E_DISPATCHER_ALLOC_ERROR;
                      u16Error = VDS_E_INTERNAL_ERROR;
                   }
               }
               else
               {
                  s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
                  u16Error = VDS_E_INTERNAL_ERROR;
               }
               
               poMsgAccIf->bIsSelftestRunning = FALSE;
            }
            else
            {
               //Test is already running so send an error saying so.
               u16Error =  AMT_C_U16_ERROR_TEMPORARY_NOT_AVAILABLE;
               s32RetVal = VDS_E_DISPATCHER_UNKNOWN_ERROR;
            }
         }
         break;

         default:
         {
            //This OP-CODE is not supported by GyroSelf Test.
            u16Error = AMT_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
            s32RetVal = VDS_E_DISPATCHER_OPCODE_NOT_SUPPORTED;
         }
         break;
      }

      //Leave critical section.
      poMsgAccIf->oCS.vLeave();
   }
   else
   {
      u16Error = VDS_E_INTERNAL_ERROR;
      s32RetVal = VDS_E_DISPATCHER_IF_ERROR;
   }

   if( s32RetVal != VDS_E_NO_ERROR )
   {
      *ppoErrorMessage = new amt_tclServiceDataError( poServiceData, u16Error );
   }

   return s32RetVal;
}

//End Of File.
