// *****************************************************************************
// * FILE:         tclPersistentDataAccess.cpp
// * SW_COMPONENT: VD-Sensor
// * DESCRIPTION:  class-definition: handles access to persistent-data
// * AUTHOR:       CM-DI/ESA1-Fischer
// * COPYRIGHT:    (c) 2002 Blaupunkt GmbH
// * HISTORY:
// * 20.03.02 Rev. 1.0 CM-DI/ESA1-Fischer
// *          Initial Revision.
// * 11.09.09 RBEI/ECF1 - sak9kor - Comments generated by Rational Rose have been removed
// * 30.09.09 RBEI/ECF1-Sainath K  Added doxygen headers for all classes/funcs
// * 23.09.10 RBEI/ECF1-Sainath K Modifications have been done for ADIT Gen2
// * 04.02.11 RBEI/ECF1-Sainath K changed alias channel of pszTempDev to OSAL_C_STRING_DEVICE_ADC_GPS_UTMP
// * 10.03.11 RBEI/ECF1-Sainath K New device accelerometer has been added
// *****************************************************************************

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#if OSAL_OS==OSAL_NUCLEUS
#define SYSTEM_S_IMPORT_INTERFACE_KDS_DEF
#define SYSTEM_S_IMPORT_INTERFACE_ERRMEM_DEF
#include "system_pif.h"
#endif //OSAL_OS==OSAL_NUCLEUS

#define SENSOR_FI_S_IMPORT_INTERFACE_SENSOR_LOCATIONFI_TYPES
#include "sensor_fi_if.h"

#define VDS_S_IMPORT_INTERFACE_PERSISTENT_DATA
#define VDS_S_IMPORT_INTERFACE_TRACE
#include "vds_internal_if.h"

#if 0
#define VDS_C_U32_MAX_PATHLENGTH    255
#endif

#define SENSOR_REG_POS "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/SENSORS"
//#define SENSOR_ADC_REG_POS "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/VERSIONS"

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!    Return the sensor types supported by this system.
//!
//!    The registry is assumed to contain sensor information under
//!    LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/SENSORS.  If this key does not
//!    exist, the default sensor types are used.
//!
//! \return
//!   actual sensor types
//!
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
static tU32 u32GetSensorTypes
(
   //!  (I) default sensor types
   tU32 u32DefaultSensorTypes
)
{
   reg_tclRegKey  oReg;
   tBool bRetVal;
   tU32 u32Entry = 0;
   tU32 u32SensorTypes = 0;
   
   bRetVal = oReg.bOpen(SENSOR_REG_POS);
   if( bRetVal )
   {
      if( oReg.bQueryU32("HAS_GPS", &u32Entry) )
      {
         vTraceMsg( VDS_C_TRACELEVEL_COMPONENT, "HAS_GPS = %d", u32Entry );
         if( u32Entry != 0 )
         {
            u32SensorTypes |= VDS_C_U32_SENSOR_GPS;
         }
      }
      else
      {
         u32SensorTypes |= (u32DefaultSensorTypes & VDS_C_U32_SENSOR_GPS);
      }
      //Specifies which device to use GNSS or GPS.
      if( oReg.bQueryU32("GNSS_FEATURE", &u32Entry) )
      {
         vTraceMsg( VDS_C_TRACELEVEL_COMPONENT, "GNSS_FEATURE = %d", u32Entry );
         if( u32Entry == 1 )
         {
            u32SensorTypes |= VDS_C_U32_SENSOR_GNSS_FEATURE;
         }
      }
      else
      {
         u32SensorTypes |= (u32DefaultSensorTypes & VDS_C_U32_SENSOR_GNSS_FEATURE);
      }

      if( oReg.bQueryU32("HAS_GYRO", &u32Entry) )
      {
         vTraceMsg( VDS_C_TRACELEVEL_COMPONENT, "HAS_GYRO = %d", u32Entry );
         if( u32Entry != 0 )
         {
            u32SensorTypes |= VDS_C_U32_SENSOR_GYRO;
         }
      }
      else
      {
         u32SensorTypes |= (u32DefaultSensorTypes & VDS_C_U32_SENSOR_GYRO);
      }

      if( oReg.bQueryU32("HAS_ACC", &u32Entry) )
      {
         vTraceMsg( VDS_C_TRACELEVEL_COMPONENT, "HAS_ACC = %d", u32Entry );
         if( u32Entry != 0 )
         {
            u32SensorTypes |= VDS_C_U32_SENSOR_ACC;
         }
      }
      else
      {
         u32SensorTypes |= (u32DefaultSensorTypes & VDS_C_U32_SENSOR_ACC);
      }

      if( oReg.bQueryU32("HAS_ODO", &u32Entry) )
      {
         vTraceMsg( VDS_C_TRACELEVEL_COMPONENT, "HAS_ODO = %d", u32Entry );
         if( u32Entry != 0 )
         {
            u32SensorTypes |= VDS_C_U32_SENSOR_ODO;
         }
      }
      else
      {
         u32SensorTypes |= (u32DefaultSensorTypes & VDS_C_U32_SENSOR_ODO);
      }

      if( oReg.bQueryU32("HAS_ABS", &u32Entry) )
      {
         vTraceMsg( VDS_C_TRACELEVEL_COMPONENT, "HAS_ABS = %d", u32Entry );
         if( u32Entry != 0 )
         {
            u32SensorTypes |= VDS_C_U32_SENSOR_ABS;
         }
      }
      else
      {
         u32SensorTypes |= (u32DefaultSensorTypes & VDS_C_U32_SENSOR_ABS);
      }

      if( oReg.bQueryU32("HAS_ODO_FAKE", &u32Entry) )
      {
         vTraceMsg( VDS_C_TRACELEVEL_COMPONENT, "HAS_ODO_FAKE = %d", u32Entry );
         if( u32Entry != 0 )
         {
            u32SensorTypes |= VDS_C_U32_SENSOR_ODO_FAKE;
         }
      }
      else
      {
         u32SensorTypes |= (u32DefaultSensorTypes & VDS_C_U32_SENSOR_ODO_FAKE);
      }

      return u32SensorTypes;
   }
   else
   {
      vTraceMsg( VDS_C_TRACELEVEL_COMPONENT, "Using default sensor types" );
      return u32DefaultSensorTypes;
   }
}

vds_trSystemInformation tclSystemInformation::rInfo;

// ***************** F U N C T I O N  H E A D E R **************************
//
//  DESCRIPTION:
//
//! \brief
//!    Initialize system information
//!
//!    This function has to be called before any attempts are made to
//!    access rInfo.
//!
//!    Some fields may be invalid even after vInit(), e.g. the gyro
//!    information is dependent on the gyro type, which is unknown
//!    until the gyro device is opened.
//!
//! \return
//!   None
//!
//  HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
//**************************************************************************
void tclSystemInformation::vInit( void )
{
   tU32 u32DefaultSensorTypes;

   // General system information
      u32DefaultSensorTypes = VDS_C_U32_SENSOR_GPS |
                              VDS_C_U32_SENSOR_GNSS_FEATURE ;

   rInfo.rSystem.u32SensorTypes = u32GetSensorTypes(u32DefaultSensorTypes);
   rInfo.rGyro.u16BlockSize     = VDS_C_U16_GYROTHREAD_BLOCKREADSIZE;
   rInfo.rAcc.u16BlockSize      = VDS_C_U16_GYROTHREAD_BLOCKREADSIZE;
}

