//*****************************************************************************
//      * FILE:         tclOdometerThread.h
//      * SW_COMPONENT: VD-Sensor
//      * DESCRIPTION:  class-declaration: inherits from tclSensorThread,
//      *               thread-main-loop, reads data from odometer-device
//      * AUTHOR:       CM-DI/ESA1-Fischer
//      * COPYRIGHT:    (c) 2002 Blaupunkt GmbH
//      * HISTORY:
//      * 20.03.02 Rev. 1.0 CM-DI/ESA1-Fischer
//      *          Initial Revision.
//      * 11.09.09 RBEI/ECF1 - sak9kor -
//                         Comments generated by Rational Rose have been removed
//*****************************************************************************

#ifndef tclOdometerThread_h
#define tclOdometerThread_h 1

// errors
#define VDS_E_ODOMTHREAD_IOREAD_ERROR        -1
#define VDS_E_ODOMTHREAD_NOT_INITIALIZED     -2
#define VDS_E_ODOMTHREAD_STORAGE_ERROR       -3
#define VDS_E_ODOMTHREAD_ALLOC_ERROR         -4
#define VDS_E_ODOMTHREAD_DEVICE_NOT_FOUND    -5
#define VDS_E_ODOMTHREAD_SEM_ERROR           -6
#define VDS_E_ODOMTHREAD_THREADCREATE_FAILED -7
#define VDS_E_ODOMTHREAD_NOT_UNINITIALIZED   -8

class tclMsgOdometerIf;

//!  \brief  Odometer Thread Class. Derived from Sensor Thread Class
class tclOdometerThread : public tclSensorThread
{
public:
   tclOdometerThread();
   virtual ~tclOdometerThread();

   // **************************************************************************
   // * METHOD:      tclOdometerThread::s32ThreadInit
   // * DESCRIPTION: inherited from class tclSensorThread.
   // *              open odometer-device, create semaphore, create
   // *              odometer-thread, set function-pointer, set internal state
   // * PARAMETER:
   // *            tS32(pfs32AddOdometerList*)(vds_trOdometerData*, tU32): (->I)
   // *            this is a pointer to the function, where sensor-data
   // *            will be stored. this function has to be called, when
   // *            sensor-data is read.
   // *
   // * RETURNVALUE: tS32
   // *                 ok   : VDS_E_NO_ERROR (thread and
   // *                        semaphore created successfully)
   // *            error: VDS_E_THREAD_IOOPEN_ERROR, VDS_E_THREAD_SEM_ERROR,
   // *                   VDS_E_THREAD_CREATE_ERROR, VDS_E_INVALID_PARAMETER,
   // *                   VDS_E_THREAD_ALREADY_INITIALIZED
   // *
   // * HISTORY:
   // * 21.03.02 CM-DI/ESA1-Fischer
   // *          Initial Revision.
   // **************************************************************************
   tS32 s32ThreadInit (
      tclMsgOdometerIf  *poMsgOdometerIf,
      tS32(*pfs32AddOdometerList)(vds_trOdometerData*, tU32));

   // **************************************************************************
   // * METHOD:      tclOdometerThread::vThreadMain
   // * DESCRIPTION: inherited from class tclSensorThread.
   // *              when thread is started, set state RUNNING.
   // *              receive odometer-data from odometer-device
   // *              when internal state is set to STOP, leave loop and
   // *              set state INITIALIZED.
   // * PARAMETER:
   // *              tPVoid pvThreadArg (->I)
   // *                 not used, argument declared in s32ThreadInit
   // *
   // * RETURNVALUE: tVoid
   // *
   // * HISTORY:
   // * 21.03.02 CM-DI/ESA1-Fischer
   // *          Initial Revision.
   // **************************************************************************
   tVoid vThreadMain ( tPVoid );

   // **************************************************************************
   // * METHOD:      tclOdometerThread::vThreadClose
   // * DESCRIPTION: inherited from class tclSensorThread.
   // *              closes handles, deletes semaphores, deletes
   // *
   // * PARAMETER:
   // *              tVoid
   // *
   // * RETURNVALUE: tVoid
   // *
   // * HISTORY:
   // * 09.04.02 CM-DI/ESA1-Fischer
   // *          Initial Revision.
   // **************************************************************************
   virtual tVoid vThreadClose ();

   // **************************************************************************
   // * METHOD:      tclOdometerThread::vThreadMain
   // * DESCRIPTION: static wrapper for main-loop of instance.
   // *
   // * PARAMETER:
   // *              tPVoid pvThreadArg (->I)
   // *                 pointer to instance
   // *
   // * RETURNVALUE: tVoid
   // *
   // * HISTORY:
   // * 16.04.02 CM-DI/ESA1-Fischer
   // *          Initial Revision.
   // **************************************************************************
   static tVoid vThreadMainWrapper ( tPVoid pvThreadArg );

   // **************************************************************************
   // * METHOD:      tclOdometerThread::u32GetOdometerCycleTime
   // * DESCRIPTION: returns gyro-sensor-cycle-time
   // *
   // * PARAMETER:
   // *              tVoid
   // *
   // * RETURNVALUE: tU32
   // *              gyro-sensor-cycle-time
   // *
   // * HISTORY:
   // * 21.04.06 Grasser
   // *          Initial Revision.
   // **************************************************************************
   tU32 u32GetOdometerCycleTime ();

private:

   //   ************************************************************************
   //   * METHOD:      tclOdometerThread::s32ReadOdometerData
   //   * DESCRIPTION: reads odometer-data from odometer-device
   //   * PARAMETER:
   //   *              OSAL_trIOCtrlOdometerData *parIOCtrlOdometerData: (->O)
   //   *                 buffer for received odometer-data
   //   *              tU32 u32NumOfElem: (I)
   //   *                 max. number of odometer-data to be stored in buffer
   //   *
   //   * RETURNVALUE: tS32
   //   *                 [0..n]: odometer-data-elements read
   //   *                 error : VDS_E_INVALID_PARAMETER,
   //   *                         VDS_E_ODOMTHREAD_NOT_INITIALIZED,
   //   *                         VDS_E_ODOMTHREAD_IOREAD_ERROR,
   //   *                         VDS_E_ODOMTHREAD_STORAGE_ERROR
   //   *
   //   * HISTORY:
   //   * 21.03.02 CM-DI/ESA1-Fischer
   //   *          Initial Revision.
   //   ************************************************************************
   tS32 s32ReadOdometerData( OSAL_trIOCtrlOdometerData *parIOCtrlOdometerData,
                             tU32 u32NumOfElem);

   //   ************************************************************************
   //   * METHOD:      tclOdometerThread::s32StoreOdometerData
   //   * DESCRIPTION: sends received odometer-data to tclMsgOdometerIf
   //   * PARAMETER:
   //   *              OSAL_trIOCtrlOdometerData *parIOCtrlOdometerData: (->I)
   //   *                 buffer with received odometer-data
   //   *              tU32 u32NumOfElem: (I)
   //   *                 number of odometer-data in buffer
   //   *
   //   * RETURNVALUE: tS32
   //   *                 ok   : VDS_E_NO_ERROR
   //   *                 error: VDS_E_INVALID_PARAMETER,
   //   *                        VDS_E_GYROTHREAD_NOT_INITIALIZED,
   //   *                        VDS_E_ODOMTHREAD_ALLOC_ERROR,
   //   *                        VDS_E_ODOMTHREAD_STORAGE_ERROR
   //   *
   //   * HISTORY:
   //   * 21.03.02 CM-DI/ESA1-Fischer
   //   *          Initial Revision.
   //   ************************************************************************
   tS32 s32StoreOdometerData( const OSAL_trIOCtrlOdometerData *parIOCtrlOdometerData,
                              tU32 u32NumOfElem);

   // Data Members for Class Attributes
   tS32(*pfs32AddOdometerList)(vds_trOdometerData *, tU32);
   OSAL_trIOCtrlOdometerData *parOdometerData;
   vds_trOdometerData *parOdometerStorage;
   tU32 u32NumOfOdometerData;
   tclMsgOdometerIf    *poMsgOdometerIf;
   tU32 u32OdometerCycleTimeInNS;

};
#endif
