//  *****************************************************************************
//  * FILE:         tclGyroThread.h
//  * SW_COMPONENT: VD-Sensor
//  * DESCRIPTION:  class-declaration: inherits from tclSensorThread,
//  *               thread-main-loop, reads data from gyro-device
//  * AUTHOR:       CM-DI/ESA1-Fischer
//  * COPYRIGHT:    (c) 2002 Blaupunkt GmbH
//  * HISTORY:
//  * 20.03.02 Rev. 1.0 CM-DI/ESA1-Fischer
//  *          Initial Revision.
//  * 18.11.02 CM-CR/EES4-Bode
//  *          Addapted to Tuareg.
//    * 11.09.09 RBEI/ECF1 - sak9kor - Rational rose comments have been removed
//  ***************************************************************************
#ifndef tclGyroThread_h
#define tclGyroThread_h 1

// errors
#define VDS_E_GYROTHREAD_IOREAD_ERROR        -1
#define VDS_E_GYROTHREAD_NOT_INITIALIZED     -2
#define VDS_E_GYROTHREAD_STORAGE_ERROR       -3
#define VDS_E_GYROTHREAD_ALLOC_ERROR         -4
#define VDS_E_GYROTHREAD_DEVICE_NOT_FOUND    -5
#define VDS_E_GYROTHREAD_SEM_ERROR           -6
#define VDS_E_GYROTHREAD_THREADCREATE_FAILED -7
#define VDS_E_GYROTHREAD_NOT_UNINITIALIZED   -8
#define VDS_E_GYROTHREAD_IO_ERROR            -9

class tclMsgGyroIf;

/*!
 * \brief Defines the interface for Gyro Thread.
 */
class tclGyroThread : public tclSensorThread
{

public:
   // ***************** F U N C T I O N  H E A D E R ***************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //    Default Constructor
   //  return
   //    None
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // --------------------------------------------------------------------------
   //***************************************************************************
   tclGyroThread();

   // ***************** F U N C T I O N  H E A D E R ***************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //    Default Destructor
   //  return
   //    None
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // --------------------------------------------------------------------------
   //***************************************************************************
   virtual ~tclGyroThread();

   // ***************** F U N C T I O N  H E A D E R ***************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //  inherited from class tclSensorThread. open gyro-device, create semaphore,
   //    create gyro-thread, set function-pointer, set internal state
   //  Paramters :
   //    tclMsgGyroIf    *poMsgGyroIf - Pointer to Message gyro interface
   //  tS32(*pfs32AddGyroList)(vds_trGyroData*, tU32) - this is a pointer to the
   //function, where sensor-data will be stored. this function has to be called,
   //          when sensor-data is read.
   //    tS32(*pfvSetSelftestResult)(tBool, tBool, tBool) - Function pointer
   //  return
   //    Succes code in case of success is:
   //        VDS_E_NO_ERROR : Success\n
   //   Error code in case of failure are:\n
   //        VDS_E_GYROTHREAD_DEVICE_NOT_FOUND :   Device not found
   //        VDS_E_GYROTHREAD_ALLOC_ERROR :  Allocation error
   //        VDS_E_GYROTHREAD_THREADCREATE_FAILED : Thread create failed
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   //---------------------------------------------------------------------------
   //  21.03.02      CM-DI/ESA1-Fischer    Initial Revision.
   //***************************************************************************
   tS32 s32ThreadInit ( tclMsgGyroIf    *poMsgGyroIf,
                        tS32( *pfs32Add3dGyroList )( const sensor_fi_tcl_3dGyroData*, tU32 ));

   // ***************** F U N C T I O N  H E A D E R ***************************
   //
   //  DESCRIPTION:
   //
   //  brief inherited from class tclSensorThread.when thread is
   //started, set state RUNNING.
   //
   //    receive gyro-data from gyro-device when internal state is set to STOP,
   //    leave loop and set state INITIALIZED.
   //  PARAMETER:
   //    tPVoid pvThreadArg (->I)
   //    not used, argument declared in s32ThreadInit
   //  return
   //    None
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // --------------------------------------------------------------------------
   //  21.03.02      CM-DI/ESA1-Fischer    Initial Revision.
   //***************************************************************************
   tVoid vThreadMain ( tPVoid );

   // ***************** F U N C T I O N  H E A D E R ***************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //   inherited from class tclSensorThread.closes handles, deletes semaphores,
   //    deletes allocated memory
   //  PARAMETER:
   //     tVoid
   //  return
   //   None
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // --------------------------------------------------------------------------
   //  09.04.02     CM-DI/ESA1-Fischer      Initial Revision.
   //***************************************************************************
   virtual tVoid vThreadClose ();

   // ***************** F U N C T I O N  H E A D E R ***************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //    static wrapper for main-loop of instance
   //  PARAMETER:
   //      tPVoid pvThreadArg (->I)
   //      pointer to instance
   //  return
   //    None
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // --------------------------------------------------------------------------
   //  16.04.02      CM-DI/ESA1-Fischer     Initial Revision.
   //***************************************************************************
   static tVoid vThreadMainWrapper ( tPVoid pvThreadArg );

   // ***************** F U N C T I O N  H E A D E R ***************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //    returns gyro-sensor-cycle-time\n
   //  PARAMETER:
   //        tVoid
   //  return
   //      Sensor cycle time
   //  HISTORY:
   // Date         |  Author       | MODIFICATION
   // --------------------------------------------------------------------------
   //  21.04.06     Grasser          Initial Revision.
   //***************************************************************************
   tU32 u32GetGyroCycleTime ();

   // ***************** F U N C T I O N  H E A D E R ***************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //   get the gyro temperature values
   //  Parameters :
   //      None
   //  return
   //     tF32 : temperature in kelvin
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // --------------------------------------------------------------------------
   //***************************************************************************
   tF32 f32GetGyroTemperature (tVoid); 
   // ***************** F U N C T I O N  H E A D E R ***************************
   //! \brief
   //!       Start Gyro self test.
   //! \return
   //!   - \c TRUE  : Self test finished successfully.
   //!   - \c FALSE : Unable to start self test.
   //  HISTORY:
   // Date            |  Author                       | MODIFICATION
   // --------------------------------------------------------------------------
   //***************************************************************************
   tBool bStartSelftest( tS32 *ps32SelfTestResult );

protected:
   // Additional Protected Declarations
	
   // ***************** F U N C T I O N  H E A D E R ***************************
   //
   //  DESCRIPTION:
   //
   // brief
   // Calculates the current temperature in Kelvin from temp sensor and ADC.
   // PARAMETERS:
   //    pointer to temperature value
   // return
   // TRUE : In case of Success\n
   // FALSE : In case of Failure\n
   //  HISTORY:
   // Date            |  Author                       | MODIFICATION
   // --------------------------------------------------------------------------
   //***************************************************************************
   tBool bCalcTemperature( tF32* );

private:
   // ***************** F U N C T I O N  H E A D E R ***************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //    reads gyro-data from gyro-device,
   //  PARAMETER:
   //               OSAL_trIOCtrlGyroData *parIOCtrlGyroData: (->O)
   //                  buffer for received gyro-data
   //               tU32 u32NumOfElem: (I)
   //                  max. number of gyro-data to be stored in buffer
   //  return
   //     Number of Elements read
   //    Error code in case of failure are:\n
   //      VDS_E_GYROTHREAD_STORAGE_ERROR     : Storage error
   //      VDS_E_GYROTHREAD_IOREAD_ERROR :  IO Read error
   //      VDS_E_GYROTHREAD_NOT_INITIALIZED : Not initialized
   //      VDS_E_INVALID_PARAMETER : Invalid parameter
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // --------------------------------------------------------------------------
   //  21.03.02      CM-DI/ESA1-Fischer     Initial Revision
   //***************************************************************************
   tS32 s32ReadGyroData ( OSAL_trIOCtrl3dGyroData *pGyroData,
                          tU32 u32NumOfElem );

   // ***************** F U N C T I O N  H E A D E R ***************************
   //
   //  DESCRIPTION:
   //
   // brief
   //   sends received gyro-data to tclMsgGyroIf
   // PARAMETER:
   //       OSAL_trIOCtrlGyroData *parIOCtrlGyroData: (->I)
   //            buffer with received gyro-data
   //       tU32 u32NumOfElem: (I)
   //           number of gyro-data in buffer
   // return
   //    Succes code in case of success is:
   //      VDS_E_NO_ERROR : Success\n
   //    Error code in case of failure are:\n
   //      VDS_E_GYROTHREAD_ALLOC_ERROR :   Allocation error
   //      VDS_E_GYROTHREAD_STORAGE_ERROR :  Storage Error
   //      VDS_E_GYROTHREAD_NOT_INITIALIZED : Not initialized
   //      VDS_E_INVALID_PARAMETER : Invalid parameter
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // --------------------------------------------------------------------------
   //  21.03.02      CM-DI/ESA1-Fischer     Initial Revision.
   //***************************************************************************
   tS32 s32StoreGyroData ( const OSAL_trIOCtrl3dGyroData *pGyroData,
                           tU32 u32NumOfElem );
   OSAL_trIOCtrl3dGyroData *parGyroData;
   tU32 u32NumOfGyroData;
   sensor_fi_tcl_3dGyroData *par3dGyroStorage;
   tS32(*pfs32Add3dGyroList)( const sensor_fi_tcl_3dGyroData*, tU32);
   tclMsgGyroIf *poMsgGyroIf;
   tU32 u32GyroSensorCycleTimeInNS;
   tF32 f32TempKelvin;
};
#endif
