//  *****************************************************************************
//  * FILE:         tclAccThread.h
//  * SW_COMPONENT: VD-Sensor
//  * DESCRIPTION:  class-declaration:This Class actually intercats with the
//  *               dev_acc driver and acceses the accelerometer information
//  *               and provides an interface for the other VDSensor layers
//  *               to get the read accelerometer Data
//  *
//  * AUTHOR:       RBEI/ECF1-Sainath Kalpuri
//  * COPYRIGHT:    (c) 2011 Robert Bosch.
//  * HISTORY:
//  * 08.03.11 Rev. 1.0 RBEI/ECF1-Sainath Kalpuri
//  *          Initial Revision.
//  *****************************************************************************

#ifndef tclAccThread_h
#define tclAccThread_h 1


// errors
#define VDS_E_ACCTHREAD_IOREAD_ERROR           -1
#define VDS_E_ACCTHREAD_NOT_INITIALIZED        -2
#define VDS_E_ACCTHREAD_STORAGE_ERROR          -3

#define VDS_E_ACCTHREAD_ALLOC_ERROR            -4
#define VDS_E_ACCTHREAD_DEVICE_NOT_FOUND       -5
#define VDS_E_ACCTHREAD_SEM_ERROR              -6
#define VDS_E_ACCTHREAD_THREADCREATE_FAILED    -7
#define VDS_E_ACCTHREAD_NOT_UNINITIALIZED  -8
#define VDS_E_ACCTHREAD_IO_ERROR   -9

class tclMsgAccIf;

/*!
 * \brief Defines the interface for Accelerometer Thread.
 */
class tclAccThread: public tclSensorThread
{
  public:
   // ***************** F U N C T I O N  H E A D E R *****************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //    Default Constructor
   //  return
   //    None
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // ----------------------------------------------------------------------------
   // 08-03-11       RBEI/ECF1 - sak9kor    Initial Version
   //******************************************************************************
   tclAccThread();

   // ***************** F U N C T I O N  H E A D E R *****************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //    Default Destructor
   //  return
   //    None
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // ----------------------------------------------------------------------------
   // 08-03-11       RBEI/ECF1 - sak9kor    Initial Version
   //******************************************************************************
   virtual ~tclAccThread();


   // ***************** F U N C T I O N  H E A D E R *****************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //    This function opens the Accelerometer device and makes ready for accessing
   //    the data
   //  Paramters :
   //    tclMsgAccIf    *poMsgAccIf - Pointer to Message acc interface
   //    sensor_fi_tcl_3dAccData*, tU32 - Pointer to the function 
   //  return
   //    Succes code in case of success is:
   //        VDS_E_NO_ERROR : Success\n
   //   Error code in case of failure are:\n
   //        VDS_E_ACCTHREAD_DEVICE_NOT_FOUND :   Device not found
   //        VDS_E_ACCTHREAD_ALLOC_ERROR :  Allocation error
   //        VDS_E_ACCTHREAD_THREADCREATE_FAILED : Thread create failed
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // ----------------------------------------------------------------------------
   // 08-03-11       RBEI/ECF1 - sak9kor    Initial Version
   //******************************************************************************
   tS32 s32ThreadInit (
      tclMsgAccIf    *poMsgAccIfParam,
      tS32( *pfs32Add3dAccListParam )( const sensor_fi_tcl_3dAccData*, tU32 ) 
      );
      
   // ***************** F U N C T I O N  H E A D E R *****************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //    inherited from class tclSensorThread.when thread is started, set state RUNNING.
   //    receive acc-data from acc-device when internal state is set to STOP,
   //    leave loop and set state INITIALIZED.
   //  PARAMETER:
   //    tPVoid pvThreadArg (->I)
   //    not used, argument declared in s32ThreadInit
   //  return
   //    None
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // ----------------------------------------------------------------------------
   //  21.03.02      CM-DI/ESA1-Fischer    Initial Revision.
   //******************************************************************************
   tVoid vThreadMain ( tPVoid ); 
   // ***************** F U N C T I O N  H E A D E R *****************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //    inherited from class tclSensorThread.closes handles, deletes semaphores,
   //    deletes allocated memory
   //  PARAMETER:
   //     tVoid
   //  return
   //   None
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // ----------------------------------------------------------------------------
   //  09.04.02     CM-DI/ESA1-Fischer      Initial Revision.
   //******************************************************************************
   virtual tVoid vThreadClose ();      
   // ***************** F U N C T I O N  H E A D E R *****************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //    static wrapper for main-loop of instance
   //  PARAMETER:
   //      tPVoid pvThreadArg (->I)
   //      pointer to instance
   //  return
   //    None
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // ----------------------------------------------------------------------------
   //  16.04.02      CM-DI/ESA1-Fischer     Initial Revision.
   //******************************************************************************
   static tVoid vThreadMainWrapper ( tPVoid pvThreadArg );   

   // ***************** F U N C T I O N  H E A D E R *****************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //    returns acc-sensor-cycle-time\n
   //  PARAMETER:
   //        tVoid
   //  return
   //      Sensor cycle time
   //  HISTORY:
   // Date         |  Author       | MODIFICATION
   // ----------------------------------------------------------------------------
   //  21.04.06     Grasser          Initial Revision.
   //******************************************************************************
   tU32 u32GetAccCycleTime ();      
   // Additional Public Declarations
      
   // ***************** F U N C T I O N  H E A D E R *****************************
   //! \brief
   //!       Start Acc self test.
   //! \return
   //!   - \c TRUE  : Self test finished successfully.
   //!   - \c FALSE : Unable to start self test.
   //  HISTORY:
   // Date            |  Author                       | MODIFICATION
   // ----------------------------------------------------------------------------
   //******************************************************************************
   tBool bStartSelftest( tS32 *ps32SelfTestResult );

  private:
   // ***************** F U N C T I O N  H E A D E R *****************************
   //
   //  DESCRIPTION:
   //
   //  brief
   //    reads acc-data from acc-device,
   //  PARAMETER:
   //               OSAL_trIOCtrlaccData *parIOCtrlAccData: (->O)
   //                  buffer for received acc-data
   //               tU32 u32NumOfElem: (I)
   //                  max. number of acc-data to be stored in buffer
   //  return
   //     Number of Elements read
   //    Error code in case of failure are:\n
   //      VDS_E_ACCTHREAD_STORAGE_ERROR     : Storage error
   //      VDS_E_ACCTHREAD_IOREAD_ERROR :  IO Read error
   //      VDS_E_ACCTHREAD_NOT_INITIALIZED : Not initialized
   //      VDS_E_INVALID_PARAMETER : Invalid parameter
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // ----------------------------------------------------------------------------
   //  21.03.02      CM-DI/ESA1-Fischer     Initial Revision
   //******************************************************************************
   tS32 s32ReadAccData ( tVoid *parIOCtrlAccData, tU32 u32NumOfElem ); 
   // ***************** F U N C T I O N  H E A D E R *****************************
   //
   //  DESCRIPTION:
   //
   // brief
   //   sends received acc-data to tclMsgaccIf
   // PARAMETER:
   //       OSAL_trIOCtrlAccData *parIOCtrlAccData: (->I)
   //            buffer with received acc-data
   //       tU32 u32NumOfElem: (I)
   //           number of acc-data in buffer
   // return
   //    Succes code in case of success is:
   //      VDS_E_NO_ERROR : Success\n
   //    Error code in case of failure are:\n
   //      VDS_E_ACCTHREAD_ALLOC_ERROR :   Allocation error
   //      VDS_E_ACCTHREAD_STORAGE_ERROR :  Storage Error
   //      VDS_E_ACCTHREAD_NOT_INITIALIZED : Not initialized
   //      VDS_E_INVALID_PARAMETER : Invalid parameter
   //  HISTORY:
   // Date         |  Author              | MODIFICATION
   // ----------------------------------------------------------------------------
   //  21.03.02      CM-DI/ESA1-Fischer     Initial Revision.
   //******************************************************************************
   tS32 s32StoreAccData ( tVoid *parIOCtrlAccData, tU32 u32NumOfElem );      

   //public:
   OSAL_trIOCtrlAccData *parAccData;
   tU32 u32NumOfAccData;
   sensor_fi_tcl_3dAccData *par3dAccStorage;
   tS32(*pfs32Add3dAccList)(const sensor_fi_tcl_3dAccData*, tU32);      
   tclMsgAccIf *poMsgAccIf;
   tU32 u32AccSensorCycleTimeInNS;
};// Class tclAccThread
#endif
